/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.BoxplotStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0014\u0010\u0019\u001a\u00020\u00042\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/plot/base/stat/BoxplotStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "()V", "myComputeWidth", "", "myWhiskerIQRRatio", "", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "getDefaultMapping", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "aes", "hasDefaultMapping", "setComputeWidth", "b", "setWhiskerIQRRatio", "v", "Companion", "plot-base-portable"})
public final class BoxplotStat
extends BaseStat {
    private double myWhiskerIQRRatio = 1.5;
    private boolean myComputeWidth;
    public static final double DEF_WHISKER_IQR_RATIO = 1.5;
    public static final boolean DEF_COMPUTE_WIDTH = false;
    @NotNull
    public static final String P_COEF = "coef";
    @NotNull
    public static final String P_VARWIDTH = "varwidth";
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    public static final Companion Companion;

    public final void setWhiskerIQRRatio(double v) {
        this.myWhiskerIQRRatio = v;
    }

    public final void setComputeWidth(boolean b) {
        this.myComputeWidth = b;
    }

    @Override
    public boolean hasDefaultMapping(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return super.hasDefaultMapping(aes) || Intrinsics.areEqual(aes, Aes.Companion.getWIDTH()) && this.myComputeWidth;
    }

    @Override
    @NotNull
    public DataFrame.Variable getDefaultMapping(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return Intrinsics.areEqual(aes, Aes.Companion.getWIDTH()) ? Stats.INSTANCE.getWIDTH() : super.getDefaultMapping(aes);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf((Object[])new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()});
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        HashMap collector2;
        List<Double> ys;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        if (!this.hasRequiredValues(data, Aes.Companion.getX(), Aes.Companion.getY())) {
            return this.withEmptyStatValues();
        }
        List<Double> xs = data.getNumeric(TransformVar.INSTANCE.getX());
        int maxCountPerBinOverall = BoxplotStatUtil.INSTANCE.buildStat(xs, ys = data.getNumeric(TransformVar.INSTANCE.getY()), this.myWhiskerIQRRatio, 0, collector2 = new HashMap());
        if (maxCountPerBinOverall == 0) {
            return this.withEmptyStatValues();
        }
        List statCount = (List)collector2.remove(Stats.INSTANCE.getWIDTH());
        if (this.myComputeWidth) {
            ArrayList<Double> statWidth = new ArrayList<Double>();
            double d = maxCountPerBinOverall;
            boolean bl = false;
            double norm = Math.sqrt(d);
            List list2 = statCount;
            Intrinsics.checkNotNull((Object)list2);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                double count2 = ((Number)iterator2.next()).doubleValue();
                boolean bl2 = false;
                statWidth.add(Math.sqrt(count2) / norm);
            }
            ((Map)collector2).put(Stats.INSTANCE.getWIDTH(), statWidth);
        }
        DataFrame.Builder builder = new DataFrame.Builder();
        Iterator iterator3 = collector2.keySet().iterator();
        while (iterator3.hasNext()) {
            DataFrame.Variable key;
            DataFrame.Variable variable = key = (DataFrame.Variable)iterator3.next();
            Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"key");
            Object v = collector2.get(key);
            Intrinsics.checkNotNull(v);
            Intrinsics.checkNotNullExpressionValue(v, (String)"collector[key]!!");
            builder.putNumeric(variable, (List)v);
        }
        return builder.build();
    }

    public BoxplotStat() {
        super(DEF_MAPPING);
    }

    static {
        Companion = new Companion(null);
        DEF_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getYMIN(), (Object)Stats.INSTANCE.getY_MIN()), TuplesKt.to(Aes.Companion.getYMAX(), (Object)Stats.INSTANCE.getY_MAX()), TuplesKt.to(Aes.Companion.getLOWER(), (Object)Stats.INSTANCE.getLOWER()), TuplesKt.to(Aes.Companion.getMIDDLE(), (Object)Stats.INSTANCE.getMIDDLE()), TuplesKt.to(Aes.Companion.getUPPER(), (Object)Stats.INSTANCE.getUPPER())});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/stat/BoxplotStat$Companion;", "", "()V", "DEF_COMPUTE_WIDTH", "", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_WHISKER_IQR_RATIO", "", "P_COEF", "", "P_VARWIDTH", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

