/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import jetbrains.datalore.plot.base.scale.MapperUtil;
import jetbrains.datalore.plot.base.scale.transform.LinearBreaksGen;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0004\"\u0004\b\u0000\u0010\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\r0\u0007J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J&\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00042\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J*\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001e\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J+\u0010\u0019\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\r0\u0007\u00a2\u0006\u0002\u0010\u001dJ2\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0004\"\u0004\b\u0000\u0010\r2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\r0\u0007J&\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J0\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0004\"\u0004\b\u0000\u0010\r2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\r0\u0007H\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/base/scale/ScaleUtil;", "", "()V", "axisBreaks", "", "", "scale", "Ljetbrains/datalore/plot/base/Scale;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "horizontal", "", "breaksAesthetics", "T", "breaksAsNumbers", "breaksTransformed", "getBreaksGenerator", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "inverseTransform", "l", "inverseTransformToContinuousDomain", "labelByBreak", "", "", "labels", "map", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "range", "d", "(Ljava/lang/Double;Ljetbrains/datalore/plot/base/Scale;)Ljava/lang/Object;", "transform", "transformAndMap", "transformedDefinedLimits", "plot-base-portable"})
public final class ScaleUtil {
    public static final ScaleUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> labels(@NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        if (!scale.hasBreaks()) {
            return CollectionsKt.emptyList();
        }
        List<?> breaks = scale.getBreaks();
        if (scale.hasLabels()) {
            List<String> labels = scale.getLabels();
            if (breaks.size() <= labels.size()) {
                return labels.subList(0, breaks.size());
            }
            ArrayList<String> result = new ArrayList<String>();
            int n = 0;
            int n2 = ((Collection)breaks).size();
            while (n < n2) {
                void i;
                if (labels.isEmpty()) {
                    result.add("");
                } else {
                    result.add(labels.get((int)(i % labels.size())));
                }
                ++i;
            }
            return result;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object o : breaks) {
            result.add(String.valueOf(o));
        }
        return result;
    }

    @NotNull
    public final Map<Object, String> labelByBreak(@NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        HashMap result = new HashMap();
        if (scale.hasBreaks()) {
            Iterator<?> breaks = scale.getBreaks().iterator();
            Iterator<String> labels = this.labels(scale).iterator();
            while (breaks.hasNext() && labels.hasNext()) {
                Map map2 = result;
                Object obj = breaks.next();
                Intrinsics.checkNotNull(obj);
                map2.put(obj, labels.next());
            }
        }
        return result;
    }

    @NotNull
    public final List<Double> breaksAsNumbers(@NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        List<?> breaks = scale.getBreaks();
        ArrayList<Double> numbers = new ArrayList<Double>();
        for (Object o : breaks) {
            Double d = scale.asNumber(o);
            Intrinsics.checkNotNull((Object)d);
            numbers.add(d);
        }
        return numbers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> breaksTransformed(@NotNull Scale<?> scale) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Iterable $this$map$iv = this.transform(scale.getBreaks(), scale);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Double d = (Double)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkNotNull((Object)v0);
            Double d2 = v0.doubleValue();
            collection2.add(d2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<Double> axisBreaks(@NotNull Scale<Double> scale, @NotNull CoordinateSystem coord, boolean horizontal) {
        double axisBr;
        boolean bl;
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        List<Double> scaleBreaks = this.transformAndMap(scale.getBreaks(), scale);
        ArrayList<Double> axisBreaks = new ArrayList<Double>();
        Iterator<Double> iterator2 = scaleBreaks.iterator();
        do {
            DoubleVector doubleVector;
            if (!iterator2.hasNext()) {
                return axisBreaks;
            }
            Double br = iterator2.next();
            if (horizontal) {
                Double d = br;
                Intrinsics.checkNotNull((Object)d);
                doubleVector = new DoubleVector(d, 0.0);
            } else {
                Double d = br;
                Intrinsics.checkNotNull((Object)d);
                doubleVector = new DoubleVector(0.0, d);
            }
            DoubleVector mappedBrPoint = doubleVector;
            DoubleVector axisBrPoint = coord.toClient(mappedBrPoint);
            axisBr = horizontal ? axisBrPoint.getX() : axisBrPoint.getY();
            axisBreaks.add(axisBr);
            double d = axisBr;
            boolean bl2 = false;
            double d2 = d;
            boolean bl3 = false;
            if (!Double.isInfinite(d2)) {
                d2 = d;
                bl3 = false;
                if (!Double.isNaN(d2)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (bl);
        throw (Throwable)new IllegalStateException("Illegal axis '" + scale.getName() + "' break position " + axisBr + " at index " + (axisBreaks.size() - 1) + "\nsource breaks    : " + scale.getBreaks() + "\ntranslated breaks: " + scaleBreaks + "\naxis breaks      : " + axisBreaks);
    }

    @NotNull
    public final <T> List<T> breaksAesthetics(@NotNull Scale<T> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        return this.transformAndMap(scale.getBreaks(), scale);
    }

    @NotNull
    public final ClosedRange<Double> map(@NotNull ClosedRange<Double> range2, @NotNull Scale<Double> scale) {
        Intrinsics.checkNotNullParameter(range2, (String)"range");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        return MapperUtil.INSTANCE.map(range2, scale.getMapper());
    }

    @Nullable
    public final <T> T map(@Nullable Double d, @NotNull Scale<T> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        return (T)scale.getMapper().invoke((Object)d);
    }

    @NotNull
    public final <T> List<T> map(@NotNull List<Double> d, @NotNull Scale<T> scale) {
        Intrinsics.checkNotNullParameter(d, (String)"d");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        ArrayList<T> result = new ArrayList<T>();
        for (Double t : d) {
            result.add(this.map(t, scale));
        }
        return result;
    }

    private final <T> List<T> transformAndMap(List<?> l, Scale<T> scale) {
        List<Double> tl = this.transform(l, scale);
        return this.map(tl, scale);
    }

    @NotNull
    public final List<Double> transform(@NotNull List<?> l, @NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        return scale.getTransform().apply(l);
    }

    @NotNull
    public final List<Double> inverseTransformToContinuousDomain(@NotNull List<Double> l, @NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Preconditions.INSTANCE.checkState(scale.isContinuousDomain(), "Not continuous numeric domain: " + scale);
        List<Double> list2 = this.inverseTransform(l, scale);
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Double?>");
        }
        return list2;
    }

    @NotNull
    public final List<?> inverseTransform(@NotNull List<Double> l, @NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Transform transform2 = scale.getTransform();
        ArrayList<Object> result = new ArrayList<Object>(l.size());
        for (Double v : l) {
            result.add(transform2.applyInverse(v));
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<Double> transformedDefinedLimits(@NotNull Scale<?> scale) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(scale, (String)"scale");
                if (!scale.hasDomainLimits()) break block3;
                v0 = new Double[2];
                v1 = scale.getDomainLimits();
                Intrinsics.checkNotNull(v1);
                v0[0] = v1.getLowerEnd();
                v2 = scale.getDomainLimits();
                Intrinsics.checkNotNull(v2);
                v0[1] = v2.getUpperEnd();
                l = CollectionsKt.listOf((Object[])v0);
                $this$filter$iv = CollectionsKt.filterNotNull((Iterable)this.transform(l, scale));
                $i$f$filter = false;
                var5_5 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = ((Number)element$iv$iv).doubleValue();
                    $i$a$-filter-ScaleUtil$transformedDefinedLimits$1 = false;
                    var13_12 = it;
                    var15_13 = false;
                    var16_14 = var13_12;
                    var18_15 = false;
                    if (Double.isInfinite(var16_14)) ** GOTO lbl-1000
                    var16_14 = var13_12;
                    var18_15 = false;
                    if (!Double.isNaN(var16_14)) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                v4 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                break block4;
            }
            v4 = CollectionsKt.emptyList();
        }
        return v4;
    }

    @NotNull
    public final BreaksGenerator getBreaksGenerator(@NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        return scale.hasBreaksGenerator() ? scale.getBreaksGenerator() : (BreaksGenerator)new LinearBreaksGen();
    }

    private ScaleUtil() {
    }

    static {
        ScaleUtil scaleUtil;
        INSTANCE = scaleUtil = new ScaleUtil();
    }
}

