/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import java.util.HashMap;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import jetbrains.datalore.plot.base.util.MutableDouble;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0002\u001a\u00020\u0003H$J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/base/pos/StackPos;", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aes", "Ljetbrains/datalore/plot/base/Aesthetics;", "(Ljetbrains/datalore/plot/base/Aesthetics;)V", "myOffsetByIndex", "", "", "", "handlesGroups", "", "mapIndexToOffset", "translate", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "SplitPositiveNegative", "SumPositiveNegative", "plot-base-portable"})
public abstract class StackPos
implements PositionAdjustment {
    private final Map<Integer, Double> myOffsetByIndex;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract Map<Integer, Double> mapIndexToOffset(@NotNull Aesthetics var1);

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Double d = this.myOffsetByIndex.get(p.index());
        Intrinsics.checkNotNull((Object)d);
        return v.add(new DoubleVector(0.0, ((Number)d).doubleValue()));
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.STACK.handlesGroups();
    }

    public StackPos(@NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        this.myOffsetByIndex = this.mapIndexToOffset(aes);
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0014\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/pos/StackPos$SplitPositiveNegative;", "Ljetbrains/datalore/plot/base/pos/StackPos;", "aes", "Ljetbrains/datalore/plot/base/Aesthetics;", "(Ljetbrains/datalore/plot/base/Aesthetics;)V", "mapIndexToOffset", "", "", "", "plot-base-portable"})
    private static final class SplitPositiveNegative
    extends StackPos {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Map<Integer, Double> mapIndexToOffset(@NotNull Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            HashMap offsetByIndex = new HashMap();
            HashMap negPosBaseByBin = new HashMap();
            int n = 0;
            int n2 = aes.dataPointCount();
            while (n < n2) {
                void i;
                DataPointAesthetics dataPoint = aes.dataPointAt((int)i);
                Double x2 = dataPoint.x();
                if (SeriesUtil.INSTANCE.isFinite(x2)) {
                    Double y2;
                    Map map2 = negPosBaseByBin;
                    boolean bl = false;
                    if (!map2.containsKey(x2)) {
                        Map map3 = negPosBaseByBin;
                        Double d = x2;
                        Intrinsics.checkNotNull((Object)d);
                        map3.put(d, new Pair<MutableDouble, MutableDouble>(new MutableDouble(0.0), new MutableDouble(0.0)));
                    }
                    if (SeriesUtil.INSTANCE.isFinite(y2 = dataPoint.y())) {
                        Map map4 = negPosBaseByBin;
                        boolean bl2 = false;
                        Object v = map4.get(x2);
                        Intrinsics.checkNotNull(v);
                        Pair pair2 = (Pair)v;
                        double offset2 = 0.0;
                        Double d = y2;
                        Intrinsics.checkNotNull((Object)d);
                        offset2 = d >= 0.0 ? ((MutableDouble)pair2.getSecond()).getAndAdd(y2) : ((MutableDouble)pair2.getFirst()).getAndAdd(y2);
                        ((Map)offsetByIndex).put((int)i, offset2);
                    }
                }
                ++i;
            }
            return offsetByIndex;
        }

        public SplitPositiveNegative(@NotNull Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            super(aes);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0014\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/pos/StackPos$SumPositiveNegative;", "Ljetbrains/datalore/plot/base/pos/StackPos;", "aes", "Ljetbrains/datalore/plot/base/Aesthetics;", "(Ljetbrains/datalore/plot/base/Aesthetics;)V", "mapIndexToOffset", "", "", "", "plot-base-portable"})
    private static final class SumPositiveNegative
    extends StackPos {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Map<Integer, Double> mapIndexToOffset(@NotNull Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            HashMap offsetByIndex = new HashMap();
            HashMap baseByBin = new HashMap();
            int n = 0;
            int n2 = aes.dataPointCount();
            while (n < n2) {
                void i;
                DataPointAesthetics dataPointAes = aes.dataPointAt((int)i);
                Double d = dataPointAes.x();
                Intrinsics.checkNotNull((Object)d);
                double x2 = d;
                if (SeriesUtil.INSTANCE.isFinite(x2)) {
                    if (!baseByBin.containsKey(x2)) {
                        ((Map)baseByBin).put(x2, new MutableDouble(0.0));
                    }
                    Double d2 = dataPointAes.y();
                    Intrinsics.checkNotNull((Object)d2);
                    double y2 = d2;
                    if (SeriesUtil.INSTANCE.isFinite(y2)) {
                        Object v = baseByBin.get(x2);
                        Intrinsics.checkNotNull(v);
                        Intrinsics.checkNotNullExpressionValue(v, (String)"baseByBin[x]!!");
                        MutableDouble base = (MutableDouble)v;
                        double offset2 = base.getAndAdd(y2);
                        ((Map)offsetByIndex).put((int)i, offset2);
                    }
                }
                ++i;
            }
            return offsetByIndex;
        }

        public SumPositiveNegative(@NotNull Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            super(aes);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/pos/StackPos$Companion;", "", "()V", "splitPositiveNegative", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aes", "Ljetbrains/datalore/plot/base/Aesthetics;", "sumPositiveNegative", "plot-base-portable"})
    public static final class Companion {
        @NotNull
        public final PositionAdjustment splitPositiveNegative(@NotNull Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            return new SplitPositiveNegative(aes);
        }

        @NotNull
        public final PositionAdjustment sumPositiveNegative(@NotNull Aesthetics aes) {
            Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
            return new SumPositiveNegative(aes);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

