/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.jsObject.JsObjectSupport;
import jetbrains.datalore.base.random.RandomString;
import jetbrains.datalore.plot.server.config.PlotConfigServerSide;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00112\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001a\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J&\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00112\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\b\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/PlotHtmlHelper;", "", "()V", "ATT_SCRIPT_KIND", "", "SCRIPT_KIND_LIB_LOADING", "SCRIPT_KIND_PLOT", "getDynamicConfigureHtml", "scriptUrl", "verbose", "", "getDynamicDisplayHtml", "plotSpecAsJsObjectInitializer", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getDynamicDisplayHtmlForRawSpec", "plotSpec", "", "getStaticConfigureHtml", "getStaticDisplayHtml", "getStaticDisplayHtmlForRawSpec", "version", "suffix", "baseUrl", "plot-config-portable"})
public final class PlotHtmlHelper {
    private static final String ATT_SCRIPT_KIND = "data-lets-plot-script";
    private static final String SCRIPT_KIND_LIB_LOADING = "library";
    private static final String SCRIPT_KIND_PLOT = "plot";
    public static final PlotHtmlHelper INSTANCE;

    @NotNull
    public final String scriptUrl(@NotNull String version, @NotNull String suffix, @NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return baseUrl + "/lets-plot-" + version + '.' + suffix;
    }

    public static /* synthetic */ String scriptUrl$default(PlotHtmlHelper plotHtmlHelper, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "min.js";
        }
        if ((n & 4) != 0) {
            string3 = "https://dl.bintray.com/jetbrains/lets-plot";
        }
        return plotHtmlHelper.scriptUrl(string, string2, string3);
    }

    @NotNull
    public final String getDynamicConfigureHtml(@NotNull String scriptUrl, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        String outputId = RandomString.INSTANCE.randomString(6);
        String successMessage = verbose ? StringsKt.trimMargin$default((String)("\n            |   var div = document.createElement(\"div\");\n            |   div.style.color = 'darkblue';\n            |   div.textContent = 'Lets-Plot JS successfully loaded.';\n            |   document.getElementById(\"" + outputId + "\").appendChild(div);\n            "), null, (int)1, null) : "";
        return StringsKt.trimMargin$default((String)("\n            |   <div id=\"" + outputId + "\"></div>\n            |   <script type=\"text/javascript\" data-lets-plot-script=\"library\">\n            |       if(!window.letsPlotCallQueue) {\n            |           window.letsPlotCallQueue = [];\n            |       }; \n            |       window.letsPlotCall = function(f) {\n            |           window.letsPlotCallQueue.push(f);\n            |       };\n            |       (function() {\n            |           var script = document.createElement(\"script\");\n            |           script.type = \"text/javascript\";\n            |           script.src = \"" + scriptUrl + "\";\n            |           script.onload = function() {\n            |               window.letsPlotCall = function(f) {f();};\n            |               window.letsPlotCallQueue.forEach(function(f) {f();});\n            |               window.letsPlotCallQueue = [];\n            |               \n            |               " + successMessage + "\n            |           };\n            |           script.onerror = function(event) {\n            |               window.letsPlotCall = function(f) {};\n            |               window.letsPlotCallQueue = [];\n            |               var div = document.createElement(\"div\");\n            |               div.style.color = 'darkred';\n            |               div.textContent = 'Error loading Lets-Plot JS';\n            |               document.getElementById(\"" + outputId + "\").appendChild(div);\n            |           };\n            |           var e = document.getElementById(\"" + outputId + "\");\n            |           e.appendChild(script);\n            |       })();\n            |   </script>\n        "), null, (int)1, null);
    }

    @NotNull
    public final String getDynamicDisplayHtmlForRawSpec(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector size2) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Map<String, Object> plotSpec2 = PlotConfigServerSide.Companion.processTransform(plotSpec);
        String plotSpecJs = JsObjectSupport.INSTANCE.mapToJsObjectInitializer(plotSpec2);
        return this.getDynamicDisplayHtml(plotSpecJs, size2);
    }

    public static /* synthetic */ String getDynamicDisplayHtmlForRawSpec$default(PlotHtmlHelper plotHtmlHelper, Map map2, DoubleVector doubleVector, int n, Object object) {
        if ((n & 2) != 0) {
            doubleVector = null;
        }
        return plotHtmlHelper.getDynamicDisplayHtmlForRawSpec(map2, doubleVector);
    }

    private final String getDynamicDisplayHtml(String plotSpecAsJsObjectInitializer, DoubleVector size2) {
        String outputId = RandomString.INSTANCE.randomString(6);
        String dim = size2 == null ? "-1, -1" : size2.getX() + ", " + size2.getY();
        return StringsKt.trimMargin$default((String)("\n            |   <div id=\"" + outputId + "\"></div>\n            |   <script type=\"text/javascript\" data-lets-plot-script=\"plot\">\n            |       (function() {\n            |           var plotSpec=" + plotSpecAsJsObjectInitializer + ";\n            |           var plotContainer = document.getElementById(\"" + outputId + "\");\n            |           window.letsPlotCall(function() {{\n            |               LetsPlot.buildPlotFromProcessedSpecs(plotSpec, " + dim + ", plotContainer);\n            |           }});\n            |       })();    \n            |   </script>\n        "), null, (int)1, null);
    }

    @NotNull
    public final String getStaticConfigureHtml(@NotNull String scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        return "<script type=\"text/javascript\" data-lets-plot-script=\"library\" src=\"" + scriptUrl + "\"></script>";
    }

    @NotNull
    public final String getStaticDisplayHtmlForRawSpec(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector size2) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Map<String, Object> plotSpec2 = PlotConfigServerSide.Companion.processTransform(plotSpec);
        String plotSpecJs = JsObjectSupport.INSTANCE.mapToJsObjectInitializer(plotSpec2);
        return this.getStaticDisplayHtml(plotSpecJs, size2);
    }

    public static /* synthetic */ String getStaticDisplayHtmlForRawSpec$default(PlotHtmlHelper plotHtmlHelper, Map map2, DoubleVector doubleVector, int n, Object object) {
        if ((n & 2) != 0) {
            doubleVector = null;
        }
        return plotHtmlHelper.getStaticDisplayHtmlForRawSpec(map2, doubleVector);
    }

    private final String getStaticDisplayHtml(String plotSpecAsJsObjectInitializer, DoubleVector size2) {
        String outputId = RandomString.INSTANCE.randomString(6);
        String dim = size2 == null ? "-1, -1" : size2.getX() + ", " + size2.getY();
        return StringsKt.trimMargin$default((String)("\n            |   <div id=\"" + outputId + "\"></div>\n            |   <script type=\"text/javascript\" data-lets-plot-script=\"plot\">\n            |       var plotSpec=" + plotSpecAsJsObjectInitializer + ";\n            |       var plotContainer = document.getElementById(\"" + outputId + "\");\n            |       LetsPlot.buildPlotFromProcessedSpecs(plotSpec, " + dim + ", plotContainer);\n            |   </script>\n        "), null, (int)1, null);
    }

    private PlotHtmlHelper() {
    }

    static {
        PlotHtmlHelper plotHtmlHelper;
        INSTANCE = plotHtmlHelper = new PlotHtmlHelper();
    }
}

