/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import jetbrains.datalore.base.spatial.GeographicKt;
import jetbrains.datalore.base.spatial.LonLat;
import jetbrains.datalore.base.spatial.QuadKey;
import jetbrains.datalore.base.spatial.QuadsKt;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import jetbrains.datalore.base.typedGeometry.Scalar;
import jetbrains.datalore.base.typedGeometry.Vec;
import jetbrains.datalore.base.typedGeometry.VecKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a*\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\t0\u0005*\b\u0012\u0004\u0012\u00020\t0\u0003\u001a0\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005\u001a0\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u00070\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0005\u001a\u0010\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\t0\u0003\u00a8\u0006\u000f"}, d2={"computeOrigin", "Ljetbrains/datalore/base/typedGeometry/Vec;", "TypeT", "Ljetbrains/datalore/base/spatial/QuadKey;", "mapRect", "Ljetbrains/datalore/base/typedGeometry/Rect;", "computeRect", "T", "rect", "Ljetbrains/datalore/base/spatial/LonLat;", "projectOrigin", "OutT", "projectRect", "zoom", "", "base-portable"})
public final class QuadKeyKt {
    @NotNull
    public static final Rect<LonLat> computeRect(@NotNull QuadKey<LonLat> $this$computeRect) {
        Intrinsics.checkNotNullParameter($this$computeRect, (String)"$this$computeRect");
        Vec<LonLat> origin = QuadKeyKt.computeOrigin($this$computeRect, GeographicKt.getEARTH_RECT());
        Vec<LonLat> dimension = FunctionsKt.div(GeographicKt.getEARTH_RECT().getDimension(), (double)QuadsKt.calulateQuadsCount($this$computeRect.getLength()));
        Scalar<LonLat> flippedY = FunctionsKt.minus(FunctionsKt.getScalarBottom(GeographicKt.getEARTH_RECT()), FunctionsKt.minus(FunctionsKt.plus(FunctionsKt.getScalarY(origin), FunctionsKt.getScalarY(dimension)), FunctionsKt.getScalarTop(GeographicKt.getEARTH_RECT())));
        return new Rect<LonLat>(FunctionsKt.transform$default(origin, null, (Function1)new Function1<Scalar<LonLat>, Scalar<LonLat>>(flippedY){
            final /* synthetic */ Scalar $flippedY;

            @NotNull
            public final Scalar<LonLat> invoke(@NotNull Scalar<LonLat> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$flippedY;
            }
            {
                this.$flippedY = scalar;
                super(1);
            }
        }, 1, null), dimension);
    }

    @NotNull
    public static final <T> Rect<T> computeRect(@NotNull QuadKey<T> $this$computeRect, @NotNull Rect<T> rect2) {
        Intrinsics.checkNotNullParameter($this$computeRect, (String)"$this$computeRect");
        Intrinsics.checkNotNullParameter(rect2, (String)"rect");
        return QuadKeyKt.projectRect($this$computeRect, rect2);
    }

    @NotNull
    public static final <T, OutT> Rect<OutT> projectRect(@NotNull QuadKey<T> $this$projectRect, @NotNull Rect<OutT> rect2) {
        Intrinsics.checkNotNullParameter($this$projectRect, (String)"$this$projectRect");
        Intrinsics.checkNotNullParameter(rect2, (String)"rect");
        Vec<OutT> origin = QuadKeyKt.projectOrigin($this$projectRect, rect2);
        Vec<OutT> dimension = FunctionsKt.div(rect2.getDimension(), (double)QuadsKt.calulateQuadsCount($this$projectRect.getLength()));
        return new Rect<OutT>(origin, dimension);
    }

    public static final int zoom(@NotNull QuadKey<LonLat> $this$zoom) {
        Intrinsics.checkNotNullParameter($this$zoom, (String)"$this$zoom");
        return $this$zoom.getLength();
    }

    @NotNull
    public static final <TypeT> Vec<TypeT> computeOrigin(@NotNull QuadKey<TypeT> $this$computeOrigin, @NotNull Rect<TypeT> mapRect) {
        Intrinsics.checkNotNullParameter($this$computeOrigin, (String)"$this$computeOrigin");
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        return QuadKeyKt.projectOrigin($this$computeOrigin, mapRect);
    }

    @NotNull
    public static final <TypeT, OutT> Vec<OutT> projectOrigin(@NotNull QuadKey<TypeT> $this$projectOrigin, @NotNull Rect<OutT> mapRect) {
        Intrinsics.checkNotNullParameter($this$projectOrigin, (String)"$this$projectOrigin");
        Intrinsics.checkNotNullParameter(mapRect, (String)"mapRect");
        Scalar<OutT> left = FunctionsKt.getScalarLeft(mapRect);
        Scalar<OutT> top = FunctionsKt.getScalarTop(mapRect);
        Scalar<OutT> width2 = FunctionsKt.getScalarWidth(mapRect);
        Scalar<OutT> height = FunctionsKt.getScalarHeight(mapRect);
        String string = $this$projectOrigin.getKey();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char quadrant = string.charAt(i);
            width2 = FunctionsKt.div(width2, 2.0);
            height = FunctionsKt.div(height, 2.0);
            if (quadrant == '1' || quadrant == '3') {
                left = FunctionsKt.plus(left, width2);
            }
            if (quadrant != '2' && quadrant != '3') continue;
            top = FunctionsKt.plus(top, height);
        }
        return VecKt.newVec(left, top);
    }
}

