/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.collections.list;

import jetbrains.datalore.base.observable.collections.CollectionItemEvent;
import jetbrains.datalore.base.observable.collections.CollectionListener;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.event.ListenerCaller;
import jetbrains.datalore.base.observable.event.Listeners;
import jetbrains.datalore.base.registration.Registration;
import kotlin.Metadata;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u001a\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00120\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007H\u0016J%\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ\u001d\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ%\u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\"J\u001d\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ\u001d\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ%\u0010%\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\"J\u001d\u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\rJ\u0010\u0010'\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J\u001d\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ\u001d\u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ\u001d\u0010*\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\rJ%\u0010+\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\"J\b\u0010,\u001a\u00020\tH\u0014J\b\u0010-\u001a\u00020\tH\u0014J\u0015\u0010.\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00101R\u001e\u0010\u0005\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ljetbrains/datalore/base/observable/collections/list/AbstractObservableList;", "ItemT", "Lkotlin/collections/AbstractMutableList;", "Ljetbrains/datalore/base/observable/collections/list/ObservableList;", "()V", "myListeners", "Ljetbrains/datalore/base/observable/event/Listeners;", "Ljetbrains/datalore/base/observable/collections/CollectionListener;", "add", "", "index", "", "element", "(ILjava/lang/Object;)V", "addHandler", "Ljetbrains/datalore/base/registration/Registration;", "handler", "Ljetbrains/datalore/base/observable/event/EventHandler;", "Ljetbrains/datalore/base/observable/collections/CollectionItemEvent;", "addListener", "l", "afterItemAdded", "item", "success", "", "(ILjava/lang/Object;Z)V", "afterItemRemoved", "afterItemSet", "oldItem", "newItem", "(ILjava/lang/Object;Ljava/lang/Object;Z)V", "beforeItemAdded", "beforeItemRemoved", "beforeItemSet", "(ILjava/lang/Object;Ljava/lang/Object;)V", "checkAdd", "checkRemove", "checkSet", "doAdd", "doRemove", "doSet", "onItemAdd", "onItemRemove", "onItemSet", "onListenersAdded", "onListenersRemoved", "removeAt", "(I)Ljava/lang/Object;", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "base-portable"})
public abstract class AbstractObservableList<ItemT>
extends AbstractMutableList<ItemT>
implements ObservableList<ItemT> {
    private Listeners<CollectionListener<? super ItemT>> myListeners;

    protected void checkAdd(int index, ItemT item) {
        if (index < 0 || index > this.size()) {
            throw (Throwable)new IndexOutOfBoundsException("Add: index=" + index + ", size=" + this.size());
        }
    }

    protected void checkSet(int index, ItemT oldItem, ItemT newItem) {
        if (index < 0 || index >= this.size()) {
            throw (Throwable)new IndexOutOfBoundsException("Set: index=" + index + ", size=" + this.size());
        }
    }

    protected void checkRemove(int index, ItemT item) {
        if (index < 0 || index >= this.size()) {
            throw (Throwable)new IndexOutOfBoundsException("Remove: index=" + index + ", size=" + this.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, ItemT element) {
        this.checkAdd(index, element);
        this.beforeItemAdded(index, element);
        boolean success2 = false;
        try {
            this.doAdd(index, element);
            success2 = true;
            this.onItemAdd(index, element);
            if (this.myListeners != null) {
                CollectionItemEvent<Object> event = new CollectionItemEvent<Object>(null, element, index, CollectionItemEvent.EventType.ADD);
                Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
                Intrinsics.checkNotNull(listeners);
                listeners.fire(new ListenerCaller<CollectionListener<? super ItemT>>(event){
                    final /* synthetic */ CollectionItemEvent $event;

                    public void call(@NotNull CollectionListener<? super ItemT> l) {
                        Intrinsics.checkNotNullParameter(l, (String)"l");
                        l.onItemAdded(this.$event);
                    }
                    {
                        this.$event = $captured_local_variable$0;
                    }
                });
            }
        }
        finally {
            this.afterItemAdded(index, element, success2);
        }
    }

    protected abstract void doAdd(int var1, ItemT var2);

    protected void beforeItemAdded(int index, ItemT item) {
    }

    protected void onItemAdd(int index, ItemT item) {
    }

    protected void afterItemAdded(int index, ItemT item, boolean success2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemT set(int index, ItemT element) {
        Object old = this.get(index);
        this.checkSet(index, old, element);
        this.beforeItemSet(index, old, element);
        boolean success2 = false;
        try {
            this.doSet(index, element);
            success2 = true;
            this.onItemSet(index, old, element);
            if (this.myListeners != null) {
                CollectionItemEvent<Object> event = new CollectionItemEvent<Object>(old, element, index, CollectionItemEvent.EventType.SET);
                Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
                Intrinsics.checkNotNull(listeners);
                listeners.fire(new ListenerCaller<CollectionListener<? super ItemT>>(event){
                    final /* synthetic */ CollectionItemEvent $event;

                    public void call(@NotNull CollectionListener<? super ItemT> l) {
                        Intrinsics.checkNotNullParameter(l, (String)"l");
                        l.onItemSet(this.$event);
                    }
                    {
                        this.$event = $captured_local_variable$0;
                    }
                });
            }
        }
        finally {
            this.afterItemSet(index, old, element, success2);
        }
        return (ItemT)old;
    }

    protected void doSet(int index, ItemT item) {
        this.doRemove(index);
        this.doAdd(index, item);
    }

    protected void beforeItemSet(int index, ItemT oldItem, ItemT newItem) {
    }

    protected void onItemSet(int index, ItemT oldItem, ItemT newItem) {
    }

    protected void afterItemSet(int index, ItemT oldItem, ItemT newItem, boolean success2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemT removeAt(int index) {
        Object item = this.get(index);
        this.checkRemove(index, item);
        this.beforeItemRemoved(index, item);
        boolean success2 = false;
        try {
            this.doRemove(index);
            success2 = true;
            this.onItemRemove(index, item);
            if (this.myListeners != null) {
                CollectionItemEvent<Object> event = new CollectionItemEvent<Object>(item, null, index, CollectionItemEvent.EventType.REMOVE);
                Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
                Intrinsics.checkNotNull(listeners);
                listeners.fire(new ListenerCaller<CollectionListener<? super ItemT>>(event){
                    final /* synthetic */ CollectionItemEvent $event;

                    public void call(@NotNull CollectionListener<? super ItemT> l) {
                        Intrinsics.checkNotNullParameter(l, (String)"l");
                        l.onItemRemoved(this.$event);
                    }
                    {
                        this.$event = $captured_local_variable$0;
                    }
                });
            }
        }
        finally {
            this.afterItemRemoved(index, item, success2);
        }
        return (ItemT)item;
    }

    protected abstract void doRemove(int var1);

    protected void beforeItemRemoved(int index, ItemT item) {
    }

    protected void onItemRemove(int index, ItemT item) {
    }

    protected void afterItemRemoved(int index, ItemT item, boolean success2) {
    }

    @Override
    @NotNull
    public Registration addListener(@NotNull CollectionListener<? super ItemT> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        if (this.myListeners == null) {
            this.myListeners = new Listeners<CollectionListener<? super ItemT>>(this){
                final /* synthetic */ AbstractObservableList this$0;

                protected void beforeFirstAdded() {
                    this.this$0.onListenersAdded();
                }

                protected void afterLastRemoved() {
                    AbstractObservableList.access$setMyListeners$p(this.this$0, null);
                    this.this$0.onListenersRemoved();
                }
                {
                    this.this$0 = this$0;
                }
            };
        }
        Listeners<CollectionListener<ItemT>> listeners = this.myListeners;
        Intrinsics.checkNotNull(listeners);
        return listeners.add(l);
    }

    @Override
    @NotNull
    public Registration addHandler(@NotNull EventHandler<? super CollectionItemEvent<? extends ItemT>> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        CollectionListener listener2 = new CollectionListener<ItemT>(handler2){
            final /* synthetic */ EventHandler $handler;

            public void onItemAdded(@NotNull CollectionItemEvent<? extends ItemT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.$handler.onEvent(event);
            }

            public void onItemSet(@NotNull CollectionItemEvent<? extends ItemT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.$handler.onEvent(event);
            }

            public void onItemRemoved(@NotNull CollectionItemEvent<? extends ItemT> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.$handler.onEvent(event);
            }
            {
                this.$handler = $captured_local_variable$0;
            }
        };
        return this.addListener(listener2);
    }

    protected void onListenersAdded() {
    }

    protected void onListenersRemoved() {
    }

    public static final /* synthetic */ Listeners access$getMyListeners$p(AbstractObservableList $this) {
        return $this.myListeners;
    }

    public static final /* synthetic */ void access$setMyListeners$p(AbstractObservableList $this, Listeners listeners) {
        $this.myListeners = listeners;
    }
}

