/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.json.JsonSupportKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.BooleanCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0001J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012H\u0002J \u0010\u0013\u001a\u00020\r2\u0016\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002JF\u0010\u0018\u001a\u00020\r\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\r0\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u001e\u0012\u0004\u0012\u00020\r0\u001cH\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ljetbrains/datalore/base/json/JsonFormatter;", "", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "kotlin.jvm.PlatformType", "s", "", "formatJson", "o", "formatList", "", "list", "", "formatMap", "map", "", "formatPair", "pair", "", "formatValue", "v", "headTail", "E", "", "head", "Lkotlin/Function1;", "tail", "Lkotlin/sequences/Sequence;", "base-portable"})
public final class JsonFormatter {
    private StringBuilder buffer;

    @NotNull
    public final String formatJson(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.buffer = new StringBuilder();
        this.formatMap((Map)o);
        StringBuilder stringBuilder = this.buffer;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    private final void formatList(List<?> list2) {
        this.append("[");
        this.headTail((Collection)list2, (Function1)new Function1<Object, Unit>(this){

            public final void invoke(@Nullable Object p1) {
                JsonFormatter.access$formatValue((JsonFormatter)this.receiver, p1);
            }
        }, (Function1)new Function1<Sequence<? extends Object>, Unit>(this){
            final /* synthetic */ JsonFormatter this$0;

            public final void invoke(@NotNull Sequence<? extends Object> tail) {
                Intrinsics.checkNotNullParameter(tail, (String)"tail");
                Sequence<? extends Object> $this$forEach$iv = tail;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    E element$iv;
                    E it = element$iv = iterator2.next();
                    boolean bl = false;
                    JsonFormatter.access$append(this.this$0, ",");
                    JsonFormatter.access$formatValue(this.this$0, it);
                }
            }
            {
                this.this$0 = jsonFormatter;
                super(1);
            }
        });
        this.append("]");
    }

    private final void formatMap(Map<?, ?> map2) {
        this.append("{");
        this.headTail((Collection)map2.entrySet(), (Function1)new Function1<Map.Entry<? extends Object, ? extends Object>, Unit>(this){

            public final void invoke(@NotNull Map.Entry<? extends Object, ? extends Object> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                JsonFormatter.access$formatPair((JsonFormatter)this.receiver, p1);
            }
        }, (Function1)new Function1<Sequence<? extends Map.Entry<? extends Object, ? extends Object>>, Unit>(this){
            final /* synthetic */ JsonFormatter this$0;

            public final void invoke(@NotNull Sequence<? extends Map.Entry<? extends Object, ? extends Object>> tail) {
                Intrinsics.checkNotNullParameter(tail, (String)"tail");
                Sequence<? extends Map.Entry<? extends Object, ? extends Object>> $this$forEach$iv = tail;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    JsonFormatter.access$append(this.this$0, ",\n");
                    JsonFormatter.access$formatPair(this.this$0, it);
                }
            }
            {
                this.this$0 = jsonFormatter;
                super(1);
            }
        });
        this.append("}");
    }

    private final void formatValue(Object v) {
        Object object = v;
        if (object == null) {
            this.append("null");
        } else if (object instanceof String) {
            this.append('\"' + JsonSupportKt.escape((String)v) + '\"');
        } else if (object instanceof Number || Intrinsics.areEqual((Object)object, (Object)BooleanCompanionObject.INSTANCE)) {
            this.append(v.toString());
        } else if (object instanceof Object[]) {
            this.formatList(ArraysKt.asList((Object[])((Object[])v)));
        } else if (object instanceof List) {
            this.formatList((List)v);
        } else if (object instanceof Map) {
            this.formatMap((Map)v);
        } else {
            throw (Throwable)new IllegalArgumentException("Can't serialize object " + v);
        }
    }

    private final void formatPair(Map.Entry<? extends Object, ? extends Object> pair2) {
        this.append("" + '\"' + pair2.getKey() + "\":");
        this.formatValue(pair2.getValue());
    }

    private final StringBuilder append(String s2) {
        StringBuilder stringBuilder = this.buffer;
        if (stringBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
        }
        return stringBuilder.append(s2);
    }

    private final <E> void headTail(Collection<? extends E> $this$headTail, Function1<? super E, Unit> head, Function1<? super Sequence<? extends E>, Unit> tail) {
        if (!$this$headTail.isEmpty()) {
            head.invoke(CollectionsKt.first((Iterable)$this$headTail));
            tail.invoke((Object)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)$this$headTail), (int)1));
        }
    }

    public static final /* synthetic */ void access$formatValue(JsonFormatter $this, Object v) {
        $this.formatValue(v);
    }

    public static final /* synthetic */ StringBuilder access$append(JsonFormatter $this, String s2) {
        return $this.append(s2);
    }

    public static final /* synthetic */ void access$formatPair(JsonFormatter $this, Map.Entry pair2) {
        $this.formatPair(pair2);
    }
}

