/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.gcommon.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072 \u0010\b\u001a\u001c\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00040\tj\n\u0012\u0006\b\u0000\u0012\u0002H\u0005`\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007JB\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0004\b\u0000\u0010\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072 \u0010\u0014\u001a\u001c\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00040\tj\n\u0012\u0006\b\u0000\u0012\u0002H\u0005`\nJI\u0010\u0015\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072 \u0010\b\u001a\u001c\u0012\u0006\b\u0000\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00040\tj\n\u0012\u0006\b\u0000\u0012\u0002H\u0005`\n2\u0006\u0010\u0016\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u0019J2\u0010\u0018\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u0002H\u0005H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u00020\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u001e\u001a\u00020\u000e2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001f\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0000\u00a2\u0006\u0004\b!\u0010\"J \u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00050$\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a8\u0006%"}, d2={"Ljetbrains/datalore/base/gcommon/collect/Iterables;", "", "()V", "all", "", "T", "iterable", "", "predicate", "Lkotlin/Function1;", "Ljetbrains/datalore/base/function/Predicate;", "checkNonNegative", "", "position", "", "concat", "a", "b", "filter", "unfiltered", "retainIfTrue", "find", "defaultValue", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)Ljava/lang/Object;", "get", "(Ljava/lang/Iterable;I)Ljava/lang/Object;", "(Ljava/lang/Iterable;ILjava/lang/Object;)Ljava/lang/Object;", "getLast", "(Ljava/lang/Iterable;)Ljava/lang/Object;", "isEmpty", "size", "toArray", "", "toArray$base_portable", "(Ljava/lang/Iterable;)[Ljava/lang/Object;", "toList", "", "base-portable"})
public final class Iterables {
    public static final Iterables INSTANCE;

    private final void checkNonNegative(int position) {
        if (position < 0) {
            throw (Throwable)new IndexOutOfBoundsException(String.valueOf(position));
        }
    }

    @NotNull
    public final <T> List<T> toList(@NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        return CollectionsKt.toList(iterable);
    }

    public final int size(@NotNull Iterable<?> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        return CollectionsKt.count(iterable);
    }

    public final boolean isEmpty(@NotNull Iterable<?> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        Iterable<?> iterable2 = iterable;
        if (!(iterable2 instanceof Collection)) {
            iterable2 = null;
        }
        Collection collection2 = (Collection)iterable2;
        return collection2 != null ? collection2.isEmpty() : !iterable.iterator().hasNext();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Iterable<T> filter(@NotNull Iterable<? extends T> unfiltered, @NotNull Function1<? super T, Boolean> retainIfTrue) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unfiltered, (String)"unfiltered");
        Intrinsics.checkNotNullParameter(retainIfTrue, (String)"retainIfTrue");
        Iterable<? extends T> $this$filter$iv = unfiltered;
        boolean $i$f$filter = false;
        Iterable<? extends T> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)retainIfTrue.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final <T> boolean all(@NotNull Iterable<? extends T> iterable, @NotNull Function1<? super T, Boolean> predicate) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable<T> $this$all$iv = iterable;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    if (((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final <T> Iterable<T> concat(@NotNull Iterable<? extends T> a, @NotNull Iterable<? extends T> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return CollectionsKt.plus(a, b);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T get(@NotNull Iterable<? extends T> iterable, int position) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        this.checkNonNegative(position);
        if (iterable instanceof List) {
            return (T)((List)iterable).get(position);
        }
        Iterator<T> it = iterable.iterator();
        int n = 0;
        int n2 = position;
        if (n <= n2) {
            while (true) {
                void i;
                if (i == position) {
                    return it.next();
                }
                it.next();
                if (i == n2) break;
                ++i;
            }
        }
        throw (Throwable)new IndexOutOfBoundsException(String.valueOf(position));
    }

    public final <T> T get(@NotNull Iterable<? extends T> iterable, int position, T defaultValue) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        this.checkNonNegative(position);
        if (iterable instanceof List) {
            List list2 = (List)iterable;
            return (T)(position < list2.size() ? list2.get(position) : defaultValue);
        }
        Iterator<T> it = iterable.iterator();
        for (int i = 0; i <= position && it.hasNext(); ++i) {
            if (i == position) {
                return it.next();
            }
            it.next();
        }
        return defaultValue;
    }

    public final <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Function1<? super T, Boolean> predicate, T defaultValue) {
        T t;
        T t2;
        block2: {
            Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable<T> iterable2 = iterable;
            boolean bl = false;
            Iterable<T> iterable3 = iterable2;
            boolean bl2 = false;
            for (T t3 : iterable3) {
                if (!((Boolean)predicate.invoke(t3)).booleanValue()) continue;
                t2 = t3;
                break block2;
            }
            t2 = t = null;
        }
        if (t2 == null) {
            t = defaultValue;
        }
        return t;
    }

    public final <T> T getLast(@NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        return (T)CollectionsKt.last(iterable);
    }

    @NotNull
    public final Object[] toArray$base_portable(@NotNull Iterable<?> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        Collection collection2 = null;
        collection2 = iterable instanceof Collection ? (Collection)iterable : (Collection)CollectionsKt.toList(iterable);
        Collection $this$toTypedArray$iv = collection2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return objectArray;
    }

    private Iterables() {
    }

    static {
        Iterables iterables;
        INSTANCE = iterables = new Iterables();
    }
}

