/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.Duration;
import jetbrains.datalore.base.datetime.Instant;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.base.datetime.Time;
import jetbrains.datalore.base.datetime.WeekDay;
import jetbrains.datalore.base.datetime.tz.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00014B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0011\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010(\u001a\u00020)2\b\u0010'\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020\nH\u0016J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u000202J\b\u00103\u001a\u000202H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\u00a8\u00065"}, d2={"Ljetbrains/datalore/base/datetime/DateTime;", "", "date", "Ljetbrains/datalore/base/datetime/Date;", "time", "Ljetbrains/datalore/base/datetime/Time;", "(Ljetbrains/datalore/base/datetime/Date;Ljetbrains/datalore/base/datetime/Time;)V", "getDate", "()Ljetbrains/datalore/base/datetime/Date;", "day", "", "getDay", "()I", "hours", "getHours", "milliseconds", "getMilliseconds", "minutes", "getMinutes", "month", "Ljetbrains/datalore/base/datetime/Month;", "getMonth", "()Ljetbrains/datalore/base/datetime/Month;", "seconds", "getSeconds", "getTime", "()Ljetbrains/datalore/base/datetime/Time;", "weekDay", "Ljetbrains/datalore/base/datetime/WeekDay;", "getWeekDay", "()Ljetbrains/datalore/base/datetime/WeekDay;", "year", "getYear", "add", "duration", "Ljetbrains/datalore/base/datetime/Duration;", "changeDate", "changeTime", "compareTo", "other", "equals", "", "", "hashCode", "isAfter", "dateTime", "isBefore", "to", "otherTime", "toPrettyString", "", "toString", "Companion", "base-portable"})
public final class DateTime
implements Comparable<DateTime> {
    @NotNull
    private final Date date;
    @NotNull
    private final Time time;
    public static final Companion Companion = new Companion(null);

    public final int getYear() {
        return this.date.getYear();
    }

    @Nullable
    public final Month getMonth() {
        return this.date.getMonth();
    }

    public final int getDay() {
        return this.date.getDay();
    }

    @NotNull
    public final WeekDay getWeekDay() {
        return this.date.getWeekDay();
    }

    public final int getHours() {
        return this.time.getHours();
    }

    public final int getMinutes() {
        return this.time.getMinutes();
    }

    public final int getSeconds() {
        return this.time.getSeconds();
    }

    public final int getMilliseconds() {
        return this.time.getMilliseconds();
    }

    @NotNull
    public final DateTime changeDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new DateTime(date, this.time);
    }

    @NotNull
    public final DateTime changeTime(@NotNull Time time2) {
        Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
        return new DateTime(this.date, time2);
    }

    @NotNull
    public final DateTime add(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Instant utcInstant = TimeZone.Companion.getUTC().toInstant(this);
        return TimeZone.Companion.getUTC().toDateTime(utcInstant.add(duration));
    }

    @NotNull
    public final Duration to(@NotNull DateTime otherTime) {
        Intrinsics.checkNotNullParameter((Object)otherTime, (String)"otherTime");
        Instant currentInstant = TimeZone.Companion.getUTC().toInstant(this);
        Instant otherInstant = TimeZone.Companion.getUTC().toInstant(otherTime);
        return currentInstant.to(otherInstant);
    }

    public final boolean isBefore(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return this.compareTo(dateTime) < 0;
    }

    public final boolean isAfter(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return this.compareTo(dateTime) > 0;
    }

    public int hashCode() {
        return this.date.hashCode() * 31 + this.time.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DateTime)) {
            return false;
        }
        DateTime otherDateTime = (DateTime)other;
        return Intrinsics.areEqual((Object)this.date, (Object)otherDateTime.date) && Intrinsics.areEqual((Object)this.time, (Object)otherDateTime.time);
    }

    @Override
    public int compareTo(@NotNull DateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int dateComparison = this.date.compareTo(other.date);
        return dateComparison != 0 ? dateComparison : this.time.compareTo(other.time);
    }

    @NotNull
    public String toString() {
        return this.date.toString() + "T" + this.time;
    }

    @NotNull
    public final String toPrettyString() {
        return this.time.toPrettyHMString() + " " + this.date.toPrettyString();
    }

    @NotNull
    public final Date getDate() {
        return this.date;
    }

    @NotNull
    public final Time getTime() {
        return this.time;
    }

    @JvmOverloads
    public DateTime(@NotNull Date date, @NotNull Time time2) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)time2, (String)"time");
        this.date = date;
        this.time = time2;
    }

    public /* synthetic */ DateTime(Date date, Time time2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            time2 = Time.Companion.getDAY_START();
        }
        this(date, time2);
    }

    @JvmOverloads
    public DateTime(@NotNull Date date) {
        this(date, null, 2, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/base/datetime/DateTime$Companion;", "", "()V", "parse", "Ljetbrains/datalore/base/datetime/DateTime;", "s", "", "base-portable"})
    public static final class Companion {
        @NotNull
        public final DateTime parse(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            if (s2.length() < 15) {
                throw (Throwable)new IllegalArgumentException();
            }
            String string = s2;
            int n = 0;
            int n2 = 8;
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Date date = Date.Companion.parse(string2);
            string = s2;
            n = 9;
            n2 = 0;
            String string3 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return new DateTime(date, Time.Companion.parse(string3));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

