/*
 * Copyright (c) 2019. JetBrains s.r.o.
 * Use of this source code is governed by the MIT license that can be found in the LICENSE file.
 */

package jetbrains.datalore.base.event

enum class Key private constructor(private val myValue: String) {
    A("A"),
    B("B"),
    C("C"),
    D("D"),
    E("E"),
    F("F"),
    G("G"),
    H("H"),
    I("I"),
    J("J"),
    K("K"),
    L("L"),
    M("M"),
    N("N"),
    O("O"),
    P("P"),
    Q("Q"),
    R("R"),
    S("S"),
    T("T"),
    U("U"),
    V("V"),
    W("W"),
    X("X"),
    Y("Y"),
    Z("Z"),
    DIGIT_0("0"),
    DIGIT_1("1"),
    DIGIT_2("2"),
    DIGIT_3("3"),
    DIGIT_4("4"),
    DIGIT_5("5"),
    DIGIT_6("6"),
    DIGIT_7("7"),
    DIGIT_8("8"),
    DIGIT_9("9"),
    LEFT_BRACE("["),
    RIGHT_BRACE("]"),
    UP("Up"),
    DOWN("Down"),
    LEFT("Left"),
    RIGHT("Right"),
    PAGE_UP("Page Up"),
    PAGE_DOWN("Page Down"),
    ESCAPE("Escape"),
    ENTER("Enter"),
    HOME("Home"),
    END("End"),
    TAB("Tab"),
    SPACE("Space"),
    INSERT("Insert"),
    DELETE("Delete"),
    BACKSPACE("Backspace"),
    EQUALS("Equals"),
    BACK_QUOTE("`"),
    PLUS("Plus"),
    MINUS("Minus"),
    SLASH("Slash"),
    CONTROL("Ctrl"),
    META("Meta"),
    ALT("Alt"),
    SHIFT("Shift"),
    UNKNOWN("?"),
    F1("F1"),
    F2("F2"),
    F3("F3"),
    F4("F4"),
    F5("F5"),
    F6("F6"),
    F7("F7"),
    F8("F8"),
    F9("F9"),
    F10("F10"),
    F11("F11"),
    F12("F12"),
    COMMA(","),
    PERIOD(".");

    override fun toString(): String {
        return myValue
    }
}
