/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.features.jvm.impl;

import com.intellij.rt.coverage.aggregate.api.AggregatorApi;
import com.intellij.rt.coverage.aggregate.api.Request;
import com.intellij.rt.coverage.report.api.Filters;
import com.intellij.rt.coverage.verify.Verifier;
import com.intellij.rt.coverage.verify.api.Counter;
import com.intellij.rt.coverage.verify.api.RuleViolation;
import com.intellij.rt.coverage.verify.api.Target;
import com.intellij.rt.coverage.verify.api.ValueType;
import com.intellij.rt.coverage.verify.api.VerificationApi;
import com.intellij.rt.coverage.verify.api.Violation;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.features.jvm.AggregationType;
import kotlinx.kover.features.jvm.Bound;
import kotlinx.kover.features.jvm.BoundViolation;
import kotlinx.kover.features.jvm.ClassFilters;
import kotlinx.kover.features.jvm.CoverageUnit;
import kotlinx.kover.features.jvm.GroupingBy;
import kotlinx.kover.features.jvm.Rule;
import kotlinx.kover.features.jvm.RuleViolations;
import kotlinx.kover.features.jvm.impl.WildcardsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001#B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002JF\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lkotlinx/kover/features/jvm/impl/LegacyVerification;", "", "()V", "ONE_HUNDRED", "Ljava/math/BigDecimal;", "getONE_HUNDRED$kover_features_jvm", "()Ljava/math/BigDecimal;", "counterToIntellij", "Lcom/intellij/rt/coverage/verify/api/Counter;", "bound", "Lkotlinx/kover/features/jvm/Bound;", "intellijToValue", "intellijValue", "isPercentage", "", "aggregationType", "Lkotlinx/kover/features/jvm/AggregationType;", "targetToIntellij", "Lcom/intellij/rt/coverage/verify/api/Target;", "rule", "Lkotlinx/kover/features/jvm/Rule;", "valueToIntellij", "value", "valueTypeToIntellij", "Lcom/intellij/rt/coverage/verify/api/ValueType;", "verify", "", "Lkotlinx/kover/features/jvm/RuleViolations;", "rules", "tempDir", "Ljava/io/File;", "filters", "Lkotlinx/kover/features/jvm/ClassFilters;", "reports", "outputs", "ViolationId", "kover-features-jvm"})
public final class LegacyVerification {
    @NotNull
    public static final LegacyVerification INSTANCE = new LegacyVerification();
    @NotNull
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);

    private LegacyVerification() {
    }

    @NotNull
    public final BigDecimal getONE_HUNDRED$kover_features_jvm() {
        return ONE_HUNDRED;
    }

    @NotNull
    public final List<RuleViolations> verify(@NotNull List<Rule> rules, @NotNull File tempDir, @NotNull ClassFilters filters, @NotNull List<? extends File> reports, @NotNull List<? extends File> outputs) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(reports, (String)"reports");
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        Filters intellijFilters = WildcardsKt.convert(filters);
        ArrayList<com.intellij.rt.coverage.verify.api.Rule> rulesArray = new ArrayList<com.intellij.rt.coverage.verify.api.Rule>();
        File ic = FilesKt.resolve((File)tempDir, (String)"agg-ic.ic");
        File smap = FilesKt.resolve((File)tempDir, (String)"agg-smap.smap");
        Request requests = new Request(intellijFilters, ic, smap);
        AggregatorApi.aggregate((List)CollectionsKt.listOf((Object)requests), reports, outputs);
        int n = ((Collection)rules).size();
        for (int ruleIndex = 0; ruleIndex < n; ++ruleIndex) {
            Rule rule = rules.get(ruleIndex);
            List bounds = new ArrayList();
            int n2 = ((Collection)rule.getBounds()).size();
            for (int boundIndex = 0; boundIndex < n2; ++boundIndex) {
                Bound b = rule.getBounds().get(boundIndex);
                bounds.add(new com.intellij.rt.coverage.verify.api.Bound(boundIndex, this.counterToIntellij(b), this.valueTypeToIntellij(b), this.valueToIntellij(b, b.getMinValue()), this.valueToIntellij(b, b.getMaxValue())));
            }
            rulesArray.add(new com.intellij.rt.coverage.verify.api.Rule(ruleIndex, ic, this.targetToIntellij(rule), bounds));
        }
        Verifier verifier = new Verifier((List)rulesArray);
        verifier.processRules();
        List violations = VerificationApi.verify((List)rulesArray);
        ArrayList<RuleViolations> ruleViolations = new ArrayList<RuleViolations>();
        for (RuleViolation ruleViolation : violations) {
            TreeMap resultBounds = new TreeMap();
            Rule rule = rules.get(ruleViolation.id);
            int n3 = ((Collection)ruleViolation.violations).size();
            for (int boundIndex = 0; boundIndex < n3; ++boundIndex) {
                BoundViolation boundViolation;
                ViolationId violationId;
                Map map;
                String entityName;
                com.intellij.rt.coverage.verify.api.BoundViolation boundViolation2 = (com.intellij.rt.coverage.verify.api.BoundViolation)ruleViolation.violations.get(boundIndex);
                Bound bound = rule.getBounds().get(boundViolation2.id);
                for (Violation maxViolation : boundViolation2.maxViolations) {
                    entityName = rule.getGroupBy() != GroupingBy.APPLICATION ? maxViolation.targetName : null;
                    map = resultBounds;
                    violationId = new ViolationId(boundViolation2.id, entityName);
                    BigDecimal bigDecimal = maxViolation.targetValue;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"maxViolation.targetValue");
                    boundViolation = new BoundViolation(bound, true, this.intellijToValue(bigDecimal, bound), entityName);
                    map.put(violationId, boundViolation);
                }
                for (Violation minViolation : boundViolation2.minViolations) {
                    entityName = rule.getGroupBy() != GroupingBy.APPLICATION ? minViolation.targetName : null;
                    map = resultBounds;
                    violationId = new ViolationId(boundViolation2.id, entityName);
                    BigDecimal bigDecimal = minViolation.targetValue;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"minViolation.targetValue");
                    boundViolation = new BoundViolation(bound, false, this.intellijToValue(bigDecimal, bound), entityName);
                    map.put(violationId, boundViolation);
                }
            }
            ruleViolations.add(new RuleViolations(rule, new ArrayList(resultBounds.values())));
        }
        return ruleViolations;
    }

    private final BigDecimal intellijToValue(BigDecimal intellijValue, Bound bound) {
        BigDecimal bigDecimal;
        if (this.isPercentage(bound.getAggregationForGroup())) {
            BigDecimal bigDecimal2 = intellijValue.multiply(ONE_HUNDRED);
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"{\n            intellijVa\u2026ly(ONE_HUNDRED)\n        }");
        } else {
            bigDecimal = intellijValue;
        }
        return bigDecimal;
    }

    private final Target targetToIntellij(Rule rule) {
        Target target;
        switch (WhenMappings.$EnumSwitchMapping$0[rule.getGroupBy().ordinal()]) {
            case 1: {
                target = Target.ALL;
                break;
            }
            case 2: {
                target = Target.CLASS;
                break;
            }
            case 3: {
                target = Target.PACKAGE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return target;
    }

    private final Counter counterToIntellij(Bound bound) {
        Counter counter;
        switch (WhenMappings.$EnumSwitchMapping$1[bound.getCoverageUnits().ordinal()]) {
            case 1: {
                counter = Counter.LINE;
                break;
            }
            case 2: {
                counter = Counter.INSTRUCTION;
                break;
            }
            case 3: {
                counter = Counter.BRANCH;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return counter;
    }

    private final ValueType valueTypeToIntellij(Bound bound) {
        ValueType valueType;
        switch (WhenMappings.$EnumSwitchMapping$2[bound.getAggregationForGroup().ordinal()]) {
            case 1: {
                valueType = ValueType.COVERED;
                break;
            }
            case 2: {
                valueType = ValueType.MISSED;
                break;
            }
            case 3: {
                valueType = ValueType.COVERED_RATE;
                break;
            }
            case 4: {
                valueType = ValueType.MISSED_RATE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return valueType;
    }

    private final BigDecimal valueToIntellij(Bound bound, BigDecimal value) {
        if (value == null) {
            return null;
        }
        return this.isPercentage(bound.getAggregationForGroup()) ? value.divide(ONE_HUNDRED, 6, RoundingMode.HALF_UP) : value;
    }

    private final boolean isPercentage(AggregationType aggregationType) {
        return aggregationType == AggregationType.COVERED_PERCENTAGE || aggregationType == AggregationType.MISSED_PERCENTAGE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0005H\u00d6\u0001R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/kover/features/jvm/impl/LegacyVerification$ViolationId;", "", "index", "", "entityName", "", "(ILjava/lang/String;)V", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "kover-features-jvm"})
    @SourceDebugExtension(value={"SMAP\nLegacyVerification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyVerification.kt\nkotlinx/kover/features/jvm/impl/LegacyVerification$ViolationId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    private static final class ViolationId
    implements Comparable<ViolationId> {
        private final int index;
        @Nullable
        private final String entityName;

        public ViolationId(int index, @Nullable String entityName) {
            this.index = index;
            this.entityName = entityName;
        }

        @Override
        public int compareTo(@NotNull ViolationId other) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Integer n2 = Intrinsics.compare((int)this.index, (int)other.index);
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = n = it != 0 ? n2 : null;
            if (n != null) {
                it = ((Number)n).intValue();
                boolean bl2 = false;
                return it;
            }
            if (this.entityName == null) {
                return other.entityName == null ? 0 : -1;
            }
            if (other.entityName == null) {
                return 1;
            }
            return this.entityName.compareTo(other.entityName);
        }

        private final int component1() {
            return this.index;
        }

        private final String component2() {
            return this.entityName;
        }

        @NotNull
        public final ViolationId copy(int index, @Nullable String entityName) {
            return new ViolationId(index, entityName);
        }

        public static /* synthetic */ ViolationId copy$default(ViolationId violationId, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = violationId.index;
            }
            if ((n2 & 2) != 0) {
                string = violationId.entityName;
            }
            return violationId.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "ViolationId(index=" + this.index + ", entityName=" + this.entityName + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + (this.entityName == null ? 0 : this.entityName.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViolationId)) {
                return false;
            }
            ViolationId violationId = (ViolationId)other;
            if (this.index != violationId.index) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.entityName, (Object)violationId.entityName);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[GroupingBy.values().length];
            try {
                nArray[GroupingBy.APPLICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupingBy.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupingBy.PACKAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CoverageUnit.values().length];
            try {
                nArray[CoverageUnit.LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageUnit.INSTRUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageUnit.BRANCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[AggregationType.values().length];
            try {
                nArray[AggregationType.COVERED_COUNT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_COUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.COVERED_PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_PERCENTAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

