/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002H\u00c6\u0003J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0001H\u0096\u0001J\u001f\u0010 \u001a\u00020\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\u0011\u0010$\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0003H\u0096\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u0003J\u0010\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\u0003J\"\u0010(\u001a\u0002H)\"\n\b\u0000\u0010)\u0018\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u0010\u0010,\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u0010\u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u0003J\u0010\u00100\u001a\u0004\u0018\u00010/2\u0006\u0010\u001d\u001a\u00020\u0003J\t\u00101\u001a\u00020\u0013H\u00d6\u0001J\t\u00102\u001a\u00020\u001cH\u0096\u0001J$\u00103\u001a\u0004\u0018\u0001H)\"\n\b\u0000\u0010)\u0018\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\b\u00a2\u0006\u0002\u0010*J\b\u00104\u001a\u00020\u0003H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\n0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lkotlinx/serialization/json/JsonObject;", "Lkotlinx/serialization/json/JsonElement;", "", "", "content", "(Ljava/util/Map;)V", "getContent", "()Ljava/util/Map;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "jsonObject", "getJsonObject", "()Lkotlinx/serialization/json/JsonObject;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "component1", "containsKey", "", "key", "containsValue", "value", "copy", "equals", "other", "", "get", "getArray", "Lkotlinx/serialization/json/JsonArray;", "getArrayOrNull", "getAs", "J", "(Ljava/lang/String;)Lkotlinx/serialization/json/JsonElement;", "getObject", "getObjectOrNull", "getOrNull", "getPrimitive", "Lkotlinx/serialization/json/JsonPrimitive;", "getPrimitiveOrNull", "hashCode", "isEmpty", "lookup", "toString", "kotlinx-serialization-runtime"})
public final class JsonObject
extends JsonElement
implements Map<String, JsonElement>,
KMappedMarker {
    @NotNull
    private final JsonObject jsonObject;
    @NotNull
    private final Map<String, JsonElement> content;

    @Override
    @NotNull
    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @NotNull
    public JsonElement get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        JsonElement jsonElement = this.content.get(key);
        if (jsonElement == null) {
            throw (Throwable)new NoSuchElementException("Element " + key + " is missing");
        }
        return jsonElement;
    }

    @Nullable
    public final JsonElement getOrNull(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.content.get(key);
    }

    @NotNull
    public final JsonPrimitive getPrimitive(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.get((Object)key);
        if (!(object instanceof JsonPrimitive)) {
            object = null;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)object;
        if (jsonPrimitive == null) {
            Void void_ = JsonElementKt.unexpectedJson(key, "JsonPrimitive");
            throw null;
        }
        return jsonPrimitive;
    }

    @NotNull
    public final JsonObject getObject(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.get((Object)key);
        if (!(object instanceof JsonObject)) {
            object = null;
        }
        JsonObject jsonObject = (JsonObject)object;
        if (jsonObject == null) {
            Void void_ = JsonElementKt.unexpectedJson(key, "JsonObject");
            throw null;
        }
        return jsonObject;
    }

    @NotNull
    public final JsonArray getArray(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Object object = this.get((Object)key);
        if (!(object instanceof JsonArray)) {
            object = null;
        }
        JsonArray jsonArray = (JsonArray)object;
        if (jsonArray == null) {
            Void void_ = JsonElementKt.unexpectedJson(key, "JsonArray");
            throw null;
        }
        return jsonArray;
    }

    @Nullable
    public final JsonPrimitive getPrimitiveOrNull(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        JsonElement jsonElement = this.content.get(key);
        if (!(jsonElement instanceof JsonPrimitive)) {
            jsonElement = null;
        }
        return (JsonPrimitive)jsonElement;
    }

    @Nullable
    public final JsonObject getObjectOrNull(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        JsonElement jsonElement = this.content.get(key);
        if (!(jsonElement instanceof JsonObject)) {
            jsonElement = null;
        }
        return (JsonObject)jsonElement;
    }

    @Nullable
    public final JsonArray getArrayOrNull(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        JsonElement jsonElement = this.content.get(key);
        if (!(jsonElement instanceof JsonArray)) {
            jsonElement = null;
        }
        return (JsonArray)jsonElement;
    }

    private final <J extends JsonElement> J getAs(String key) {
        Object object = this.get((Object)key);
        Intrinsics.reifiedOperationMarker((int)2, (String)"J");
        JsonElement jsonElement = (JsonElement)object;
        if (jsonElement == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"J");
            Void void_ = JsonElementKt.unexpectedJson(key, Reflection.getOrCreateKotlinClass(JsonElement.class).toString());
            throw null;
        }
        return (J)jsonElement;
    }

    private final <J extends JsonElement> J lookup(String key) {
        JsonElement jsonElement = this.getContent().get(key);
        Intrinsics.reifiedOperationMarker((int)2, (String)"J");
        return (J)jsonElement;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.content.entrySet(), null, (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)toString.1.INSTANCE, (int)25, null);
    }

    @NotNull
    public final Map<String, JsonElement> getContent() {
        return this.content;
    }

    public JsonObject(@NotNull Map<String, ? extends JsonElement> content) {
        Intrinsics.checkParameterIsNotNull(content, (String)"content");
        super(null);
        this.content = content;
        this.jsonObject = this;
    }

    @NotNull
    public Set<Map.Entry<String, JsonElement>> getEntries() {
        return this.content.entrySet();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.content.keySet();
    }

    public int getSize() {
        return this.content.size();
    }

    @NotNull
    public Collection<JsonElement> getValues() {
        return this.content.values();
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.content.containsKey(key);
    }

    public boolean containsValue(@NotNull JsonElement value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.content.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @NotNull
    public final Map<String, JsonElement> component1() {
        return this.content;
    }

    @NotNull
    public final JsonObject copy(@NotNull Map<String, ? extends JsonElement> content) {
        Intrinsics.checkParameterIsNotNull(content, (String)"content");
        return new JsonObject(content);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ JsonObject copy$default(JsonObject jsonObject, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = jsonObject.content;
        }
        return jsonObject.copy(map);
    }

    @Override
    public int hashCode() {
        Map<String, JsonElement> map = this.content;
        return map != null ? ((Object)map).hashCode() : 0;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JsonObject)) break block3;
                JsonObject jsonObject = (JsonObject)object;
                if (!Intrinsics.areEqual(this.content, jsonObject.content)) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement compute(String string, BiFunction<? super String, ? super JsonElement, ? extends JsonElement> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement computeIfAbsent(String string, Function<? super String, ? extends JsonElement> function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement computeIfPresent(String string, BiFunction<? super String, ? super JsonElement, ? extends JsonElement> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement merge(String string, JsonElement jsonElement, BiFunction<? super JsonElement, ? super JsonElement, ? extends JsonElement> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement put(String string, JsonElement jsonElement) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> map) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement putIfAbsent(String string, JsonElement jsonElement) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(String string, JsonElement jsonElement, JsonElement jsonElement2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JsonElement replace(String string, JsonElement jsonElement) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super JsonElement, ? extends JsonElement> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object compute(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object computeIfAbsent(Object object, Function function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object computeIfPresent(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object merge(Object object, Object object2, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object putIfAbsent(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ boolean replace(Object object, Object object2, Object object3) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object replace(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

