/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.serialization.ImplicitReflectionSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.TypeBase;
import kotlinx.serialization.context.SerialContext;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.BooleanSerializer;
import kotlinx.serialization.internal.ByteSerializer;
import kotlinx.serialization.internal.CharSerializer;
import kotlinx.serialization.internal.DoubleSerializer;
import kotlinx.serialization.internal.FloatSerializer;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.HashSetSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.MapEntryClassDesc;
import kotlinx.serialization.internal.MapEntrySerializer;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.internal.SerialCache;
import kotlinx.serialization.internal.ShortSerializer;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u001a,\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a(\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000f\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\u0006\u0010\u0012\u001a\u00020\u0013\u001a-\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\t0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0015\u001a\u0002H\t2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0016\u001a\u0011\u0010\u0017\u001a\u00020\u0013\"\u0006\b\u0000\u0010\u0018\u0018\u0001H\u0086\b\u00a8\u0006\u0019"}, d2={"mapJavaClassNameToKotlin", "", "s", "registerSerializer", "", "forClassName", "serializer", "Lkotlinx/serialization/KSerializer;", "serializerByClass", "E", "klass", "Lkotlin/reflect/KClass;", "context", "Lkotlinx/serialization/context/SerialContext;", "serializerBySerialDescClassName", "className", "serializerByTypeToken", "", "type", "Ljava/lang/reflect/Type;", "serializerByValue", "value", "(Ljava/lang/Object;Lkotlinx/serialization/context/SerialContext;)Lkotlinx/serialization/KSerializer;", "typeTokenOf", "T", "kotlinx-serialization-runtime"})
public final class ResolvingKt {
    public static final void registerSerializer(@NotNull String forClassName, @NotNull KSerializer<?> serializer) {
        Intrinsics.checkParameterIsNotNull((Object)forClassName, (String)"forClassName");
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        SerialCache.INSTANCE.registerSerializer$kotlinx_serialization_runtime(forClassName, serializer);
    }

    private static final String mapJavaClassNameToKotlin(String s) {
        String string;
        switch (s) {
            case "java.lang.Integer": 
            case "int": {
                string = IntSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                string = BooleanSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.Byte": 
            case "byte": {
                string = ByteSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.Short": 
            case "short": {
                string = ShortSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "long": 
            case "java.lang.Long": {
                string = LongSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.Float": 
            case "float": {
                string = FloatSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.Double": 
            case "double": {
                string = DoubleSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.Character": 
            case "char": {
                string = CharSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.lang.String": {
                string = StringSerializer.INSTANCE.getDescriptor().getName();
                break;
            }
            case "java.util.ArrayList": 
            case "java.util.List": {
                string = "kotlin.collections.ArrayList";
                break;
            }
            case "java.util.LinkedHashSet": 
            case "java.util.Set": {
                string = "kotlin.collections.LinkedHashSet";
                break;
            }
            case "java.util.HashSet": {
                string = "kotlin.collections.HashSet";
                break;
            }
            case "java.util.LinkedHashMap": 
            case "java.util.Map": {
                string = "kotlin.collections.LinkedHashMap";
                break;
            }
            case "java.util.HashMap": {
                string = "kotlin.collections.HashMap";
                break;
            }
            case "java.util.Map$Entry": {
                string = MapEntryClassDesc.INSTANCE.getName();
                break;
            }
            default: {
                string = s;
            }
        }
        return string;
    }

    @ImplicitReflectionSerializer
    @NotNull
    public static final <E> KSerializer<E> serializerByValue(E value, @Nullable SerialContext context) {
        E e;
        E e2 = value;
        if (!(e2 instanceof Object)) {
            e2 = e = null;
        }
        if (e2 == null || (e = e.getClass()) == null || (e = JvmClassMappingKt.getKotlinClass(e)) == null) {
            throw (Throwable)new SerializationException("Cannot determine class for value " + value, null, 2, null);
        }
        E klass = e;
        return ResolvingKt.serializerByClass(klass, context);
    }

    @ImplicitReflectionSerializer
    @NotNull
    public static /* synthetic */ KSerializer serializerByValue$default(Object object, SerialContext serialContext, int n, Object object2) {
        if ((n & 2) != 0) {
            serialContext = null;
        }
        return ResolvingKt.serializerByValue(object, serialContext);
    }

    @ImplicitReflectionSerializer
    @NotNull
    public static final <E> KSerializer<E> serializerBySerialDescClassName(@NotNull String className, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return SerialCache.lookupSerializer$kotlinx_serialization_runtime$default(SerialCache.INSTANCE, className, null, context, 2, null);
    }

    @ImplicitReflectionSerializer
    @NotNull
    public static /* synthetic */ KSerializer serializerBySerialDescClassName$default(String string, SerialContext serialContext, int n, Object object) {
        if ((n & 2) != 0) {
            serialContext = null;
        }
        return ResolvingKt.serializerBySerialDescClassName(string, serialContext);
    }

    @ImplicitReflectionSerializer
    @NotNull
    public static final <E> KSerializer<E> serializerByClass(@NotNull KClass<?> klass, @Nullable SerialContext context) {
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getCanonicalName();
        if (string == null) {
            string = "";
        }
        return SerialCache.INSTANCE.lookupSerializer$kotlinx_serialization_runtime(ResolvingKt.mapJavaClassNameToKotlin(string), klass, context);
    }

    @ImplicitReflectionSerializer
    @NotNull
    public static /* synthetic */ KSerializer serializerByClass$default(KClass kClass, SerialContext serialContext, int n, Object object) {
        if ((n & 2) != 0) {
            serialContext = null;
        }
        return ResolvingKt.serializerByClass(kClass, serialContext);
    }

    private static final <T> Type typeTokenOf() {
        Type superType;
        int $i$f$typeTokenOf = 0;
        Intrinsics.needClassReification();
        TypeBase base2 = new TypeBase<T>(){};
        Type type = base2.getClass().getGenericSuperclass();
        if (type == null) {
            Intrinsics.throwNpe();
        }
        Type type2 = superType = type;
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        }
        Object[] objectArray = ((ParameterizedType)type2).getActualTypeArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"(superType as Parameteri\u2026Type).actualTypeArguments");
        Object object = ArraysKt.first((Object[])objectArray);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Type)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KSerializer<Object> serializerByTypeToken(@NotNull Type type) {
        KSerializer kSerializer;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Type type2 = type;
        if (type2 instanceof GenericArrayType) {
            KClass kClass;
            Type eType;
            Type type3;
            Type type4;
            Type it = type4 = ((GenericArrayType)type).getGenericComponentType();
            boolean $i$a$-let-ResolvingKt$serializerByTypeToken$eType$22 = false;
            Type type5 = it;
            if (type5 instanceof WildcardType) {
                Object[] objectArray = ((WildcardType)it).getUpperBounds();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.upperBounds");
                type3 = (Type)ArraysKt.first((Object[])objectArray);
            } else {
                type3 = it;
            }
            Type type6 = eType = type3;
            Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"eType");
            KSerializer<Object> serializer = ResolvingKt.serializerByTypeToken(type6);
            Type $i$a$-let-ResolvingKt$serializerByTypeToken$eType$22 = eType;
            if ($i$a$-let-ResolvingKt$serializerByTypeToken$eType$22 instanceof ParameterizedType) {
                Type type7 = ((ParameterizedType)eType).getRawType();
                if (type7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                kClass = JvmClassMappingKt.getKotlinClass((Class)((Class)type7));
            } else if ($i$a$-let-ResolvingKt$serializerByTypeToken$eType$22 instanceof KClass) {
                kClass = (KClass)eType;
            } else {
                throw (Throwable)new IllegalStateException("unsupported type in GenericArray: " + Reflection.getOrCreateKotlinClass(eType.getClass()));
            }
            if (kClass == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
            }
            KClass kclass = kClass;
            kSerializer = new ReferenceArraySerializer(kclass, serializer);
        } else if (type2 instanceof Class) {
            if (!((Class)type).isArray()) {
                kSerializer = ResolvingKt.serializerByClass$default(JvmClassMappingKt.getKotlinClass((Class)((Class)type)), null, 2, null);
            } else {
                Class<?> clazz = ((Class)type).getComponentType();
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"type.componentType");
                Class<?> eType = clazz;
                KSerializer<Object> s = ResolvingKt.serializerByTypeToken(eType);
                KClass kClass = JvmClassMappingKt.getKotlinClass(eType);
                if (kClass == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
                }
                ReferenceArraySerializer arraySerializer = new ReferenceArraySerializer(kClass, s);
                kSerializer = arraySerializer;
            }
        } else if (type2 instanceof ParameterizedType) {
            Type type8 = ((ParameterizedType)type).getRawType();
            if (type8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            Class rootClass = (Class)type8;
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (List.class.isAssignableFrom(rootClass)) {
                Type type9 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"args[0]");
                kSerializer = new ArrayListSerializer<Object>(ResolvingKt.serializerByTypeToken(type9));
            } else if (Set.class.isAssignableFrom(rootClass)) {
                Type type10 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type10, (String)"args[0]");
                kSerializer = new HashSetSerializer<Object>(ResolvingKt.serializerByTypeToken(type10));
            } else if (Map.class.isAssignableFrom(rootClass)) {
                Type type11 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type11, (String)"args[0]");
                KSerializer<Object> kSerializer2 = ResolvingKt.serializerByTypeToken(type11);
                Type type12 = args[1];
                Intrinsics.checkExpressionValueIsNotNull((Object)type12, (String)"args[1]");
                kSerializer = new HashMapSerializer<Object, Object>(kSerializer2, ResolvingKt.serializerByTypeToken(type12));
            } else if (Map.Entry.class.isAssignableFrom(rootClass)) {
                Type type13 = args[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)type13, (String)"args[0]");
                KSerializer<Object> kSerializer3 = ResolvingKt.serializerByTypeToken(type13);
                Type type14 = args[1];
                Intrinsics.checkExpressionValueIsNotNull((Object)type14, (String)"args[1]");
                kSerializer = new MapEntrySerializer<Object, Object>(kSerializer3, ResolvingKt.serializerByTypeToken(type14));
            } else {
                void $receiver$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)args, (String)"args");
                Object $receiver$iv = args;
                Type[] typeArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(((Type[])$receiver$iv).length);
                void var8_17 = $receiver$iv$iv;
                int n = ((void)var8_17).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_21 = item$iv$iv = var8_17[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v17 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"it");
                    KSerializer<Object> kSerializer4 = ResolvingKt.serializerByTypeToken((Type)v17);
                    collection.add(kSerializer4);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object thisCollection$iv = $receiver$iv;
                KSerializer[] kSerializerArray = thisCollection$iv.toArray(new KSerializer[0]);
                if (kSerializerArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                KSerializer[] varargs = kSerializerArray;
                KSerializer kSerializer5 = SerializationKt.invokeSerializerGetter(rootClass, Arrays.copyOf(varargs, varargs.length));
                if (!(kSerializer5 instanceof KSerializer)) {
                    kSerializer5 = kSerializer = null;
                }
                if (kSerializer5 == null) {
                    kSerializer = ResolvingKt.serializerByClass$default(JvmClassMappingKt.getKotlinClass((Class)rootClass), null, 2, null);
                }
            }
        } else if (type2 instanceof WildcardType) {
            Object[] objectArray = ((WildcardType)type).getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"type.upperBounds");
            Object object = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"type.upperBounds.first()");
            kSerializer = ResolvingKt.serializerByTypeToken((Type)object);
        } else {
            throw (Throwable)new IllegalArgumentException("typeToken should be an instance of Class<?>, GenericArray, ParametrizedType or WildcardType, but actual type is " + type + ' ' + Reflection.getOrCreateKotlinClass(type.getClass()));
        }
        return kSerializer;
    }
}

