/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.DecodingKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.EncodingKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicKind;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StructureKind;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.builtins.CollectionSerializersKt;
import kotlinx.serialization.builtins.PrimitiveSerializersKt;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.internal.TaggedDecoder;
import kotlinx.serialization.internal.TaggedEncoder;
import kotlinx.serialization.internal.UtilKt;
import kotlinx.serialization.modules.EmptyModule;
import kotlinx.serialization.modules.SerialModule;
import kotlinx.serialization.protobuf.ProtoBuf$ProtobufDecoder$WhenMappings;
import kotlinx.serialization.protobuf.ProtoBuf$ProtobufEncoder$WhenMappings;
import kotlinx.serialization.protobuf.ProtoBufKt;
import kotlinx.serialization.protobuf.ProtoNumberType;
import kotlinx.serialization.protobuf.ProtoTypesKt;
import kotlinx.serialization.protobuf.ProtobufDecodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u00172\u00020\u0001:\u000b\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf;", "Lkotlinx/serialization/BinaryFormat;", "encodeDefaults", "", "context", "Lkotlinx/serialization/modules/SerialModule;", "(ZLkotlinx/serialization/modules/SerialModule;)V", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "getEncodeDefaults", "()Z", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "load", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "Default", "MapEntryReader", "MapRepeatedWriter", "ObjectWriter", "ProtobufDecoder", "ProtobufEncoder", "ProtobufReader", "ProtobufWriter", "RepeatedReader", "RepeatedWriter", "Varint", "kotlinx-serialization-protobuf"})
public final class ProtoBuf
implements BinaryFormat {
    private final boolean encodeDefaults;
    @NotNull
    private final SerialModule context;
    public static final int VARINT = 0;
    public static final int i64 = 1;
    public static final int SIZE_DELIMITED = 2;
    public static final int i32 = 5;
    @NotNull
    private static final ProtoBuf plain;
    public static final Default Default;

    @NotNull
    public <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        ByteArrayOutputStream encoder = new ByteArrayOutputStream();
        ProtobufWriter dumper = new ProtobufWriter(new ProtobufEncoder(encoder));
        EncodingKt.encode((Encoder)((Encoder)dumper), serializer, value);
        byte[] byArray = encoder.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"encoder.toByteArray()");
        return byArray;
    }

    public <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        ProtobufReader reader = new ProtobufReader(new ProtobufDecoder(stream));
        return (T)DecodingKt.decode((Decoder)((Decoder)reader), deserializer);
    }

    public final boolean getEncodeDefaults() {
        return this.encodeDefaults;
    }

    @NotNull
    public SerialModule getContext() {
        return this.context;
    }

    public ProtoBuf(boolean encodeDefaults, @NotNull SerialModule context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.encodeDefaults = encodeDefaults;
        this.context = context;
    }

    public /* synthetic */ ProtoBuf(boolean bl, SerialModule serialModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            serialModule = (SerialModule)EmptyModule.INSTANCE;
        }
        this(bl, serialModule);
    }

    public ProtoBuf() {
        this(false, null, 3, null);
    }

    static {
        Default = new Default(null);
        plain = new ProtoBuf(false, null, 3, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0090\u0004\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ1\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u001a\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014\"\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\u0006\u0010\u001c\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020 H\u0016J(\u0010!\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020$H\u0016J(\u0010%\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020&H\u0016J0\u0010'\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u0003H\u0016J(\u0010*\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020+H\u0016J(\u0010,\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J(\u0010-\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u00020.H\u0016J(\u0010/\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u000200H\u0016J(\u00101\u001a\u00020\u00182\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001c\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0003H\u0016J$\u00105\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020\u00122\u0006\u00104\u001a\u00020\u0003H\u0014R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00066"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufWriter;", "Lkotlinx/serialization/internal/TaggedEncoder;", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "encoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;)V", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "getEncoder", "()Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "beginStructure", "Lkotlinx/serialization/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "typeSerializers", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeEncoder;", "encodeSerializableValue", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeTaggedBoolean", "tag", "", "encodeTaggedByte", "", "encodeTaggedChar", "", "encodeTaggedDouble", "", "encodeTaggedEnum", "enumDescription", "ordinal", "encodeTaggedFloat", "", "encodeTaggedInt", "encodeTaggedLong", "", "encodeTaggedShort", "", "encodeTaggedString", "", "shouldEncodeElementDefault", "index", "getTag", "kotlinx-serialization-protobuf"})
    public class ProtobufWriter
    extends TaggedEncoder<Pair<? extends Integer, ? extends ProtoNumberType>> {
        @NotNull
        private final ProtobufEncoder encoder;

        @NotNull
        public SerialModule getContext() {
            return ProtoBuf.this.getContext();
        }

        public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            return ProtoBuf.this.getEncodeDefaults();
        }

        @NotNull
        public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor, KSerializer<?> ... typeSerializers) {
            CompositeEncoder compositeEncoder;
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull(typeSerializers, (String)"typeSerializers");
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                compositeEncoder = (CompositeEncoder)new RepeatedWriter(this.encoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTag()));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                compositeEncoder = (CompositeEncoder)new ObjectWriter(ProtoBuf.this, (Pair)this.getCurrentTagOrNull(), this.encoder, null, 4, null);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                compositeEncoder = (CompositeEncoder)new MapRepeatedWriter((Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull()), this.encoder);
            } else {
                throw (Throwable)new SerializationException("Primitives are not supported at top-level", null, 2, null);
            }
            return compositeEncoder;
        }

        public void encodeTaggedInt(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, int value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        public void encodeTaggedByte(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, byte value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        public void encodeTaggedShort(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, short value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        public void encodeTaggedLong(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, long value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeLong(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        public void encodeTaggedFloat(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, float value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeFloat(value, ((Number)tag.getFirst()).intValue());
        }

        public void encodeTaggedDouble(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, double value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeDouble(value, ((Number)tag.getFirst()).intValue());
        }

        public void encodeTaggedBoolean(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, boolean value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value ? 1 : 0, ((Number)tag.getFirst()).intValue(), ProtoNumberType.DEFAULT);
        }

        public void encodeTaggedChar(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, char value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            this.encoder.writeInt(value, ((Number)tag.getFirst()).intValue(), (ProtoNumberType)((Object)tag.getSecond()));
        }

        public void encodeTaggedString(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.encoder.writeString(value, ((Number)tag.getFirst()).intValue());
        }

        public void encodeTaggedEnum(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, @NotNull SerialDescriptor enumDescription, int ordinal) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
            this.encoder.writeInt(((Number)ProtoTypesKt.extractParameters(enumDescription, ordinal, true).getFirst()).intValue(), ((Number)tag.getFirst()).intValue(), ProtoNumberType.DEFAULT);
        }

        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
            return Default.getProtoDesc($this$getTag, index);
        }

        public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            if (serializer instanceof MapLikeSerializer) {
                MapLikeSerializer serializer2 = (MapLikeSerializer)serializer;
                KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)serializer2.keySerializer, (KSerializer)serializer2.valueSerializer);
                T t = value;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                CollectionSerializersKt.SetSerializer((KSerializer)mapEntrySerial).serialize((Encoder)this, ((Map)t).entrySet());
            } else if (Intrinsics.areEqual((Object)serializer.getDescriptor(), (Object)PrimitiveSerializersKt.ByteArraySerializer().getDescriptor())) {
                T t = value;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                this.encoder.writeBytes((byte[])t, ((Number)((Pair)this.popTag()).getFirst()).intValue());
            } else {
                serializer.serialize((Encoder)this, value);
            }
        }

        @NotNull
        public final ProtobufEncoder getEncoder() {
            return this.encoder;
        }

        public ProtobufWriter(ProtobufEncoder encoder) {
            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
            this.encoder = encoder;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0090\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B7\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\b\u0002\u0010\n\u001a\u00060\u000bj\u0002`\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ObjectWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "parentEncoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "stream", "Ljava/io/ByteArrayOutputStream;", "Lkotlinx/io/ByteArrayOutputStream;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlin/Pair;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;Ljava/io/ByteArrayOutputStream;)V", "getParentTag", "()Lkotlin/Pair;", "endEncode", "", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "kotlinx-serialization-protobuf"})
    public class ObjectWriter
    extends ProtobufWriter {
        @Nullable
        private final Pair<Integer, ProtoNumberType> parentTag;
        private final ProtobufEncoder parentEncoder;
        private final ByteArrayOutputStream stream;
        final /* synthetic */ ProtoBuf this$0;

        public void endEncode(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            if (this.parentTag != null) {
                byte[] byArray = this.stream.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"stream.toByteArray()");
                this.parentEncoder.writeBytes(byArray, ((Number)this.parentTag.getFirst()).intValue());
            } else {
                this.parentEncoder.getOut().write(this.stream.toByteArray());
            }
        }

        @Nullable
        public final Pair<Integer, ProtoNumberType> getParentTag() {
            return this.parentTag;
        }

        public ObjectWriter(@Nullable ProtoBuf $outer, @NotNull Pair<Integer, ? extends ProtoNumberType> parentTag, @NotNull ProtobufEncoder parentEncoder, ByteArrayOutputStream stream) {
            Intrinsics.checkParameterIsNotNull((Object)parentEncoder, (String)"parentEncoder");
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            this.this$0 = $outer;
            super(new ProtobufEncoder(stream));
            this.parentTag = parentTag;
            this.parentEncoder = parentEncoder;
            this.stream = stream;
        }

        public /* synthetic */ ObjectWriter(ProtoBuf protoBuf, Pair pair, ProtobufEncoder protobufEncoder, ByteArrayOutputStream byteArrayOutputStream, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            this(protoBuf, (Pair<Integer, ? extends ProtoNumberType>)pair, protobufEncoder, byteArrayOutputStream);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\u0012\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007*\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0014\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$MapRepeatedWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf$ObjectWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "parentEncoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlin/Pair;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;)V", "getTag", "Lkotlinx/serialization/SerialDescriptor;", "index", "kotlinx-serialization-protobuf"})
    public final class MapRepeatedWriter
    extends ObjectWriter {
        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
            if (index % 2 == 0) {
                Integer n = 1;
                Object object = this.getParentTag();
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            } else {
                Integer n = 2;
                Object object = this.getParentTag();
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            }
            return pair;
        }

        public MapRepeatedWriter(@NotNull Pair<Integer, ? extends ProtoNumberType> parentTag, ProtobufEncoder parentEncoder) {
            Intrinsics.checkParameterIsNotNull((Object)parentEncoder, (String)"parentEncoder");
            super(ProtoBuf.this, parentTag, parentEncoder, null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\u0010\nJ$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0014R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$RepeatedWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufWriter;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "encoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "curTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;Lkotlin/Pair;)V", "getCurTag", "()Lkotlin/Pair;", "getTag", "Lkotlinx/serialization/SerialDescriptor;", "index", "kotlinx-serialization-protobuf"})
    public final class RepeatedWriter
    extends ProtobufWriter {
        @NotNull
        private final Pair<Integer, ProtoNumberType> curTag;

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
            return this.curTag;
        }

        @NotNull
        public final Pair<Integer, ProtoNumberType> getCurTag() {
            return this.curTag;
        }

        public RepeatedWriter(@NotNull ProtobufEncoder encoder, Pair<Integer, ? extends ProtoNumberType> curTag) {
            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
            Intrinsics.checkParameterIsNotNull(curTag, (String)"curTag");
            super(encoder);
            this.curTag = curTag;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000f2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u000bJ\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000bR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "", "out", "Ljava/io/ByteArrayOutputStream;", "Lkotlinx/io/ByteArrayOutputStream;", "(Ljava/io/ByteArrayOutputStream;)V", "getOut", "()Ljava/io/ByteArrayOutputStream;", "encode32", "", "number", "", "format", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "encode64", "", "writeBytes", "", "bytes", "tag", "writeDouble", "value", "", "writeFloat", "", "writeInt", "writeLong", "writeString", "", "kotlinx-serialization-protobuf"})
    public static final class ProtobufEncoder {
        @NotNull
        private final ByteArrayOutputStream out;

        public final void writeBytes(@NotNull byte[] bytes, int tag) {
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 2, null, 2, null);
            byte[] len = ProtobufEncoder.encode32$default(this, bytes.length, null, 2, null);
            this.out.write(header);
            this.out.write(len);
            this.out.write(bytes);
        }

        public final void writeInt(int value, int tag, @NotNull ProtoNumberType format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int wireType = format == ProtoNumberType.FIXED ? 5 : 0;
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | wireType, null, 2, null);
            byte[] content = this.encode32(value, format);
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeLong(long value, int tag, @NotNull ProtoNumberType format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int wireType = format == ProtoNumberType.FIXED ? 1 : 0;
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | wireType, null, 2, null);
            byte[] content = this.encode64(value, format);
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeString(@NotNull String value, int tag) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            byte[] bytes = StringsKt.encodeToByteArray((String)value);
            this.writeBytes(bytes, tag);
        }

        public final void writeDouble(double value, int tag) {
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 1, null, 2, null);
            byte[] content = ProtoBufKt.access$toByteArray(ProtoBufKt.access$toLittleEndian(value));
            this.out.write(header);
            this.out.write(content);
        }

        public final void writeFloat(float value, int tag) {
            byte[] header = ProtobufEncoder.encode32$default(this, tag << 3 | 5, null, 2, null);
            byte[] content = ProtoBufKt.access$toByteArray(ProtoBufKt.access$toLittleEndian(value));
            this.out.write(header);
            this.out.write(content);
        }

        private final byte[] encode32(int number, ProtoNumberType format) {
            byte[] byArray;
            switch (ProtoBuf$ProtobufEncoder$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    byArray = ProtoBufKt.access$toByteArray(ProtoBufKt.access$toLittleEndian(number));
                    break;
                }
                case 2: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_protobuf((long)number);
                    break;
                }
                case 3: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_protobuf(number << 1 ^ number >> 31);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return byArray;
        }

        static /* synthetic */ byte[] encode32$default(ProtobufEncoder protobufEncoder, int n, ProtoNumberType protoNumberType, int n2, Object object) {
            if ((n2 & 2) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            return protobufEncoder.encode32(n, protoNumberType);
        }

        private final byte[] encode64(long number, ProtoNumberType format) {
            byte[] byArray;
            switch (ProtoBuf$ProtobufEncoder$WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
                case 1: {
                    byArray = ProtoBufKt.access$toByteArray(ProtoBufKt.access$toLittleEndian(number));
                    break;
                }
                case 2: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_protobuf(number);
                    break;
                }
                case 3: {
                    byArray = Varint.INSTANCE.encodeVarint$kotlinx_serialization_protobuf(number << 1 ^ number >> 63);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return byArray;
        }

        static /* synthetic */ byte[] encode64$default(ProtobufEncoder protobufEncoder, long l, ProtoNumberType protoNumberType, int n, Object object) {
            if ((n & 2) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            return protobufEncoder.encode64(l, protoNumberType);
        }

        @NotNull
        public final ByteArrayOutputStream getOut() {
            return this.out;
        }

        public ProtobufEncoder(@NotNull ByteArrayOutputStream out) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            this.out = out;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0092\u0004\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00050\u0001B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u001a\u0010\u0015\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\"\u0006\u0012\u0002\b\u00030\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ \u0010\u001f\u001a\u00020 2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010\"\u001a\u00020#2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010$\u001a\u00020%2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010&\u001a\u00020'2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J(\u0010(\u001a\u00020\u00032\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010)\u001a\u00020\u0014H\u0016J \u0010*\u001a\u00020+2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010,\u001a\u00020\u00032\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010-\u001a\u00020.2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u0010/\u001a\u0002002\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J \u00101\u001a\u0002022\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005H\u0016J\u0010\u00103\u001a\u0002042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u00032\b\b\u0002\u00108\u001a\u00020 H\u0002J$\u00109\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020\u00142\u0006\u0010:\u001a\u00020\u0003H\u0014R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufReader;", "Lkotlinx/serialization/internal/TaggedDecoder;", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "decoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;)V", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "getDecoder", "()Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "indexByTag", "", "beginStructure", "Lkotlinx/serialization/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeDecoder;", "decodeElementIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeTaggedBoolean", "", "tag", "decodeTaggedByte", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "enumDescription", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "", "decodeTaggedShort", "", "decodeTaggedString", "", "endStructure", "", "findIndexByTag", "desc", "serialId", "zeroBasedDefault", "getTag", "index", "kotlinx-serialization-protobuf"})
    private class ProtobufReader
    extends TaggedDecoder<Pair<? extends Integer, ? extends ProtoNumberType>> {
        private final Map<Integer, Integer> indexByTag;
        @NotNull
        private final ProtobufDecoder decoder;

        @NotNull
        public SerialModule getContext() {
            return ProtoBuf.this.getContext();
        }

        private final int findIndexByTag(SerialDescriptor desc, int serialId, boolean zeroBasedDefault) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)desc.getElementsCount());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    if (!(((Number)ProtoTypesKt.extractParameters(desc, it, zeroBasedDefault).getFirst()).intValue() == serialId)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Integer n = v0;
            return n != null ? n : -1;
        }

        static /* synthetic */ int findIndexByTag$default(ProtobufReader protobufReader, SerialDescriptor serialDescriptor, int n, boolean bl, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findIndexByTag");
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return protobufReader.findIndexByTag(serialDescriptor, n, bl);
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor, KSerializer<?> ... typeParams) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull(typeParams, (String)"typeParams");
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                compositeDecoder = (CompositeDecoder)new RepeatedReader(this.decoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTag()));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                compositeDecoder = (CompositeDecoder)new ProtobufReader(Default.makeDelimited(this.decoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull())));
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                compositeDecoder = (CompositeDecoder)new MapEntryReader(Default.makeDelimited(this.decoder, (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull())), (Pair<Integer, ? extends ProtoNumberType>)((Pair)this.getCurrentTagOrNull()));
            } else {
                throw (Throwable)new SerializationException("Primitives are not supported at top-level", null, 2, null);
            }
            return compositeDecoder;
        }

        public void endStructure(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        }

        public boolean decodeTaggedBoolean(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            int i = this.decoder.nextInt(ProtoNumberType.DEFAULT);
            if (i == 0) {
                bl = false;
            } else if (i == 1) {
                bl = true;
            } else {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected boolean value (0 or 1), found " + i));
            }
            return bl;
        }

        public byte decodeTaggedByte(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return (byte)this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        public short decodeTaggedShort(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return (short)this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        public int decodeTaggedInt(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        public long decodeTaggedLong(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextLong((ProtoNumberType)((Object)tag.getSecond()));
        }

        public float decodeTaggedFloat(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextFloat();
        }

        public double decodeTaggedDouble(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextDouble();
        }

        public char decodeTaggedChar(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return (char)this.decoder.nextInt((ProtoNumberType)((Object)tag.getSecond()));
        }

        @NotNull
        public String decodeTaggedString(@NotNull Pair<Integer, ? extends ProtoNumberType> tag) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            return this.decoder.nextString();
        }

        public int decodeTaggedEnum(@NotNull Pair<Integer, ? extends ProtoNumberType> tag, @NotNull SerialDescriptor enumDescription) {
            Intrinsics.checkParameterIsNotNull(tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)enumDescription, (String)"enumDescription");
            return this.findIndexByTag(enumDescription, this.decoder.nextInt(ProtoNumberType.DEFAULT), true);
        }

        /*
         * WARNING - void declaration
         */
        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
            Object object;
            Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
            if (deserializer instanceof MapLikeSerializer) {
                void $this$associateByTo$iv$iv;
                MapLikeSerializer serializer = (MapLikeSerializer)deserializer;
                KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)serializer.keySerializer, (KSerializer)serializer.valueSerializer);
                Set setOfEntries = (Set)CollectionSerializersKt.SetSerializer((KSerializer)mapEntrySerial).deserialize((Decoder)this);
                Iterable $this$associateBy$iv = setOfEntries;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    Map.Entry it;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Object k = it.getKey();
                    it = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    Object v = it.getValue();
                    map.put(k, v);
                }
                object = destination$iv$iv;
            } else {
                object = Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)PrimitiveSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.decoder.nextObject() : deserializer.deserialize((Decoder)this);
            }
            return (T)object;
        }

        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
            return Default.getProtoDesc($this$getTag, index);
        }

        /*
         * WARNING - void declaration
         */
        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            int ind;
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            while (true) {
                Object object;
                void $this$getOrPut$iv;
                if (this.decoder.getCurId() == -1) {
                    return -1;
                }
                Map<Integer, Integer> map = this.indexByTag;
                Integer key$iv = this.decoder.getCurId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Integer answer$iv = ProtobufReader.findIndexByTag$default(this, descriptor, this.decoder.getCurId(), false, 4, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                if ((ind = ((Number)object).intValue()) != -1) break;
                this.decoder.skipElement();
            }
            return ind;
        }

        @NotNull
        public final ProtobufDecoder getDecoder() {
            return this.decoder;
        }

        public ProtobufReader(ProtobufDecoder decoder) {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            this.decoder = decoder;
            ProtobufReader protobufReader = this;
            boolean bl = false;
            protobufReader.indexByTag = map = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0014R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$RepeatedReader;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufReader;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "targetTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;Lkotlin/Pair;)V", "ind", "getTargetTag", "()Lkotlin/Pair;", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getTag", "index", "kotlinx-serialization-protobuf"})
    private final class RepeatedReader
    extends ProtobufReader {
        private int ind;
        @NotNull
        private final Pair<Integer, ProtoNumberType> targetTag;

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            if (this.getDecoder().getCurId() == ((Number)this.targetTag.getFirst()).intValue()) {
                RepeatedReader repeatedReader = this;
                n = ++repeatedReader.ind;
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
            return this.targetTag;
        }

        @NotNull
        public final Pair<Integer, ProtoNumberType> getTargetTag() {
            return this.targetTag;
        }

        public RepeatedReader(@NotNull ProtobufDecoder decoder, Pair<Integer, ? extends ProtoNumberType> targetTag) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            Intrinsics.checkParameterIsNotNull(targetTag, (String)"targetTag");
            super(decoder);
            this.targetTag = targetTag;
            this.ind = -1;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006j\u0004\u0018\u0001`\t\u00a2\u0006\u0002\u0010\nJ$\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0014R%\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006j\u0004\u0018\u0001`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$MapEntryReader;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufReader;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "parentTag", "Lkotlin/Pair;", "", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;Lkotlin/Pair;)V", "getParentTag", "()Lkotlin/Pair;", "getTag", "Lkotlinx/serialization/SerialDescriptor;", "index", "kotlinx-serialization-protobuf"})
    private final class MapEntryReader
    extends ProtobufReader {
        @Nullable
        private final Pair<Integer, ProtoNumberType> parentTag;

        @Override
        @NotNull
        protected Pair<Integer, ProtoNumberType> getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)$this$getTag, (String)"$this$getTag");
            if (index % 2 == 0) {
                Integer n = 1;
                Object object = this.parentTag;
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            } else {
                Integer n = 2;
                Object object = this.parentTag;
                if (object == null || (object = (ProtoNumberType)((Object)object.getSecond())) == null) {
                    object = ProtoNumberType.DEFAULT;
                }
                pair = TuplesKt.to((Object)n, object);
            }
            return pair;
        }

        @Nullable
        public final Pair<Integer, ProtoNumberType> getParentTag() {
            return this.parentTag;
        }

        public MapEntryReader(@Nullable ProtobufDecoder decoder, Pair<Integer, ? extends ProtoNumberType> parentTag) {
            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
            super(decoder);
            this.parentTag = parentTag;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0082\bJ\u001c\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020\u0017H\u0002J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J\u0006\u0010%\u001a\u00020\u000fR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "", "inp", "Ljava/io/ByteArrayInputStream;", "Lkotlinx/io/ByteArrayInputStream;", "(Ljava/io/ByteArrayInputStream;)V", "curId", "", "getCurId", "()I", "curTag", "Lkotlin/Pair;", "getInp", "()Ljava/io/ByteArrayInputStream;", "assertWireType", "", "expected", "decode32", "format", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "eofAllowed", "", "decode64", "", "nextDouble", "", "nextFloat", "", "nextInt", "nextLong", "nextObject", "", "nextString", "", "readIntLittleEndian", "readLongLittleEndian", "readTag", "skipElement", "kotlinx-serialization-protobuf"})
    public static final class ProtobufDecoder {
        private Pair<Integer, Integer> curTag;
        @NotNull
        private final ByteArrayInputStream inp;

        public final int getCurId() {
            return ((Number)this.curTag.getFirst()).intValue();
        }

        private final Pair<Integer, Integer> readTag() {
            Pair pair;
            int header = ProtobufDecoder.decode32$default(this, null, true, 1, null);
            if (header == -1) {
                pair = TuplesKt.to((Object)-1, (Object)-1);
            } else {
                int wireType = header & 7;
                int fieldId = header >>> 3;
                pair = TuplesKt.to((Object)fieldId, (Object)wireType);
            }
            this.curTag = pair;
            return this.curTag;
        }

        public final void skipElement() {
            switch (((Number)this.curTag.getSecond()).intValue()) {
                case 0: {
                    this.nextInt(ProtoNumberType.DEFAULT);
                    break;
                }
                case 1: {
                    this.nextLong(ProtoNumberType.FIXED);
                    break;
                }
                case 2: {
                    this.nextObject();
                    break;
                }
                case 5: {
                    this.nextInt(ProtoNumberType.FIXED);
                    break;
                }
                default: {
                    throw (Throwable)((Object)new ProtobufDecodingException("Unsupported start group or end group wire type"));
                }
            }
        }

        private final void assertWireType(int expected) {
            int $i$f$assertWireType = 0;
            if (((Number)this.curTag.getSecond()).intValue() != expected) {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected wire type " + expected + ", but found " + ((Number)this.curTag.getSecond()).intValue()));
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final byte[] nextObject() {
            void this_$iv;
            ProtobufDecoder protobufDecoder = this;
            int expected$iv = 2;
            boolean $i$f$assertWireType = false;
            if (((Number)((ProtobufDecoder)this_$iv).curTag.getSecond()).intValue() != expected$iv) {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + ((Number)((ProtobufDecoder)this_$iv).curTag.getSecond()).intValue()));
            }
            int len = ProtobufDecoder.decode32$default(this, null, false, 3, null);
            expected$iv = len >= 0 ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (expected$iv == 0) {
                boolean bl4 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            byte[] ans = UtilKt.readExactNBytes((InputStream)this.inp, (int)len);
            this.readTag();
            return ans;
        }

        public final int nextInt(@NotNull ProtoNumberType format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int wireType = format == ProtoNumberType.FIXED ? 5 : 0;
            ProtobufDecoder this_$iv = this;
            boolean $i$f$assertWireType = false;
            if (((Number)this_$iv.curTag.getSecond()).intValue() != wireType) {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + ((Number)this_$iv.curTag.getSecond()).intValue()));
            }
            int ans = ProtobufDecoder.decode32$default(this, format, false, 2, null);
            this.readTag();
            return ans;
        }

        public final long nextLong(@NotNull ProtoNumberType format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            int wireType = format == ProtoNumberType.FIXED ? 1 : 0;
            ProtobufDecoder this_$iv = this;
            boolean $i$f$assertWireType = false;
            if (((Number)this_$iv.curTag.getSecond()).intValue() != wireType) {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + ((Number)this_$iv.curTag.getSecond()).intValue()));
            }
            long ans = this.decode64(format);
            this.readTag();
            return ans;
        }

        /*
         * WARNING - void declaration
         */
        public final float nextFloat() {
            void this_$iv;
            ProtobufDecoder protobufDecoder = this;
            int expected$iv = 5;
            boolean $i$f$assertWireType = false;
            if (((Number)((ProtobufDecoder)this_$iv).curTag.getSecond()).intValue() != expected$iv) {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + ((Number)((ProtobufDecoder)this_$iv).curTag.getSecond()).intValue()));
            }
            int ans = this.readIntLittleEndian();
            this.readTag();
            FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
            boolean bl = false;
            return Float.intBitsToFloat(ans);
        }

        /*
         * WARNING - void declaration
         */
        private final int readIntLittleEndian() {
            int result = 0;
            int n = 0;
            int n2 = 3;
            while (n <= n2) {
                void i;
                int n3 = this.inp.read();
                result = result << 8 | n3;
                ++i;
            }
            return ProtoBufKt.access$toLittleEndian(result);
        }

        /*
         * WARNING - void declaration
         */
        private final long readLongLittleEndian() {
            long result = 0L;
            int n = 0;
            int n2 = 7;
            while (n <= n2) {
                void i;
                int n3 = this.inp.read();
                result = result << 8 | (long)n3;
                ++i;
            }
            return ProtoBufKt.access$toLittleEndian(result);
        }

        /*
         * WARNING - void declaration
         */
        public final double nextDouble() {
            void this_$iv;
            ProtobufDecoder protobufDecoder = this;
            int expected$iv = 1;
            boolean $i$f$assertWireType = false;
            if (((Number)((ProtobufDecoder)this_$iv).curTag.getSecond()).intValue() != expected$iv) {
                throw (Throwable)((Object)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + ((Number)((ProtobufDecoder)this_$iv).curTag.getSecond()).intValue()));
            }
            long ans = this.readLongLittleEndian();
            this.readTag();
            DoubleCompanionObject doubleCompanionObject = DoubleCompanionObject.INSTANCE;
            boolean bl = false;
            return Double.longBitsToDouble(ans);
        }

        @NotNull
        public final String nextString() {
            byte[] bytes = this.nextObject();
            return StringsKt.decodeToString((byte[])bytes);
        }

        private final int decode32(ProtoNumberType format, boolean eofAllowed) {
            int n;
            switch (ProtoBuf$ProtobufDecoder$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    n = (int)Varint.INSTANCE.decodeVarint$kotlinx_serialization_protobuf(this.inp, 64, eofAllowed);
                    break;
                }
                case 2: {
                    n = Varint.INSTANCE.decodeSignedVarintInt$kotlinx_serialization_protobuf(this.inp);
                    break;
                }
                case 3: {
                    n = this.readIntLittleEndian();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        static /* synthetic */ int decode32$default(ProtobufDecoder protobufDecoder, ProtoNumberType protoNumberType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return protobufDecoder.decode32(protoNumberType, bl);
        }

        private final long decode64(ProtoNumberType format) {
            long l;
            switch (ProtoBuf$ProtobufDecoder$WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
                case 1: {
                    l = Varint.decodeVarint$kotlinx_serialization_protobuf$default(Varint.INSTANCE, this.inp, 64, false, 4, null);
                    break;
                }
                case 2: {
                    l = Varint.INSTANCE.decodeSignedVarintLong$kotlinx_serialization_protobuf(this.inp);
                    break;
                }
                case 3: {
                    l = this.readLongLittleEndian();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return l;
        }

        static /* synthetic */ long decode64$default(ProtobufDecoder protobufDecoder, ProtoNumberType protoNumberType, int n, Object object) {
            if ((n & 1) != 0) {
                protoNumberType = ProtoNumberType.DEFAULT;
            }
            return protobufDecoder.decode64(protoNumberType);
        }

        @NotNull
        public final ByteArrayInputStream getInp() {
            return this.inp;
        }

        public ProtobufDecoder(@NotNull ByteArrayInputStream inp) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            this.inp = inp;
            this.curTag = TuplesKt.to((Object)-1, (Object)-1);
            this.readTag();
        }

        public static final /* synthetic */ void access$setCurTag$p(ProtobufDecoder $this, Pair pair) {
            $this.curTag = pair;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0019\u0010\t\u001a\u00020\n2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ-\u0010\f\u001a\u00020\n2\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$Varint;", "", "()V", "decodeSignedVarintInt", "", "inp", "Ljava/io/InputStream;", "Lkotlinx/io/InputStream;", "decodeSignedVarintInt$kotlinx_serialization_protobuf", "decodeSignedVarintLong", "", "decodeSignedVarintLong$kotlinx_serialization_protobuf", "decodeVarint", "bitLimit", "eofOnStartAllowed", "", "decodeVarint$kotlinx_serialization_protobuf", "encodeVarint", "", "encodeVarint$kotlinx_serialization_protobuf", "kotlinx-serialization-protobuf"})
    public static final class Varint {
        public static final Varint INSTANCE;

        @NotNull
        public final byte[] encodeVarint$kotlinx_serialization_protobuf(int inp) {
            int value = inp;
            byte[] byteArrayList = new byte[10];
            int i = 0;
            while ((value & (int)0xFFFFFF80L) != 0) {
                byteArrayList[i++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
            byteArrayList[i] = (byte)(value & 0x7F);
            byte[] out = new byte[i + 1];
            while (i >= 0) {
                out[i] = byteArrayList[i];
                --i;
            }
            return out;
        }

        @NotNull
        public final byte[] encodeVarint$kotlinx_serialization_protobuf(long inp) {
            long value = inp;
            byte[] byteArrayList = new byte[10];
            int i = 0;
            while ((value & (0x7FL ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                byteArrayList[i++] = (byte)(value & 0x7FL | 0x80L);
                value >>>= 7;
            }
            byteArrayList[i] = (byte)(value & 0x7FL);
            byte[] out = new byte[i + 1];
            while (i >= 0) {
                out[i] = byteArrayList[i];
                --i;
            }
            return out;
        }

        public final long decodeVarint$kotlinx_serialization_protobuf(@NotNull InputStream inp, int bitLimit, boolean eofOnStartAllowed) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            long result = 0L;
            int shift = 0;
            int b = 0;
            do {
                if (shift >= bitLimit) {
                    throw (Throwable)((Object)new ProtobufDecodingException("Varint too long: exceeded " + bitLimit + " bits"));
                }
                b = inp.read();
                if (b == -1) {
                    if (eofOnStartAllowed && shift == 0) {
                        return -1L;
                    }
                    String string = "Unexpected EOF";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                result |= ((long)b & 0x7FL) << shift;
                shift += 7;
            } while ((b & 0x80) != 0);
            return result;
        }

        public static /* synthetic */ long decodeVarint$kotlinx_serialization_protobuf$default(Varint varint, InputStream inputStream, int n, boolean bl, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 32;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return varint.decodeVarint$kotlinx_serialization_protobuf(inputStream, n, bl);
        }

        public final int decodeSignedVarintInt$kotlinx_serialization_protobuf(@NotNull InputStream inp) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            int raw = (int)Varint.decodeVarint$kotlinx_serialization_protobuf$default(this, inp, 32, false, 4, null);
            int temp = (raw << 31 >> 31 ^ raw) >> 1;
            return temp ^ raw & Integer.MIN_VALUE;
        }

        public final long decodeSignedVarintLong$kotlinx_serialization_protobuf(@NotNull InputStream inp) {
            Intrinsics.checkParameterIsNotNull((Object)inp, (String)"inp");
            long raw = Varint.decodeVarint$kotlinx_serialization_protobuf$default(this, inp, 64, false, 4, null);
            long temp = (raw << 63 >> 63 ^ raw) >> 1;
            return temp ^ raw & Long.MIN_VALUE;
        }

        private Varint() {
        }

        static {
            Varint varint;
            INSTANCE = varint = new Varint();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0006\u0010\u0016\u001a\u0002H\u0013H\u0096\u0001\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0096\u0001\u00a2\u0006\u0002\u0010\u001cJ,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u001a\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"\u0018\u00010!j\u0004\u0018\u0001`#H\u0002J$\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\"0!j\u0002`#*\u00020%2\u0006\u0010&\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$Default;", "Lkotlinx/serialization/BinaryFormat;", "()V", "SIZE_DELIMITED", "", "VARINT", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "i32", "i64", "plain", "Lkotlinx/serialization/protobuf/ProtoBuf;", "plain$annotations", "getPlain", "()Lkotlinx/serialization/protobuf/ProtoBuf;", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "load", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "makeDelimited", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "decoder", "parentTag", "Lkotlin/Pair;", "Lkotlinx/serialization/protobuf/ProtoNumberType;", "Lkotlinx/serialization/protobuf/ProtoDesc;", "getProtoDesc", "Lkotlinx/serialization/SerialDescriptor;", "index", "kotlinx-serialization-protobuf"})
    public static final class Default
    implements BinaryFormat {
        private final /* synthetic */ ProtoBuf $$delegate_0;

        private final ProtobufDecoder makeDelimited(ProtobufDecoder decoder, Pair<Integer, ? extends ProtoNumberType> parentTag) {
            if (parentTag == null) {
                return decoder;
            }
            byte[] bytes = decoder.nextObject();
            return new ProtobufDecoder(new ByteArrayInputStream(bytes));
        }

        private final Pair<Integer, ProtoNumberType> getProtoDesc(@NotNull SerialDescriptor $this$getProtoDesc, int index) {
            return ProtoTypesKt.extractParameters$default($this$getProtoDesc, index, false, 4, null);
        }

        @Deprecated(message="Deprecated for removal in the favour of user-defined instances or ProtoBuf companion object", level=DeprecationLevel.ERROR, replaceWith=@ReplaceWith(imports={}, expression="ProtoBuf"))
        public static /* synthetic */ void plain$annotations() {
        }

        @NotNull
        public final ProtoBuf getPlain() {
            return plain;
        }

        private Default() {
            this.$$delegate_0 = new ProtoBuf(false, null, 3, null);
        }

        @NotNull
        public SerialModule getContext() {
            return this.$$delegate_0.getContext();
        }

        @NotNull
        public <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer, T value) {
            Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
            return this.$$delegate_0.dump(serializer, value);
        }

        public <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
            Intrinsics.checkParameterIsNotNull(deserializer, (String)"deserializer");
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            return this.$$delegate_0.load(deserializer, bytes);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

