/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.ByteArrayInput;
import kotlinx.serialization.protobuf.internal.ProtoWireType;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0011\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\tH\u0082\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0014J\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010$\u001a\u00020#J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\b\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020#H\u0002J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020+J\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020.J\u0010\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\u0007H\u0002J\u0012\u00102\u001a\u00020\u00072\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002J\u0012\u00103\u001a\u00020#2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00104\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00105\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "", "input", "Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "<init>", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)V", "currentId", "", "currentType", "Lkotlinx/serialization/protobuf/internal/ProtoWireType;", "pushBack", "", "pushBackHeader", "eof", "getEof", "()Z", "readTag", "updateIdAndType", "header", "pushBackTag", "", "skipElement", "assertWireType", "expected", "readByteArray", "", "skipSizeDelimited", "readByteArrayNoTag", "objectInput", "objectTaglessInput", "readInt", "format", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "readInt32NoTag", "readLong", "", "readLongNoTag", "readFloat", "", "readFloatNoTag", "readIntLittleEndian", "readLongLittleEndian", "readDouble", "", "readDoubleNoTag", "readString", "", "readStringNoTag", "checkLength", "length", "decode32", "decode64", "decodeSignedVarintInt", "decodeSignedVarintLong", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufReader.kt\nkotlinx/serialization/protobuf/internal/ProtobufReader\n*L\n1#1,212:1\n70#1,2:213\n70#1,2:215\n70#1,2:217\n70#1,2:219\n70#1,2:221\n70#1,2:223\n70#1,2:225\n70#1,2:227\n*S KotlinDebug\n*F\n+ 1 ProtobufReader.kt\nkotlinx/serialization/protobuf/internal/ProtobufReader\n*L\n74#1:213,2\n79#1:215,2\n92#1:217,2\n104#1:219,2\n112#1:221,2\n119#1:223,2\n146#1:225,2\n155#1:227,2\n*E\n"})
public final class ProtobufReader {
    @NotNull
    private final ByteArrayInput input;
    @JvmField
    public int currentId;
    @JvmField
    @NotNull
    public ProtoWireType currentType;
    private boolean pushBack;
    private int pushBackHeader;

    public ProtobufReader(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.currentId = -1;
        this.currentType = ProtoWireType.INVALID;
    }

    public final boolean getEof() {
        return !this.pushBack && this.input.getAvailableBytes() == 0;
    }

    public final int readTag() {
        if (this.pushBack) {
            int n;
            this.pushBack = false;
            int previousHeader = this.currentId << 3 | this.currentType.getTypeId();
            int it = n = this.updateIdAndType(this.pushBackHeader);
            boolean bl = false;
            this.pushBackHeader = previousHeader;
            return n;
        }
        this.pushBackHeader = this.currentId << 3 | this.currentType.getTypeId();
        int header = (int)this.input.readVarint64(true);
        return this.updateIdAndType(header);
    }

    private final int updateIdAndType(int header) {
        int n;
        if (header == -1) {
            this.currentId = -1;
            this.currentType = ProtoWireType.INVALID;
            n = -1;
        } else {
            this.currentId = header >>> 3;
            this.currentType = ProtoWireType.Companion.from(header & 7);
            n = this.currentId;
        }
        return n;
    }

    public final void pushBackTag() {
        this.pushBack = true;
        int nextHeader = this.currentId << 3 | this.currentType.getTypeId();
        this.updateIdAndType(this.pushBackHeader);
        this.pushBackHeader = nextHeader;
    }

    public final void skipElement() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentType.ordinal()]) {
            case 1: {
                this.readInt(ProtoIntegerType.DEFAULT);
                break;
            }
            case 2: {
                this.readLong(ProtoIntegerType.FIXED);
                break;
            }
            case 3: {
                this.skipSizeDelimited();
                break;
            }
            case 4: {
                this.readInt(ProtoIntegerType.FIXED);
                break;
            }
            default: {
                throw new ProtobufDecodingException("Unsupported start group or end group wire type: " + (Object)((Object)this.currentType), null, 2, null);
            }
        }
    }

    private final void assertWireType(ProtoWireType expected) {
        boolean $i$f$assertWireType = false;
        if (this.currentType != expected) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected) + ", but found " + (Object)((Object)this.currentType), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] readByteArray() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected$iv) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        return this.readByteArrayNoTag();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipSizeDelimited() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected$iv) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        this.input.skipExactNBytes(length);
    }

    @NotNull
    public final byte[] readByteArrayNoTag() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readExactNBytes(length);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayInput objectInput() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected$iv) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        return this.objectTaglessInput();
    }

    @NotNull
    public final ByteArrayInput objectTaglessInput() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.slice(length);
    }

    public final int readInt(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ProtoWireType wireType = format == ProtoIntegerType.FIXED ? ProtoWireType.i32 : ProtoWireType.VARINT;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)wireType) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        return this.decode32(format);
    }

    public final int readInt32NoTag() {
        return ProtobufReader.decode32$default(this, null, 1, null);
    }

    public final long readLong(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        ProtoWireType wireType = format == ProtoIntegerType.FIXED ? ProtoWireType.i64 : ProtoWireType.VARINT;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)wireType) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        return this.decode64(format);
    }

    public final long readLongNoTag() {
        return this.decode64(ProtoIntegerType.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public final float readFloat() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.i32;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected$iv) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    public final float readFloatNoTag() {
        return Float.intBitsToFloat(this.readIntLittleEndian());
    }

    private final int readIntLittleEndian() {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            int n = this.input.read() & 0xFF;
            result |= n << i * 8;
        }
        return result;
    }

    private final long readLongLittleEndian() {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            long l = this.input.read() & 0xFF;
            result |= l << i * 8;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final double readDouble() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.i64;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected$iv) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    public final double readDoubleNoTag() {
        return Double.longBitsToDouble(this.readLongLittleEndian());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readString() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        ProtoWireType expected$iv = ProtoWireType.SIZE_DELIMITED;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw new ProtobufDecodingException("Expected wire type " + (Object)((Object)expected$iv) + ", but found " + (Object)((Object)this_$iv.currentType), null, 2, null);
        }
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString(length);
    }

    @NotNull
    public final String readStringNoTag() {
        int length = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length);
        return this.input.readString(length);
    }

    private final void checkLength(int length) {
        if (length < 0) {
            throw new ProtobufDecodingException("Unexpected negative length: " + length, null, 2, null);
        }
    }

    private final int decode32(ProtoIntegerType format) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1: {
                n = (int)this.input.readVarint64(false);
                break;
            }
            case 2: {
                n = this.decodeSignedVarintInt(this.input);
                break;
            }
            case 3: {
                n = this.readIntLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    static /* synthetic */ int decode32$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode32(protoIntegerType);
    }

    private final long decode64(ProtoIntegerType format) {
        long l;
        switch (WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1: {
                l = this.input.readVarint64(false);
                break;
            }
            case 2: {
                l = this.decodeSignedVarintLong(this.input);
                break;
            }
            case 3: {
                l = this.readLongLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    static /* synthetic */ long decode64$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode64(protoIntegerType);
    }

    private final int decodeSignedVarintInt(ByteArrayInput input) {
        int raw = input.readVarint32();
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    private final long decodeSignedVarintLong(ByteArrayInput input) {
        long raw = input.readVarint64(false);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProtoWireType.values().length];
            try {
                nArray[ProtoWireType.VARINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoWireType.i64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoWireType.SIZE_DELIMITED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoWireType.i32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoIntegerType.values().length];
            try {
                nArray[ProtoIntegerType.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.SIGNED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoIntegerType.FIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

