/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.ElementMarker;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapEntryReader;
import kotlinx.serialization.protobuf.internal.OneOfPolymorphicReader;
import kotlinx.serialization.protobuf.internal.PackedArrayDecoder;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.RepeatedDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J(\u0010\u001c\u001a\u00020\u0019*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0019\u0010)\u001a\u00020\u00152\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020/2\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u00100J\u0019\u00101\u001a\u0002022\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u00103J\u0019\u00104\u001a\u00020\u00122\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u00105J\u0019\u00106\u001a\u00020,2\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u00107J\u0019\u00108\u001a\u0002092\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u0010:J\u0019\u0010;\u001a\u00020<2\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u0010=J\u0019\u0010>\u001a\u00020?2\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u0010@J\u0019\u0010A\u001a\u00020B2\n\u0010*\u001a\u00060,j\u0002`+H\u0014\u00a2\u0006\u0002\u0010CJ!\u0010D\u001a\u00020\u00122\n\u0010*\u001a\u00060,j\u0002`+2\u0006\u0010E\u001a\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010FJ!\u0010G\u001a\u0002HH\"\u0004\b\u0000\u0010H2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0JH\u0016\u00a2\u0006\u0002\u0010KJ+\u0010G\u001a\u0002HH\"\u0004\b\u0000\u0010H2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0J2\b\u0010L\u001a\u0004\u0018\u0001HHH\u0014\u00a2\u0006\u0002\u0010MJ\u0012\u0010N\u001a\u00020O2\b\u0010L\u001a\u0004\u0018\u00010OH\u0002J+\u0010P\u001a\u0002HH\"\u0004\b\u0000\u0010H2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0J2\b\u0010L\u001a\u0004\u0018\u0001HHH\u0002\u00a2\u0006\u0002\u0010MJ\u001d\u0010Q\u001a\u00060,j\u0002`+*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0012H\u0014\u00a2\u0006\u0002\u0010RJ\u0010\u0010S\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010T\u001a\u00020\u0015H\u0016J\u0018\u0010U\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0012H\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "reader", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "indexCache", "", "sparseIndexCache", "", "", "index2IdMap", "nullValue", "", "elementMarker", "Lkotlinx/serialization/internal/ElementMarker;", "populateCache", "", "populateCacheMap", "elements", "putProtoId", "protoId", "index", "getIndexByNum", "protoNum", "getIndexByNumSlowPath", "protoTag", "findIndexByTag", "findIndexByTagSlowPath", "desc", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "decodeTaggedBoolean", "tag", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "", "(J)Z", "decodeTaggedByte", "", "(J)B", "decodeTaggedShort", "", "(J)S", "decodeTaggedInt", "(J)I", "decodeTaggedLong", "(J)J", "decodeTaggedFloat", "", "(J)F", "decodeTaggedDouble", "", "(J)D", "decodeTaggedChar", "", "(J)C", "decodeTaggedString", "", "(J)Ljava/lang/String;", "decodeTaggedEnum", "enumDescription", "(JLkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "deserializeByteArray", "", "deserializeMap", "getTag", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)J", "decodeElementIndex", "decodeNotNullMark", "readIfAbsent", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufDecoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,479:1\n1557#2:480\n1628#2,2:481\n1630#2:484\n1863#2,2:485\n1216#2,2:494\n1246#2,4:496\n33#3:483\n26#3,5:488\n33#3:493\n1#4:487\n*S KotlinDebug\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n*L\n75#1:480\n75#1:481,2\n75#1:484\n76#1:485,2\n249#1:494,2\n249#1:496,4\n75#1:483\n133#1:488,5\n152#1:493\n*E\n"})
public class ProtobufDecoder
extends ProtobufTaggedDecoder {
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @JvmField
    @NotNull
    protected final ProtobufReader reader;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;
    @Nullable
    private int[] indexCache;
    @Nullable
    private Map<Integer, Integer> sparseIndexCache;
    @Nullable
    private Map<Integer, Integer> index2IdMap;
    private boolean nullValue;
    @NotNull
    private final ElementMarker elementMarker;

    public ProtobufDecoder(@NotNull ProtoBuf proto, @NotNull ProtobufReader reader, @NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.proto = proto;
        this.reader = reader;
        this.descriptor = descriptor;
        this.elementMarker = new ElementMarker(this.descriptor, (Function2)new Function2<SerialDescriptor, Integer, Boolean>((Object)this){

            public final Boolean invoke(SerialDescriptor p0, int p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ProtobufDecoder.access$readIfAbsent((ProtobufDecoder)this.receiver, p0, p1);
            }
        });
        this.populateCache(this.descriptor);
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    public final void populateCache(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int elements = descriptor.getElementsCount();
        if (elements < 32) {
            int[] cache = new int[elements + 1];
            int i = 0;
            while (i < elements) {
                int protoId = HelpersKt.extractProtoId(descriptor, i, false);
                if (protoId > elements || protoId == -2) {
                    this.populateCacheMap(descriptor, elements);
                    return;
                }
                cache[protoId] = i++;
            }
            this.indexCache = cache;
        } else {
            this.populateCacheMap(descriptor, elements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateCacheMap(SerialDescriptor descriptor, int elements) {
        HashMap map = new HashMap(elements, 1.0f);
        int oneOfCount = 0;
        for (int i = 0; i < elements; ++i) {
            int id = HelpersKt.extractProtoId(descriptor, i, false);
            if (id == -2) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = HelpersKt.getAllOneOfSerializerOfField(descriptor.getElementDescriptor(i), this.getSerializersModule());
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SerialDescriptor serialDescriptor = (SerialDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    long $this$protoId$iv = HelpersKt.extractParameters((SerialDescriptor)it, 0);
                    boolean $i$f$getProtoId = false;
                    collection.add((int)($this$protoId$iv & Integer.MAX_VALUE));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    this.putProtoId(map, it, i);
                }
                ++oneOfCount;
                continue;
            }
            this.putProtoId(map, HelpersKt.extractProtoId(descriptor, i, false), i);
        }
        if (oneOfCount > 0) {
            this.index2IdMap = new HashMap(oneOfCount, 1.0f);
        }
        this.sparseIndexCache = map;
    }

    private final void putProtoId(Map<Integer, Integer> $this$putProtoId, int protoId, int index) {
        $this$putProtoId.put(protoId, index);
    }

    private final int getIndexByNum(int protoNum) {
        int[] array = this.indexCache;
        if (array != null) {
            int n;
            int[] nArray = array;
            boolean bl = 0 <= protoNum ? protoNum < nArray.length : false;
            if (bl) {
                n = nArray[protoNum];
            } else {
                int it = protoNum;
                boolean bl2 = false;
                n = -1;
            }
            return n;
        }
        return this.getIndexByNumSlowPath(protoNum);
    }

    private final int getIndexByNumSlowPath(int protoTag) {
        Map<Integer, Integer> map = this.sparseIndexCache;
        Intrinsics.checkNotNull(map);
        Map<Integer, Integer> map2 = map;
        Integer n = map2.get(protoTag);
        if (n == null) {
            boolean bl = false;
            n = -1;
        }
        return ((Number)n).intValue();
    }

    private final int findIndexByTag(SerialDescriptor descriptor, int protoTag) {
        int protoId;
        if (protoTag < descriptor.getElementsCount() && protoTag >= 0 && (protoId = HelpersKt.extractProtoId(descriptor, protoTag, true)) == protoTag) {
            return protoTag;
        }
        return this.findIndexByTagSlowPath(descriptor, protoTag);
    }

    private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
        int n = desc.getElementsCount();
        for (int i = 0; i < n; ++i) {
            int protoId = HelpersKt.extractProtoId(desc, i, true);
            if (protoId != protoTag) continue;
            return i;
        }
        throw new ProtobufDecodingException(protoTag + " is not among valid " + this.descriptor.getSerialName() + " enum proto numbers");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            CompositeDecoder compositeDecoder;
            long tag = this.getCurrentTagOrDefault();
            if (Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor)) {
                void protoId$iv;
                ProtobufReader reader = ProtobufDecodingKt.access$makeDelimited(this.reader, tag);
                reader.readTag();
                boolean bl = true;
                ProtoIntegerType type$iv = ProtoIntegerType.DEFAULT;
                boolean packed$iv = false;
                boolean oneOf$iv = false;
                boolean $i$f$ProtoDesc = false;
                long packedBits$iv = 0L;
                long oneOfBits$iv = 0L;
                compositeDecoder = new RepeatedDecoder(this.proto, reader, packedBits$iv | oneOfBits$iv | type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv, descriptor);
            } else if (this.reader.currentType == 2 && HelpersKt.isPackable(descriptor.getElementDescriptor(0))) {
                ProtobufReader sliceReader = new ProtobufReader(this.reader.objectInput());
                compositeDecoder = new PackedArrayDecoder(this.proto, sliceReader, descriptor);
            } else {
                compositeDecoder = new RepeatedDecoder(this.proto, this.reader, tag, descriptor);
            }
            return compositeDecoder;
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
            long tag = this.getCurrentTagOrDefault();
            if (tag == 19500L && Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor)) {
                return this;
            }
            if (HelpersKt.isOneOf(tag)) {
                long l;
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                int rawIndex = (int)($this$protoId$iv & Integer.MAX_VALUE) - 1;
                Map<Integer, Integer> map = this.index2IdMap;
                if (map != null && (map = map.get(rawIndex)) != null) {
                    int it = ((Number)((Object)map)).intValue();
                    boolean bl = false;
                    l = HelpersKt.overrideId(tag, it);
                } else {
                    l = tag;
                }
                long restoredTag = l;
                return new OneOfPolymorphicReader(this.proto, this.reader, restoredTag, descriptor);
            }
            return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor);
        }
        if (!Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            throw new SerializationException("Primitives are not supported at top-level");
        }
        return new MapEntryReader(this.proto, ProtobufDecodingKt.access$makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
    }

    @Override
    protected boolean decodeTaggedBoolean(long tag) {
        boolean bl;
        int value = this.decodeTaggedInt(tag);
        switch (value) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw new SerializationException("Unexpected boolean value: " + value);
            }
        }
        return bl;
    }

    @Override
    protected byte decodeTaggedByte(long tag) {
        return (byte)this.decodeTaggedInt(tag);
    }

    @Override
    protected short decodeTaggedShort(long tag) {
        return (short)this.decodeTaggedInt(tag);
    }

    @Override
    protected int decodeTaggedInt(long tag) {
        return tag == 19500L ? this.reader.readInt32NoTag() : this.reader.readInt(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected long decodeTaggedLong(long tag) {
        return tag == 19500L ? this.reader.readLongNoTag() : this.reader.readLong(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected float decodeTaggedFloat(long tag) {
        return tag == 19500L ? this.reader.readFloatNoTag() : this.reader.readFloat();
    }

    @Override
    protected double decodeTaggedDouble(long tag) {
        return tag == 19500L ? this.reader.readDoubleNoTag() : this.reader.readDouble();
    }

    @Override
    protected char decodeTaggedChar(long tag) {
        return (char)this.decodeTaggedInt(tag);
    }

    @Override
    @NotNull
    protected String decodeTaggedString(long tag) {
        return tag == 19500L ? this.reader.readStringNoTag() : this.reader.readString();
    }

    @Override
    protected int decodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription) {
        Intrinsics.checkNotNullParameter((Object)enumDescription, (String)"enumDescription");
        return this.findIndexByTag(enumDescription, this.decodeTaggedInt(tag));
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return this.decodeSerializableValue(deserializer, null);
    }

    @Override
    protected <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return (T)(deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge((Decoder)this, previousValue) : deserializer.deserialize((Decoder)this))));
    }

    private final byte[] deserializeByteArray(byte[] previousValue) {
        long tag = this.getCurrentTagOrDefault();
        byte[] array = tag == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
        return previousValue == null ? array : ArraysKt.plus((byte[])previousValue, (byte[])array);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeMap(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNull(deserializer, (String)"null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufDecoder.deserializeMap, *>");
        MapLikeSerializer serializer = (MapLikeSerializer)deserializer;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)serializer.getKeySerializer(), (KSerializer)serializer.getValueSerializer());
        Map map = previousValue instanceof Map ? (Map)previousValue : null;
        Set oldSet = map != null ? map.entrySet() : null;
        KSerializer kSerializer = BuiltinSerializersKt.SetSerializer((KSerializer)mapEntrySerial);
        Intrinsics.checkNotNull((Object)kSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.internal.AbstractCollectionSerializer<kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>, kotlin.collections.Set<kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>>, *>");
        Set setOfEntries = (Set)((AbstractCollectionSerializer)kSerializer).merge((Decoder)this, oldSet);
        Iterable $this$associateBy$iv = setOfEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Object k = it.getKey();
            boolean bl2 = false;
            Object v = it.getValue();
            map2.put(k, v);
        }
        return (T)destination$iv$iv;
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        int index;
        int protoId;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        while (true) {
            if ((protoId = this.reader.readTag()) == -1) {
                return this.elementMarker.nextUnmarkedIndex();
            }
            index = this.getIndexByNum(protoId);
            if (index != -1) break;
            this.reader.skipElement();
        }
        if (HelpersKt.isOneOf(HelpersKt.extractParameters(descriptor, index))) {
            Map<Integer, Integer> map = this.index2IdMap;
            if (map != null) {
                map.put(index, protoId);
            }
        }
        this.elementMarker.mark(index);
        return index;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.nullValue;
    }

    private final boolean readIfAbsent(SerialDescriptor descriptor, int index) {
        if (!descriptor.isElementOptional(index)) {
            SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(index);
            SerialKind kind = elementDescriptor.getKind();
            if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.MAP.INSTANCE) || Intrinsics.areEqual((Object)kind, (Object)StructureKind.LIST.INSTANCE)) {
                this.nullValue = false;
                return true;
            }
            if (elementDescriptor.isNullable()) {
                this.nullValue = true;
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$readIfAbsent(ProtobufDecoder $this, SerialDescriptor descriptor, int index) {
        return $this.readIfAbsent(descriptor, index);
    }
}

