/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.OneOfElementEncoder;
import kotlinx.serialization.protobuf.internal.ProtobufEncoder;
import kotlinx.serialization.protobuf.internal.ProtobufWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0012j\u0002`\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/protobuf/internal/OneOfPolymorphicEncoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufEncoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentWriter", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "encodeTaggedString", "", "tag", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "", "value", "", "(JLjava/lang/String;)V", "getTag", "index", "", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/OneOfPolymorphicEncoder\n+ 2 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n1#1,291:1\n33#2:292\n*S KotlinDebug\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/OneOfPolymorphicEncoder\n*L\n216#1:292\n*E\n"})
final class OneOfPolymorphicEncoder
extends ProtobufEncoder {
    @NotNull
    private final ProtobufWriter parentWriter;

    public OneOfPolymorphicEncoder(@NotNull ProtoBuf proto, @NotNull ProtobufWriter parentWriter, @NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)parentWriter, (String)"parentWriter");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super(proto, parentWriter, descriptor);
        this.parentWriter = parentWriter;
        if (!(descriptor.getKind() instanceof PolymorphicKind)) {
            boolean bl = false;
            String string = "The serializer of one of type " + descriptor.getSerialName() + " should be using generic polymorphic serializer, but got " + descriptor.getKind() + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return Intrinsics.areEqual((Object)descriptor, (Object)this.descriptor) ? (CompositeEncoder)this : (CompositeEncoder)new OneOfElementEncoder(this.proto, this.parentWriter, descriptor);
    }

    @Override
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        long $this$protoId$iv = HelpersKt.extractParameters(descriptor, 0);
        boolean $i$f$getProtoId = false;
        return this.encodeTaggedInline(HelpersKt.overrideId(this.popTag(), (int)($this$protoId$iv & Integer.MAX_VALUE)), descriptor);
    }

    @Override
    protected void encodeTaggedString(long tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (tag != 19501L) {
            super.encodeTaggedString(tag, value);
        }
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
        switch (index) {
            case 0: {
                l = 19501L;
                break;
            }
            case 1: {
                l = HelpersKt.extractParameters($this$getTag, index);
                break;
            }
            default: {
                throw new SerializationException("Unsupported index: " + index + " in a oneOf type " + $this$getTag.getSerialName() + ", which should be using generic polymorphic serializer");
            }
        }
        return l;
    }
}

