/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0004J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;", "", "()V", "array", "", "position", "", "encodeVarint", "", "value", "", "length", "encodeVarint32", "encodeVarint64", "ensureCapacity", "elementsToAppend", "size", "toByteArray", "varIntLength", "write", "buffer", "output", "writeInt", "intValue", "writeLong", "longValue", "Companion", "kotlinx-serialization-protobuf"})
public final class ByteArrayOutput {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] array = new byte[32];
    private int position;
    @Deprecated
    @NotNull
    private static final int[] VAR_INT_LENGTHS;

    private final void ensureCapacity(int elementsToAppend) {
        if (this.position + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] newArray = new byte[Integer.highestOneBit(this.position + elementsToAppend) << 1];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)0, (int)14, null);
        this.array = newArray;
    }

    public final int size() {
        return this.position;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] newArray = new byte[this.position];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)this.position, (int)2, null);
        return newArray;
    }

    public final void write(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int count = buffer.length;
        if (count == 0) {
            return;
        }
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])buffer, (byte[])this.array, (int)this.position, (int)0, (int)count);
        this.position += count;
    }

    public final void write(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int count = output.size();
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])output.array, (byte[])this.array, (int)this.position, (int)0, (int)count);
        this.position += count;
    }

    public final void writeInt(int intValue) {
        this.ensureCapacity(4);
        int n = 3;
        do {
            int i = n--;
            int n2 = this.position;
            this.position = n2 + 1;
            this.array[n2] = (byte)(intValue >> i * 8);
        } while (0 <= n);
    }

    public final void writeLong(long longValue) {
        this.ensureCapacity(8);
        int n = 7;
        do {
            int i = n--;
            int n2 = this.position;
            this.position = n2 + 1;
            this.array[n2] = (byte)(longValue >> i * 8);
        } while (0 <= n);
    }

    public final void encodeVarint32(int value) {
        this.ensureCapacity(5);
        if ((value & 0xFFFFFF80) == 0) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)value;
            return;
        }
        int length = this.varIntLength(value);
        this.encodeVarint(value, length);
    }

    public final void encodeVarint64(long value) {
        int length = this.varIntLength(value);
        this.ensureCapacity(length + 1);
        this.encodeVarint(value, length);
    }

    private final void encodeVarint(long value, int length) {
        long current = value;
        int n = 0;
        while (n < length) {
            int i = n++;
            this.array[this.position + i] = (byte)(current & 0x7FL | 0x80L);
            current >>>= 7;
        }
        this.array[this.position + length] = (byte)current;
        this.position += length + 1;
    }

    private final int varIntLength(long value) {
        return VAR_INT_LENGTHS[Long.numberOfLeadingZeros(value)];
    }

    static {
        int n = 0;
        int[] nArray = new int[65];
        while (n < 65) {
            int n2 = n++;
            nArray[n2] = (63 - n2) / 7;
        }
        VAR_INT_LENGTHS = nArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput$Companion;", "", "()V", "VAR_INT_LENGTHS", "", "kotlinx-serialization-protobuf"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

