/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;", "", "()V", "array", "", "position", "", "encodeVarint32", "", "value", "encodeVarint32SlowPath", "encodeVarint64", "", "ensureCapacity", "elementsToAppend", "size", "toByteArray", "write", "buffer", "output", "writeInt", "intValue", "writeLong", "longValue", "kotlinx-serialization-protobuf"})
public final class ByteArrayOutput {
    private byte[] array = new byte[32];
    private int position;

    private final void ensureCapacity(int elementsToAppend) {
        if (this.position + elementsToAppend <= this.array.length) {
            return;
        }
        int n = this.position + elementsToAppend;
        boolean bl = false;
        byte[] newArray = new byte[Integer.highestOneBit(n) << 1];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)0, (int)14, null);
        this.array = newArray;
    }

    public final int size() {
        return this.position;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] newArray = new byte[this.position];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)this.position, (int)2, null);
        return newArray;
    }

    public final void write(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int count = buffer.length;
        if (count == 0) {
            return;
        }
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])buffer, (byte[])this.array, (int)this.position, (int)0, (int)count);
        this.position += count;
    }

    public final void write(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int count = output.size();
        this.ensureCapacity(count);
        ArraysKt.copyInto((byte[])output.array, (byte[])this.array, (int)this.position, (int)0, (int)count);
        this.position += count;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt(int intValue) {
        this.ensureCapacity(4);
        int n = 3;
        boolean bl = false;
        while (n >= 0) {
            void i;
            int n2 = this.position;
            this.position = n2 + 1;
            this.array[n2] = (byte)(intValue >> i * 8);
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeLong(long longValue) {
        this.ensureCapacity(8);
        int n = 7;
        boolean bl = false;
        while (n >= 0) {
            void i;
            int n2 = this.position;
            this.position = n2 + 1;
            this.array[n2] = (byte)(longValue >> i * 8);
            --i;
        }
    }

    public final void encodeVarint32(int value) {
        this.ensureCapacity(5);
        if ((value & ~127) == 0) {
            int n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)value;
            return;
        }
        int current = value;
        int n = this.position;
        this.position = n + 1;
        this.array[n] = (byte)(current | 0x80);
        current >>>= 7;
        if ((value & ~127) == 0) {
            n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)value;
            return;
        }
        this.encodeVarint32SlowPath(current);
    }

    private final void encodeVarint32SlowPath(int value) {
        int n;
        int current = value;
        while ((current & ~127) != 0) {
            n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)(current & 0x7F | 0x80);
            current >>>= 7;
        }
        n = this.position;
        this.position = n + 1;
        this.array[n] = (byte)(current & 0x7F);
    }

    public final void encodeVarint64(long value) {
        this.ensureCapacity(10);
        long currentValue = value;
        while (true) {
            int n;
            if ((currentValue & (long)(~127)) == 0L) {
                n = this.position;
                this.position = n + 1;
                this.array[n] = (byte)currentValue;
                return;
            }
            n = this.position;
            this.position = n + 1;
            this.array[n] = (byte)((int)currentValue & 0x7F | 0x80);
            currentValue >>>= 7;
        }
    }
}

