/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import kotlinx.serialization.protobuf.ProtoNumberType;
import kotlinx.serialization.protobuf.ProtoTypesKt;
import kotlinx.serialization.protobuf.internal.ByteArrayInput;
import kotlinx.serialization.protobuf.internal.ByteArrayOutput;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedEncoder;
import kotlinx.serialization.protobuf.internal.ProtobufWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00172\u00020\u0001:\b\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001eB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J)\u0010\u0012\u001a\u00020\u0010\"\u0004\b\u0000\u0010\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\f0\u00142\u0006\u0010\u0015\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf;", "Lkotlinx/serialization/BinaryFormat;", "encodeDefaults", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(ZLkotlinx/serialization/modules/SerializersModule;)V", "getEncodeDefaults", "()Z", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromByteArray", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "encodeToByteArray", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "Default", "MapEntryReader", "MapRepeatedEncoder", "ObjectEncoder", "ProtobufDecoder", "ProtobufEncoder", "RepeatedDecoder", "RepeatedEncoder", "kotlinx-serialization-protobuf"})
public final class ProtoBuf
implements BinaryFormat {
    private final boolean encodeDefaults;
    @NotNull
    private final SerializersModule serializersModule;
    public static final int VARINT = 0;
    public static final int i64 = 1;
    public static final int SIZE_DELIMITED = 2;
    public static final int i32 = 5;
    public static final Default Default = new Default(null);

    @NotNull
    public <T> byte[] encodeToByteArray(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        ByteArrayOutput output = new ByteArrayOutput();
        ProtobufEncoder encoder = new ProtobufEncoder(new ProtobufWriter(output), serializer.getDescriptor());
        encoder.encodeSerializableValue(serializer, value);
        return output.toByteArray();
    }

    public <T> T decodeFromByteArray(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ByteArrayInput input = new ByteArrayInput(bytes, 0, 2, null);
        ProtobufDecoder decoder = new ProtobufDecoder(new ProtobufReader(input), deserializer.getDescriptor());
        return decoder.decodeSerializableValue(deserializer);
    }

    public final boolean getEncodeDefaults() {
        return this.encodeDefaults;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public ProtoBuf(boolean encodeDefaults, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.encodeDefaults = encodeDefaults;
        this.serializersModule = serializersModule;
    }

    public /* synthetic */ ProtoBuf(boolean bl, SerializersModule serializersModule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            serializersModule = SerializersModuleKt.getEmptySerializersModule();
        }
        this(bl, serializersModule);
    }

    public ProtoBuf() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0090\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J)\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u0012H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020\u001bH\u0014J\u001c\u0010\u001c\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020\u001dH\u0014J\u001c\u0010\u001e\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020\u001fH\u0014J\u001c\u0010 \u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020!H\u0014J$\u0010\"\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000eH\u0014J\u001c\u0010%\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020&H\u0014J\u001c\u0010'\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\u001c\u0010(\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020\u0019H\u0014J\u001c\u0010)\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020*H\u0014J\u001c\u0010+\u001a\u00020\u00112\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u0015\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020.H\u0002J)\u0010/\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0018\u00100\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u000eH\u0016J\u0018\u00102\u001a\u00060\u0019j\u0002`\u001a*\u00020\u00052\u0006\u00101\u001a\u00020\u000eH\u0014R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedEncoder;", "writer", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginCollection", "Lkotlinx/serialization/encoding/CompositeEncoder;", "collectionSize", "", "beginStructure", "encodeSerializableValue", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeTaggedBoolean", "tag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "", "encodeTaggedByte", "", "encodeTaggedChar", "", "encodeTaggedDouble", "", "encodeTaggedEnum", "enumDescription", "ordinal", "encodeTaggedFloat", "", "encodeTaggedInt", "encodeTaggedLong", "encodeTaggedShort", "", "encodeTaggedString", "", "serializeByteArray", "", "serializeMap", "shouldEncodeElementDefault", "index", "getTag", "kotlinx-serialization-protobuf"})
    public class ProtobufEncoder
    extends ProtobufTaggedEncoder {
        private final ProtobufWriter writer;
        @JvmField
        @NotNull
        public final SerialDescriptor descriptor;

        @NotNull
        public SerializersModule getSerializersModule() {
            return ProtoBuf.this.getSerializersModule();
        }

        @Override
        public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return ProtoBuf.this.getEncodeDefaults();
        }

        @Override
        @NotNull
        public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
            CompositeEncoder compositeEncoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                long tag = this.getCurrentTagOrDefault();
                if (tag == 19500L) {
                    this.writer.writeInt(collectionSize);
                }
                compositeEncoder = new RepeatedEncoder(this.writer, tag, descriptor);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                compositeEncoder = new MapRepeatedEncoder(this.getCurrentTag(), this.writer, descriptor);
            } else {
                throw (Throwable)new SerializationException("This serial kind is not supported as collection: " + descriptor);
            }
            return compositeEncoder;
        }

        @Override
        @NotNull
        public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeEncoder compositeEncoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                compositeEncoder = new RepeatedEncoder(this.writer, this.getCurrentTagOrDefault(), descriptor);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                long tag = this.getCurrentTagOrDefault();
                compositeEncoder = tag == 19500L && Intrinsics.areEqual((Object)descriptor, (Object)this.descriptor) ? this : (ProtobufEncoder)new ObjectEncoder(ProtoBuf.this, this.getCurrentTagOrDefault(), this.writer, null, descriptor, 4, null);
            } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                compositeEncoder = new MapRepeatedEncoder(this.getCurrentTagOrDefault(), this.writer, descriptor);
            } else {
                throw (Throwable)new SerializationException("This serial kind is not supported as structure: " + descriptor);
            }
            return compositeEncoder;
        }

        @Override
        protected void encodeTaggedInt(long tag, int value) {
            if (tag == 19500L) {
                this.writer.writeInt(value);
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeInt(value, (int)($this$protoId$iv & (long)Integer.MAX_VALUE), ProtoTypesKt.getNumberType(tag));
            }
        }

        @Override
        protected void encodeTaggedByte(long tag, byte value) {
            this.encodeTaggedInt(tag, value);
        }

        @Override
        protected void encodeTaggedShort(long tag, short value) {
            this.encodeTaggedInt(tag, value);
        }

        @Override
        protected void encodeTaggedBoolean(long tag, boolean value) {
            this.encodeTaggedInt(tag, value ? 1 : 0);
        }

        @Override
        protected void encodeTaggedChar(long tag, char value) {
            this.encodeTaggedInt(tag, value);
        }

        @Override
        protected void encodeTaggedLong(long tag, long value) {
            if (tag == 19500L) {
                this.writer.writeLong(value);
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeLong(value, (int)($this$protoId$iv & (long)Integer.MAX_VALUE), ProtoTypesKt.getNumberType(tag));
            }
        }

        @Override
        protected void encodeTaggedFloat(long tag, float value) {
            if (tag == 19500L) {
                this.writer.writeFloat(value);
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeFloat(value, (int)($this$protoId$iv & (long)Integer.MAX_VALUE));
            }
        }

        @Override
        protected void encodeTaggedDouble(long tag, double value) {
            if (tag == 19500L) {
                this.writer.writeDouble(value);
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeDouble(value, (int)($this$protoId$iv & (long)Integer.MAX_VALUE));
            }
        }

        @Override
        protected void encodeTaggedString(long tag, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (tag == 19500L) {
                this.writer.writeString(value);
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeString(value, (int)($this$protoId$iv & (long)Integer.MAX_VALUE));
            }
        }

        @Override
        protected void encodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription, int ordinal) {
            Intrinsics.checkNotNullParameter((Object)enumDescription, (String)"enumDescription");
            if (tag == 19500L) {
                this.writer.writeInt(ProtoTypesKt.extractProtoId(enumDescription, ordinal, true));
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeInt(ProtoTypesKt.extractProtoId(enumDescription, ordinal, true), (int)($this$protoId$iv & (long)Integer.MAX_VALUE), ProtoNumberType.DEFAULT);
            }
        }

        @Override
        protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return ProtoTypesKt.extractParameters($this$getTag, index);
        }

        @Override
        public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            if (serializer instanceof MapLikeSerializer) {
                this.serializeMap(serializer, value);
            } else if (Intrinsics.areEqual((Object)serializer.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
                T t = value;
                if (t == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                this.serializeByteArray((byte[])t);
            } else {
                serializer.serialize((Encoder)this, value);
            }
        }

        private final void serializeByteArray(byte[] value) {
            long tag = this.popTagOrDefault();
            if (tag == 19500L) {
                this.writer.writeBytes(value);
            } else {
                long $this$protoId$iv = tag;
                boolean $i$f$getProtoId = false;
                this.writer.writeBytes(value, (int)($this$protoId$iv & (long)Integer.MAX_VALUE));
            }
        }

        private final <T> void serializeMap(SerializationStrategy<? super T> serializer, T value) {
            SerializationStrategy<? super T> serializationStrategy = serializer;
            if (serializationStrategy == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T, *>");
            }
            MapLikeSerializer casted = (MapLikeSerializer)serializationStrategy;
            KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)casted.getKeySerializer(), (KSerializer)casted.getValueSerializer());
            T t = value;
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            }
            BuiltinSerializersKt.SetSerializer((KSerializer)mapEntrySerial).serialize((Encoder)this, ((Map)t).entrySet());
        }

        public ProtobufEncoder(@NotNull ProtobufWriter writer, SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.writer = writer;
            this.descriptor = descriptor;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0090\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B+\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ObjectEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentTag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "parentWriter", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "stream", "Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;JLkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/protobuf/internal/ByteArrayOutput;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "endEncode", "", "kotlinx-serialization-protobuf"})
    public class ObjectEncoder
    extends ProtobufEncoder {
        @JvmField
        public final long parentTag;
        @JvmField
        @NotNull
        protected final ProtobufWriter parentWriter;
        @JvmField
        @NotNull
        protected final ByteArrayOutput stream;
        final /* synthetic */ ProtoBuf this$0;

        @Override
        protected void endEncode(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (this.parentTag != 19500L) {
                long $this$protoId$iv = this.parentTag;
                boolean $i$f$getProtoId = false;
                this.parentWriter.writeOutput(this.stream, (int)($this$protoId$iv & (long)Integer.MAX_VALUE));
            } else {
                this.parentWriter.writeOutput(this.stream);
            }
        }

        public ObjectEncoder(ProtoBuf this$0, @NotNull long parentTag, @NotNull ProtobufWriter parentWriter, @NotNull ByteArrayOutput stream, SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)parentWriter, (String)"parentWriter");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.this$0 = this$0;
            super(new ProtobufWriter(stream), descriptor);
            this.parentTag = parentTag;
            this.parentWriter = parentWriter;
            this.stream = stream;
        }

        public /* synthetic */ ObjectEncoder(ProtoBuf protoBuf, long l, ProtobufWriter protobufWriter, ByteArrayOutput byteArrayOutput, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                byteArrayOutput = new ByteArrayOutput();
            }
            this(protoBuf, l, protobufWriter, byteArrayOutput, serialDescriptor);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\r\u001a\u00060\u0004j\u0002`\u0005*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$MapRepeatedEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf$ObjectEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "parentTag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "parentWriter", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;JLkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "endEncode", "", "getTag", "index", "", "kotlinx-serialization-protobuf"})
    public final class MapRepeatedEncoder
    extends ObjectEncoder {
        /*
         * WARNING - void declaration
         */
        @Override
        protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            long l;
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            if (index % 2 == 0) {
                void protoId$iv;
                boolean bl = true;
                ProtoNumberType type$iv = ProtoTypesKt.getNumberType(this.parentTag);
                boolean $i$f$ProtoDesc = false;
                l = type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv;
            } else {
                int protoId$iv = 2;
                ProtoNumberType type$iv = ProtoTypesKt.getNumberType(this.parentTag);
                boolean $i$f$ProtoDesc = false;
                l = type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv;
            }
            return l;
        }

        @Override
        protected void endEncode(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (this.parentTag != 19500L) {
                long $this$protoId$iv = this.parentTag;
                boolean $i$f$getProtoId = false;
                this.parentWriter.writeOutput(this.stream, (int)($this$protoId$iv & (long)Integer.MAX_VALUE));
            } else {
                this.parentWriter.writeOutput(this.stream);
            }
        }

        public MapRepeatedEncoder(@NotNull long parentTag, @NotNull ProtobufWriter parentWriter, SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)parentWriter, (String)"parentWriter");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            super(ProtoBuf.this, parentTag, parentWriter, null, descriptor, 4, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0080\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007*\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$RepeatedEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufEncoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "writer", "Lkotlinx/serialization/protobuf/internal/ProtobufWriter;", "curTag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;JLkotlinx/serialization/descriptors/SerialDescriptor;)V", "getTag", "index", "", "kotlinx-serialization-protobuf"})
    public final class RepeatedEncoder
    extends ProtobufEncoder {
        @JvmField
        public final long curTag;

        @Override
        protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return this.curTag;
        }

        public RepeatedEncoder(ProtobufWriter writer, @NotNull long curTag, SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            super(writer, descriptor);
            this.curTag = curTag;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\b\u0010\u0018\u001a\u0004\u0018\u0001H\u0014H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010\u001f\u001a\u00020 2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010!\u001a\u00020\"2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010#\u001a\u00020$2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u001c\u0010%\u001a\u00020\u000f2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\u0006\u0010&\u001a\u00020\u0005H\u0014J\u0014\u0010'\u001a\u00020(2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010)\u001a\u00020\u000f2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010*\u001a\u00020\u001d2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010+\u001a\u00020,2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0014\u0010-\u001a\u00020.2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0014J\u0012\u0010/\u001a\u0002002\b\u0010\u0018\u001a\u0004\u0018\u000100H\u0002J+\u00101\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\b\u0010\u0018\u001a\u0004\u0018\u0001H\u0014H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u00102\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u00104\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u000fH\u0002J\u0018\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u000fH\u0002J\u0010\u00108\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0002J\u0010\u00109\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0002J\u000e\u0010:\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010;\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u000fH\u0002J\u0018\u0010=\u001a\u00060\u001dj\u0002`\u001e*\u00020\u00052\u0006\u0010>\u001a\u00020\u000fH\u0014R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "reader", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "indexCache", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "sparseIndexCache", "", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "decodeElementIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeTaggedBoolean", "", "tag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "decodeTaggedByte", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "enumDescription", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "decodeTaggedShort", "", "decodeTaggedString", "", "deserializeByteArray", "", "deserializeMap", "endStructure", "", "findIndexByTag", "protoTag", "findIndexByTagSlowPath", "desc", "getIndexByTag", "getIndexByTagSlowPath", "populateCache", "populateCacheMap", "elements", "getTag", "index", "kotlinx-serialization-protobuf"})
    private class ProtobufDecoder
    extends ProtobufTaggedDecoder {
        private int[] indexCache;
        private Map<Integer, Integer> sparseIndexCache;
        @JvmField
        @NotNull
        public final ProtobufReader reader;
        @JvmField
        @NotNull
        public final SerialDescriptor descriptor;

        @NotNull
        public SerializersModule getSerializersModule() {
            return ProtoBuf.this.getSerializersModule();
        }

        /*
         * WARNING - void declaration
         */
        public final void populateCache(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int elements = descriptor.getElementsCount();
            if (elements < 32) {
                int[] cache = new int[elements + 1];
                int n = 0;
                int n2 = elements;
                while (n < n2) {
                    void i;
                    int protoId = ProtoTypesKt.extractProtoId(descriptor, (int)i, false);
                    if (protoId > elements) {
                        this.populateCacheMap(descriptor, elements);
                        return;
                    }
                    cache[protoId] = i++;
                }
                this.indexCache = cache;
            } else {
                this.populateCacheMap(descriptor, elements);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void populateCacheMap(SerialDescriptor descriptor, int elements) {
            HashMap map = new HashMap(elements);
            int n = 0;
            int n2 = elements;
            while (n < n2) {
                void i;
                ((Map)map).put(ProtoTypesKt.extractProtoId(descriptor, (int)i, false), (int)i);
                ++i;
            }
            this.sparseIndexCache = map;
        }

        private final int getIndexByTag(int protoTag) {
            int[] array = this.indexCache;
            if (array != null) {
                int n;
                int[] nArray = array;
                boolean bl = false;
                if (protoTag >= 0 && protoTag <= ArraysKt.getLastIndex((int[])nArray)) {
                    n = nArray[protoTag];
                } else {
                    int it = protoTag;
                    boolean bl2 = false;
                    n = -1;
                }
                return n;
            }
            return this.getIndexByTagSlowPath(protoTag);
        }

        private final int getIndexByTagSlowPath(int protoTag) {
            Map<Integer, Integer> map = this.sparseIndexCache;
            Intrinsics.checkNotNull(map);
            Map<Integer, Integer> map2 = map;
            Integer n = protoTag;
            boolean bl = false;
            Integer n2 = map2.get(n);
            if (n2 == null) {
                boolean bl2 = false;
                n2 = -1;
            }
            return ((Number)n2).intValue();
        }

        private final int findIndexByTag(SerialDescriptor descriptor, int protoTag) {
            int protoId;
            if (protoTag < descriptor.getElementsCount() && (protoId = ProtoTypesKt.extractProtoId(descriptor, protoTag, true)) == protoTag) {
                return protoTag;
            }
            return this.findIndexByTagSlowPath(descriptor, protoTag);
        }

        /*
         * WARNING - void declaration
         */
        private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
            int n = 0;
            int n2 = desc.getElementsCount();
            while (n < n2) {
                void i;
                int protoId = ProtoTypesKt.extractProtoId(desc, (int)i, true);
                if (protoId == protoTag) {
                    return (int)i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SerialKind serialKind = descriptor.getKind();
            if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
                compositeDecoder = new RepeatedDecoder(this.reader, this.getCurrentTagOrDefault(), descriptor);
            } else {
                if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                    long tag = this.getCurrentTagOrDefault();
                    if (tag == 19500L && Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor)) {
                        return this;
                    }
                    return new ProtobufDecoder(Default.makeDelimited(this.reader, tag), descriptor);
                }
                if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
                    compositeDecoder = new MapEntryReader(Default.makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor);
                } else {
                    throw (Throwable)new SerializationException("Unsupported top-level serial kind: " + descriptor.getKind() + ", descriptor: " + descriptor);
                }
            }
            return compositeDecoder;
        }

        @Override
        public void endStructure(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        }

        @Override
        protected boolean decodeTaggedBoolean(long tag) {
            boolean bl;
            int value = this.decodeTaggedInt(tag);
            switch (value) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    throw (Throwable)new SerializationException("Unexpected boolean value: " + value + " when deserializing field with tag " + tag);
                }
            }
            return bl;
        }

        @Override
        protected byte decodeTaggedByte(long tag) {
            return (byte)this.decodeTaggedInt(tag);
        }

        @Override
        protected short decodeTaggedShort(long tag) {
            return (short)this.decodeTaggedInt(tag);
        }

        @Override
        protected int decodeTaggedInt(long tag) {
            return tag == 19500L ? this.reader.readInt32NoTag() : this.reader.readInt(ProtoTypesKt.getNumberType(tag));
        }

        @Override
        protected long decodeTaggedLong(long tag) {
            return tag == 19500L ? this.reader.readLongNoTag() : this.reader.readLong(ProtoTypesKt.getNumberType(tag));
        }

        @Override
        protected float decodeTaggedFloat(long tag) {
            return tag == 19500L ? this.reader.readFloatNoTag() : this.reader.readFloat();
        }

        @Override
        protected double decodeTaggedDouble(long tag) {
            return tag == 19500L ? this.reader.readDoubleNoTag() : this.reader.readDouble();
        }

        @Override
        protected char decodeTaggedChar(long tag) {
            return (char)this.decodeTaggedInt(tag);
        }

        @Override
        @NotNull
        protected String decodeTaggedString(long tag) {
            return tag == 19500L ? this.reader.readStringNoTag() : this.reader.readString();
        }

        @Override
        protected int decodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription) {
            Intrinsics.checkNotNullParameter((Object)enumDescription, (String)"enumDescription");
            return this.findIndexByTag(enumDescription, this.decodeTaggedInt(tag));
        }

        @Override
        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return this.decodeSerializableValue(deserializer, null);
        }

        @Override
        protected <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer, @Nullable T previousValue) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return (T)(deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge((Decoder)this, previousValue) : deserializer.deserialize((Decoder)this))));
        }

        private final byte[] deserializeByteArray(byte[] previousValue) {
            long tag = this.getCurrentTagOrDefault();
            byte[] array = tag == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
            return previousValue == null ? array : ArraysKt.plus((byte[])previousValue, (byte[])array);
        }

        /*
         * WARNING - void declaration
         */
        private final <T> T deserializeMap(DeserializationStrategy<T> deserializer, T previousValue) {
            void $this$associateByTo$iv$iv;
            DeserializationStrategy<T> deserializationStrategy = deserializer;
            if (deserializationStrategy == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T, *>");
            }
            MapLikeSerializer serializer = (MapLikeSerializer)deserializationStrategy;
            KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer((KSerializer)serializer.getKeySerializer(), (KSerializer)serializer.getValueSerializer());
            T t = previousValue;
            if (!(t instanceof Map)) {
                t = null;
            }
            Map map = (Map)t;
            Set oldSet = map != null ? map.entrySet() : null;
            Set setOfEntries = (Set)new LinkedHashSetSerializer(mapEntrySerial).merge((Decoder)this, oldSet);
            Iterable $this$associateBy$iv = setOfEntries;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry it;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Object v = it.getValue();
                map2.put(k, v);
            }
            return (T)destination$iv$iv;
        }

        @Override
        protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return ProtoTypesKt.extractParameters($this$getTag, index);
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            int index;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            while (true) {
                int protoId;
                if ((protoId = this.reader.readTag()) == -1) {
                    return -1;
                }
                index = this.getIndexByTag(protoId);
                if (index != -1) break;
                this.reader.skipElement();
            }
            return index;
        }

        public ProtobufDecoder(@NotNull ProtobufReader reader, SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.reader = reader;
            this.descriptor = descriptor;
            this.populateCache(this.descriptor);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00060\u0006j\u0002`\u0007*\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$RepeatedDecoder;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "currentTag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;JLkotlinx/serialization/descriptors/SerialDescriptor;)V", "index", "", "tagOrSize", "decodeElementIndex", "decodeListIndexNoTag", "decodeTaggedListIndex", "getTag", "kotlinx-serialization-protobuf"})
    private final class RepeatedDecoder
    extends ProtobufDecoder {
        private int index;
        private final long tagOrSize;

        @Override
        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (this.tagOrSize > 0L) {
                return this.decodeTaggedListIndex();
            }
            return this.decodeListIndexNoTag();
        }

        private final int decodeListIndexNoTag() {
            long size = -this.tagOrSize;
            RepeatedDecoder repeatedDecoder = this;
            ++repeatedDecoder.index;
            int idx = repeatedDecoder.index;
            if ((long)idx == size) {
                return -1;
            }
            return idx;
        }

        private final int decodeTaggedListIndex() {
            int n;
            int protoId = this.index == -1 ? this.reader.currentId : this.reader.readTag();
            long $this$protoId$iv = this.tagOrSize;
            boolean $i$f$getProtoId = false;
            if (protoId == (int)($this$protoId$iv & (long)Integer.MAX_VALUE)) {
                RepeatedDecoder repeatedDecoder = this;
                n = ++repeatedDecoder.index;
            } else {
                this.reader.pushBackTag();
                n = -1;
            }
            return n;
        }

        @Override
        protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            if (this.tagOrSize > 0L) {
                return this.tagOrSize;
            }
            return 19500L;
        }

        public RepeatedDecoder(ProtobufReader decoder, @NotNull long currentTag, SerialDescriptor descriptor) {
            long l;
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            super(decoder, descriptor);
            this.index = -1;
            if (currentTag == 19500L) {
                int length = this.reader.readInt32NoTag();
                if (length < 0) {
                    throw (Throwable)new SerializationException("Expected positive length for " + descriptor + ", but got " + length);
                }
                l = -((long)length);
            } else {
                l = currentTag;
            }
            this.tagOrSize = l;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007*\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$MapEntryReader;", "Lkotlinx/serialization/protobuf/ProtoBuf$ProtobufDecoder;", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "parentTag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;JLkotlinx/serialization/descriptors/SerialDescriptor;)V", "getTag", "index", "", "kotlinx-serialization-protobuf"})
    private final class MapEntryReader
    extends ProtobufDecoder {
        @JvmField
        public final long parentTag;

        /*
         * WARNING - void declaration
         */
        @Override
        protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            long l;
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            if (index % 2 == 0) {
                void protoId$iv;
                boolean bl = true;
                ProtoNumberType type$iv = ProtoTypesKt.getNumberType(this.parentTag);
                boolean $i$f$ProtoDesc = false;
                l = type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv;
            } else {
                int protoId$iv = 2;
                ProtoNumberType type$iv = ProtoTypesKt.getNumberType(this.parentTag);
                boolean $i$f$ProtoDesc = false;
                l = type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv;
            }
            return l;
        }

        public MapEntryReader(ProtobufReader decoder, @NotNull long parentTag, SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            super(decoder, descriptor);
            this.parentTag = parentTag;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001\u00a2\u0006\u0002\u0010\u0012J*\u0010\u0013\u001a\u00020\u0011\"\u0004\b\u0000\u0010\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u00152\u0006\u0010\u0016\u001a\u0002H\rH\u0096\u0001\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lkotlinx/serialization/protobuf/ProtoBuf$Default;", "Lkotlinx/serialization/BinaryFormat;", "()V", "SIZE_DELIMITED", "", "VARINT", "i32", "i64", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromByteArray", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "bytes", "", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "encodeToByteArray", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "makeDelimited", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "decoder", "parentTag", "", "Lkotlinx/serialization/protobuf/ProtoDesc;", "makeDelimitedForced", "kotlinx-serialization-protobuf"})
    public static final class Default
    implements BinaryFormat {
        private final /* synthetic */ ProtoBuf $$delegate_0;

        private final ProtobufReader makeDelimited(ProtobufReader decoder, long parentTag) {
            boolean tagless = parentTag == 19500L;
            ByteArrayInput input = tagless ? decoder.objectTaglessInput() : decoder.objectInput();
            return new ProtobufReader(input);
        }

        private final ProtobufReader makeDelimitedForced(ProtobufReader decoder, long parentTag) {
            boolean tagless = parentTag == 19500L;
            ByteArrayInput input = tagless ? decoder.objectTaglessInput() : decoder.objectInput();
            return new ProtobufReader(input);
        }

        private Default() {
            this.$$delegate_0 = new ProtoBuf(false, null, 3, null);
        }

        @NotNull
        public SerializersModule getSerializersModule() {
            return this.$$delegate_0.getSerializersModule();
        }

        public <T> T decodeFromByteArray(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return this.$$delegate_0.decodeFromByteArray(deserializer, bytes);
        }

        @NotNull
        public <T> byte[] encodeToByteArray(@NotNull SerializationStrategy<? super T> serializer, T value) {
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            return this.$$delegate_0.encodeToByteArray(serializer, value);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

