/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.okio.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.SerialReader;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/json/okio/internal/OkioSerialReader;", "Lkotlinx/serialization/json/internal/SerialReader;", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "bufferedChar", "", "Ljava/lang/Character;", "read", "", "buffer", "", "bufferOffset", "count", "kotlinx-serialization-json-okio"})
public final class OkioSerialReader
implements SerialReader {
    @NotNull
    private final BufferedSource source;
    @Nullable
    private Character bufferedChar;

    public OkioSerialReader(@NotNull BufferedSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    public int read(@NotNull char[] buffer, int bufferOffset, int count) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int i = 0;
        if (this.bufferedChar != null) {
            Character c = this.bufferedChar;
            Intrinsics.checkNotNull((Object)c);
            buffer[bufferOffset + i] = c.charValue();
            ++i;
            this.bufferedChar = null;
        }
        while (i < count && !this.source.exhausted()) {
            int codePoint = this.source.readUtf8CodePoint();
            if (codePoint <= 65535) {
                buffer[bufferOffset + i] = (char)codePoint;
                ++i;
                continue;
            }
            char upChar = (char)((codePoint >>> 10) + 55232);
            char lowChar = (char)((codePoint & 0x3FF) + 56320);
            buffer[bufferOffset + i] = upChar;
            if (++i < count) {
                buffer[bufferOffset + i] = lowChar;
                ++i;
                continue;
            }
            this.bufferedChar = Character.valueOf(lowChar);
        }
        return i > 0 ? i : -1;
    }
}

