/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.hocon.Hocon;
import kotlinx.serialization.hocon.HoconConfigEncoder;
import kotlinx.serialization.hocon.HoconDecoder;
import kotlinx.serialization.hocon.HoconExceptionsKt;
import kotlinx.serialization.hocon.HoconSerialKindKt;
import kotlinx.serialization.hocon.NamingConventionKt;
import kotlinx.serialization.hocon.internal.HoconDurationKt;
import kotlinx.serialization.hocon.internal.SuppressAnimalSniffer;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.TaggedDecoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 $2\u00020\u0001:\u0006$%&'()B1\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001d2\u0006\u0010\u001e\u001a\u0002H\u0015H\u0007\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u0002*+\u00a8\u0006,"}, d2={"Lkotlinx/serialization/hocon/Hocon;", "Lkotlinx/serialization/SerialFormat;", "encodeDefaults", "", "useConfigNamingConvention", "useArrayPolymorphism", "classDiscriminator", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "<init>", "(ZZZLjava/lang/String;Lkotlinx/serialization/modules/SerializersModule;)V", "getEncodeDefaults$kotlinx_serialization_hocon", "()Z", "getUseConfigNamingConvention$kotlinx_serialization_hocon", "getUseArrayPolymorphism$kotlinx_serialization_hocon", "getClassDiscriminator$kotlinx_serialization_hocon", "()Ljava/lang/String;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromConfig", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "config", "Lcom/typesafe/config/Config;", "(Lkotlinx/serialization/DeserializationStrategy;Lcom/typesafe/config/Config;)Ljava/lang/Object;", "encodeToConfig", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lcom/typesafe/config/Config;", "getElementIndexOrThrow", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "name", "Default", "ConfigConverter", "ConfigReader", "PolymorphConfigReader", "ListConfigReader", "MapConfigReader", "Lkotlinx/serialization/hocon/Hocon$Default;", "Lkotlinx/serialization/hocon/HoconImpl;", "kotlinx-serialization-hocon"})
public abstract class Hocon
implements SerialFormat {
    @NotNull
    public static final Default Default = new Default(null);
    private final boolean encodeDefaults;
    private final boolean useConfigNamingConvention;
    private final boolean useArrayPolymorphism;
    @NotNull
    private final String classDiscriminator;
    @NotNull
    private final SerializersModule serializersModule;

    private Hocon(boolean encodeDefaults, boolean useConfigNamingConvention, boolean useArrayPolymorphism, String classDiscriminator, SerializersModule serializersModule) {
        this.encodeDefaults = encodeDefaults;
        this.useConfigNamingConvention = useConfigNamingConvention;
        this.useArrayPolymorphism = useArrayPolymorphism;
        this.classDiscriminator = classDiscriminator;
        this.serializersModule = serializersModule;
    }

    public final boolean getEncodeDefaults$kotlinx_serialization_hocon() {
        return this.encodeDefaults;
    }

    public final boolean getUseConfigNamingConvention$kotlinx_serialization_hocon() {
        return this.useConfigNamingConvention;
    }

    public final boolean getUseArrayPolymorphism$kotlinx_serialization_hocon() {
        return this.useArrayPolymorphism;
    }

    @NotNull
    public final String getClassDiscriminator$kotlinx_serialization_hocon() {
        return this.classDiscriminator;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @ExperimentalSerializationApi
    public final <T> T decodeFromConfig(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull Config config) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new ConfigReader(this, config, false, 2, null).decodeSerializableValue(deserializer);
    }

    @ExperimentalSerializationApi
    @NotNull
    public final <T> Config encodeToConfig(@NotNull SerializationStrategy<? super T> serializer, T value) {
        ConfigValue configValue;
        ConfigValue configValue2;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Ref.ObjectRef configValue3 = new Ref.ObjectRef();
        HoconConfigEncoder encoder = new HoconConfigEncoder(this, (Function1<? super ConfigValue, Unit>)((Function1)arg_0 -> Hocon.encodeToConfig$lambda$0(configValue3, arg_0)));
        encoder.encodeSerializableValue(serializer, value);
        if (configValue3.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configValue");
            configValue2 = null;
        } else {
            configValue2 = (ConfigValue)configValue3.element;
        }
        if (!(configValue2 instanceof ConfigObject)) {
            ConfigValue configValue4;
            StringBuilder stringBuilder = new StringBuilder().append("Value of type '");
            if (configValue3.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configValue");
                configValue4 = null;
            } else {
                configValue4 = (ConfigValue)configValue3.element;
            }
            throw new SerializationException(stringBuilder.append(configValue4.valueType()).append("' can't be used at the root of HOCON Config. It should be either object or map.").toString());
        }
        if (configValue3.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configValue");
            configValue = null;
        } else {
            configValue = (ConfigValue)configValue3.element;
        }
        Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
        Config config = ((ConfigObject)configValue).toConfig();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"toConfig(...)");
        return config;
    }

    private final int getElementIndexOrThrow(SerialDescriptor $this$getElementIndexOrThrow, String name) {
        int index = $this$getElementIndexOrThrow.getElementIndex(name);
        if (index == -3) {
            throw new SerializationException($this$getElementIndexOrThrow.getSerialName() + " does not contain element with name '" + name + '\'');
        }
        return index;
    }

    private static final Unit encodeToConfig$lambda$0(Ref.ObjectRef $configValue, ConfigValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $configValue.element = it;
        return Unit.INSTANCE;
    }

    public /* synthetic */ Hocon(boolean encodeDefaults, boolean useConfigNamingConvention, boolean useArrayPolymorphism, String classDiscriminator, SerializersModule serializersModule, DefaultConstructorMarker $constructor_marker) {
        this(encodeDefaults, useConfigNamingConvention, useArrayPolymorphism, classDiscriminator, serializersModule);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u000b0\u000eH&\u00a2\u0006\u0002\u0010\u0011J\"\u0010\u0012\u001a\u0002H\u000b\"\n\b\u0001\u0010\u000b\u0018\u0001*\u00020\u00132\u0006\u0010\f\u001a\u00028\u0000H\u0082\b\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u0002H\u000b\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0010H\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010/J\u0015\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00105J\u0015\u00106\u001a\u0002072\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00108J\u0015\u00109\u001a\u00020\u00132\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010:\u001a\u00020\"2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010#J\u001d\u0010;\u001a\u00020+2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010<\u001a\u00020=H\u0014\u00a2\u0006\u0002\u0010>J-\u0010?\u001a\u0002H\u000b\"\u0004\b\u0001\u0010\u000b2\u0018\u0010@\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0016\u00a2\u0006\u0002\u0010AR\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006B"}, d2={"Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "T", "Lkotlinx/serialization/internal/TaggedDecoder;", "Lkotlinx/serialization/hocon/HoconDecoder;", "<init>", "(Lkotlinx/serialization/hocon/Hocon;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "Lcom/typesafe/config/Config;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "validateAndCast", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "getTaggedNumber", "", "(Ljava/lang/Object;)Ljava/lang/Number;", "decodeDuration", "decodeDurationImpl", "Lkotlin/time/Duration;", "conf", "path", "decodeDurationImpl-3nIYWDw", "(Lcom/typesafe/config/Config;Ljava/lang/String;)J", "decodeTaggedString", "(Ljava/lang/Object;)Ljava/lang/String;", "decodeTaggedBoolean", "", "(Ljava/lang/Object;)Z", "decodeTaggedByte", "", "(Ljava/lang/Object;)B", "decodeTaggedShort", "", "(Ljava/lang/Object;)S", "decodeTaggedInt", "", "(Ljava/lang/Object;)I", "decodeTaggedLong", "", "(Ljava/lang/Object;)J", "decodeTaggedFloat", "", "(Ljava/lang/Object;)F", "decodeTaggedDouble", "", "(Ljava/lang/Object;)D", "decodeTaggedChar", "", "(Ljava/lang/Object;)C", "decodeTaggedValue", "decodeTaggedNotNullMark", "decodeTaggedEnum", "enumDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Ljava/lang/Object;Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeConfigValue", "extractValueAtPath", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "kotlinx-serialization-hocon"})
    @SourceDebugExtension(value={"SMAP\nHocon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$ConfigConverter\n+ 2 HoconExceptions.kt\nkotlinx/serialization/hocon/HoconExceptionsKt\n*L\n1#1,388:1\n97#1,10:392\n97#1,10:405\n97#1,10:418\n97#1,10:431\n97#1,10:444\n15#2,3:389\n15#2,3:402\n15#2,3:415\n15#2,3:428\n15#2,3:441\n15#2,3:454\n*S KotlinDebug\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$ConfigConverter\n*L\n110#1:392,10\n120#1:405,10\n122#1:418,10\n131#1:431,10\n141#1:444,10\n106#1:389,3\n110#1:402,3\n120#1:415,3\n122#1:428,3\n131#1:441,3\n141#1:454,3\n*E\n"})
    private abstract class ConfigConverter<T>
    extends TaggedDecoder<T>
    implements HoconDecoder {
        @NotNull
        public SerializersModule getSerializersModule() {
            return Hocon.this.getSerializersModule();
        }

        public abstract <E> E getValueFromTaggedConfig(T var1, @NotNull Function2<? super Config, ? super String, ? extends E> var2);

        private final /* synthetic */ <E> E validateAndCast(T tag) {
            Object object;
            boolean $i$f$validateAndCast = false;
            try {
                E e;
                Intrinsics.reifiedOperationMarker((int)4, (String)"E");
                object = Reflection.getOrCreateKotlinClass(Object.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    E e2 = this.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e2;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    E e3 = this.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e3;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    E e4 = this.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e4;
                } else {
                    E e5 = this.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e5;
                }
                object = e;
            }
            catch (ConfigException e) {
                ConfigOrigin configOrigin = e.origin();
                Intrinsics.checkNotNull((Object)configOrigin);
                ConfigOrigin valueOrigin$iv = configOrigin;
                boolean $i$f$ConfigValueTypeCastException = false;
                StringBuilder stringBuilder = new StringBuilder().append(valueOrigin$iv.description()).append(" required to be of type ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"E");
                throw new SerializationException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getSimpleName()).append('.').toString());
            }
            return (E)object;
        }

        /*
         * WARNING - void declaration
         */
        private final Number getTaggedNumber(T tag) {
            Object object;
            ConfigConverter configConverter = this;
            T tag$iv = tag;
            boolean $i$f$validateAndCast = false;
            try {
                Number number;
                void this_$iv;
                object = Reflection.getOrCreateKotlinClass(Number.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                }
                object = number;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNull((Object)configOrigin$iv);
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(Number.class).getSimpleName() + '.');
            }
            return object;
        }

        protected final <E> E decodeDuration(T tag) {
            return this.getValueFromTaggedConfig(tag, (Function2)new Function2<Config, String, Duration>((Object)this){

                public final long invoke-3nIYWDw(Config p0, String p1) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ConfigConverter.access$decodeDurationImpl-3nIYWDw((ConfigConverter)this.receiver, p0, p1);
                }
            });
        }

        @SuppressAnimalSniffer
        private final long decodeDurationImpl-3nIYWDw(Config conf, String path) {
            java.time.Duration duration = HoconDurationKt.decodeJavaDuration(conf, path);
            return Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected String decodeTaggedString(T tag) {
            Object object;
            ConfigConverter configConverter = this;
            T tag$iv = tag;
            boolean $i$f$validateAndCast = false;
            try {
                String string;
                void this_$iv;
                object = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                }
                object = string;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNull((Object)configOrigin$iv);
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName() + '.');
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        protected boolean decodeTaggedBoolean(T tag) {
            Object object;
            ConfigConverter configConverter = this;
            T tag$iv = tag;
            boolean $i$f$validateAndCast = false;
            try {
                Boolean bl;
                void this_$iv;
                object = Reflection.getOrCreateKotlinClass(Boolean.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                }
                object = bl;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNull((Object)configOrigin$iv);
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(Boolean.class).getSimpleName() + '.');
            }
            return (Boolean)object;
        }

        protected byte decodeTaggedByte(T tag) {
            return this.getTaggedNumber(tag).byteValue();
        }

        protected short decodeTaggedShort(T tag) {
            return this.getTaggedNumber(tag).shortValue();
        }

        protected int decodeTaggedInt(T tag) {
            return this.getTaggedNumber(tag).intValue();
        }

        protected long decodeTaggedLong(T tag) {
            return this.getTaggedNumber(tag).longValue();
        }

        protected float decodeTaggedFloat(T tag) {
            return this.getTaggedNumber(tag).floatValue();
        }

        protected double decodeTaggedDouble(T tag) {
            return this.getTaggedNumber(tag).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        protected char decodeTaggedChar(T tag) {
            Object object;
            ConfigConverter configConverter = this;
            T tag$iv = tag;
            boolean $i$f$validateAndCast = false;
            try {
                String string;
                void this_$iv;
                object = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                }
                object = string;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNull((Object)configOrigin$iv);
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName() + '.');
            }
            Object s = object;
            if (((String)s).length() != 1) {
                throw new SerializationException("String \"" + (String)s + "\" is not convertible to Char");
            }
            return ((String)s).charAt(0);
        }

        @NotNull
        protected Object decodeTaggedValue(T tag) {
            Object e = this.getValueFromTaggedConfig(tag, ConfigConverter::decodeTaggedValue$lambda$0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"getValueFromTaggedConfig(...)");
            return e;
        }

        protected boolean decodeTaggedNotNullMark(T tag) {
            return (Boolean)this.getValueFromTaggedConfig(tag, ConfigConverter::decodeTaggedNotNullMark$lambda$1);
        }

        /*
         * WARNING - void declaration
         */
        protected int decodeTaggedEnum(T tag, @NotNull SerialDescriptor enumDescriptor) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
            ConfigConverter configConverter = this;
            T tag$iv = tag;
            boolean $i$f$validateAndCast = false;
            try {
                String string;
                void this_$iv;
                object = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag$iv, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                }
                object = string;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNull((Object)configOrigin$iv);
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName() + '.');
            }
            Object s = object;
            return Hocon.this.getElementIndexOrThrow(enumDescriptor, (String)s);
        }

        @Override
        public <E> E decodeConfigValue(@NotNull Function2<? super Config, ? super String, ? extends E> extractValueAtPath) {
            Intrinsics.checkNotNullParameter(extractValueAtPath, (String)"extractValueAtPath");
            return this.getValueFromTaggedConfig(this.getCurrentTag(), extractValueAtPath);
        }

        private static final Object decodeTaggedValue$lambda$0(Config c, String s) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return c.getAnyRef(s);
        }

        private static final boolean decodeTaggedNotNullMark$lambda$1(Config c, String s) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return !c.getIsNull(s);
        }

        public static final /* synthetic */ long access$decodeDurationImpl-3nIYWDw(ConfigConverter $this, Config conf, String path) {
            return $this.decodeDurationImpl-3nIYWDw(conf, path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0014\u0010\u0014\u001a\u00020\u0002*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0014J\b\u0010\u0016\u001a\u00020\u0007H\u0016J!\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J5\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020\u00022\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001f0\"H\u0016\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkotlinx/serialization/hocon/Hocon$ConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "conf", "Lcom/typesafe/config/Config;", "isPolymorphic", "", "<init>", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/Config;Z)V", "getConf", "()Lcom/typesafe/config/Config;", "ind", "", "decodeElementIndex", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "composeName", "parentName", "childName", "getTag", "index", "decodeNotNullMark", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "kotlinx-serialization-hocon"})
    private final class ConfigReader
    extends ConfigConverter<String> {
        @NotNull
        private final Config conf;
        private final boolean isPolymorphic;
        private int ind;
        final /* synthetic */ Hocon this$0;

        public ConfigReader(@NotNull Hocon this$0, Config conf, boolean isPolymorphic) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            this.this$0 = this$0;
            this.conf = conf;
            this.isPolymorphic = isPolymorphic;
            this.ind = -1;
        }

        public /* synthetic */ ConfigReader(Hocon hocon, Config config, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(hocon, config, bl);
        }

        @NotNull
        public final Config getConf() {
            return this.conf;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            block1: {
                String name;
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                do {
                    ++this.ind;
                    if (this.ind >= descriptor.getElementsCount()) break block1;
                } while (!this.conf.hasPathOrNull(name = this.getTag(descriptor, this.ind)));
                return this.ind;
            }
            return -1;
        }

        private final String composeName(String parentName, String childName) {
            return ((CharSequence)parentName).length() == 0 ? childName : parentName + '.' + childName;
        }

        @NotNull
        protected String getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            String conventionName = NamingConventionKt.getConventionElementName($this$getTag, index, this.this$0.getUseConfigNamingConvention$kotlinx_serialization_hocon());
            if (!this.isPolymorphic) {
                String string2 = (String)this.getCurrentTagOrNull();
                if (string2 == null) {
                    string2 = "";
                }
                string = this.composeName(string2, conventionName);
            } else {
                string = conventionName;
            }
            return string;
        }

        public boolean decodeNotNullMark() {
            String string = (String)this.getCurrentTagOrNull();
            if (string == null) {
                return !this.conf.isEmpty();
            }
            String currentTag = string;
            return this.decodeTaggedNotNullMark(currentTag);
        }

        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
            Object object;
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            if (HoconDurationKt.isDuration(deserializer.getDescriptor())) {
                object = this.decodeDuration(this.getCurrentTag());
            } else if (!(deserializer instanceof AbstractPolymorphicSerializer) || this.this$0.getUseArrayPolymorphism$kotlinx_serialization_hocon()) {
                object = deserializer.deserialize((Decoder)this);
            } else {
                Config config = this.getCurrentTagOrNull() != null ? this.conf.getConfig((String)this.getCurrentTag()) : this.conf;
                Intrinsics.checkNotNull((Object)config);
                ConfigReader reader = new ConfigReader(this.this$0, config, false, 2, null);
                String type = reader.decodeTaggedString(this.this$0.getClassDiscriminator$kotlinx_serialization_hocon());
                DeserializationStrategy deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull((CompositeDecoder)reader, type);
                if (deserializationStrategy == null) {
                    throw HoconExceptionsKt.SerializerNotFoundException(type);
                }
                DeserializationStrategy actualSerializer = deserializationStrategy;
                object = actualSerializer.deserialize((Decoder)reader);
            }
            return (T)object;
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SerialKind kind = HoconSerialKindKt.hoconKind(descriptor, this.this$0.getUseArrayPolymorphism$kotlinx_serialization_hocon());
            if (HoconSerialKindKt.getListLike(kind)) {
                ConfigList configList = this.conf.getList((String)this.getCurrentTag());
                Intrinsics.checkNotNullExpressionValue((Object)configList, (String)"getList(...)");
                compositeDecoder = (CompositeDecoder)this.this$0.new ListConfigReader(configList);
            } else if (HoconSerialKindKt.getObjLike(kind)) {
                ConfigReader configReader;
                if (this.ind > -1) {
                    Config config = this.conf.getConfig((String)this.getCurrentTag());
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"getConfig(...)");
                    configReader = new ConfigReader(this.this$0, config, false, 2, null);
                } else {
                    configReader = this;
                }
                compositeDecoder = (CompositeDecoder)configReader;
            } else if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.MAP.INSTANCE)) {
                ConfigObject configObject = this.getCurrentTagOrNull() != null ? this.conf.getObject((String)this.getCurrentTag()) : this.conf.root();
                Intrinsics.checkNotNull((Object)configObject);
                compositeDecoder = (CompositeDecoder)this.this$0.new MapConfigReader(configObject);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @Override
        public <E> E getValueFromTaggedConfig(@NotNull String tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            return (E)valueResolver.invoke((Object)this.conf, (Object)tag);
        }
    }

    @ExperimentalSerializationApi
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lkotlinx/serialization/hocon/Hocon$Default;", "Lkotlinx/serialization/hocon/Hocon;", "<init>", "()V", "kotlinx-serialization-hocon"})
    public static final class Default
    extends Hocon {
        private Default() {
            super(false, false, false, "type", SerializersModuleBuildersKt.EmptySerializersModule(), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0019\u0010\u0012\u001a\u00020\u0002*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J5\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00170\u001aH\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/hocon/Hocon$ListConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "list", "Lcom/typesafe/config/ConfigList;", "<init>", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/ConfigList;)V", "ind", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getTag", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Integer;", "decodeElementIndex", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "Lcom/typesafe/config/Config;", "", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "kotlinx-serialization-hocon"})
    private final class ListConfigReader
    extends ConfigConverter<Integer> {
        @NotNull
        private final ConfigList list;
        private int ind;

        public ListConfigReader(ConfigList list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            this.list = list;
            this.ind = -1;
        }

        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return (T)(HoconDurationKt.isDuration(deserializer.getDescriptor()) ? this.decodeDuration(this.ind) : super.decodeSerializableValue(deserializer));
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (descriptor.getKind() instanceof PolymorphicKind) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                Config config = ((ConfigObject)object).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"toConfig(...)");
                compositeDecoder = (CompositeDecoder)new PolymorphConfigReader(config);
            } else if (HoconSerialKindKt.getListLike(descriptor.getKind())) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigList");
                compositeDecoder = (CompositeDecoder)new ListConfigReader((ConfigList)object);
            } else if (HoconSerialKindKt.getObjLike(descriptor.getKind())) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                Config config = ((ConfigObject)object).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"toConfig(...)");
                compositeDecoder = (CompositeDecoder)new ConfigReader(Hocon.this, config, false, 2, null);
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                compositeDecoder = (CompositeDecoder)new MapConfigReader((ConfigObject)object);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        protected Integer getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            return index;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind > this.list.size() - 1 ? -1 : this.ind;
        }

        @Override
        public <E> E getValueFromTaggedConfig(int tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            String tagString = String.valueOf(tag);
            Config config = ((ConfigValue)this.list.get(tag)).atKey(tagString);
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"atKey(...)");
            Object configValue = valueResolver.invoke((Object)config, (Object)tagString);
            return (E)configValue;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0019\u0010\u0018\u001a\u00020\u0002*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J5\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001d0 H\u0016\u00a2\u0006\u0002\u0010\"R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkotlinx/serialization/hocon/Hocon$MapConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "map", "Lcom/typesafe/config/ConfigObject;", "<init>", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/ConfigObject;)V", "ind", "keys", "", "", "values", "Lcom/typesafe/config/ConfigValue;", "indexSize", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getTag", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Integer;", "decodeElementIndex", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "Lcom/typesafe/config/Config;", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "kotlinx-serialization-hocon"})
    @SourceDebugExtension(value={"SMAP\nHocon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$MapConfigReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,388:1\n1563#2:389\n1634#2,3:390\n1563#2:393\n1634#2,3:394\n*S KotlinDebug\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$MapConfigReader\n*L\n272#1:389\n272#1:390,3\n273#1:393\n273#1:394,3\n*E\n"})
    private final class MapConfigReader
    extends ConfigConverter<Integer> {
        private int ind;
        @NotNull
        private final List<String> keys;
        @NotNull
        private final List<ConfigValue> values;
        private final int indexSize;

        public MapConfigReader(ConfigObject map) {
            Map.Entry p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            this.ind = -1;
            List entries = CollectionsKt.toList((Iterable)map.entrySet());
            Iterable iterable = entries;
            MapConfigReader mapConfigReader = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)p0.getKey());
            }
            mapConfigReader.keys = (List)destination$iv$iv;
            $this$map$iv = entries;
            mapConfigReader = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ConfigValue)p0.getValue());
            }
            mapConfigReader.values = (List)destination$iv$iv;
            this.indexSize = this.values.size() * 2;
        }

        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return (T)(HoconDurationKt.isDuration(deserializer.getDescriptor()) ? this.decodeDuration(this.ind) : super.decodeSerializableValue(deserializer));
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (descriptor.getKind() instanceof PolymorphicKind) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                Config config = ((ConfigObject)configValue).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"toConfig(...)");
                compositeDecoder = (CompositeDecoder)new PolymorphConfigReader(config);
            } else if (HoconSerialKindKt.getListLike(descriptor.getKind())) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigList");
                compositeDecoder = (CompositeDecoder)new ListConfigReader((ConfigList)configValue);
            } else if (HoconSerialKindKt.getObjLike(descriptor.getKind())) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                Config config = ((ConfigObject)configValue).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"toConfig(...)");
                compositeDecoder = (CompositeDecoder)new ConfigReader(Hocon.this, config, false, 2, null);
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                compositeDecoder = (CompositeDecoder)new MapConfigReader((ConfigObject)configValue);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        protected Integer getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            return index;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind >= this.indexSize ? -1 : this.ind;
        }

        @Override
        public <E> E getValueFromTaggedConfig(int tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Config config;
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            int idx = tag / 2;
            String tagString = String.valueOf(tag);
            if (tag % 2 == 0) {
                config = ConfigValueFactory.fromAnyRef((Object)this.keys.get(idx)).atKey(tagString);
            } else {
                ConfigValue configValue = this.values.get(idx);
                config = configValue.atKey(tagString);
            }
            Config configValue = config;
            Intrinsics.checkNotNull((Object)configValue);
            return (E)valueResolver.invoke((Object)configValue, (Object)tagString);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u0002*\u00020\r2\u0006\u0010\u000f\u001a\u00020\tH\u0014J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J5\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/hocon/Hocon$PolymorphConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "conf", "Lcom/typesafe/config/Config;", "<init>", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/Config;)V", "ind", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getTag", "index", "decodeElementIndex", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "kotlinx-serialization-hocon"})
    private final class PolymorphConfigReader
    extends ConfigConverter<String> {
        @NotNull
        private final Config conf;
        private int ind;

        public PolymorphConfigReader(Config conf) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            this.conf = conf;
            this.ind = -1;
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return HoconSerialKindKt.getObjLike(descriptor.getKind()) ? (CompositeDecoder)new ConfigReader(Hocon.this, this.conf, true) : (CompositeDecoder)this;
        }

        @NotNull
        protected String getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            return $this$getTag.getElementName(index);
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind >= descriptor.getElementsCount() ? -1 : this.ind;
        }

        @Override
        public <E> E getValueFromTaggedConfig(@NotNull String tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            return (E)valueResolver.invoke((Object)this.conf, (Object)tag);
        }
    }
}

