/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.hocon.Hocon;
import kotlinx.serialization.hocon.HoconConfigEncoder;
import kotlinx.serialization.hocon.HoconExceptionsKt;
import kotlinx.serialization.hocon.HoconSerialKindKt;
import kotlinx.serialization.hocon.NamingConventionKt;
import kotlinx.serialization.hocon.internal.SuppressAnimalSniffer;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.TaggedDecoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 %2\u00020\u0001:\u0005#$%&'B/\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001c2\u0006\u0010\u001d\u001a\u0002H\u0014H\u0007\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010\u001f\u001a\u00020 *\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u0082\u0001\u0002()\u00a8\u0006*"}, d2={"Lkotlinx/serialization/hocon/Hocon;", "Lkotlinx/serialization/SerialFormat;", "encodeDefaults", "", "useConfigNamingConvention", "useArrayPolymorphism", "classDiscriminator", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(ZZZLjava/lang/String;Lkotlinx/serialization/modules/SerializersModule;)V", "getClassDiscriminator$kotlinx_serialization_hocon", "()Ljava/lang/String;", "getEncodeDefaults$kotlinx_serialization_hocon", "()Z", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getUseArrayPolymorphism$kotlinx_serialization_hocon", "getUseConfigNamingConvention$kotlinx_serialization_hocon", "decodeFromConfig", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "config", "Lcom/typesafe/config/Config;", "(Lkotlinx/serialization/DeserializationStrategy;Lcom/typesafe/config/Config;)Ljava/lang/Object;", "encodeToConfig", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lcom/typesafe/config/Config;", "getElementIndexOrThrow", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "name", "ConfigConverter", "ConfigReader", "Default", "ListConfigReader", "MapConfigReader", "Lkotlinx/serialization/hocon/Hocon$Default;", "Lkotlinx/serialization/hocon/HoconImpl;", "kotlinx-serialization-hocon"})
public abstract class Hocon
implements SerialFormat {
    @NotNull
    public static final Default Default = new Default(null);
    private final boolean encodeDefaults;
    private final boolean useConfigNamingConvention;
    private final boolean useArrayPolymorphism;
    @NotNull
    private final String classDiscriminator;
    @NotNull
    private final SerializersModule serializersModule;

    private Hocon(boolean encodeDefaults, boolean useConfigNamingConvention, boolean useArrayPolymorphism, String classDiscriminator, SerializersModule serializersModule) {
        this.encodeDefaults = encodeDefaults;
        this.useConfigNamingConvention = useConfigNamingConvention;
        this.useArrayPolymorphism = useArrayPolymorphism;
        this.classDiscriminator = classDiscriminator;
        this.serializersModule = serializersModule;
    }

    public final boolean getEncodeDefaults$kotlinx_serialization_hocon() {
        return this.encodeDefaults;
    }

    public final boolean getUseConfigNamingConvention$kotlinx_serialization_hocon() {
        return this.useConfigNamingConvention;
    }

    public final boolean getUseArrayPolymorphism$kotlinx_serialization_hocon() {
        return this.useArrayPolymorphism;
    }

    @NotNull
    public final String getClassDiscriminator$kotlinx_serialization_hocon() {
        return this.classDiscriminator;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @ExperimentalSerializationApi
    public final <T> T decodeFromConfig(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull Config config) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new ConfigReader(config).decodeSerializableValue(deserializer);
    }

    @ExperimentalSerializationApi
    @NotNull
    public final <T> Config encodeToConfig(@NotNull SerializationStrategy<? super T> serializer, T value) {
        ConfigValue configValue;
        ConfigValue configValue2;
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Ref.ObjectRef configValue3 = new Ref.ObjectRef();
        HoconConfigEncoder encoder2 = new HoconConfigEncoder(this, (Function1<? super ConfigValue, Unit>)((Function1)new Function1<ConfigValue, Unit>((Ref.ObjectRef<ConfigValue>)configValue3){
            final /* synthetic */ Ref.ObjectRef<ConfigValue> $configValue;
            {
                this.$configValue = $configValue;
                super(1);
            }

            public final void invoke(@NotNull ConfigValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$configValue.element = it;
            }
        }));
        encoder2.encodeSerializableValue(serializer, value);
        if (configValue3.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configValue");
            configValue2 = null;
        } else {
            configValue2 = (ConfigValue)configValue3.element;
        }
        if (!(configValue2 instanceof ConfigObject)) {
            ConfigValue configValue4;
            StringBuilder stringBuilder = new StringBuilder().append("Value of type '");
            if (configValue3.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configValue");
                configValue4 = null;
            } else {
                configValue4 = (ConfigValue)configValue3.element;
            }
            throw new SerializationException(stringBuilder.append(configValue4.valueType()).append("' can't be used at the root of HOCON Config. It should be either object or map.").toString());
        }
        if (configValue3.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configValue");
            configValue = null;
        } else {
            configValue = (ConfigValue)configValue3.element;
        }
        Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
        Config config = ((ConfigObject)configValue).toConfig();
        Intrinsics.checkNotNullExpressionValue((Object)config, (String)"configValue as ConfigObject).toConfig()");
        return config;
    }

    private final int getElementIndexOrThrow(SerialDescriptor $this$getElementIndexOrThrow, String name) {
        int index = $this$getElementIndexOrThrow.getElementIndex(name);
        if (index == -3) {
            throw new SerializationException($this$getElementIndexOrThrow.getSerialName() + " does not contain element with name '" + name + '\'');
        }
        return index;
    }

    public /* synthetic */ Hocon(boolean encodeDefaults, boolean useConfigNamingConvention, boolean useArrayPolymorphism, String classDiscriminator, SerializersModule serializersModule, DefaultConstructorMarker $constructor_marker) {
        this(encodeDefaults, useConfigNamingConvention, useArrayPolymorphism, classDiscriminator, serializersModule);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u00022\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0014\u0010 \u001a\u00020\u0002*\u00020\u000e2\u0006\u0010!\u001a\u00020\nH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkotlinx/serialization/hocon/Hocon$ConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "conf", "Lcom/typesafe/config/Config;", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/Config;)V", "getConf", "()Lcom/typesafe/config/Config;", "ind", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "composeName", "parentName", "childName", "decodeElementIndex", "decodeNotNullMark", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getTag", "index", "kotlinx-serialization-hocon"})
    private final class ConfigReader
    extends ConfigConverter<String> {
        @NotNull
        private final Config conf;
        private int ind;

        public ConfigReader(Config conf) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            this.conf = conf;
            this.ind = -1;
        }

        @NotNull
        public final Config getConf() {
            return this.conf;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            block1: {
                String name;
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                do {
                    ++this.ind;
                    if (this.ind >= descriptor.getElementsCount()) break block1;
                } while (!this.conf.hasPathOrNull(name = this.getTag(descriptor, this.ind)));
                return this.ind;
            }
            return -1;
        }

        private final String composeName(String parentName, String childName) {
            return ((CharSequence)parentName).length() == 0 ? childName : parentName + '.' + childName;
        }

        @NotNull
        protected String getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            String string = (String)this.getCurrentTagOrNull();
            if (string == null) {
                string = "";
            }
            return this.composeName(string, NamingConventionKt.getConventionElementName($this$getTag, index, Hocon.this.getUseConfigNamingConvention$kotlinx_serialization_hocon()));
        }

        public boolean decodeNotNullMark() {
            String string = (String)this.getCurrentTagOrNull();
            if (string == null) {
                return !this.conf.isEmpty();
            }
            String currentTag = string;
            return this.decodeTaggedNotNullMark(currentTag);
        }

        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
            Object object;
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            if (Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.serializer((Duration.Companion)Duration.Companion).getDescriptor())) {
                object = this.decodeDurationInHoconFormat(this.getCurrentTag());
            } else if (!(deserializer instanceof AbstractPolymorphicSerializer) || Hocon.this.getUseArrayPolymorphism$kotlinx_serialization_hocon()) {
                object = deserializer.deserialize((Decoder)this);
            } else {
                Config config = this.getCurrentTagOrNull() != null ? this.conf.getConfig((String)this.getCurrentTag()) : this.conf;
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
                ConfigReader reader = new ConfigReader(config);
                String type = reader.decodeTaggedString(Hocon.this.getClassDiscriminator$kotlinx_serialization_hocon());
                DeserializationStrategy deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull((CompositeDecoder)reader, type);
                if (deserializationStrategy == null) {
                    throw HoconExceptionsKt.SerializerNotFoundException(type);
                }
                DeserializationStrategy actualSerializer = deserializationStrategy;
                object = actualSerializer.deserialize((Decoder)reader);
            }
            return (T)object;
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            SerialKind kind = HoconSerialKindKt.hoconKind(descriptor, Hocon.this.getUseArrayPolymorphism$kotlinx_serialization_hocon());
            if (HoconSerialKindKt.getListLike(kind)) {
                ConfigList configList = this.conf.getList((String)this.getCurrentTag());
                Intrinsics.checkNotNullExpressionValue((Object)configList, (String)"conf.getList(currentTag)");
                compositeDecoder = (CompositeDecoder)new ListConfigReader(configList);
            } else if (HoconSerialKindKt.getObjLike(kind)) {
                ConfigReader configReader;
                if (this.ind > -1) {
                    Config config = this.conf.getConfig((String)this.getCurrentTag());
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"conf.getConfig(currentTag)");
                    configReader = new ConfigReader(config);
                } else {
                    configReader = this;
                }
                compositeDecoder = (CompositeDecoder)configReader;
            } else if (Intrinsics.areEqual((Object)kind, (Object)StructureKind.MAP.INSTANCE)) {
                ConfigObject configObject = this.getCurrentTagOrNull() != null ? this.conf.getObject((String)this.getCurrentTag()) : this.conf.root();
                Intrinsics.checkNotNullExpressionValue((Object)configObject, (String)"if (currentTagOrNull != \u2026rentTag) else conf.root()");
                compositeDecoder = (CompositeDecoder)new MapConfigReader(configObject);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @Override
        public <E> E getValueFromTaggedConfig(@NotNull String tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            return (E)valueResolver.invoke((Object)this.conf, (Object)tag);
        }
    }

    @ExperimentalSerializationApi
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lkotlinx/serialization/hocon/Hocon$Default;", "Lkotlinx/serialization/hocon/Hocon;", "()V", "kotlinx-serialization-hocon"})
    public static final class Default
    extends Hocon {
        private Default() {
            super(false, false, false, "type", SerializersModuleBuildersKt.EmptySerializersModule(), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\b\u001a\u0002H\t\"\u0004\b\u0001\u0010\t2\u0006\u0010\n\u001a\u00028\u0000H\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00192\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\u00020*2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010+J\u0015\u0010,\u001a\u00020-2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00100J5\u00101\u001a\u0002H\t\"\u0004\b\u0001\u0010\t2\u0006\u0010\n\u001a\u00028\u00002\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002H\t03H&\u00a2\u0006\u0002\u00105J\"\u00106\u001a\u0002H\t\"\n\b\u0001\u0010\t\u0018\u0001*\u00020-2\u0006\u0010\n\u001a\u00028\u0000H\u0082\b\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00067"}, d2={"Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "T", "Lkotlinx/serialization/internal/TaggedDecoder;", "(Lkotlinx/serialization/hocon/Hocon;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeDurationInHoconFormat", "E", "tag", "(Ljava/lang/Object;)Ljava/lang/Object;", "decodeTaggedBoolean", "", "(Ljava/lang/Object;)Z", "decodeTaggedByte", "", "(Ljava/lang/Object;)B", "decodeTaggedChar", "", "(Ljava/lang/Object;)C", "decodeTaggedDouble", "", "(Ljava/lang/Object;)D", "decodeTaggedEnum", "", "enumDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Ljava/lang/Object;Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeTaggedFloat", "", "(Ljava/lang/Object;)F", "decodeTaggedInt", "(Ljava/lang/Object;)I", "decodeTaggedLong", "", "(Ljava/lang/Object;)J", "decodeTaggedNotNullMark", "decodeTaggedShort", "", "(Ljava/lang/Object;)S", "decodeTaggedString", "", "(Ljava/lang/Object;)Ljava/lang/String;", "decodeTaggedValue", "", "getTaggedNumber", "", "(Ljava/lang/Object;)Ljava/lang/Number;", "getValueFromTaggedConfig", "valueResolver", "Lkotlin/Function2;", "Lcom/typesafe/config/Config;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "validateAndCast", "kotlinx-serialization-hocon"})
    @SourceDebugExtension(value={"SMAP\nHocon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$ConfigConverter\n+ 2 HoconExceptions.kt\nkotlinx/serialization/hocon/HoconExceptionsKt\n*L\n1#1,355:1\n89#1,10:359\n89#1,10:372\n89#1,10:385\n89#1,10:398\n89#1,10:411\n15#2,3:356\n15#2,3:369\n15#2,3:382\n15#2,3:395\n15#2,3:408\n15#2,3:421\n*S KotlinDebug\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$ConfigConverter\n*L\n102#1:359,10\n116#1:372,10\n118#1:385,10\n127#1:398,10\n137#1:411,10\n98#1:356,3\n102#1:369,3\n116#1:382,3\n118#1:395,3\n127#1:408,3\n137#1:421,3\n*E\n"})
    private abstract class ConfigConverter<T>
    extends TaggedDecoder<T> {
        @NotNull
        public SerializersModule getSerializersModule() {
            return Hocon.this.getSerializersModule();
        }

        public abstract <E> E getValueFromTaggedConfig(T var1, @NotNull Function2<? super Config, ? super String, ? extends E> var2);

        private final /* synthetic */ <E> E validateAndCast(T tag) {
            Object object;
            boolean $i$f$validateAndCast = false;
            try {
                E e;
                Intrinsics.reifiedOperationMarker((int)4, (String)"E");
                object = Reflection.getOrCreateKotlinClass(Object.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    E e2 = this.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e2;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    E e3 = this.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e3;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    E e4 = this.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e4;
                } else {
                    E e5 = this.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    Intrinsics.reifiedOperationMarker((int)1, (String)"E");
                    e = e5;
                }
                object = e;
            }
            catch (ConfigException e) {
                ConfigOrigin configOrigin = e.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin, (String)"configOrigin");
                ConfigOrigin valueOrigin$iv = configOrigin;
                boolean $i$f$ConfigValueTypeCastException = false;
                StringBuilder stringBuilder = new StringBuilder().append(valueOrigin$iv.description()).append(" required to be of type ");
                Intrinsics.reifiedOperationMarker((int)4, (String)"E");
                throw new SerializationException(stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getSimpleName()).append('.').toString());
            }
            return (E)object;
        }

        private final Number getTaggedNumber(T tag) {
            Object object;
            ConfigConverter this_$iv = this;
            boolean $i$f$validateAndCast = false;
            try {
                Number number;
                object = Reflection.getOrCreateKotlinClass(Number.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    number = (Number)e;
                }
                object = number;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin$iv, (String)"configOrigin");
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(Number.class).getSimpleName() + '.');
            }
            return object;
        }

        @SuppressAnimalSniffer
        protected final <E> E decodeDurationInHoconFormat(T tag) {
            return this.getValueFromTaggedConfig(tag, decodeDurationInHoconFormat.1.INSTANCE);
        }

        @NotNull
        protected String decodeTaggedString(T tag) {
            Object object;
            ConfigConverter this_$iv = this;
            boolean $i$f$validateAndCast = false;
            try {
                String string;
                object = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                }
                object = string;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin$iv, (String)"configOrigin");
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName() + '.');
            }
            return object;
        }

        protected boolean decodeTaggedBoolean(T tag) {
            Object object;
            ConfigConverter this_$iv = this;
            boolean $i$f$validateAndCast = false;
            try {
                Boolean bl;
                object = Reflection.getOrCreateKotlinClass(Boolean.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)e;
                }
                object = bl;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin$iv, (String)"configOrigin");
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(Boolean.class).getSimpleName() + '.');
            }
            return (Boolean)object;
        }

        protected byte decodeTaggedByte(T tag) {
            return this.getTaggedNumber(tag).byteValue();
        }

        protected short decodeTaggedShort(T tag) {
            return this.getTaggedNumber(tag).shortValue();
        }

        protected int decodeTaggedInt(T tag) {
            return this.getTaggedNumber(tag).intValue();
        }

        protected long decodeTaggedLong(T tag) {
            return this.getTaggedNumber(tag).longValue();
        }

        protected float decodeTaggedFloat(T tag) {
            return this.getTaggedNumber(tag).floatValue();
        }

        protected double decodeTaggedDouble(T tag) {
            return this.getTaggedNumber(tag).doubleValue();
        }

        protected char decodeTaggedChar(T tag) {
            Object object;
            ConfigConverter this_$iv = this;
            boolean $i$f$validateAndCast = false;
            try {
                String string;
                object = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                }
                object = string;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin$iv, (String)"configOrigin");
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName() + '.');
            }
            Object s = object;
            if (((String)s).length() != 1) {
                throw new SerializationException("String \"" + (String)s + "\" is not convertible to Char");
            }
            return ((String)s).charAt(0);
        }

        @NotNull
        protected Object decodeTaggedValue(T tag) {
            Object e = this.getValueFromTaggedConfig(tag, decodeTaggedValue.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(e, (String)"getValueFromTaggedConfig\u2026 c, s -> c.getAnyRef(s) }");
            return e;
        }

        protected boolean decodeTaggedNotNullMark(T tag) {
            return (Boolean)this.getValueFromTaggedConfig(tag, decodeTaggedNotNullMark.1.INSTANCE);
        }

        protected int decodeTaggedEnum(T tag, @NotNull SerialDescriptor enumDescriptor) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
            ConfigConverter this_$iv = this;
            boolean $i$f$validateAndCast = false;
            try {
                String string;
                object = Reflection.getOrCreateKotlinClass(String.class);
                if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Number.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.1.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.2.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else if (Intrinsics.areEqual((Object)object, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.3.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                } else {
                    Object e = this_$iv.getValueFromTaggedConfig(tag, validateAndCast.4.INSTANCE);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)e;
                }
                object = string;
            }
            catch (ConfigException e$iv) {
                ConfigOrigin configOrigin$iv = e$iv.origin();
                Intrinsics.checkNotNullExpressionValue((Object)configOrigin$iv, (String)"configOrigin");
                ConfigOrigin valueOrigin$iv$iv = configOrigin$iv;
                boolean $i$f$ConfigValueTypeCastException = false;
                throw new SerializationException(valueOrigin$iv$iv.description() + " required to be of type " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName() + '.');
            }
            Object s = object;
            return Hocon.this.getElementIndexOrThrow(enumDescriptor, (String)s);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J!\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J5\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u00130\u0016H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\u00020\u0002*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/hocon/Hocon$ListConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "list", "Lcom/typesafe/config/ConfigList;", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/ConfigList;)V", "ind", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeElementIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "Lcom/typesafe/config/Config;", "", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getTag", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Integer;", "kotlinx-serialization-hocon"})
    private final class ListConfigReader
    extends ConfigConverter<Integer> {
        @NotNull
        private final ConfigList list;
        private int ind;

        public ListConfigReader(ConfigList list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            this.list = list;
            this.ind = -1;
        }

        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return (T)(Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.serializer((Duration.Companion)Duration.Companion).getDescriptor()) ? this.decodeDurationInHoconFormat(this.ind) : super.decodeSerializableValue(deserializer));
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (HoconSerialKindKt.getListLike(descriptor.getKind())) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigList");
                compositeDecoder = (CompositeDecoder)new ListConfigReader((ConfigList)object);
            } else if (HoconSerialKindKt.getObjLike(descriptor.getKind())) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                Config config = ((ConfigObject)object).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"list[currentTag] as ConfigObject).toConfig()");
                compositeDecoder = (CompositeDecoder)new ConfigReader(config);
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                compositeDecoder = (CompositeDecoder)new MapConfigReader((ConfigObject)object);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        protected Integer getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            return index;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind > this.list.size() - 1 ? -1 : this.ind;
        }

        @Override
        public <E> E getValueFromTaggedConfig(int tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            String tagString = String.valueOf(tag);
            Config config = ((ConfigValue)this.list.get(tag)).atKey(tagString);
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"list[tag].atKey(tagString)");
            Object configValue = valueResolver.invoke((Object)config, (Object)tagString);
            return (E)configValue;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J5\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00190\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0019\u0010\u001f\u001a\u00020\u0002*\u00020\u00112\u0006\u0010 \u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkotlinx/serialization/hocon/Hocon$MapConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "map", "Lcom/typesafe/config/ConfigObject;", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/ConfigObject;)V", "ind", "indexSize", "keys", "", "", "values", "Lcom/typesafe/config/ConfigValue;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeElementIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "getValueFromTaggedConfig", "E", "tag", "valueResolver", "Lkotlin/Function2;", "Lcom/typesafe/config/Config;", "(ILkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getTag", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Integer;", "kotlinx-serialization-hocon"})
    @SourceDebugExtension(value={"SMAP\nHocon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$MapConfigReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1549#2:356\n1620#2,3:357\n1549#2:360\n1620#2,3:361\n*S KotlinDebug\n*F\n+ 1 Hocon.kt\nkotlinx/serialization/hocon/Hocon$MapConfigReader\n*L\n240#1:356\n240#1:357,3\n241#1:360\n241#1:361,3\n*E\n"})
    private final class MapConfigReader
    extends ConfigConverter<Integer> {
        private int ind;
        @NotNull
        private final List<String> keys;
        @NotNull
        private final List<ConfigValue> values;
        private final int indexSize;

        public MapConfigReader(ConfigObject map) {
            Map.Entry p0;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            this.ind = -1;
            List entries = CollectionsKt.toList((Iterable)map.entrySet());
            Iterable iterable = entries;
            MapConfigReader mapConfigReader = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)p0.getKey());
            }
            mapConfigReader.keys = (List)destination$iv$iv;
            $this$map$iv = entries;
            mapConfigReader = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ConfigValue)p0.getValue());
            }
            mapConfigReader.values = (List)destination$iv$iv;
            this.indexSize = this.values.size() * 2;
        }

        public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
            Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
            return (T)(Intrinsics.areEqual((Object)deserializer.getDescriptor(), (Object)BuiltinSerializersKt.serializer((Duration.Companion)Duration.Companion).getDescriptor()) ? this.decodeDurationInHoconFormat(this.ind) : super.decodeSerializableValue(deserializer));
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (HoconSerialKindKt.getListLike(descriptor.getKind())) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigList");
                compositeDecoder = (CompositeDecoder)new ListConfigReader((ConfigList)configValue);
            } else if (HoconSerialKindKt.getObjLike(descriptor.getKind())) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                Config config = ((ConfigObject)configValue).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"values[currentTag / 2] as ConfigObject).toConfig()");
                compositeDecoder = (CompositeDecoder)new ConfigReader(config);
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                Intrinsics.checkNotNull((Object)configValue, (String)"null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                compositeDecoder = (CompositeDecoder)new MapConfigReader((ConfigObject)configValue);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        protected Integer getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
            return index;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind >= this.indexSize ? -1 : this.ind;
        }

        @Override
        public <E> E getValueFromTaggedConfig(int tag, @NotNull Function2<? super Config, ? super String, ? extends E> valueResolver) {
            Config config;
            Intrinsics.checkNotNullParameter(valueResolver, (String)"valueResolver");
            int idx = tag / 2;
            String tagString = String.valueOf(tag);
            if (tag % 2 == 0) {
                config = ConfigValueFactory.fromAnyRef((Object)this.keys.get(idx)).atKey(tagString);
            } else {
                ConfigValue configValue = this.values.get(idx);
                config = configValue.atKey(tagString);
            }
            Config configValue = config;
            Intrinsics.checkNotNullExpressionValue((Object)configValue, (String)"configValue");
            return (E)valueResolver.invoke((Object)configValue, (Object)tagString);
        }
    }
}

