/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.hocon.Hocon;
import kotlinx.serialization.internal.TaggedDecoder;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleKt;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u001f2\u00020\u0001:\u0005\u001d\u001e\u001f !B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0003*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0003*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lkotlinx/serialization/hocon/Hocon;", "Lkotlinx/serialization/SerialFormat;", "useConfigNamingConvention", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(ZLkotlinx/serialization/modules/SerializersModule;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getUseConfigNamingConvention$kotlinx_serialization_hocon", "()Z", "listLike", "Lkotlinx/serialization/descriptors/SerialKind;", "getListLike", "(Lkotlinx/serialization/descriptors/SerialKind;)Z", "objLike", "getObjLike", "decodeFromConfig", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "config", "Lcom/typesafe/config/Config;", "(Lkotlinx/serialization/DeserializationStrategy;Lcom/typesafe/config/Config;)Ljava/lang/Object;", "getElementIndexOrThrow", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "name", "", "ConfigConverter", "ConfigReader", "Default", "ListConfigReader", "MapConfigReader", "Lkotlinx/serialization/hocon/HoconImpl;", "Lkotlinx/serialization/hocon/Hocon$Default;", "kotlinx-serialization-hocon"})
public abstract class Hocon
implements SerialFormat {
    private final boolean useConfigNamingConvention;
    @NotNull
    private final SerializersModule serializersModule;
    private static final Lazy NAMING_CONVENTION_REGEX$delegate;
    public static final Default Default;

    @ExperimentalSerializationApi
    public final <T> T decodeFromConfig(@NotNull DeserializationStrategy<T> deserializer, @NotNull Config config) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return (T)new ConfigReader(config).decodeSerializableValue(deserializer);
    }

    private final int getElementIndexOrThrow(SerialDescriptor $this$getElementIndexOrThrow, String name) {
        int index = $this$getElementIndexOrThrow.getElementIndex(name);
        if (index == -3) {
            throw (Throwable)new SerializationException($this$getElementIndexOrThrow.getSerialName() + " does not contain element with name '" + name + '\'');
        }
        return index;
    }

    private final boolean getListLike(SerialKind $this$listLike) {
        return Intrinsics.areEqual((Object)$this$listLike, (Object)StructureKind.LIST.INSTANCE) || $this$listLike instanceof PolymorphicKind;
    }

    private final boolean getObjLike(SerialKind $this$objLike) {
        return Intrinsics.areEqual((Object)$this$objLike, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)$this$objLike, (Object)StructureKind.OBJECT.INSTANCE);
    }

    public final boolean getUseConfigNamingConvention$kotlinx_serialization_hocon() {
        return this.useConfigNamingConvention;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private Hocon(boolean useConfigNamingConvention, SerializersModule serializersModule) {
        this.useConfigNamingConvention = useConfigNamingConvention;
        this.serializersModule = serializersModule;
    }

    static {
        Default = new Default(null);
        NAMING_CONVENTION_REGEX$delegate = LazyKt.lazy((Function0)Default.NAMING_CONVENTION_REGEX.2.INSTANCE);
    }

    public /* synthetic */ Hocon(boolean useConfigNamingConvention, SerializersModule serializersModule, DefaultConstructorMarker $constructor_marker) {
        this(useConfigNamingConvention, serializersModule);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00132\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010*J\u0015\u0010+\u001a\u00020,2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010-J\u0015\u0010.\u001a\u00020/2\u0006\u0010\n\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00100J*\u00101\u001a\u0002H2\"\n\b\u0001\u00102\u0018\u0001*\u00020)2\u0006\u0010\n\u001a\u00028\u00002\u0006\u00103\u001a\u000204H\u0082\b\u00a2\u0006\u0002\u00105R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00066"}, d2={"Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "T", "Lkotlinx/serialization/internal/TaggedDecoder;", "(Lkotlinx/serialization/hocon/Hocon;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeTaggedByte", "", "tag", "(Ljava/lang/Object;)B", "decodeTaggedChar", "", "(Ljava/lang/Object;)C", "decodeTaggedDouble", "", "(Ljava/lang/Object;)D", "decodeTaggedEnum", "", "enumDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Ljava/lang/Object;Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeTaggedFloat", "", "(Ljava/lang/Object;)F", "decodeTaggedInt", "(Ljava/lang/Object;)I", "decodeTaggedLong", "", "(Ljava/lang/Object;)J", "decodeTaggedNotNullMark", "", "(Ljava/lang/Object;)Z", "decodeTaggedShort", "", "(Ljava/lang/Object;)S", "decodeTaggedString", "", "(Ljava/lang/Object;)Ljava/lang/String;", "decodeTaggedValue", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "getTaggedConfigValue", "Lcom/typesafe/config/ConfigValue;", "(Ljava/lang/Object;)Lcom/typesafe/config/ConfigValue;", "getTaggedNumber", "", "(Ljava/lang/Object;)Ljava/lang/Number;", "validateAndCast", "E", "wrappedType", "Lcom/typesafe/config/ConfigValueType;", "(Ljava/lang/Object;Lcom/typesafe/config/ConfigValueType;)Ljava/lang/Object;", "kotlinx-serialization-hocon"})
    private abstract class ConfigConverter<T>
    extends TaggedDecoder<T> {
        @NotNull
        public SerializersModule getSerializersModule() {
            return Hocon.this.getSerializersModule();
        }

        @NotNull
        public abstract ConfigValue getTaggedConfigValue(T var1);

        private final /* synthetic */ <E> E validateAndCast(T tag, ConfigValueType wrappedType) {
            int $i$f$validateAndCast = 0;
            ConfigValue cfValue = this.getTaggedConfigValue(tag);
            if (cfValue.valueType() != wrappedType) {
                throw (Throwable)new SerializationException(cfValue.origin().description() + " required to be a " + wrappedType);
            }
            Object object = cfValue.unwrapped();
            Intrinsics.reifiedOperationMarker((int)1, (String)"E");
            return (E)object;
        }

        /*
         * WARNING - void declaration
         */
        private final Number getTaggedNumber(T tag) {
            void this_$iv;
            ConfigConverter configConverter = this;
            ConfigValueType wrappedType$iv = ConfigValueType.NUMBER;
            boolean $i$f$validateAndCast = false;
            ConfigValue cfValue$iv = this_$iv.getTaggedConfigValue(tag);
            if (cfValue$iv.valueType() != wrappedType$iv) {
                throw (Throwable)new SerializationException(cfValue$iv.origin().description() + " required to be a " + wrappedType$iv);
            }
            Object object = cfValue$iv.unwrapped();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            return (Number)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected String decodeTaggedString(T tag) {
            void this_$iv;
            ConfigConverter configConverter = this;
            ConfigValueType wrappedType$iv = ConfigValueType.STRING;
            boolean $i$f$validateAndCast = false;
            ConfigValue cfValue$iv = this_$iv.getTaggedConfigValue(tag);
            if (cfValue$iv.valueType() != wrappedType$iv) {
                throw (Throwable)new SerializationException(cfValue$iv.origin().description() + " required to be a " + wrappedType$iv);
            }
            Object object = cfValue$iv.unwrapped();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return (String)object;
        }

        protected byte decodeTaggedByte(T tag) {
            return this.getTaggedNumber(tag).byteValue();
        }

        protected short decodeTaggedShort(T tag) {
            return this.getTaggedNumber(tag).shortValue();
        }

        protected int decodeTaggedInt(T tag) {
            return this.getTaggedNumber(tag).intValue();
        }

        protected long decodeTaggedLong(T tag) {
            return this.getTaggedNumber(tag).longValue();
        }

        protected float decodeTaggedFloat(T tag) {
            return this.getTaggedNumber(tag).floatValue();
        }

        protected double decodeTaggedDouble(T tag) {
            return this.getTaggedNumber(tag).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        protected char decodeTaggedChar(T tag) {
            void this_$iv;
            ConfigConverter configConverter = this;
            ConfigValueType wrappedType$iv = ConfigValueType.STRING;
            boolean $i$f$validateAndCast = false;
            ConfigValue cfValue$iv = this_$iv.getTaggedConfigValue(tag);
            if (cfValue$iv.valueType() != wrappedType$iv) {
                throw (Throwable)new SerializationException(cfValue$iv.origin().description() + " required to be a " + wrappedType$iv);
            }
            Object object = cfValue$iv.unwrapped();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String s = (String)object;
            if (s.length() != 1) {
                throw (Throwable)new SerializationException("String \"" + s + "\" is not convertible to Char");
            }
            return s.charAt(0);
        }

        @NotNull
        protected Object decodeTaggedValue(T tag) {
            Object object = this.getTaggedConfigValue(tag).unwrapped();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTaggedConfigValue(tag).unwrapped()");
            return object;
        }

        protected boolean decodeTaggedNotNullMark(T tag) {
            return this.getTaggedConfigValue(tag).valueType() != ConfigValueType.NULL;
        }

        /*
         * WARNING - void declaration
         */
        protected int decodeTaggedEnum(T tag, @NotNull SerialDescriptor enumDescriptor) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
            ConfigConverter configConverter = this;
            ConfigValueType wrappedType$iv = ConfigValueType.STRING;
            boolean $i$f$validateAndCast = false;
            ConfigValue cfValue$iv = this_$iv.getTaggedConfigValue(tag);
            if (cfValue$iv.valueType() != wrappedType$iv) {
                throw (Throwable)new SerializationException(cfValue$iv.origin().description() + " required to be a " + wrappedType$iv);
            }
            Object object = cfValue$iv.unwrapped();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String s = (String)object;
            return Hocon.this.getElementIndexOrThrow(enumDescriptor, s);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0014\u0010\u0019\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0014\u0010\u001b\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\nH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lkotlinx/serialization/hocon/Hocon$ConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "conf", "Lcom/typesafe/config/Config;", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/Config;)V", "getConf", "()Lcom/typesafe/config/Config;", "ind", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "composeName", "parentName", "childName", "decodeElementIndex", "decodeNotNullMark", "", "decodeTaggedNotNullMark", "tag", "getTaggedConfigValue", "Lcom/typesafe/config/ConfigValue;", "getConventionElementName", "index", "getTag", "kotlinx-serialization-hocon"})
    private final class ConfigReader
    extends ConfigConverter<String> {
        private int ind;
        @NotNull
        private final Config conf;

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            block1: {
                String name;
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                do {
                    ConfigReader configReader = this;
                    ++configReader.ind;
                    if (configReader.ind >= descriptor.getElementsCount()) break block1;
                } while (!this.conf.hasPathOrNull(name = this.getTag(descriptor, this.ind)));
                return this.ind;
            }
            return -1;
        }

        private final String composeName(String parentName, String childName) {
            CharSequence charSequence = parentName;
            boolean bl = false;
            return charSequence.length() == 0 ? childName : parentName + '.' + childName;
        }

        @NotNull
        protected String getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            String string = (String)this.getCurrentTagOrNull();
            if (string == null) {
                string = "";
            }
            return this.composeName(string, this.getConventionElementName($this$getTag, index));
        }

        private final String getConventionElementName(SerialDescriptor $this$getConventionElementName, int index) {
            String string;
            String originalName = $this$getConventionElementName.getElementName(index);
            if (!Hocon.this.getUseConfigNamingConvention$kotlinx_serialization_hocon()) {
                string = originalName;
            } else {
                CharSequence charSequence = originalName;
                Regex regex = Default.getNAMING_CONVENTION_REGEX();
                Function1 function1 = getConventionElementName.1.INSTANCE;
                boolean bl = false;
                string = regex.replace(charSequence, function1);
            }
            return string;
        }

        @Override
        @NotNull
        public ConfigValue getTaggedConfigValue(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            ConfigValue configValue = this.conf.getValue(tag);
            Intrinsics.checkNotNullExpressionValue((Object)configValue, (String)"conf.getValue(tag)");
            return configValue;
        }

        @Override
        protected boolean decodeTaggedNotNullMark(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return !this.conf.getIsNull(tag);
        }

        public boolean decodeNotNullMark() {
            String string = (String)this.getCurrentTagOrNull();
            if (string == null) {
                return !this.conf.isEmpty();
            }
            String currentTag = string;
            return this.decodeTaggedNotNullMark(currentTag);
        }

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (Hocon.this.getListLike(descriptor.getKind())) {
                ConfigList configList = this.conf.getList((String)this.getCurrentTag());
                Intrinsics.checkNotNullExpressionValue((Object)configList, (String)"conf.getList(currentTag)");
                compositeDecoder = (CompositeDecoder)new ListConfigReader(configList);
            } else if (Hocon.this.getObjLike(descriptor.getKind())) {
                ConfigReader configReader;
                if (this.ind > -1) {
                    Config config = this.conf.getConfig((String)this.getCurrentTag());
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"conf.getConfig(currentTag)");
                    configReader = new ConfigReader(config);
                } else {
                    configReader = this;
                }
                compositeDecoder = (CompositeDecoder)configReader;
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                ConfigObject configObject = this.conf.getObject((String)this.getCurrentTag());
                Intrinsics.checkNotNullExpressionValue((Object)configObject, (String)"conf.getObject(currentTag)");
                compositeDecoder = (CompositeDecoder)new MapConfigReader(configObject);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        public final Config getConf() {
            return this.conf;
        }

        public ConfigReader(Config conf) {
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            this.conf = conf;
            this.ind = -1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0019\u0010\u0010\u001a\u00020\u0002*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkotlinx/serialization/hocon/Hocon$ListConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "list", "Lcom/typesafe/config/ConfigList;", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/ConfigList;)V", "ind", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeElementIndex", "getTaggedConfigValue", "Lcom/typesafe/config/ConfigValue;", "tag", "getTag", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Integer;", "kotlinx-serialization-hocon"})
    private final class ListConfigReader
    extends ConfigConverter<Integer> {
        private int ind;
        private final ConfigList list;

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (Hocon.this.getListLike(descriptor.getKind())) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.typesafe.config.ConfigList");
                }
                compositeDecoder = (CompositeDecoder)new ListConfigReader((ConfigList)object);
            } else if (Hocon.this.getObjLike(descriptor.getKind())) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                }
                Config config = ((ConfigObject)object).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"(list[currentTag] as ConfigObject).toConfig()");
                compositeDecoder = (CompositeDecoder)new ConfigReader(config);
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                Object object = this.list.get(((Number)this.getCurrentTag()).intValue());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                }
                compositeDecoder = (CompositeDecoder)new MapConfigReader((ConfigObject)object);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        protected Integer getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return index;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind > this.list.size() - 1 ? -1 : this.ind;
        }

        @Override
        @NotNull
        public ConfigValue getTaggedConfigValue(int tag) {
            Object object = this.list.get(tag);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"list[tag]");
            return (ConfigValue)object;
        }

        public ListConfigReader(ConfigList list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            this.list = list;
            this.ind = -1;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0019\u0010\u0015\u001a\u00020\u0002*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkotlinx/serialization/hocon/Hocon$MapConfigReader;", "Lkotlinx/serialization/hocon/Hocon$ConfigConverter;", "", "Lkotlinx/serialization/hocon/Hocon;", "map", "Lcom/typesafe/config/ConfigObject;", "(Lkotlinx/serialization/hocon/Hocon;Lcom/typesafe/config/ConfigObject;)V", "ind", "indexSize", "keys", "", "", "values", "Lcom/typesafe/config/ConfigValue;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeElementIndex", "getTaggedConfigValue", "tag", "getTag", "index", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Ljava/lang/Integer;", "kotlinx-serialization-hocon"})
    private final class MapConfigReader
    extends ConfigConverter<Integer> {
        private int ind;
        private final List<String> keys;
        private final List<ConfigValue> values;
        private final int indexSize;

        @NotNull
        public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
            CompositeDecoder compositeDecoder;
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (Hocon.this.getListLike(descriptor.getKind())) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                if (configValue == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.typesafe.config.ConfigList");
                }
                compositeDecoder = (CompositeDecoder)new ListConfigReader((ConfigList)configValue);
            } else if (Hocon.this.getObjLike(descriptor.getKind())) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                if (configValue == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                }
                Config config = ((ConfigObject)configValue).toConfig();
                Intrinsics.checkNotNullExpressionValue((Object)config, (String)"(values[currentTag / 2] \u2026 ConfigObject).toConfig()");
                compositeDecoder = (CompositeDecoder)new ConfigReader(config);
            } else if (Intrinsics.areEqual((Object)descriptor.getKind(), (Object)StructureKind.MAP.INSTANCE)) {
                ConfigValue configValue = this.values.get(((Number)this.getCurrentTag()).intValue() / 2);
                if (configValue == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.typesafe.config.ConfigObject");
                }
                compositeDecoder = (CompositeDecoder)new MapConfigReader((ConfigObject)configValue);
            } else {
                compositeDecoder = (CompositeDecoder)this;
            }
            return compositeDecoder;
        }

        @NotNull
        protected Integer getTag(@NotNull SerialDescriptor $this$getTag, int index) {
            Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"$this$getTag");
            return index;
        }

        public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            int n = this.ind;
            this.ind = n + 1;
            return this.ind >= this.indexSize ? -1 : this.ind;
        }

        @Override
        @NotNull
        public ConfigValue getTaggedConfigValue(int tag) {
            ConfigValue configValue;
            int idx = tag / 2;
            if (tag % 2 == 0) {
                ConfigValue configValue2 = ConfigValueFactory.fromAnyRef((Object)this.keys.get(idx));
                configValue = configValue2;
                Intrinsics.checkNotNullExpressionValue((Object)configValue2, (String)"ConfigValueFactory.fromAnyRef(keys[idx])");
            } else {
                configValue = this.values.get(idx);
            }
            return configValue;
        }

        public MapConfigReader(ConfigObject map) {
            Object object;
            Object receiver;
            boolean bl;
            Collection collection;
            Object item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)map, (String)"map");
            this.ind = -1;
            List entries = CollectionsKt.toList((Iterable)map.entrySet());
            Iterable iterable = entries;
            MapConfigReader mapConfigReader = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                bl = false;
                object = ((Map.Entry)receiver).getKey();
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            mapConfigReader.keys = collection;
            $this$map$iv = entries;
            mapConfigReader = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                receiver = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                bl = false;
                object = ((Map.Entry)receiver).getValue();
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            mapConfigReader.values = collection;
            this.indexSize = this.values.size() * 2;
        }
    }

    @ExperimentalSerializationApi
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lkotlinx/serialization/hocon/Hocon$Default;", "Lkotlinx/serialization/hocon/Hocon;", "()V", "NAMING_CONVENTION_REGEX", "Lkotlin/text/Regex;", "getNAMING_CONVENTION_REGEX", "()Lkotlin/text/Regex;", "NAMING_CONVENTION_REGEX$delegate", "Lkotlin/Lazy;", "kotlinx-serialization-hocon"})
    public static final class Default
    extends Hocon {
        private final Regex getNAMING_CONVENTION_REGEX() {
            Lazy lazy = NAMING_CONVENTION_REGEX$delegate;
            Default default_ = Default;
            Object var3_3 = null;
            boolean bl = false;
            return (Regex)lazy.getValue();
        }

        private Default() {
            super(false, SerializersModuleKt.getEmptySerializersModule(), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

