/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001d\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u001dJ-\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0014H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0006\u0010$\u001a\u00020\u000fJ\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006'"}, d2={"Lkotlinx/serialization/cbor/internal/CborEncoder;", "", "output", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "composeNegative", "", "value", "", "composeNumber", "composePositive", "Lkotlin/ULong;", "composePositive-VKZWuLQ", "(J)[B", "encodeBoolean", "", "", "encodeByteArray", "data", "type", "", "encodeByteString", "encodeDouble", "", "encodeFloat", "", "encodeNull", "encodeNumber", "encodeString", "", "encodeToByteArray", "bytes", "", "tag", "encodeToByteArray-E0BElUM", "(JIB)[B", "end", "startArray", "startMap", "kotlinx-serialization-cbor"})
public final class CborEncoder {
    @NotNull
    private final ByteArrayOutput output;

    public CborEncoder(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
    }

    public final void startArray() {
        this.output.write(159);
    }

    public final void startMap() {
        this.output.write(191);
    }

    public final void end() {
        this.output.write(255);
    }

    public final void encodeNull() {
        this.output.write(246);
    }

    public final void encodeBoolean(boolean value) {
        this.output.write(value ? 245 : 244);
    }

    public final void encodeNumber(long value) {
        ByteArrayOutput.write$default(this.output, this.composeNumber(value), 0, 0, 6, null);
    }

    public final void encodeByteString(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.encodeByteArray(data, (byte)64);
    }

    public final void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeByteArray(StringsKt.encodeToByteArray((String)value), (byte)96);
    }

    private final void encodeByteArray(byte[] data, byte type) {
        byte[] header = this.composeNumber(data.length);
        byte by = header[0];
        boolean bl = false;
        header[0] = (byte)(by | type);
        ByteArrayOutput.write$default(this.output, header, 0, 0, 6, null);
        ByteArrayOutput.write$default(this.output, data, 0, 0, 6, null);
    }

    public final void encodeFloat(float value) {
        this.output.write(250);
        float f = value;
        boolean bl = false;
        int bits = Float.floatToRawIntBits(f);
        int n = 0;
        do {
            int i = n++;
            this.output.write(bits >> 24 - 8 * i & 0xFF);
        } while (n <= 3);
    }

    public final void encodeDouble(double value) {
        this.output.write(251);
        double d = value;
        boolean bl = false;
        long bits = Double.doubleToRawLongBits(d);
        int n = 0;
        do {
            int i = n++;
            this.output.write((int)(bits >> 56 - 8 * i & 0xFFL));
        } while (n <= 7);
    }

    private final byte[] composeNumber(long value) {
        byte[] byArray;
        if (value >= 0L) {
            long l = value;
            boolean bl = false;
            byArray = this.composePositive-VKZWuLQ(ULong.constructor-impl((long)l));
        } else {
            byArray = this.composeNegative(value);
        }
        return byArray;
    }

    private final byte[] composePositive-VKZWuLQ(long value) {
        byte[] byArray;
        boolean bl;
        long l = value;
        int n = 0;
        int n2 = 0;
        long l2 = ULong.constructor-impl((long)((long)n & 0xFFFFFFFFL));
        int n3 = 0;
        if (0 <= UnsignedKt.ulongCompare((long)l, (long)l2)) {
            int n4 = 23;
            n2 = 0;
            l2 = ULong.constructor-impl((long)((long)n4 & 0xFFFFFFFFL));
            n3 = 0;
            bl = UnsignedKt.ulongCompare((long)l, (long)l2) <= 0;
        } else {
            bl = false;
        }
        if (bl) {
            byte[] byArray2 = new byte[1];
            n2 = 0;
            byArray2[0] = (byte)value;
            byArray = byArray2;
        } else {
            boolean bl2;
            int n5 = 24;
            n2 = 0;
            long l3 = ULong.constructor-impl((long)((long)n5 & 0xFFFFFFFFL));
            n3 = 0;
            if (0 <= UnsignedKt.ulongCompare((long)l, (long)l3)) {
                int n6 = -1;
                n2 = 0;
                n6 = UInt.constructor-impl((int)(n6 & 0xFF));
                n2 = 0;
                l3 = ULong.constructor-impl((long)((long)n6 & 0xFFFFFFFFL));
                n3 = 0;
                bl2 = UnsignedKt.ulongCompare((long)l, (long)l3) <= 0;
            } else {
                bl2 = false;
            }
            if (bl2) {
                byte[] byArray3 = new byte[2];
                byArray3[0] = 24;
                n2 = 0;
                byArray3[1] = (byte)value;
                byArray = byArray3;
            } else {
                boolean bl3;
                n2 = -1;
                n3 = 0;
                n2 = UInt.constructor-impl((int)(n2 & 0xFF));
                n3 = 1;
                boolean bl4 = false;
                int n7 = UInt.constructor-impl((int)(n2 + n3));
                n2 = -1;
                n3 = 0;
                n2 = UInt.constructor-impl((int)(n2 & 0xFFFF));
                n3 = 0;
                long l4 = ULong.constructor-impl((long)((long)n2 & 0xFFFFFFFFL));
                bl4 = false;
                if (UnsignedKt.ulongCompare((long)l, (long)l4) <= 0) {
                    boolean bl5 = false;
                    l4 = ULong.constructor-impl((long)((long)n7 & 0xFFFFFFFFL));
                    bl4 = false;
                    bl3 = 0 <= UnsignedKt.ulongCompare((long)l, (long)l4);
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    byArray = this.encodeToByteArray-E0BElUM(value, 2, (byte)25);
                } else {
                    boolean bl6;
                    n7 = -1;
                    int n8 = 0;
                    n7 = UInt.constructor-impl((int)(n7 & 0xFFFF));
                    n8 = 1;
                    n3 = 0;
                    n7 = UInt.constructor-impl((int)(n7 + n8));
                    n8 = 0;
                    long l5 = ULong.constructor-impl((long)((long)n7 & 0xFFFFFFFFL));
                    n3 = 0;
                    if (0 <= UnsignedKt.ulongCompare((long)l, (long)l5)) {
                        int n9 = -1;
                        n8 = 0;
                        long l6 = ULong.constructor-impl((long)((long)n9 & 0xFFFFFFFFL));
                        n3 = 0;
                        bl6 = UnsignedKt.ulongCompare((long)l, (long)l6) <= 0;
                    } else {
                        bl6 = false;
                    }
                    byArray = bl6 ? this.encodeToByteArray-E0BElUM(value, 4, (byte)26) : this.encodeToByteArray-E0BElUM(value, 8, (byte)27);
                }
            }
        }
        return byArray;
    }

    private final byte[] encodeToByteArray-E0BElUM(long value, int bytes, byte tag) {
        byte[] result = new byte[bytes + 1];
        int limit = bytes * 8 - 8;
        result[0] = tag;
        int n = 0;
        if (n < bytes) {
            do {
                int i = n++;
                int n2 = limit - 8 * i;
                boolean bl = false;
                long l = ULong.constructor-impl((long)(value >>> n2));
                long l2 = 255L;
                boolean bl2 = false;
                l = ULong.constructor-impl((long)(l & l2));
                boolean bl3 = false;
                result[i + 1] = (byte)l;
            } while (n < bytes);
        }
        return result;
    }

    private final byte[] composeNegative(long value) {
        long aVal;
        long l = aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
        boolean bl = false;
        byte[] data = this.composePositive-VKZWuLQ(ULong.constructor-impl((long)l));
        byte by = data[0];
        int n = 32;
        bl = false;
        data[0] = (byte)(by | n);
        return data;
    }
}

