/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\fJ\u0006\u0010!\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lkotlinx/serialization/cbor/internal/CborEncoder;", "", "output", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "composeNegative", "", "value", "", "composeNumber", "composePositive", "encodeBoolean", "", "", "encodeByteArray", "data", "type", "", "encodeByteString", "encodeDouble", "", "encodeFloat", "", "encodeNull", "encodeNumber", "encodeString", "", "encodeToByteArray", "bytes", "", "tag", "end", "startArray", "startMap", "kotlinx-serialization-cbor"})
public final class CborEncoder {
    @NotNull
    private final ByteArrayOutput output;

    public CborEncoder(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
    }

    public final void startArray() {
        this.output.write(159);
    }

    public final void startMap() {
        this.output.write(191);
    }

    public final void end() {
        this.output.write(255);
    }

    public final void encodeNull() {
        this.output.write(246);
    }

    public final void encodeBoolean(boolean value) {
        this.output.write(value ? 245 : 244);
    }

    public final void encodeNumber(long value) {
        ByteArrayOutput.write$default(this.output, this.composeNumber(value), 0, 0, 6, null);
    }

    public final void encodeByteString(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.encodeByteArray(data, (byte)64);
    }

    public final void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeByteArray(StringsKt.encodeToByteArray((String)value), (byte)96);
    }

    private final void encodeByteArray(byte[] data, byte type) {
        byte[] header = this.composeNumber(data.length);
        byte by = header[0];
        boolean bl = false;
        header[0] = (byte)(by | type);
        ByteArrayOutput.write$default(this.output, header, 0, 0, 6, null);
        ByteArrayOutput.write$default(this.output, data, 0, 0, 6, null);
    }

    public final void encodeFloat(float value) {
        this.output.write(250);
        float f = value;
        boolean bl = false;
        int bits = Float.floatToRawIntBits(f);
        int n = 0;
        do {
            int i = n++;
            this.output.write(bits >> 24 - 8 * i & 0xFF);
        } while (n <= 3);
    }

    public final void encodeDouble(double value) {
        this.output.write(251);
        double d = value;
        boolean bl = false;
        long bits = Double.doubleToRawLongBits(d);
        int n = 0;
        do {
            int i = n++;
            this.output.write((int)(bits >> 56 - 8 * i & 0xFFL));
        } while (n <= 7);
    }

    private final byte[] composeNumber(long value) {
        return value >= 0L ? this.composePositive(value) : this.composeNegative(value);
    }

    private final byte[] composePositive(long value) {
        byte[] byArray;
        long l = value;
        boolean bl = 0L <= l ? l <= 23L : false;
        if (bl) {
            byte[] byArray2 = new byte[]{(byte)value};
            byArray = byArray2;
        } else {
            boolean bl2 = 24L <= l ? l <= 127L : false;
            if (bl2) {
                byte[] byArray3 = new byte[]{24, (byte)value};
                byArray = byArray3;
            } else {
                boolean bl3 = 128L <= l ? l <= 32767L : false;
                if (bl3) {
                    byArray = this.encodeToByteArray(value, 2, (byte)25);
                } else {
                    boolean bl4 = 32768L <= l ? l <= Integer.MAX_VALUE : false;
                    if (bl4) {
                        byArray = this.encodeToByteArray(value, 4, (byte)26);
                    } else {
                        boolean bl5 = 0x80000000L <= l ? l <= Long.MAX_VALUE : false;
                        if (bl5) {
                            byArray = this.encodeToByteArray(value, 8, (byte)27);
                        } else {
                            throw new AssertionError((Object)(value + " should be positive"));
                        }
                    }
                }
            }
        }
        return byArray;
    }

    private final byte[] encodeToByteArray(long value, int bytes, byte tag) {
        byte[] result = new byte[bytes + 1];
        int limit = bytes * 8 - 8;
        result[0] = tag;
        int n = 0;
        if (n < bytes) {
            do {
                int i = n++;
                result[i + 1] = (byte)(value >> limit - 8 * i & 0xFFL);
            } while (n < bytes);
        }
        return result;
    }

    private final byte[] composeNegative(long value) {
        long aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
        byte[] data = this.composePositive(aVal);
        byte by = data[0];
        int n = 32;
        boolean bl = false;
        data[0] = (byte)(by | n);
        return data;
    }
}

