/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.cbor.Cbor;
import kotlinx.serialization.cbor.internal.CborDecoder;
import kotlinx.serialization.cbor.internal.CborListReader;
import kotlinx.serialization.cbor.internal.CborMapReader;
import kotlinx.serialization.cbor.internal.EncodingKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001aH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u000fH\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\nH\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00103\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u000fH\u0004J\b\u00104\u001a\u000202H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u000f@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"Lkotlinx/serialization/cbor/internal/CborReader;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "cbor", "Lkotlinx/serialization/cbor/Cbor;", "decoder", "Lkotlinx/serialization/cbor/internal/CborDecoder;", "(Lkotlinx/serialization/cbor/Cbor;Lkotlinx/serialization/cbor/internal/CborDecoder;)V", "getDecoder", "()Lkotlinx/serialization/cbor/internal/CborDecoder;", "<set-?>", "", "finiteMode", "getFiniteMode", "()Z", "readProperties", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "size", "getSize", "()I", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeNotNullMark", "decodeNull", "", "decodeShort", "", "decodeString", "", "endStructure", "", "setSize", "skipBeginToken", "kotlinx-serialization-cbor"})
public class CborReader
extends AbstractDecoder {
    private int size;
    private boolean finiteMode;
    private int readProperties;
    private final Cbor cbor;
    @NotNull
    private final CborDecoder decoder;

    protected final int getSize() {
        return this.size;
    }

    protected final boolean getFiniteMode() {
        return this.finiteMode;
    }

    protected final void setSize(int size) {
        if (size >= 0) {
            this.finiteMode = true;
            this.size = size;
        }
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.cbor.getSerializersModule();
    }

    protected void skipBeginToken() {
        this.setSize(this.decoder.startMap());
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        CborReader re = Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) || serialKind instanceof PolymorphicKind ? (CborReader)new CborListReader(this.cbor, this.decoder) : (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? (CborReader)new CborMapReader(this.cbor, this.decoder) : new CborReader(this.cbor, this.decoder));
        re.skipBeginToken();
        return (CompositeDecoder)re;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.finiteMode) {
            this.decoder.end();
        }
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.finiteMode && this.decoder.isEnd() || this.finiteMode && this.readProperties >= this.size) {
            return -1;
        }
        String elemName = this.decoder.nextString();
        int n = this.readProperties;
        this.readProperties = n + 1;
        return EncodingKt.access$getElementIndexOrThrow(descriptor, elemName);
    }

    @NotNull
    public String decodeString() {
        return this.decoder.nextString();
    }

    public boolean decodeNotNullMark() {
        return !this.decoder.isNull();
    }

    public double decodeDouble() {
        return this.decoder.nextDouble();
    }

    public float decodeFloat() {
        return this.decoder.nextFloat();
    }

    public boolean decodeBoolean() {
        return this.decoder.nextBoolean();
    }

    public byte decodeByte() {
        return (byte)this.decoder.nextNumber();
    }

    public short decodeShort() {
        return (short)this.decoder.nextNumber();
    }

    public char decodeChar() {
        return (char)this.decoder.nextNumber();
    }

    public int decodeInt() {
        return (int)this.decoder.nextNumber();
    }

    public long decodeLong() {
        return this.decoder.nextNumber();
    }

    @Nullable
    public Void decodeNull() {
        return this.decoder.nextNull();
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return EncodingKt.access$getElementIndexOrThrow(enumDescriptor, this.decoder.nextString());
    }

    @NotNull
    protected final CborDecoder getDecoder() {
        return this.decoder;
    }

    public CborReader(@NotNull Cbor cbor, @NotNull CborDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)cbor, (String)"cbor");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        this.cbor = cbor;
        this.decoder = decoder;
        this.size = -1;
    }
}

