/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lkotlinx/serialization/cbor/internal/CborEncoder;", "", "output", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "composeNegative", "", "value", "", "composeNumber", "composePositive", "encodeBoolean", "", "", "encodeDouble", "", "encodeFloat", "", "encodeNull", "encodeNumber", "encodeString", "", "encodeToByteArray", "bytes", "", "tag", "", "end", "startArray", "startMap", "kotlinx-serialization-cbor"})
public final class CborEncoder {
    private final ByteArrayOutput output;

    public final void startArray() {
        this.output.write(159);
    }

    public final void startMap() {
        this.output.write(191);
    }

    public final void end() {
        this.output.write(255);
    }

    public final void encodeNull() {
        this.output.write(246);
    }

    public final void encodeBoolean(boolean value) {
        this.output.write(value ? 245 : 244);
    }

    public final void encodeNumber(long value) {
        ByteArrayOutput.write$default(this.output, this.composeNumber(value), 0, 0, 6, null);
    }

    public final void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] data = StringsKt.encodeToByteArray((String)value);
        byte[] header = this.composeNumber(data.length);
        byte by = header[0];
        int n = 96;
        boolean bl = false;
        header[0] = (byte)(by | n);
        ByteArrayOutput.write$default(this.output, header, 0, 0, 6, null);
        ByteArrayOutput.write$default(this.output, data, 0, 0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeFloat(float value) {
        this.output.write(250);
        float f = value;
        int n = 0;
        int bits = Float.floatToRawIntBits(f);
        int n2 = 0;
        n = 3;
        while (n2 <= n) {
            void i;
            this.output.write(bits >> 24 - 8 * i & 0xFF);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void encodeDouble(double value) {
        this.output.write(251);
        double d = value;
        boolean bl = false;
        long bits = Double.doubleToRawLongBits(d);
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void i;
            this.output.write((int)(bits >> 56 - 8 * i & 0xFFL));
            ++i;
        }
    }

    private final byte[] composeNumber(long value) {
        return value >= 0L ? this.composePositive(value) : this.composeNegative(value);
    }

    private final byte[] composePositive(long value) {
        byte[] byArray;
        long l = value;
        long l2 = l;
        if (0L <= l2 && (long)23 >= l2) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = (byte)value;
        } else {
            l2 = l;
            if ((long)24 <= l2 && (long)127 >= l2) {
                byte[] byArray3 = new byte[2];
                byArray3[0] = 24;
                byArray = byArray3;
                byArray3[1] = (byte)value;
            } else {
                l2 = l;
                if ((long)128 <= l2 && (long)Short.MAX_VALUE >= l2) {
                    byArray = this.encodeToByteArray(value, 2, (byte)25);
                } else {
                    l2 = l;
                    if ((long)32768 <= l2 && (long)Integer.MAX_VALUE >= l2) {
                        byArray = this.encodeToByteArray(value, 4, (byte)26);
                    } else {
                        l2 = l;
                        if (0x80000000L <= l2 && Long.MAX_VALUE >= l2) {
                            byArray = this.encodeToByteArray(value, 8, (byte)27);
                        } else {
                            throw (Throwable)((Object)new AssertionError((Object)(value + " should be positive")));
                        }
                    }
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] encodeToByteArray(long value, int bytes, byte tag) {
        byte[] result = new byte[bytes + 1];
        int limit = bytes * 8 - 8;
        result[0] = tag;
        int n = 0;
        int n2 = bytes;
        while (n < n2) {
            void i;
            result[i + true] = (byte)(value >> limit - 8 * i & 0xFFL);
            ++i;
        }
        return result;
    }

    private final byte[] composeNegative(long value) {
        long aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
        byte[] data = this.composePositive(aVal);
        byte by = data[0];
        int n = 32;
        boolean bl = false;
        data[0] = (byte)(by | n);
        return data;
    }

    public CborEncoder(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
    }
}

