/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayInput;
import kotlinx.serialization.cbor.internal.CborDecodingException;
import kotlinx.serialization.cbor.internal.CborDecodingExceptionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0006H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u0006J \u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0014\u0010#\u001a\u00020\u0014*\u00020\u00032\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0014\u0010%\u001a\u00020&*\u00020\u00032\u0006\u0010'\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkotlinx/serialization/cbor/internal/CborDecoder;", "", "input", "Lkotlinx/serialization/cbor/internal/ByteArrayInput;", "(Lkotlinx/serialization/cbor/internal/ByteArrayInput;)V", "curByte", "", "end", "", "isEnd", "", "isNull", "nextBoolean", "nextDouble", "", "nextFloat", "", "nextNull", "", "nextNumber", "", "nextString", "", "readByte", "readInt", "readLong", "readNumber", "skipByte", "expected", "startArray", "startMap", "startSized", "unboundedHeader", "boundedHeaderMask", "collectionType", "readExact", "bytes", "readExactNBytes", "", "bytesCount", "kotlinx-serialization-cbor"})
public final class CborDecoder {
    private int curByte;
    private final ByteArrayInput input;

    private final int readByte() {
        this.curByte = this.input.read();
        return this.curByte;
    }

    private final void skipByte(int expected) {
        if (this.curByte != expected) {
            throw (Throwable)((Object)new CborDecodingException("byte " + CborDecodingExceptionKt.printByte(expected), this.curByte));
        }
        this.readByte();
    }

    public final boolean isNull() {
        return this.curByte == 246;
    }

    @Nullable
    public final Void nextNull() {
        this.skipByte(246);
        return null;
    }

    public final boolean nextBoolean() {
        boolean bl;
        switch (this.curByte) {
            case 245: {
                bl = true;
                break;
            }
            case 244: {
                bl = false;
                break;
            }
            default: {
                throw (Throwable)((Object)new CborDecodingException("boolean value", this.curByte));
            }
        }
        boolean ans = bl;
        this.readByte();
        return ans;
    }

    public final int startArray() {
        return this.startSized(159, 128, "array");
    }

    public final int startMap() {
        return this.startSized(191, 160, "map");
    }

    private final int startSized(int unboundedHeader, int boundedHeaderMask, String collectionType) {
        if (this.curByte == unboundedHeader) {
            this.skipByte(unboundedHeader);
            return -1;
        }
        if ((this.curByte & 0xE0) != boundedHeaderMask) {
            throw (Throwable)((Object)new CborDecodingException("start of " + collectionType, this.curByte));
        }
        int size = (int)this.readNumber();
        this.readByte();
        return size;
    }

    public final boolean isEnd() {
        return this.curByte == 255;
    }

    public final void end() {
        this.skipByte(255);
    }

    @NotNull
    public final String nextString() {
        if ((this.curByte & 0xE0) != 96) {
            throw (Throwable)((Object)new CborDecodingException("start of string", this.curByte));
        }
        int strLen = (int)this.readNumber();
        byte[] arr = this.readExactNBytes(this.input, strLen);
        String ans = StringsKt.decodeToString((byte[])arr);
        this.readByte();
        return ans;
    }

    public final long nextNumber() {
        long res = this.readNumber();
        this.readByte();
        return res;
    }

    private final long readNumber() {
        int bytesToRead;
        int value = this.curByte & 0x1F;
        boolean negative = (this.curByte & 0xE0) == 32;
        switch (value) {
            case 24: {
                int n = 1;
                break;
            }
            case 25: {
                int n = 2;
                break;
            }
            case 26: {
                int n = 4;
                break;
            }
            case 27: {
                int n = 8;
                break;
            }
            default: {
                int n = bytesToRead = 0;
            }
        }
        if (bytesToRead == 0) {
            return negative ? -((long)(value + 1)) : (long)value;
        }
        long res = this.readExact(this.input, bytesToRead);
        return negative ? -(res + 1L) : res;
    }

    /*
     * WARNING - void declaration
     */
    private final long readExact(ByteArrayInput $this$readExact, int bytes) {
        byte[] arr = this.readExactNBytes($this$readExact, bytes);
        long result = 0L;
        int n = 0;
        int n2 = bytes;
        while (n < n2) {
            void i;
            result = result << 8 | (long)(arr[i] & 0xFF);
            ++i;
        }
        return result;
    }

    private final byte[] readExactNBytes(ByteArrayInput $this$readExactNBytes, int bytesCount) {
        if (bytesCount > $this$readExactNBytes.getAvailableBytes()) {
            String string = "Unexpected EOF, available " + $this$readExactNBytes.getAvailableBytes() + " bytes, requested: " + bytesCount;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] array = new byte[bytesCount];
        $this$readExactNBytes.read(array, 0, bytesCount);
        return array;
    }

    public final float nextFloat() {
        if (this.curByte != 250) {
            throw (Throwable)((Object)new CborDecodingException("float header", this.curByte));
        }
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = this.readInt();
        boolean bl = false;
        float res = Float.intBitsToFloat(n);
        this.readByte();
        return res;
    }

    public final double nextDouble() {
        if (this.curByte != 251) {
            throw (Throwable)((Object)new CborDecodingException("double header", this.curByte));
        }
        DoubleCompanionObject doubleCompanionObject = DoubleCompanionObject.INSTANCE;
        long l = this.readLong();
        boolean bl = false;
        double res = Double.longBitsToDouble(l);
        this.readByte();
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private final long readLong() {
        long result = 0L;
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void i;
            int n3 = this.input.read();
            result = result << 8 | (long)n3;
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final int readInt() {
        int result = 0;
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            int n3 = this.input.read();
            result = result << 8 | n3;
            ++i;
        }
        return result;
    }

    public CborDecoder(@NotNull ByteArrayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.curByte = -1;
        this.readByte();
    }
}

