(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'.");
    }
    if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'.");
    }
    root['kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'] = factory(typeof this['kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'] === 'undefined' ? {} : this['kotlinx-serialization-kotlinx-serialization-cbor-js-legacy'], kotlin, this['kotlinx-serialization-kotlinx-serialization-core-js-legacy']);
  }
}(this, function (_, Kotlin, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy) {
  'use strict';
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Annotation = Kotlin.kotlin.Annotation;
  var EmptySerializersModule = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.modules.EmptySerializersModule;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var BinaryFormat = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.BinaryFormat;
  var SerializationException_init = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.SerializationException_init_pdl1vj$;
  var SerializationException = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.SerializationException;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var ByteArraySerializer = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.builtins.ByteArraySerializer;
  var equals = Kotlin.equals;
  var throwCCE = Kotlin.throwCCE;
  var AbstractEncoder = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.encoding.AbstractEncoder;
  var StructureKind = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.descriptors.StructureKind;
  var PolymorphicKind = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.descriptors.PolymorphicKind;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var toRawBits = Kotlin.floatToRawBits;
  var toRawBits_0 = Kotlin.doubleToRawBits;
  var L255 = Kotlin.Long.fromInt(255);
  var UInt = Kotlin.kotlin.UInt;
  var contains = Kotlin.kotlin.ranges.contains_dwe1qd$;
  var UByte = Kotlin.kotlin.UByte;
  var UShort = Kotlin.kotlin.UShort;
  var ULong = Kotlin.kotlin.ULong;
  var Long$Companion$MIN_VALUE = Kotlin.Long.MIN_VALUE;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var Any = Object;
  var AbstractDecoder = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.encoding.AbstractDecoder;
  var toByte = Kotlin.toByte;
  var toShort = Kotlin.toShort;
  var toChar = Kotlin.toChar;
  var toBoxedChar = Kotlin.toBoxedChar;
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  var L0 = Kotlin.Long.ZERO;
  var removeLastOrNull = Kotlin.kotlin.collections.removeLastOrNull_vvxzk3$;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var toBits = Kotlin.floatToBits;
  var UIntRange_init = Kotlin.kotlin.ranges.UIntRange;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var arrayCopy = Kotlin.kotlin.collections.arrayCopy;
  var IndexOutOfBoundsException_init = Kotlin.kotlin.IndexOutOfBoundsException_init;
  var takeHighestOneBit = Kotlin.kotlin.takeHighestOneBit_s8ev3n$;
  Cbor$Default.prototype = Object.create(Cbor.prototype);
  Cbor$Default.prototype.constructor = Cbor$Default;
  CborImpl.prototype = Object.create(Cbor.prototype);
  CborImpl.prototype.constructor = CborImpl;
  CborDecodingException.prototype = Object.create(SerializationException.prototype);
  CborDecodingException.prototype.constructor = CborDecodingException;
  CborWriter.prototype = Object.create(AbstractEncoder.prototype);
  CborWriter.prototype.constructor = CborWriter;
  CborListWriter.prototype = Object.create(CborWriter.prototype);
  CborListWriter.prototype.constructor = CborListWriter;
  CborMapWriter.prototype = Object.create(CborListWriter.prototype);
  CborMapWriter.prototype.constructor = CborMapWriter;
  CborReader.prototype = Object.create(AbstractDecoder.prototype);
  CborReader.prototype.constructor = CborReader;
  CborListReader.prototype = Object.create(CborReader.prototype);
  CborListReader.prototype.constructor = CborListReader;
  CborMapReader.prototype = Object.create(CborListReader.prototype);
  CborMapReader.prototype.constructor = CborMapReader;
  function ByteString() {
  }
  ByteString.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ByteString',
    interfaces: [Annotation]
  };
  function Cbor(encodeDefaults, ignoreUnknownKeys, serializersModule) {
    Cbor$Default_getInstance();
    this.encodeDefaults_8be2vx$ = encodeDefaults;
    this.ignoreUnknownKeys_8be2vx$ = ignoreUnknownKeys;
    this.serializersModule_og1iyq$_0 = serializersModule;
  }
  Object.defineProperty(Cbor.prototype, 'serializersModule', {
    get: function () {
      return this.serializersModule_og1iyq$_0;
    }
  });
  function Cbor$Default() {
    Cbor$Default_instance = this;
    Cbor.call(this, false, false, EmptySerializersModule());
  }
  Cbor$Default.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Default',
    interfaces: [Cbor]
  };
  var Cbor$Default_instance = null;
  function Cbor$Default_getInstance() {
    if (Cbor$Default_instance === null) {
      new Cbor$Default();
    }
    return Cbor$Default_instance;
  }
  Cbor.prototype.encodeToByteArray_tf03ej$ = function (serializer, value) {
    var output = new ByteArrayOutput();
    var dumper = new CborWriter(this, new CborEncoder(output));
    dumper.encodeSerializableValue_tf03ej$(serializer, value);
    return output.toByteArray();
  };
  Cbor.prototype.decodeFromByteArray_j5nm4a$ = function (deserializer, bytes) {
    var stream = new ByteArrayInput(bytes);
    var reader = new CborReader(this, new CborDecoder(stream));
    return reader.decodeSerializableValue_2crrky$(deserializer);
  };
  Cbor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Cbor',
    interfaces: [BinaryFormat]
  };
  function CborImpl(encodeDefaults, ignoreUnknownKeys, serializersModule) {
    Cbor.call(this, encodeDefaults, ignoreUnknownKeys, serializersModule);
  }
  CborImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborImpl',
    interfaces: [Cbor]
  };
  function Cbor_0(from, builderAction) {
    if (from === void 0)
      from = Cbor$Default_getInstance();
    var builder = new CborBuilder(from);
    builderAction(builder);
    return new CborImpl(builder.encodeDefaults, builder.ignoreUnknownKeys, builder.serializersModule);
  }
  function CborBuilder(cbor) {
    this.encodeDefaults = cbor.encodeDefaults_8be2vx$;
    this.ignoreUnknownKeys = cbor.ignoreUnknownKeys_8be2vx$;
    this.serializersModule = cbor.serializersModule;
  }
  CborBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborBuilder',
    interfaces: []
  };
  function CborDecodingException(message) {
    SerializationException_init(message, this);
    this.name = 'CborDecodingException';
  }
  CborDecodingException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborDecodingException',
    interfaces: [SerializationException]
  };
  function CborDecodingException_0(expected, foundByte) {
    return new CborDecodingException('Expected ' + expected + ', but found ' + printByte(foundByte));
  }
  function printByte(b) {
    var hexCode = '0123456789ABCDEF';
    var $receiver = StringBuilder_init();
    $receiver.append_s8itvh$(hexCode.charCodeAt(b >> 4 & 15));
    $receiver.append_s8itvh$(hexCode.charCodeAt(b & 15));
    return $receiver.toString();
  }
  var FALSE;
  var TRUE;
  var NULL;
  var NEXT_HALF;
  var NEXT_FLOAT;
  var NEXT_DOUBLE;
  var BEGIN_ARRAY;
  var BEGIN_MAP;
  var BREAK;
  var ADDITIONAL_INFORMATION_INDEFINITE_LENGTH;
  var HEADER_BYTE_STRING;
  var HEADER_STRING;
  var HEADER_NEGATIVE;
  var HEADER_ARRAY;
  var HEADER_MAP;
  var HEADER_TAG;
  var LENGTH_STACK_INDEFINITE;
  var HALF_PRECISION_EXPONENT_BIAS;
  var HALF_PRECISION_MAX_EXPONENT;
  var HALF_PRECISION_MAX_MANTISSA;
  var SINGLE_PRECISION_EXPONENT_BIAS;
  var SINGLE_PRECISION_MAX_EXPONENT;
  var SINGLE_PRECISION_NORMALIZE_BASE;
  function CborMapWriter(cbor, encoder) {
    CborListWriter.call(this, cbor, encoder);
  }
  CborMapWriter.prototype.writeBeginToken = function () {
    this.encoder_0.startMap();
  };
  CborMapWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborMapWriter',
    interfaces: [CborListWriter]
  };
  function CborListWriter(cbor, encoder) {
    CborWriter.call(this, cbor, encoder);
  }
  CborListWriter.prototype.writeBeginToken = function () {
    this.encoder_0.startArray();
  };
  CborListWriter.prototype.encodeElement_szpzho$ = function (descriptor, index) {
    return true;
  };
  CborListWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborListWriter',
    interfaces: [CborWriter]
  };
  function CborWriter(cbor, encoder) {
    AbstractEncoder.call(this);
    this.cbor_0 = cbor;
    this.encoder_0 = encoder;
    this.encodeByteArrayAsByteString_0 = false;
  }
  Object.defineProperty(CborWriter.prototype, 'serializersModule', {
    configurable: true,
    get: function () {
      return this.cbor_0.serializersModule;
    }
  });
  CborWriter.prototype.encodeSerializableValue_tf03ej$ = function (serializer, value) {
    var tmp$;
    if (this.encodeByteArrayAsByteString_0 && equals(serializer.descriptor, ByteArraySerializer().descriptor)) {
      this.encoder_0.encodeByteString_fqrh44$(Kotlin.isByteArray(tmp$ = value) ? tmp$ : throwCCE());
    } else {
      AbstractEncoder.prototype.encodeSerializableValue_tf03ej$.call(this, serializer, value);
    }
  };
  CborWriter.prototype.shouldEncodeElementDefault_szpzho$ = function (descriptor, index) {
    return this.cbor_0.encodeDefaults_8be2vx$;
  };
  CborWriter.prototype.writeBeginToken = function () {
    this.encoder_0.startMap();
  };
  CborWriter.prototype.beginStructure_24f42q$ = function (descriptor) {
    var tmp$, tmp$_0;
    tmp$ = descriptor.kind;
    if (equals(tmp$, StructureKind.LIST) || Kotlin.isType(tmp$, PolymorphicKind))
      tmp$_0 = new CborListWriter(this.cbor_0, this.encoder_0);
    else if (equals(tmp$, StructureKind.MAP))
      tmp$_0 = new CborMapWriter(this.cbor_0, this.encoder_0);
    else
      tmp$_0 = new CborWriter(this.cbor_0, this.encoder_0);
    var writer = tmp$_0;
    writer.writeBeginToken();
    return writer;
  };
  CborWriter.prototype.endStructure_24f42q$ = function (descriptor) {
    this.encoder_0.end();
  };
  CborWriter.prototype.encodeElement_szpzho$ = function (descriptor, index) {
    this.encodeByteArrayAsByteString_0 = isByteString(descriptor, index);
    var name = descriptor.getElementName_za3lpa$(index);
    this.encoder_0.encodeString_61zpoe$(name);
    return true;
  };
  CborWriter.prototype.encodeString_61zpoe$ = function (value) {
    this.encoder_0.encodeString_61zpoe$(value);
  };
  CborWriter.prototype.encodeFloat_mx4ult$ = function (value) {
    this.encoder_0.encodeFloat_mx4ult$(value);
  };
  CborWriter.prototype.encodeDouble_14dthe$ = function (value) {
    this.encoder_0.encodeDouble_14dthe$(value);
  };
  CborWriter.prototype.encodeChar_s8itvh$ = function (value) {
    this.encoder_0.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value | 0));
  };
  CborWriter.prototype.encodeByte_s8j3t7$ = function (value) {
    this.encoder_0.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value));
  };
  CborWriter.prototype.encodeShort_mq22fl$ = function (value) {
    this.encoder_0.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value));
  };
  CborWriter.prototype.encodeInt_za3lpa$ = function (value) {
    this.encoder_0.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value));
  };
  CborWriter.prototype.encodeLong_s8cxhz$ = function (value) {
    this.encoder_0.encodeNumber_s8cxhz$(value);
  };
  CborWriter.prototype.encodeBoolean_6taknv$ = function (value) {
    this.encoder_0.encodeBoolean_6taknv$(value);
  };
  CborWriter.prototype.encodeNull = function () {
    this.encoder_0.encodeNull();
  };
  CborWriter.prototype.encodeEnum_szpzho$ = function (enumDescriptor, index) {
    this.encoder_0.encodeString_61zpoe$(enumDescriptor.getElementName_za3lpa$(index));
  };
  CborWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborWriter',
    interfaces: [AbstractEncoder]
  };
  function CborEncoder(output) {
    this.output_0 = output;
  }
  CborEncoder.prototype.startArray = function () {
    this.output_0.write_za3lpa$(159);
  };
  CborEncoder.prototype.startMap = function () {
    this.output_0.write_za3lpa$(191);
  };
  CborEncoder.prototype.end = function () {
    this.output_0.write_za3lpa$(255);
  };
  CborEncoder.prototype.encodeNull = function () {
    this.output_0.write_za3lpa$(246);
  };
  CborEncoder.prototype.encodeBoolean_6taknv$ = function (value) {
    this.output_0.write_za3lpa$(value ? 245 : 244);
  };
  CborEncoder.prototype.encodeNumber_s8cxhz$ = function (value) {
    this.output_0.write_mj6st8$(this.composeNumber_0(value));
  };
  CborEncoder.prototype.encodeByteString_fqrh44$ = function (data) {
    this.encodeByteArray_0(data, HEADER_BYTE_STRING);
  };
  CborEncoder.prototype.encodeString_61zpoe$ = function (value) {
    this.encodeByteArray_0(encodeToByteArray(value), HEADER_STRING);
  };
  CborEncoder.prototype.encodeByteArray_0 = function (data, type) {
    var header = this.composeNumber_0(Kotlin.Long.fromInt(data.length));
    header[0] = toByte(header[0] | type);
    this.output_0.write_mj6st8$(header);
    this.output_0.write_mj6st8$(data);
  };
  CborEncoder.prototype.encodeFloat_mx4ult$ = function (value) {
    this.output_0.write_za3lpa$(250);
    var bits = toRawBits(value);
    for (var i = 0; i <= 3; i++) {
      this.output_0.write_za3lpa$(bits >> 24 - (8 * i | 0) & 255);
    }
  };
  CborEncoder.prototype.encodeDouble_14dthe$ = function (value) {
    this.output_0.write_za3lpa$(251);
    var bits = toRawBits_0(value);
    for (var i = 0; i <= 7; i++) {
      this.output_0.write_za3lpa$(bits.shiftRight(56 - (8 * i | 0) | 0).and(L255).toInt());
    }
  };
  CborEncoder.prototype.composeNumber_0 = function (value) {
    return value.toNumber() >= 0 ? this.composePositive_0(new ULong(value)) : this.composeNegative_0(value);
  };
  CborEncoder.prototype.composePositive_0 = function (value) {
    if (contains(new UIntRange_init(new UInt(0), new UInt(23)), value)) {
      return new Int8Array([toByte(value.data.toInt())]);
    } else {
      if (contains(new UIntRange_init(new UInt(24), new UInt(UByte.Companion.MAX_VALUE.data & 255)), value)) {
        return new Int8Array([24, toByte(value.data.toInt())]);
      } else {
        var $this = new UInt(UByte.Companion.MAX_VALUE.data & 255);
        var other = new UInt(1);
        if (contains(new UIntRange_init(new UInt($this.data + other.data | 0), new UInt(UShort.Companion.MAX_VALUE.data & 65535)), value))
          return this.encodeToByteArray_0(value, 2, 25);
        else {
          var $this_0 = new UInt(UShort.Companion.MAX_VALUE.data & 65535);
          var other_0 = new UInt(1);
          if (contains(new UIntRange_init(new UInt($this_0.data + other_0.data | 0), UInt.Companion.MAX_VALUE), value))
            return this.encodeToByteArray_0(value, 4, 26);
          else
            return this.encodeToByteArray_0(value, 8, 27);
        }
      }
    }
  };
  CborEncoder.prototype.encodeToByteArray_0 = function (value, bytes, tag) {
    var result = new Int8Array(bytes + 1 | 0);
    var limit = (bytes * 8 | 0) - 8 | 0;
    result[0] = tag;
    for (var i = 0; i < bytes; i++) {
      var bitCount = limit - (8 * i | 0) | 0;
      var $this = new ULong(value.data.shiftRightUnsigned(bitCount));
      var other = new ULong(Kotlin.Long.fromInt(255));
      result[i + 1 | 0] = toByte((new ULong($this.data.and(other.data))).data.toInt());
    }
    return result;
  };
  CborEncoder.prototype.composeNegative_0 = function (value) {
    var aVal = equals(value, Long$Companion$MIN_VALUE) ? Long$Companion$MAX_VALUE : Kotlin.Long.fromInt(-1).subtract(value);
    var data = this.composePositive_0(new ULong(aVal));
    data[0] = toByte(data[0] | HEADER_NEGATIVE);
    return data;
  };
  CborEncoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborEncoder',
    interfaces: []
  };
  function CborMapReader(cbor, decoder) {
    CborListReader.call(this, cbor, decoder);
  }
  CborMapReader.prototype.skipBeginToken = function () {
    this.setSize_0(this.decoder_0.startMap() * 2 | 0);
  };
  CborMapReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborMapReader',
    interfaces: [CborListReader]
  };
  function CborListReader(cbor, decoder) {
    CborReader.call(this, cbor, decoder);
    this.ind_0 = 0;
  }
  CborListReader.prototype.skipBeginToken = function () {
    this.setSize_0(this.decoder_0.startArray());
  };
  CborListReader.prototype.decodeElementIndex_24f42q$ = function (descriptor) {
    var tmp$;
    return !this.finiteMode_0 && this.decoder_0.isEnd() || (this.finiteMode_0 && this.ind_0 >= this.size_0) ? -1 : (tmp$ = this.ind_0, this.ind_0 = tmp$ + 1 | 0, tmp$);
  };
  CborListReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborListReader',
    interfaces: [CborReader]
  };
  function CborReader(cbor, decoder) {
    AbstractDecoder.call(this);
    this.cbor_0 = cbor;
    this.decoder_0 = decoder;
    this.size_x9jc0a$_0 = -1;
    this.finiteMode_uvhgjr$_0 = false;
    this.readProperties_0 = 0;
    this.decodeByteArrayAsByteString_0 = false;
  }
  Object.defineProperty(CborReader.prototype, 'size_0', {
    configurable: true,
    get: function () {
      return this.size_x9jc0a$_0;
    },
    set: function (size) {
      this.size_x9jc0a$_0 = size;
    }
  });
  Object.defineProperty(CborReader.prototype, 'finiteMode_0', {
    configurable: true,
    get: function () {
      return this.finiteMode_uvhgjr$_0;
    },
    set: function (finiteMode) {
      this.finiteMode_uvhgjr$_0 = finiteMode;
    }
  });
  CborReader.prototype.setSize_0 = function (size) {
    if (size >= 0) {
      this.finiteMode_0 = true;
      this.size_0 = size;
    }
  };
  Object.defineProperty(CborReader.prototype, 'serializersModule', {
    configurable: true,
    get: function () {
      return this.cbor_0.serializersModule;
    }
  });
  CborReader.prototype.skipBeginToken = function () {
    this.setSize_0(this.decoder_0.startMap());
  };
  CborReader.prototype.beginStructure_24f42q$ = function (descriptor) {
    var tmp$, tmp$_0;
    tmp$ = descriptor.kind;
    if (equals(tmp$, StructureKind.LIST) || Kotlin.isType(tmp$, PolymorphicKind))
      tmp$_0 = new CborListReader(this.cbor_0, this.decoder_0);
    else if (equals(tmp$, StructureKind.MAP))
      tmp$_0 = new CborMapReader(this.cbor_0, this.decoder_0);
    else
      tmp$_0 = new CborReader(this.cbor_0, this.decoder_0);
    var re = tmp$_0;
    re.skipBeginToken();
    return re;
  };
  CborReader.prototype.endStructure_24f42q$ = function (descriptor) {
    if (!this.finiteMode_0)
      this.decoder_0.end();
  };
  CborReader.prototype.decodeElementIndex_24f42q$ = function (descriptor) {
    var tmp$;
    if (this.cbor_0.ignoreUnknownKeys_8be2vx$) {
      var knownIndex;
      while (true) {
        if (this.isDone_0())
          return -1;
        var elemName = this.decoder_0.nextString();
        this.readProperties_0 = this.readProperties_0 + 1 | 0;
        var index = descriptor.getElementIndex_61zpoe$(elemName);
        if (index === -3) {
          this.decoder_0.skipElement();
        } else {
          knownIndex = index;
          break;
        }
      }
      tmp$ = knownIndex;
    } else {
      if (this.isDone_0())
        return -1;
      var elemName_0 = this.decoder_0.nextString();
      this.readProperties_0 = this.readProperties_0 + 1 | 0;
      tmp$ = getElementIndexOrThrow(descriptor, elemName_0);
    }
    var index_0 = tmp$;
    this.decodeByteArrayAsByteString_0 = isByteString(descriptor, index_0);
    return index_0;
  };
  CborReader.prototype.decodeSerializableValue_2crrky$ = function (deserializer) {
    var tmp$, tmp$_0;
    if (this.decodeByteArrayAsByteString_0 && equals(deserializer.descriptor, ByteArraySerializer().descriptor)) {
      tmp$_0 = (tmp$ = this.decoder_0.nextByteString()) == null || Kotlin.isType(tmp$, Any) ? tmp$ : throwCCE();
    } else {
      tmp$_0 = AbstractDecoder.prototype.decodeSerializableValue_2crrky$.call(this, deserializer);
    }
    return tmp$_0;
  };
  CborReader.prototype.decodeString = function () {
    return this.decoder_0.nextString();
  };
  CborReader.prototype.decodeNotNullMark = function () {
    return !this.decoder_0.isNull();
  };
  CborReader.prototype.decodeDouble = function () {
    return this.decoder_0.nextDouble();
  };
  CborReader.prototype.decodeFloat = function () {
    return this.decoder_0.nextFloat();
  };
  CborReader.prototype.decodeBoolean = function () {
    return this.decoder_0.nextBoolean();
  };
  CborReader.prototype.decodeByte = function () {
    return toByte(this.decoder_0.nextNumber().toInt());
  };
  CborReader.prototype.decodeShort = function () {
    return toShort(this.decoder_0.nextNumber().toInt());
  };
  CborReader.prototype.decodeChar = function () {
    return toBoxedChar(toChar(this.decoder_0.nextNumber().toInt()));
  };
  CborReader.prototype.decodeInt = function () {
    return this.decoder_0.nextNumber().toInt();
  };
  CborReader.prototype.decodeLong = function () {
    return this.decoder_0.nextNumber();
  };
  CborReader.prototype.decodeNull = function () {
    return this.decoder_0.nextNull();
  };
  CborReader.prototype.decodeEnum_24f42q$ = function (enumDescriptor) {
    return getElementIndexOrThrow(enumDescriptor, this.decoder_0.nextString());
  };
  CborReader.prototype.isDone_0 = function () {
    return !this.finiteMode_0 && this.decoder_0.isEnd() || (this.finiteMode_0 && this.readProperties_0 >= this.size_0);
  };
  CborReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborReader',
    interfaces: [AbstractDecoder]
  };
  function CborDecoder(input) {
    this.input_0 = input;
    this.curByte_0 = -1;
    this.readByte_0();
  }
  CborDecoder.prototype.readByte_0 = function () {
    this.curByte_0 = this.input_0.read();
    return this.curByte_0;
  };
  CborDecoder.prototype.isEof = function () {
    return this.curByte_0 === -1;
  };
  CborDecoder.prototype.skipByte_0 = function (expected) {
    if (this.curByte_0 !== expected)
      throw CborDecodingException_0('byte ' + printByte(expected), this.curByte_0);
    this.readByte_0();
  };
  CborDecoder.prototype.isNull = function () {
    return this.curByte_0 === 246;
  };
  CborDecoder.prototype.nextNull = function () {
    this.skipOverTags_0();
    this.skipByte_0(246);
    return null;
  };
  CborDecoder.prototype.nextBoolean = function () {
    var tmp$;
    this.skipOverTags_0();
    switch (this.curByte_0) {
      case 245:
        tmp$ = true;
        break;
      case 244:
        tmp$ = false;
        break;
      default:
        throw CborDecodingException_0('boolean value', this.curByte_0);
    }
    var ans = tmp$;
    this.readByte_0();
    return ans;
  };
  CborDecoder.prototype.startArray = function () {
    return this.startSized_0(159, 128, 'array');
  };
  CborDecoder.prototype.startMap = function () {
    return this.startSized_0(191, 160, 'map');
  };
  CborDecoder.prototype.startSized_0 = function (unboundedHeader, boundedHeaderMask, collectionType) {
    this.skipOverTags_0();
    if (this.curByte_0 === unboundedHeader) {
      this.skipByte_0(unboundedHeader);
      return -1;
    }
    if ((this.curByte_0 & 224) !== boundedHeaderMask)
      throw CborDecodingException_0('start of ' + collectionType, this.curByte_0);
    var size = this.readNumber_0().toInt();
    this.readByte_0();
    return size;
  };
  CborDecoder.prototype.isEnd = function () {
    return this.curByte_0 === 255;
  };
  CborDecoder.prototype.end = function () {
    this.skipByte_0(255);
  };
  CborDecoder.prototype.nextByteString = function () {
    this.skipOverTags_0();
    if ((this.curByte_0 & 224) !== 64)
      throw CborDecodingException_0('start of byte string', this.curByte_0);
    var arr = this.readBytes_0();
    this.readByte_0();
    return arr;
  };
  CborDecoder.prototype.nextString = function () {
    this.skipOverTags_0();
    if ((this.curByte_0 & 224) !== 96)
      throw CborDecodingException_0('start of string', this.curByte_0);
    var arr = this.readBytes_0();
    var ans = decodeToString(arr);
    this.readByte_0();
    return ans;
  };
  CborDecoder.prototype.readBytes_0 = function () {
    if ((this.curByte_0 & 31) === 31) {
      this.readByte_0();
      return this.readIndefiniteLengthBytes_0();
    } else {
      var strLen = this.readNumber_0().toInt();
      return this.readExactNBytes_0(this.input_0, strLen);
    }
  };
  CborDecoder.prototype.skipOverTags_0 = function () {
    while ((this.curByte_0 & 224) === 192) {
      this.readNumber_0();
      this.readByte_0();
    }
  };
  CborDecoder.prototype.nextNumber = function () {
    this.skipOverTags_0();
    var res = this.readNumber_0();
    this.readByte_0();
    return res;
  };
  CborDecoder.prototype.readNumber_0 = function () {
    var tmp$;
    var value = this.curByte_0 & 31;
    var negative = (this.curByte_0 & 224) === 32;
    switch (value) {
      case 24:
        tmp$ = 1;
        break;
      case 25:
        tmp$ = 2;
        break;
      case 26:
        tmp$ = 4;
        break;
      case 27:
        tmp$ = 8;
        break;
      default:
        tmp$ = 0;
        break;
    }
    var bytesToRead = tmp$;
    if (bytesToRead === 0) {
      return negative ? Kotlin.Long.fromInt(value + 1 | 0).unaryMinus() : Kotlin.Long.fromInt(value);
    }
    var res = this.readExact_0(this.input_0, bytesToRead);
    return negative ? res.add(Kotlin.Long.fromInt(1)).unaryMinus() : res;
  };
  CborDecoder.prototype.readExact_0 = function ($receiver, bytes) {
    var arr = this.readExactNBytes_0($receiver, bytes);
    var result = L0;
    for (var i = 0; i < bytes; i++) {
      result = result.shiftLeft(8).or(Kotlin.Long.fromInt(arr[i] & 255));
    }
    return result;
  };
  CborDecoder.prototype.readExactNBytes_0 = function ($receiver, bytesCount) {
    if (bytesCount > $receiver.availableBytes) {
      throw IllegalStateException_init(('Unexpected EOF, available ' + $receiver.availableBytes + ' bytes, requested: ' + bytesCount).toString());
    }
    var array = new Int8Array(bytesCount);
    $receiver.read_mj6st8$(array, 0, bytesCount);
    return array;
  };
  CborDecoder.prototype.nextFloat = function () {
    var tmp$;
    this.skipOverTags_0();
    switch (this.curByte_0) {
      case 250:
        var bits = this.readInt_0();
        tmp$ = Kotlin.floatFromBits(bits);
        break;
      case 249:
        tmp$ = floatFromHalfBits(this.readShort_0());
        break;
      default:
        throw CborDecodingException_0('float header', this.curByte_0);
    }
    var res = tmp$;
    this.readByte_0();
    return res;
  };
  CborDecoder.prototype.nextDouble = function () {
    var tmp$;
    this.skipOverTags_0();
    switch (this.curByte_0) {
      case 251:
        var bits = this.readLong_0();
        tmp$ = Kotlin.doubleFromBits(bits);
        break;
      case 250:
        var bits_0 = this.readInt_0();
        tmp$ = Kotlin.floatFromBits(bits_0);
        break;
      case 249:
        tmp$ = floatFromHalfBits(this.readShort_0());
        break;
      default:
        throw CborDecodingException_0('double header', this.curByte_0);
    }
    var res = tmp$;
    this.readByte_0();
    return res;
  };
  CborDecoder.prototype.readLong_0 = function () {
    var result = L0;
    for (var i = 0; i <= 7; i++) {
      var byte = this.input_0.read();
      result = result.shiftLeft(8).or(Kotlin.Long.fromInt(byte));
    }
    return result;
  };
  CborDecoder.prototype.readShort_0 = function () {
    var highByte = this.input_0.read();
    var lowByte = this.input_0.read();
    return toShort(highByte << 8 | lowByte);
  };
  CborDecoder.prototype.readInt_0 = function () {
    var result = 0;
    for (var i = 0; i <= 3; i++) {
      var byte = this.input_0.read();
      result = result << 8 | byte;
    }
    return result;
  };
  CborDecoder.prototype.skipElement = function () {
    var lengthStack = ArrayList_init();
    this.skipOverTags_0();
    do {
      if (this.isEof())
        throw new CborDecodingException('Unexpected EOF while skipping element');
      if (this.isIndefinite_0()) {
        lengthStack.add_11rb$(-1);
      } else if (this.isEnd()) {
        if (removeLastOrNull(lengthStack) !== -1)
          throw CborDecodingException_0('next data item', this.curByte_0);
        this.prune_0(lengthStack);
      } else {
        var header = this.curByte_0 & 224;
        var length = this.elementLength_0();
        if (header === 128 || header === 160) {
          if (length > 0)
            lengthStack.add_11rb$(length);
          this.skipOverTags_0();
        } else {
          this.input_0.skip_za3lpa$(length);
          this.prune_0(lengthStack);
        }
      }
      this.readByte_0();
      var isNotEmpty$result;
      isNotEmpty$result = !lengthStack.isEmpty();
    }
     while (isNotEmpty$result);
  };
  CborDecoder.prototype.prune_0 = function (lengthStack) {
    for (var i = get_lastIndex(lengthStack); i >= 0; i--) {
      switch (lengthStack.get_za3lpa$(i)) {
        case -1:
          break;
        case 1:
          lengthStack.removeAt_za3lpa$(i);
          break;
        default:
          lengthStack.set_wxm5ur$(i, lengthStack.get_za3lpa$(i) - 1 | 0);
          break;
      }
    }
  };
  CborDecoder.prototype.isIndefinite_0 = function () {
    var majorType = this.curByte_0 & 224;
    var value = this.curByte_0 & 31;
    return value === 31 && (majorType === 128 || majorType === 160 || majorType === 64 || majorType === 96);
  };
  CborDecoder.prototype.elementLength_0 = function () {
    var tmp$;
    var majorType = this.curByte_0 & 224;
    var additionalInformation = this.curByte_0 & 31;
    switch (majorType) {
      case 64:
      case 96:
      case 128:
        tmp$ = this.readNumber_0().toInt();
        break;
      case 160:
        tmp$ = this.readNumber_0().toInt() * 2 | 0;
        break;
      default:
        switch (additionalInformation) {
          case 24:
            tmp$ = 1;
            break;
          case 25:
            tmp$ = 2;
            break;
          case 26:
            tmp$ = 4;
            break;
          case 27:
            tmp$ = 8;
            break;
          default:
            tmp$ = 0;
            break;
        }

        break;
    }
    return tmp$;
  };
  CborDecoder.prototype.readIndefiniteLengthBytes_0 = function () {
    var byteStrings = ArrayList_init();
    do {
      byteStrings.add_11rb$(this.readBytes_0());
      this.readByte_0();
    }
     while (!this.isEnd());
    return flatten(byteStrings);
  };
  CborDecoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborDecoder',
    interfaces: []
  };
  function getElementIndexOrThrow($receiver, name) {
    var index = $receiver.getElementIndex_61zpoe$(name);
    if (index === -3)
      throw SerializationException_init($receiver.serialName + " does not contain element with name '" + name + '.' + " You can enable 'CborBuilder.ignoreUnknownKeys' property to ignore unknown keys");
    return index;
  }
  function flatten($receiver) {
    var tmp$;
    var tmp$_0 = Int8Array;
    var tmp$_1;
    var sum = 0;
    tmp$_1 = $receiver.iterator();
    while (tmp$_1.hasNext()) {
      var element = tmp$_1.next();
      sum = sum + element.length | 0;
    }
    var output = new tmp$_0(sum);
    var position = 0;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var chunk = tmp$.next();
      arrayCopy(chunk, output, position, 0, chunk.length);
      position = position + chunk.length | 0;
    }
    return output;
  }
  function isByteString($receiver, index) {
    var $receiver_0 = $receiver.getElementAnnotations_za3lpa$(index);
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (Kotlin.isType(element, ByteString)) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }
      }
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result != null;
  }
  var normalizeBaseBits;
  function floatFromHalfBits(bits) {
    var intBits = bits;
    var negative = (intBits & 32768) !== 0;
    var halfExp = intBits >> 10 & 31;
    var halfMant = intBits & 1023;
    var exp;
    var mant;
    switch (halfExp) {
      case 31:
        exp = 255;
        mant = halfMant;
        break;
      case 0:
        if (halfMant === 0) {
          mant = 0;
          exp = 0;
        } else {
          var bits_0 = normalizeBaseBits + halfMant | 0;
          var res = Kotlin.floatFromBits(bits_0);
          res -= SINGLE_PRECISION_NORMALIZE_BASE;
          return negative ? -res : res;
        }

        break;
      default:
        exp = halfExp + 112 | 0;
        mant = halfMant;
        break;
    }
    var bits_1 = exp << 23 | mant << 13;
    var res_0 = Kotlin.floatFromBits(bits_1);
    return negative ? -res_0 : res_0;
  }
  function ByteArrayInput(array) {
    this.array_0 = array;
    this.position_0 = 0;
  }
  Object.defineProperty(ByteArrayInput.prototype, 'availableBytes', {
    configurable: true,
    get: function () {
      return this.array_0.length - this.position_0 | 0;
    }
  });
  ByteArrayInput.prototype.read = function () {
    var tmp$, tmp$_0;
    if (this.position_0 < this.array_0.length) {
      tmp$_0 = this.array_0[tmp$ = this.position_0, this.position_0 = tmp$ + 1 | 0, tmp$] & 255;
    } else
      tmp$_0 = -1;
    return tmp$_0;
  };
  ByteArrayInput.prototype.read_mj6st8$ = function (b, offset, length) {
    if (offset < 0 || offset > b.length || length < 0 || length > (b.length - offset | 0)) {
      throw IndexOutOfBoundsException_init();
    }
    if (this.position_0 >= this.array_0.length) {
      return -1;
    }
    if (length === 0) {
      return 0;
    }
    var copied = (this.array_0.length - this.position_0 | 0) < length ? this.array_0.length - this.position_0 | 0 : length;
    arrayCopy(this.array_0, b, offset, this.position_0, this.position_0 + copied | 0);
    this.position_0 = this.position_0 + copied | 0;
    return copied;
  };
  ByteArrayInput.prototype.skip_za3lpa$ = function (length) {
    this.position_0 = this.position_0 + length | 0;
  };
  ByteArrayInput.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ByteArrayInput',
    interfaces: []
  };
  function ByteArrayOutput() {
    this.array_0 = new Int8Array(32);
    this.position_0 = 0;
  }
  ByteArrayOutput.prototype.ensureCapacity_0 = function (elementsToAppend) {
    if ((this.position_0 + elementsToAppend | 0) <= this.array_0.length) {
      return;
    }
    var newArray = new Int8Array(takeHighestOneBit(this.position_0 + elementsToAppend | 0) << 1);
    var $receiver = this.array_0;
    arrayCopy($receiver, newArray, 0, 0, $receiver.length);
    this.array_0 = newArray;
  };
  ByteArrayOutput.prototype.toByteArray = function () {
    var newArray = new Int8Array(this.position_0);
    arrayCopy(this.array_0, newArray, 0, 0, this.position_0);
    return newArray;
  };
  ByteArrayOutput.prototype.write_mj6st8$ = function (buffer, offset, count) {
    if (offset === void 0)
      offset = 0;
    if (count === void 0)
      count = buffer.length;
    if (offset < 0 || offset > buffer.length || count < 0 || count > (buffer.length - offset | 0)) {
      throw IndexOutOfBoundsException_init();
    }
    if (count === 0) {
      return;
    }
    this.ensureCapacity_0(count);
    arrayCopy(buffer, this.array_0, this.position_0, offset, offset + count | 0);
    this.position_0 = this.position_0 + count | 0;
  };
  ByteArrayOutput.prototype.write_za3lpa$ = function (byteValue) {
    var tmp$;
    this.ensureCapacity_0(1);
    this.array_0[tmp$ = this.position_0, this.position_0 = tmp$ + 1 | 0, tmp$] = toByte(byteValue);
  };
  ByteArrayOutput.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ByteArrayOutput',
    interfaces: []
  };
  var package$kotlinx = _.kotlinx || (_.kotlinx = {});
  var package$serialization = package$kotlinx.serialization || (package$kotlinx.serialization = {});
  var package$cbor = package$serialization.cbor || (package$serialization.cbor = {});
  package$cbor.ByteString = ByteString;
  Object.defineProperty(Cbor, 'Default', {
    get: Cbor$Default_getInstance
  });
  package$cbor.Cbor = Cbor;
  package$cbor.Cbor_m8xcf6$ = Cbor_0;
  package$cbor.CborBuilder = CborBuilder;
  var package$internal = package$cbor.internal || (package$cbor.internal = {});
  package$internal.CborDecodingException = CborDecodingException;
  package$internal.CborDecodingException_pd5a99$ = CborDecodingException_0;
  package$internal.printByte_kcn2v3$ = printByte;
  package$internal.CborWriter = CborWriter;
  package$internal.CborEncoder = CborEncoder;
  package$internal.CborReader = CborReader;
  package$internal.CborDecoder = CborDecoder;
  package$internal.ByteArrayInput = ByteArrayInput;
  package$internal.ByteArrayOutput = ByteArrayOutput;
  FALSE = 244;
  TRUE = 245;
  NULL = 246;
  NEXT_HALF = 249;
  NEXT_FLOAT = 250;
  NEXT_DOUBLE = 251;
  BEGIN_ARRAY = 159;
  BEGIN_MAP = 191;
  BREAK = 255;
  ADDITIONAL_INFORMATION_INDEFINITE_LENGTH = 31;
  HEADER_BYTE_STRING = 64;
  HEADER_STRING = 96;
  HEADER_NEGATIVE = 32;
  HEADER_ARRAY = 128;
  HEADER_MAP = 160;
  HEADER_TAG = 192;
  LENGTH_STACK_INDEFINITE = -1;
  HALF_PRECISION_EXPONENT_BIAS = 15;
  HALF_PRECISION_MAX_EXPONENT = 31;
  HALF_PRECISION_MAX_MANTISSA = 1023;
  SINGLE_PRECISION_EXPONENT_BIAS = 127;
  SINGLE_PRECISION_MAX_EXPONENT = 255;
  SINGLE_PRECISION_NORMALIZE_BASE = 0.5;
  normalizeBaseBits = toBits(SINGLE_PRECISION_NORMALIZE_BASE);
  Kotlin.defineModule('kotlinx-serialization-kotlinx-serialization-cbor-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kotlinx-serialization-kotlinx-serialization-cbor-js-legacy.js.map
