(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-serialization-kotlinx-serialization-runtime'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-serialization-kotlinx-serialization-runtime'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-cbor'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-cbor'.");
    }if (typeof this['kotlinx-serialization-kotlinx-serialization-runtime'] === 'undefined') {
      throw new Error("Error loading module 'kotlinx-serialization-kotlinx-serialization-cbor'. Its dependency 'kotlinx-serialization-kotlinx-serialization-runtime' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-runtime' is loaded prior to 'kotlinx-serialization-kotlinx-serialization-cbor'.");
    }root['kotlinx-serialization-kotlinx-serialization-cbor'] = factory(typeof this['kotlinx-serialization-kotlinx-serialization-cbor'] === 'undefined' ? {} : this['kotlinx-serialization-kotlinx-serialization-cbor'], kotlin, this['kotlinx-serialization-kotlinx-serialization-runtime']);
  }
}(this, function (_, Kotlin, $module$kotlinx_serialization_kotlinx_serialization_runtime) {
  'use strict';
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var StructureKind = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.StructureKind;
  var equals = Kotlin.equals;
  var PolymorphicKind = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.PolymorphicKind;
  var AbstractEncoder = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.builtins.AbstractEncoder;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var toRawBits = Kotlin.floatToRawBits;
  var toRawBits_0 = Kotlin.doubleToRawBits;
  var L255 = Kotlin.Long.fromInt(255);
  var toByte = Kotlin.toByte;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var contains = Kotlin.kotlin.ranges.contains_8sy4e8$;
  var kotlin_js_internal_ByteCompanionObject = Kotlin.kotlin.js.internal.ByteCompanionObject;
  var kotlin_js_internal_ShortCompanionObject = Kotlin.kotlin.js.internal.ShortCompanionObject;
  var L2147483648 = new Kotlin.Long(-2147483648, 0);
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var AssertionError_init = Kotlin.kotlin.AssertionError_init_pdl1vj$;
  var Long$Companion$MIN_VALUE = Kotlin.Long.MIN_VALUE;
  var getElementIndexOrThrow = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.getElementIndexOrThrow_27vawp$;
  var toShort = Kotlin.toShort;
  var toChar = Kotlin.toChar;
  var toBoxedChar = Kotlin.toBoxedChar;
  var AbstractDecoder = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.builtins.AbstractDecoder;
  var readExactNBytes = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.readExactNBytes_5u4fs$;
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  var L0 = Kotlin.Long.ZERO;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var BinaryFormat = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.BinaryFormat;
  var ByteArrayOutputStream_init = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.io.ByteArrayOutputStream_init;
  var encode = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.encode_dt3ugd$;
  var ByteArrayInputStream_init = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.io.ByteArrayInputStream_init_fqrh44$;
  var decode = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.decode_cmswi7$;
  var UpdateMode = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.UpdateMode;
  var modules = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.modules;
  var SerializationException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.SerializationException;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  Cbor$CborWriter.prototype = Object.create(AbstractEncoder.prototype);
  Cbor$CborWriter.prototype.constructor = Cbor$CborWriter;
  Cbor$CborListWriter.prototype = Object.create(Cbor$CborWriter.prototype);
  Cbor$CborListWriter.prototype.constructor = Cbor$CborListWriter;
  Cbor$CborMapWriter.prototype = Object.create(Cbor$CborListWriter.prototype);
  Cbor$CborMapWriter.prototype.constructor = Cbor$CborMapWriter;
  Cbor$CborReader.prototype = Object.create(AbstractDecoder.prototype);
  Cbor$CborReader.prototype.constructor = Cbor$CborReader;
  Cbor$CborListReader.prototype = Object.create(Cbor$CborReader.prototype);
  Cbor$CborListReader.prototype.constructor = Cbor$CborListReader;
  Cbor$CborMapReader.prototype = Object.create(Cbor$CborListReader.prototype);
  Cbor$CborMapReader.prototype.constructor = Cbor$CborMapReader;
  CborDecodingException.prototype = Object.create(SerializationException.prototype);
  CborDecodingException.prototype.constructor = CborDecodingException;
  function Cbor(updateMode, encodeDefaults, context) {
    Cbor$Default_getInstance();
    if (updateMode === void 0)
      updateMode = UpdateMode.BANNED;
    if (encodeDefaults === void 0)
      encodeDefaults = true;
    if (context === void 0)
      context = modules.EmptyModule;
    this.updateMode = updateMode;
    this.encodeDefaults = encodeDefaults;
    this.context_le1n9c$_0 = context;
  }
  Object.defineProperty(Cbor.prototype, 'context', {
    get: function () {
      return this.context_le1n9c$_0;
    }
  });
  function Cbor$CborMapWriter($outer, encoder) {
    this.$outer = $outer;
    Cbor$CborListWriter.call(this, this.$outer, encoder);
  }
  Cbor$CborMapWriter.prototype.writeBeginToken = function () {
    this.encoder.startMap();
  };
  Cbor$CborMapWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborMapWriter',
    interfaces: [Cbor$CborListWriter]
  };
  function Cbor$CborListWriter($outer, encoder) {
    this.$outer = $outer;
    Cbor$CborWriter.call(this, this.$outer, encoder);
  }
  Cbor$CborListWriter.prototype.writeBeginToken = function () {
    this.encoder.startArray();
  };
  Cbor$CborListWriter.prototype.encodeElement_3zr2iy$ = function (descriptor, index) {
    return true;
  };
  Cbor$CborListWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborListWriter',
    interfaces: [Cbor$CborWriter]
  };
  function Cbor$CborWriter($outer, encoder) {
    this.$outer = $outer;
    AbstractEncoder.call(this);
    this.encoder = encoder;
  }
  Object.defineProperty(Cbor$CborWriter.prototype, 'context', {
    get: function () {
      return this.$outer.context;
    }
  });
  Cbor$CborWriter.prototype.shouldEncodeElementDefault_3zr2iy$ = function (descriptor, index) {
    return this.$outer.encodeDefaults;
  };
  Cbor$CborWriter.prototype.writeBeginToken = function () {
    this.encoder.startMap();
  };
  Cbor$CborWriter.prototype.beginStructure_r0sa6z$ = function (descriptor, typeSerializers) {
    var tmp$, tmp$_0;
    tmp$ = descriptor.kind;
    if (equals(tmp$, StructureKind.LIST) || Kotlin.isType(tmp$, PolymorphicKind))
      tmp$_0 = new Cbor$CborListWriter(this.$outer, this.encoder);
    else if (equals(tmp$, StructureKind.MAP))
      tmp$_0 = new Cbor$CborMapWriter(this.$outer, this.encoder);
    else
      tmp$_0 = new Cbor$CborWriter(this.$outer, this.encoder);
    var writer = tmp$_0;
    writer.writeBeginToken();
    return writer;
  };
  Cbor$CborWriter.prototype.endStructure_qatsm0$ = function (descriptor) {
    this.encoder.end();
  };
  Cbor$CborWriter.prototype.encodeElement_3zr2iy$ = function (descriptor, index) {
    var name = descriptor.getElementName_za3lpa$(index);
    this.encoder.encodeString_61zpoe$(name);
    return true;
  };
  Cbor$CborWriter.prototype.encodeString_61zpoe$ = function (value) {
    this.encoder.encodeString_61zpoe$(value);
  };
  Cbor$CborWriter.prototype.encodeFloat_mx4ult$ = function (value) {
    this.encoder.encodeFloat_mx4ult$(value);
  };
  Cbor$CborWriter.prototype.encodeDouble_14dthe$ = function (value) {
    this.encoder.encodeDouble_14dthe$(value);
  };
  Cbor$CborWriter.prototype.encodeChar_s8itvh$ = function (value) {
    this.encoder.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value | 0));
  };
  Cbor$CborWriter.prototype.encodeByte_s8j3t7$ = function (value) {
    this.encoder.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value));
  };
  Cbor$CborWriter.prototype.encodeShort_mq22fl$ = function (value) {
    this.encoder.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value));
  };
  Cbor$CborWriter.prototype.encodeInt_za3lpa$ = function (value) {
    this.encoder.encodeNumber_s8cxhz$(Kotlin.Long.fromInt(value));
  };
  Cbor$CborWriter.prototype.encodeLong_s8cxhz$ = function (value) {
    this.encoder.encodeNumber_s8cxhz$(value);
  };
  Cbor$CborWriter.prototype.encodeBoolean_6taknv$ = function (value) {
    this.encoder.encodeBoolean_6taknv$(value);
  };
  Cbor$CborWriter.prototype.encodeNull = function () {
    this.encoder.encodeNull();
  };
  Cbor$CborWriter.prototype.encodeEnum_3zr2iy$ = function (enumDescriptor, index) {
    this.encoder.encodeString_61zpoe$(enumDescriptor.getElementName_za3lpa$(index));
  };
  Cbor$CborWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborWriter',
    interfaces: [AbstractEncoder]
  };
  function Cbor$CborEncoder(output) {
    this.output = output;
  }
  Cbor$CborEncoder.prototype.startArray = function () {
    this.output.write_za3lpa$(159);
  };
  Cbor$CborEncoder.prototype.startMap = function () {
    this.output.write_za3lpa$(191);
  };
  Cbor$CborEncoder.prototype.end = function () {
    this.output.write_za3lpa$(255);
  };
  Cbor$CborEncoder.prototype.encodeNull = function () {
    this.output.write_za3lpa$(246);
  };
  Cbor$CborEncoder.prototype.encodeBoolean_6taknv$ = function (value) {
    this.output.write_za3lpa$(value ? 245 : 244);
  };
  Cbor$CborEncoder.prototype.encodeNumber_s8cxhz$ = function (value) {
    this.output.write_fqrh44$(this.composeNumber_0(value));
  };
  Cbor$CborEncoder.prototype.encodeString_61zpoe$ = function (value) {
    var data = encodeToByteArray(value);
    var header = this.composeNumber_0(Kotlin.Long.fromInt(data.length));
    header[0] = toByte(header[0] | Cbor$Default_getInstance().HEADER_STRING_0);
    this.output.write_fqrh44$(header);
    this.output.write_fqrh44$(data);
  };
  Cbor$CborEncoder.prototype.encodeFloat_mx4ult$ = function (value) {
    this.output.write_za3lpa$(250);
    var bits = toRawBits(value);
    for (var i = 0; i <= 3; i++) {
      this.output.write_za3lpa$(bits >> 24 - (8 * i | 0) & 255);
    }
  };
  Cbor$CborEncoder.prototype.encodeDouble_14dthe$ = function (value) {
    this.output.write_za3lpa$(251);
    var bits = toRawBits_0(value);
    for (var i = 0; i <= 7; i++) {
      this.output.write_za3lpa$(bits.shiftRight(56 - (8 * i | 0) | 0).and(L255).toInt());
    }
  };
  Cbor$CborEncoder.prototype.composeNumber_0 = function (value) {
    return value.toNumber() >= 0 ? this.composePositive_0(value) : this.composeNegative_0(value);
  };
  Cbor$CborEncoder.prototype.composePositive_0 = function (value) {
    if (contains(new IntRange(0, 23), value))
      return new Int8Array([toByte(value.toInt())]);
    else if (contains(new IntRange(24, kotlin_js_internal_ByteCompanionObject.MAX_VALUE), value))
      return new Int8Array([24, toByte(value.toInt())]);
    else if (contains(new IntRange(128, kotlin_js_internal_ShortCompanionObject.MAX_VALUE), value))
      return this.encodeToByteArray_0(value, 2, 25);
    else if (contains(new IntRange(32768, 2147483647), value))
      return this.encodeToByteArray_0(value, 4, 26);
    else if (L2147483648.lessThanOrEqual(value) && value.lessThanOrEqual(Long$Companion$MAX_VALUE))
      return this.encodeToByteArray_0(value, 8, 27);
    else
      throw AssertionError_init(value.toString() + ' should be positive');
  };
  Cbor$CborEncoder.prototype.encodeToByteArray_0 = function (value, bytes, tag) {
    var result = new Int8Array(bytes + 1 | 0);
    var limit = (bytes * 8 | 0) - 8 | 0;
    result[0] = tag;
    for (var i = 0; i < bytes; i++) {
      result[i + 1 | 0] = toByte(value.shiftRight(limit - (8 * i | 0) | 0).and(L255).toInt());
    }
    return result;
  };
  Cbor$CborEncoder.prototype.composeNegative_0 = function (value) {
    var aVal = equals(value, Long$Companion$MIN_VALUE) ? Long$Companion$MAX_VALUE : Kotlin.Long.fromInt(-1).subtract(value);
    var data = this.composePositive_0(aVal);
    data[0] = toByte(data[0] | Cbor$Default_getInstance().HEADER_NEGATIVE_0);
    return data;
  };
  Cbor$CborEncoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborEncoder',
    interfaces: []
  };
  function Cbor$CborMapReader($outer, decoder) {
    this.$outer = $outer;
    Cbor$CborListReader.call(this, this.$outer, decoder);
  }
  Cbor$CborMapReader.prototype.skipBeginToken = function () {
    this.setSize_0(this.decoder.startMap() * 2 | 0);
  };
  Cbor$CborMapReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborMapReader',
    interfaces: [Cbor$CborListReader]
  };
  function Cbor$CborListReader($outer, decoder) {
    this.$outer = $outer;
    Cbor$CborReader.call(this, this.$outer, decoder);
    this.ind_0 = 0;
  }
  Cbor$CborListReader.prototype.skipBeginToken = function () {
    this.setSize_0(this.decoder.startArray());
  };
  Cbor$CborListReader.prototype.decodeElementIndex_qatsm0$ = function (descriptor) {
    var tmp$;
    return !this.finiteMode_0 && this.decoder.isEnd() || (this.finiteMode_0 && this.ind_0 >= this.size_0) ? -1 : (tmp$ = this.ind_0, this.ind_0 = tmp$ + 1 | 0, tmp$);
  };
  Cbor$CborListReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborListReader',
    interfaces: [Cbor$CborReader]
  };
  function Cbor$CborReader($outer, decoder) {
    this.$outer = $outer;
    AbstractDecoder.call(this);
    this.decoder = decoder;
    this.size_1uqt39$_0 = -1;
    this.finiteMode_6n8ees$_0 = false;
    this.readProperties_0 = 0;
  }
  Object.defineProperty(Cbor$CborReader.prototype, 'size_0', {
    get: function () {
      return this.size_1uqt39$_0;
    },
    set: function (size) {
      this.size_1uqt39$_0 = size;
    }
  });
  Object.defineProperty(Cbor$CborReader.prototype, 'finiteMode_0', {
    get: function () {
      return this.finiteMode_6n8ees$_0;
    },
    set: function (finiteMode) {
      this.finiteMode_6n8ees$_0 = finiteMode;
    }
  });
  Cbor$CborReader.prototype.setSize_0 = function (size) {
    if (size >= 0) {
      this.finiteMode_0 = true;
      this.size_0 = size;
    }};
  Object.defineProperty(Cbor$CborReader.prototype, 'context', {
    get: function () {
      return this.$outer.context;
    }
  });
  Object.defineProperty(Cbor$CborReader.prototype, 'updateMode', {
    get: function () {
      return this.$outer.updateMode;
    }
  });
  Cbor$CborReader.prototype.skipBeginToken = function () {
    this.setSize_0(this.decoder.startMap());
  };
  Cbor$CborReader.prototype.beginStructure_r0sa6z$ = function (descriptor, typeParams) {
    var tmp$, tmp$_0;
    tmp$ = descriptor.kind;
    if (equals(tmp$, StructureKind.LIST) || Kotlin.isType(tmp$, PolymorphicKind))
      tmp$_0 = new Cbor$CborListReader(this.$outer, this.decoder);
    else if (equals(tmp$, StructureKind.MAP))
      tmp$_0 = new Cbor$CborMapReader(this.$outer, this.decoder);
    else
      tmp$_0 = new Cbor$CborReader(this.$outer, this.decoder);
    var re = tmp$_0;
    re.skipBeginToken();
    return re;
  };
  Cbor$CborReader.prototype.endStructure_qatsm0$ = function (descriptor) {
    if (!this.finiteMode_0)
      this.decoder.end();
  };
  Cbor$CborReader.prototype.decodeElementIndex_qatsm0$ = function (descriptor) {
    if (!this.finiteMode_0 && this.decoder.isEnd() || (this.finiteMode_0 && this.readProperties_0 >= this.size_0))
      return -1;
    var elemName = this.decoder.nextString();
    this.readProperties_0 = this.readProperties_0 + 1 | 0;
    return getElementIndexOrThrow(descriptor, elemName);
  };
  Cbor$CborReader.prototype.decodeString = function () {
    return this.decoder.nextString();
  };
  Cbor$CborReader.prototype.decodeNotNullMark = function () {
    return !this.decoder.isNull();
  };
  Cbor$CborReader.prototype.decodeDouble = function () {
    return this.decoder.nextDouble();
  };
  Cbor$CborReader.prototype.decodeFloat = function () {
    return this.decoder.nextFloat();
  };
  Cbor$CborReader.prototype.decodeBoolean = function () {
    return this.decoder.nextBoolean();
  };
  Cbor$CborReader.prototype.decodeByte = function () {
    return toByte(this.decoder.nextNumber().toInt());
  };
  Cbor$CborReader.prototype.decodeShort = function () {
    return toShort(this.decoder.nextNumber().toInt());
  };
  Cbor$CborReader.prototype.decodeChar = function () {
    return toBoxedChar(toChar(this.decoder.nextNumber().toInt()));
  };
  Cbor$CborReader.prototype.decodeInt = function () {
    return this.decoder.nextNumber().toInt();
  };
  Cbor$CborReader.prototype.decodeLong = function () {
    return this.decoder.nextNumber();
  };
  Cbor$CborReader.prototype.decodeNull = function () {
    return this.decoder.nextNull();
  };
  Cbor$CborReader.prototype.decodeEnum_qatsm0$ = function (enumDescriptor) {
    return getElementIndexOrThrow(enumDescriptor, this.decoder.nextString());
  };
  Cbor$CborReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborReader',
    interfaces: [AbstractDecoder]
  };
  function Cbor$CborDecoder(input) {
    this.input = input;
    this.curByte_0 = -1;
    this.readByte_0();
  }
  Cbor$CborDecoder.prototype.readByte_0 = function () {
    this.curByte_0 = this.input.read();
    return this.curByte_0;
  };
  Cbor$CborDecoder.prototype.skipByte_0 = function (expected) {
    if (this.curByte_0 !== expected)
      throw new CborDecodingException('byte ' + printByte(expected), this.curByte_0);
    this.readByte_0();
  };
  Cbor$CborDecoder.prototype.isNull = function () {
    return this.curByte_0 === 246;
  };
  Cbor$CborDecoder.prototype.nextNull = function () {
    this.skipByte_0(246);
    return null;
  };
  Cbor$CborDecoder.prototype.nextBoolean = function () {
    var tmp$;
    switch (this.curByte_0) {
      case 245:
        tmp$ = true;
        break;
      case 244:
        tmp$ = false;
        break;
      default:throw new CborDecodingException('boolean value', this.curByte_0);
    }
    var ans = tmp$;
    this.readByte_0();
    return ans;
  };
  Cbor$CborDecoder.prototype.startArray = function () {
    return this.startSized_0(159, 128, 'array');
  };
  Cbor$CborDecoder.prototype.startMap = function () {
    return this.startSized_0(191, 160, 'map');
  };
  Cbor$CborDecoder.prototype.startSized_0 = function (unboundedHeader, boundedHeaderMask, collectionType) {
    if (this.curByte_0 === unboundedHeader) {
      this.skipByte_0(unboundedHeader);
      return -1;
    }if ((this.curByte_0 & 224) !== boundedHeaderMask)
      throw new CborDecodingException('start of ' + collectionType, this.curByte_0);
    var size = this.readNumber_0().toInt();
    this.readByte_0();
    return size;
  };
  Cbor$CborDecoder.prototype.isEnd = function () {
    return this.curByte_0 === 255;
  };
  Cbor$CborDecoder.prototype.end = function () {
    this.skipByte_0(255);
  };
  Cbor$CborDecoder.prototype.nextString = function () {
    if ((this.curByte_0 & 224) !== 96)
      throw new CborDecodingException('start of string', this.curByte_0);
    var strLen = this.readNumber_0().toInt();
    var arr = readExactNBytes(this.input, strLen);
    var ans = decodeToString(arr);
    this.readByte_0();
    return ans;
  };
  Cbor$CborDecoder.prototype.nextNumber = function () {
    var res = this.readNumber_0();
    this.readByte_0();
    return res;
  };
  Cbor$CborDecoder.prototype.readNumber_0 = function () {
    var tmp$;
    var value = this.curByte_0 & 31;
    var negative = (this.curByte_0 & 224) === 32;
    switch (value) {
      case 24:
        tmp$ = 1;
        break;
      case 25:
        tmp$ = 2;
        break;
      case 26:
        tmp$ = 4;
        break;
      case 27:
        tmp$ = 8;
        break;
      default:tmp$ = 0;
        break;
    }
    var bytesToRead = tmp$;
    if (bytesToRead === 0) {
      return negative ? Kotlin.Long.fromInt(value + 1 | 0).unaryMinus() : Kotlin.Long.fromInt(value);
    }var res = this.readExact_0(this.input, bytesToRead);
    return negative ? res.add(Kotlin.Long.fromInt(1)).unaryMinus() : res;
  };
  Cbor$CborDecoder.prototype.readExact_0 = function ($receiver, bytes) {
    var arr = readExactNBytes($receiver, bytes);
    var result = L0;
    for (var i = 0; i < bytes; i++) {
      result = result.shiftLeft(8).or(Kotlin.Long.fromInt(arr[i] & 255));
    }
    return result;
  };
  Cbor$CborDecoder.prototype.nextFloat = function () {
    if (this.curByte_0 !== 250)
      throw new CborDecodingException('float header', this.curByte_0);
    var bits = this.readInt_0();
    var res = Kotlin.floatFromBits(bits);
    this.readByte_0();
    return res;
  };
  Cbor$CborDecoder.prototype.nextDouble = function () {
    if (this.curByte_0 !== 251)
      throw new CborDecodingException('double header', this.curByte_0);
    var bits = this.readLong_0();
    var res = Kotlin.doubleFromBits(bits);
    this.readByte_0();
    return res;
  };
  Cbor$CborDecoder.prototype.readLong_0 = function () {
    var result = L0;
    for (var i = 0; i <= 7; i++) {
      var byte = this.input.read();
      result = result.shiftLeft(8).or(Kotlin.Long.fromInt(byte));
    }
    return result;
  };
  Cbor$CborDecoder.prototype.readInt_0 = function () {
    var result = 0;
    for (var i = 0; i <= 3; i++) {
      var byte = this.input.read();
      result = result << 8 | byte;
    }
    return result;
  };
  Cbor$CborDecoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborDecoder',
    interfaces: []
  };
  function Cbor$Default() {
    Cbor$Default_instance = this;
    this.$delegate_rhiqy4$_0 = new Cbor();
    this.FALSE_0 = 244;
    this.TRUE_0 = 245;
    this.NULL_0 = 246;
    this.NEXT_FLOAT_0 = 250;
    this.NEXT_DOUBLE_0 = 251;
    this.BEGIN_ARRAY_0 = 159;
    this.BEGIN_MAP_0 = 191;
    this.BREAK_0 = 255;
    this.HEADER_STRING_0 = 96;
    this.HEADER_NEGATIVE_0 = 32;
    this.HEADER_ARRAY_0 = 128;
    this.HEADER_MAP_0 = 160;
    this.plain = new Cbor();
  }
  Object.defineProperty(Cbor$Default.prototype, 'context', {
    get: function () {
      return this.$delegate_rhiqy4$_0.context;
    }
  });
  Cbor$Default.prototype.dump_tf03ej$ = function (serializer, value) {
    return this.$delegate_rhiqy4$_0.dump_tf03ej$(serializer, value);
  };
  Cbor$Default.prototype.load_dntfbn$ = function (deserializer, bytes) {
    return this.$delegate_rhiqy4$_0.load_dntfbn$(deserializer, bytes);
  };
  Cbor$Default.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Default',
    interfaces: [BinaryFormat]
  };
  var Cbor$Default_instance = null;
  function Cbor$Default_getInstance() {
    if (Cbor$Default_instance === null) {
      new Cbor$Default();
    }return Cbor$Default_instance;
  }
  Cbor.prototype.dump_tf03ej$ = function (serializer, value) {
    var output = ByteArrayOutputStream_init();
    var dumper = new Cbor$CborWriter(this, new Cbor$CborEncoder(output));
    encode(dumper, serializer, value);
    return output.toByteArray();
  };
  Cbor.prototype.load_dntfbn$ = function (deserializer, bytes) {
    var stream = ByteArrayInputStream_init(bytes);
    var reader = new Cbor$CborReader(this, new Cbor$CborDecoder(stream));
    return decode(reader, deserializer);
  };
  Cbor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Cbor',
    interfaces: [BinaryFormat]
  };
  function CborDecodingException(expected, foundByte) {
    SerializationException.call(this, 'Expected ' + expected + ', but found ' + printByte(foundByte));
    this.name = 'CborDecodingException';
  }
  CborDecodingException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CborDecodingException',
    interfaces: [SerializationException]
  };
  function printByte(b) {
    var hexCode = '0123456789ABCDEF';
    var $receiver = StringBuilder_init();
    $receiver.append_s8itvh$(hexCode.charCodeAt(b >> 4 & 15));
    $receiver.append_s8itvh$(hexCode.charCodeAt(b & 15));
    return $receiver.toString();
  }
  Cbor.CborEncoder = Cbor$CborEncoder;
  Cbor.CborDecoder = Cbor$CborDecoder;
  Object.defineProperty(Cbor, 'Default', {
    get: Cbor$Default_getInstance
  });
  var package$kotlinx = _.kotlinx || (_.kotlinx = {});
  var package$serialization = package$kotlinx.serialization || (package$kotlinx.serialization = {});
  var package$cbor = package$serialization.cbor || (package$serialization.cbor = {});
  package$cbor.Cbor = Cbor;
  package$cbor.CborDecodingException = CborDecodingException;
  package$cbor.printByte_kcn2v3$ = printByte;
  Kotlin.defineModule('kotlinx-serialization-kotlinx-serialization-cbor', _);
  return _;
}));

//# sourceMappingURL=kotlinx-serialization-kotlinx-serialization-cbor.js.map
