package kotlinx.html

import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlinx.html.*
import kotlinx.html.impl.*
import kotlinx.html.attributes.*

/*******************************************************************************
    DO NOT EDIT
    This file was generated by module generate
*******************************************************************************/

@Suppress("unused")
open class TABLE(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("table", consumer, initialAttributes, null, false, false), HtmlBlockTag {
    var summary : String
        get()  = attributeStringString[this, "summary"]
        set(newValue) {attributeStringString[this, "summary"] = newValue}


}
/**
 * Table caption
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TABLE.caption(classes : String? = null, crossinline block : CAPTION.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    CAPTION(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Table column group
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TABLE.colGroup(classes : String? = null, crossinline block : COLGROUP.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    COLGROUP(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Table header
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TABLE.thead(classes : String? = null, crossinline block : THEAD.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    THEAD(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Table footer
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TABLE.tfoot(classes : String? = null, crossinline block : TFOOT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TFOOT(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Table body
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TABLE.tbody(classes : String? = null, crossinline block : TBODY.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TBODY(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Table row
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TABLE.tr(classes : String? = null, crossinline block : TR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TR(attributesMapOf("class", classes), consumer).visit(block)
}


@Suppress("unused")
open class TBODY(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("tbody", consumer, initialAttributes, null, false, false), CommonAttributeGroupFacade {

}
/**
 * Table row
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TBODY.tr(classes : String? = null, crossinline block : TR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TR(attributesMapOf("class", classes), consumer).visit(block)
}


@Suppress("unused")
open class TD(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("td", consumer, initialAttributes, null, false, false), HtmlBlockTag {
    var headers : String
        get()  = attributeStringString[this, "headers"]
        set(newValue) {attributeStringString[this, "headers"] = newValue}

    var rowSpan : String
        get()  = attributeStringString[this, "rowspan"]
        set(newValue) {attributeStringString[this, "rowspan"] = newValue}

    var colSpan : String
        get()  = attributeStringString[this, "colspan"]
        set(newValue) {attributeStringString[this, "colspan"] = newValue}


}

@Suppress("unused")
open class TEMPLATE(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("template", consumer, initialAttributes, null, false, false), HtmlBlockInlineTag {

}
val TEMPLATE.asFlowContent : FlowContent
    get()  = this

val TEMPLATE.asPhrasingContent : PhrasingContent
    get()  = this


@Suppress("unused")
open class TEXTAREA(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("textarea", consumer, initialAttributes, null, true, false), CommonAttributeGroupFacadeFlowInteractivePhrasingContent {
    var autoFocus : Boolean
        get()  = attributeBooleanTicker[this, "autofocus"]
        set(newValue) {attributeBooleanTicker[this, "autofocus"] = newValue}

    var disabled : Boolean
        get()  = attributeBooleanTicker[this, "disabled"]
        set(newValue) {attributeBooleanTicker[this, "disabled"] = newValue}

    var form : String
        get()  = attributeStringString[this, "form"]
        set(newValue) {attributeStringString[this, "form"] = newValue}

    var maxLength : String
        get()  = attributeStringString[this, "maxlength"]
        set(newValue) {attributeStringString[this, "maxlength"] = newValue}

    var minLength : String
        get()  = attributeStringString[this, "minlength"]
        set(newValue) {attributeStringString[this, "minlength"] = newValue}

    var name : String
        get()  = attributeStringString[this, "name"]
        set(newValue) {attributeStringString[this, "name"] = newValue}

    var placeholder : String
        get()  = attributeStringString[this, "placeholder"]
        set(newValue) {attributeStringString[this, "placeholder"] = newValue}

    var readonly : Boolean
        get()  = attributeBooleanTicker[this, "readonly"]
        set(newValue) {attributeBooleanTicker[this, "readonly"] = newValue}

    var required : Boolean
        get()  = attributeBooleanTicker[this, "required"]
        set(newValue) {attributeBooleanTicker[this, "required"] = newValue}

    var rows : String
        get()  = attributeStringString[this, "rows"]
        set(newValue) {attributeStringString[this, "rows"] = newValue}

    var cols : String
        get()  = attributeStringString[this, "cols"]
        set(newValue) {attributeStringString[this, "cols"] = newValue}

    var wrap : TextAreaWrap
        get()  = attributeTextAreaWrapEnumTextAreaWrapValues[this, "wrap"]
        set(newValue) {attributeTextAreaWrapEnumTextAreaWrapValues[this, "wrap"] = newValue}


}
val TEXTAREA.asFlowContent : FlowContent
    get()  = this

val TEXTAREA.asInteractiveContent : InteractiveContent
    get()  = this

val TEXTAREA.asPhrasingContent : PhrasingContent
    get()  = this


@Suppress("unused")
open class TFOOT(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("tfoot", consumer, initialAttributes, null, false, false), CommonAttributeGroupFacade {

}
/**
 * Table row
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TFOOT.tr(classes : String? = null, crossinline block : TR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TR(attributesMapOf("class", classes), consumer).visit(block)
}


@Suppress("unused")
open class TH(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("th", consumer, initialAttributes, null, false, false), HtmlInlineTag {
    var headers : String
        get()  = attributeStringString[this, "headers"]
        set(newValue) {attributeStringString[this, "headers"] = newValue}

    var rowSpan : String
        get()  = attributeStringString[this, "rowspan"]
        set(newValue) {attributeStringString[this, "rowspan"] = newValue}

    var colSpan : String
        get()  = attributeStringString[this, "colspan"]
        set(newValue) {attributeStringString[this, "colspan"] = newValue}

    var scope : ThScope
        get()  = attributeThScopeEnumThScopeValues[this, "scope"]
        set(newValue) {attributeThScopeEnumThScopeValues[this, "scope"] = newValue}


}

@Suppress("unused")
open class THEAD(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("thead", consumer, initialAttributes, null, false, false), CommonAttributeGroupFacade {

}
/**
 * Table row
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun THEAD.tr(classes : String? = null, crossinline block : TR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TR(attributesMapOf("class", classes), consumer).visit(block)
}


@Suppress("unused")
open class TIME(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("time", consumer, initialAttributes, null, true, false), HtmlBlockInlineTag {
    var dateTime : String
        get()  = attributeStringString[this, "datetime"]
        set(newValue) {attributeStringString[this, "datetime"] = newValue}


}
val TIME.asFlowContent : FlowContent
    get()  = this

val TIME.asPhrasingContent : PhrasingContent
    get()  = this


@Suppress("unused")
open class TITLE(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("title", consumer, initialAttributes, null, false, false), HtmlHeadTag {

}

@Suppress("unused")
open class TR(initialAttributes : Map<String, String>, override val consumer : TagConsumer<*>) : HTMLTag("tr", consumer, initialAttributes, null, false, false), CommonAttributeGroupFacade {

}
/**
 * Table header cell
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TR.th(scope : ThScope? = null, classes : String? = null, crossinline block : TH.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TH(attributesMapOf("scope", scope?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TR.colTh(classes : String? = null, crossinline block : TH.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TH(attributesMapOf("scope", ThScope.col.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TR.colGroupTh(classes : String? = null, crossinline block : TH.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TH(attributesMapOf("scope", ThScope.colGroup.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TR.rowTh(classes : String? = null, crossinline block : TH.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TH(attributesMapOf("scope", ThScope.row.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TR.rowGroupTh(classes : String? = null, crossinline block : TH.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TH(attributesMapOf("scope", ThScope.rowGroup.realValue,"class", classes), consumer).visit(block)
}

/**
 * Table data cell
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun TR.td(classes : String? = null, crossinline block : TD.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TD(attributesMapOf("class", classes), consumer).visit(block)
}


