package kotlinx.html

import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlinx.html.*
import kotlinx.html.impl.*
import kotlinx.html.attributes.*

/*******************************************************************************
    DO NOT EDIT
    This file was generated by module generate
*******************************************************************************/

interface FlowContent : FlowOrMetaDataOrPhrasingContent, FlowOrHeadingContent, FlowOrMetaDataContent, FlowOrInteractiveContent, FlowOrPhrasingContent, SectioningOrFlowContent, FlowOrInteractiveOrPhrasingContent, Tag {
}

interface HeadingContent : FlowOrHeadingContent, Tag {
}

interface InteractiveContent : FlowOrInteractiveContent, FlowOrInteractiveOrPhrasingContent, Tag {
}

interface MetaDataContent : FlowOrMetaDataOrPhrasingContent, FlowOrMetaDataContent, Tag {
}

interface PhrasingContent : FlowOrMetaDataOrPhrasingContent, FlowOrPhrasingContent, FlowOrInteractiveOrPhrasingContent, Tag {
}

interface SectioningContent : SectioningOrFlowContent, Tag {
}

/**
 * Information on author
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.address(classes : String? = null, crossinline block : ADDRESS.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    ADDRESS(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Long quotation
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.blockQuote(classes : String? = null, crossinline block : BLOCKQUOTE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BLOCKQUOTE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Dialog box or window
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.dialog(classes : String? = null, crossinline block : DIALOG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DIALOG(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Generic language/style container
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.div(classes : String? = null, crossinline block : DIV.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DIV(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Definition list
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.dl(classes : String? = null, crossinline block : DL.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DL(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Form control group
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.fieldSet(classes : String? = null, crossinline block : FIELDSET.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FIELDSET(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Figure with optional caption
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.figure(classes : String? = null, crossinline block : FIGURE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FIGURE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Caption for 
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.figcaption(classes : String? = null, crossinline block : FIGCAPTION.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FIGCAPTION(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Footer for a page or section
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.footer(classes : String? = null, crossinline block : FOOTER.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FOOTER(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Interactive form
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.form(action : String? = null, encType : FormEncType? = null, method : FormMethod? = null, classes : String? = null, crossinline block : FORM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", method?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.getForm(action : String? = null, encType : FormEncType? = null, classes : String? = null, crossinline block : FORM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", FormMethod.get.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.postForm(action : String? = null, encType : FormEncType? = null, classes : String? = null, crossinline block : FORM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", FormMethod.post.realValue,"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.putForm(action : String? = null, encType : FormEncType? = null, classes : String? = null, crossinline block : FORM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", FormMethod.put.realValue,"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.deleteForm(action : String? = null, encType : FormEncType? = null, classes : String? = null, crossinline block : FORM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", FormMethod.delete.realValue,"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.patchForm(action : String? = null, encType : FormEncType? = null, classes : String? = null, crossinline block : FORM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    FORM(attributesMapOf("action", action,"enctype", encType?.enumEncode(),"method", FormMethod.patch.realValue,"class", classes), consumer).visit(block)
}

/**
 * Introductory or navigational aids for a page or section
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.header(classes : String? = null, crossinline block : HEADER.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    HEADER(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Horizontal rule
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.hr(classes : String? = null, crossinline block : HR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    HR(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Ordered list
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.ol(classes : String? = null, crossinline block : OL.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    OL(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Paragraph
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.p(classes : String? = null, crossinline block : P.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    P(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Preformatted text
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.pre(classes : String? = null, crossinline block : PRE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    PRE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Caption for 
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.summary(classes : String? = null, crossinline block : SUMMARY.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SUMMARY(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * 
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.table(classes : String? = null, crossinline block : TABLE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TABLE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Underlined text style
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.u(classes : String? = null, crossinline block : U.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    U(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Unordered list
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.ul(classes : String? = null, crossinline block : UL.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    UL(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Strike-through text style
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowContent.s(classes : String? = null, crossinline block : S.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    S(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Document base URI
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun MetaDataContent.base(classes : String? = null, crossinline block : BASE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BASE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Document title
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun MetaDataContent.title(crossinline block : TITLE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TITLE(emptyMap, consumer).visit(block)
}
/**
 * Document title
 */
@HtmlTagMarker
fun MetaDataContent.title(content : String = "") : Unit = TITLE(emptyMap, consumer).visit({+content})

@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun PhrasingContent.slot(classes : String? = null, crossinline block : SLOT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SLOT(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Template
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun PhrasingContent.template(classes : String? = null, crossinline block : TEMPLATE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEMPLATE(attributesMapOf("class", classes), consumer).visit(block)
}

