package kotlinx.html

import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.InvocationKind
import kotlin.contracts.contract
import kotlinx.html.*
import kotlinx.html.impl.*
import kotlinx.html.attributes.*

/*******************************************************************************
    DO NOT EDIT
    This file was generated by module generate
*******************************************************************************/

interface FlowOrMetaDataOrPhrasingContent : Tag {
}

interface FlowOrHeadingContent : Tag {
}

interface FlowOrMetaDataContent : FlowOrMetaDataOrPhrasingContent, Tag {
}

interface FlowOrInteractiveContent : FlowOrInteractiveOrPhrasingContent, Tag {
}

interface FlowOrPhrasingContent : FlowOrInteractiveOrPhrasingContent, FlowOrMetaDataOrPhrasingContent, Tag {
}

interface SectioningOrFlowContent : Tag {
}

interface FlowOrInteractiveOrPhrasingContent : Tag {
}



@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.command(type : CommandType? = null, classes : String? = null, crossinline block : COMMAND.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    COMMAND(attributesMapOf("type", type?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.commandCommand(classes : String? = null, crossinline block : COMMAND.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    COMMAND(attributesMapOf("type", CommandType.command.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.checkBoxCommand(classes : String? = null, crossinline block : COMMAND.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    COMMAND(attributesMapOf("type", CommandType.checkBox.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.radioCommand(classes : String? = null, crossinline block : COMMAND.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    COMMAND(attributesMapOf("type", CommandType.radio.realValue,"class", classes), consumer).visit(block)
}

/**
 * A media-independent link
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.link(href : String? = null, rel : String? = null, type : String? = null, htmlAs : LinkAs? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", htmlAs?.enumEncode()), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.audioLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.audio.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.documentLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.document.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.embedLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.embed.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.fetchLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.fetch.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.fontLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.font.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.imageLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.image.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.htmlObjectLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.htmlObject.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.scriptLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.script.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.styleLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.style.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.trackLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.track.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.videoLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.video.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.workerLink(href : String? = null, rel : String? = null, type : String? = null, crossinline block : LINK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LINK(attributesMapOf("href", href,"rel", rel,"type", type,"as", LinkAs.worker.realValue), consumer).visit(block)
}

/**
 * Generic metainformation
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.meta(name : String? = null, content : String? = null, charset : String? = null, crossinline block : META.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    META(attributesMapOf("name", name,"content", content,"charset", charset), consumer).visit(block)
}

/**
 * Generic metainformation
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.noScript(classes : String? = null, crossinline block : NOSCRIPT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    NOSCRIPT(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Script statements
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.script(type : String? = null, src : String? = null, crossorigin : ScriptCrossorigin? = null, crossinline block : SCRIPT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SCRIPT(attributesMapOf("type", type,"src", src,"crossorigin", crossorigin?.enumEncode()), consumer).visit(block)
}
@Suppress("DEPRECATION", "DeprecatedCallableAddReplaceWith")
@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
/**
 * Script statements
 */
@HtmlTagMarker
fun FlowOrMetaDataOrPhrasingContent.script(type : String? = null, src : String? = null, crossorigin : ScriptCrossorigin? = null, content : String = "") : Unit = SCRIPT(attributesMapOf("type", type,"src", src,"crossorigin", crossorigin?.enumEncode()), consumer).visit({+content})
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.anonymousScript(type : String? = null, src : String? = null, crossinline block : SCRIPT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SCRIPT(attributesMapOf("type", type,"src", src,"crossorigin", ScriptCrossorigin.anonymous.realValue), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataOrPhrasingContent.useCredentialsScript(type : String? = null, src : String? = null, crossinline block : SCRIPT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SCRIPT(attributesMapOf("type", type,"src", src,"crossorigin", ScriptCrossorigin.useCredentials.realValue), consumer).visit(block)
}
@Suppress("DEPRECATION", "DeprecatedCallableAddReplaceWith")
@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
@HtmlTagMarker
fun FlowOrMetaDataOrPhrasingContent.anonymousScript(type : String? = null, src : String? = null, content : String = "") : Unit = SCRIPT(attributesMapOf("type", type,"src", src,"crossorigin", ScriptCrossorigin.anonymous.realValue), consumer).visit({+content})
@HtmlTagMarker
fun FlowOrMetaDataOrPhrasingContent.useCredentialsScript(type : String? = null, src : String? = null, content : String = "") : Unit = SCRIPT(attributesMapOf("type", type,"src", src,"crossorigin", ScriptCrossorigin.useCredentials.realValue), consumer).visit({+content})


/**
 * Heading
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.h1(classes : String? = null, crossinline block : H1.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    H1(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Heading
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.h2(classes : String? = null, crossinline block : H2.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    H2(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Heading
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.h3(classes : String? = null, crossinline block : H3.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    H3(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Heading
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.h4(classes : String? = null, crossinline block : H4.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    H4(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Heading
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.h5(classes : String? = null, crossinline block : H5.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    H5(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Heading
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.h6(classes : String? = null, crossinline block : H6.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    H6(attributesMapOf("class", classes), consumer).visit(block)
}

@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrHeadingContent.hGroup(classes : String? = null, crossinline block : HGROUP.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    HGROUP(attributesMapOf("class", classes), consumer).visit(block)
}


/**
 * Style info
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrMetaDataContent.style(type : String? = null, crossinline block : STYLE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    STYLE(attributesMapOf("type", type), consumer).visit(block)
}
@Suppress("DEPRECATION", "DeprecatedCallableAddReplaceWith")
@Deprecated("This tag doesn't support content or requires unsafe (try unsafe {})")
/**
 * Style info
 */
@HtmlTagMarker
fun FlowOrMetaDataContent.style(type : String? = null, content : String = "") : Unit = STYLE(attributesMapOf("type", type), consumer).visit({+content})


/**
 * Disclosure control for hiding details
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveContent.details(classes : String? = null, crossinline block : DETAILS.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DETAILS(attributesMapOf("class", classes), consumer).visit(block)
}


/**
 * Abbreviated form (e.g., WWW, HTTP,etc.)
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.abbr(classes : String? = null, crossinline block : ABBR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    ABBR(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Client-side image map area
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.area(shape : AreaShape? = null, alt : String? = null, classes : String? = null, crossinline block : AREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    AREA(attributesMapOf("shape", shape?.enumEncode(),"alt", alt,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.rectArea(alt : String? = null, classes : String? = null, crossinline block : AREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    AREA(attributesMapOf("shape", AreaShape.rect.realValue,"alt", alt,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.circleArea(alt : String? = null, classes : String? = null, crossinline block : AREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    AREA(attributesMapOf("shape", AreaShape.circle.realValue,"alt", alt,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.polyArea(alt : String? = null, classes : String? = null, crossinline block : AREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    AREA(attributesMapOf("shape", AreaShape.poly.realValue,"alt", alt,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.defaultArea(alt : String? = null, classes : String? = null, crossinline block : AREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    AREA(attributesMapOf("shape", AreaShape.default.realValue,"alt", alt,"class", classes), consumer).visit(block)
}

/**
 * Bold text style
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.b(classes : String? = null, crossinline block : B.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    B(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Text directionality isolation
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.bdi(classes : String? = null, crossinline block : BDI.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BDI(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * I18N BiDi over-ride
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.bdo(classes : String? = null, crossinline block : BDO.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BDO(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Forced line break
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.br(classes : String? = null, crossinline block : BR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BR(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Scriptable bitmap canvas
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.canvas(classes : String? = null, crossinline block : CANVAS.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    CANVAS(attributesMapOf("class", classes), consumer).visit(block)
}
/**
 * Scriptable bitmap canvas
 */
@HtmlTagMarker
fun FlowOrPhrasingContent.canvas(classes : String? = null, content : String = "") : Unit = CANVAS(attributesMapOf("class", classes), consumer).visit({+content})

/**
 * Citation
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.cite(classes : String? = null, crossinline block : CITE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    CITE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Computer code fragment
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.code(classes : String? = null, crossinline block : CODE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    CODE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Container for options for 
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.dataList(classes : String? = null, crossinline block : DATALIST.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DATALIST(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Deleted text
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.del(classes : String? = null, crossinline block : DEL.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DEL(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Instance definition
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.dfn(classes : String? = null, crossinline block : DFN.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    DFN(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Emphasis
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.em(classes : String? = null, crossinline block : EM.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    EM(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Italic text style
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.i(classes : String? = null, crossinline block : I.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    I(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Inserted text
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.ins(classes : String? = null, crossinline block : INS.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INS(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Text to be entered by the user
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.kbd(classes : String? = null, crossinline block : KBD.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    KBD(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Client-side image map
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.map(name : String? = null, classes : String? = null, crossinline block : MAP.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    MAP(attributesMapOf("name", name,"class", classes), consumer).visit(block)
}

/**
 * Highlight
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.mark(classes : String? = null, crossinline block : MARK.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    MARK(attributesMapOf("class", classes), consumer).visit(block)
}

@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.math(classes : String? = null, crossinline block : MATH.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    MATH(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Gauge
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.meter(classes : String? = null, crossinline block : METER.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    METER(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Calculated output value
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.output(classes : String? = null, crossinline block : OUTPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    OUTPUT(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Progress bar
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.progress(classes : String? = null, crossinline block : PROGRESS.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    PROGRESS(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Short inline quotation
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.q(classes : String? = null, crossinline block : Q.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    Q(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Ruby annotation(s)
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.ruby(classes : String? = null, crossinline block : RUBY.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    RUBY(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Sample or quote text style
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.samp(classes : String? = null, crossinline block : SAMP.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SAMP(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Small text style
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.small(classes : String? = null, crossinline block : SMALL.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SMALL(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Generic language/style container
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.span(classes : String? = null, crossinline block : SPAN.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SPAN(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Strong emphasis
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.strong(classes : String? = null, crossinline block : STRONG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    STRONG(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Subscript
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.sub(classes : String? = null, crossinline block : SUB.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SUB(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Superscript
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.sup(classes : String? = null, crossinline block : SUP.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SUP(attributesMapOf("class", classes), consumer).visit(block)
}

@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.svg(classes : String? = null, crossinline block : SVG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SVG(attributesMapOf("class", classes), consumer).visit(block)
}
@HtmlTagMarker
fun FlowOrPhrasingContent.svg(classes : String? = null, content : String = "") : Unit = SVG(attributesMapOf("class", classes), consumer).visit({+content})

/**
 * Machine-readable equivalent of date- or time-related data
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.time(classes : String? = null, crossinline block : TIME.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TIME(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Unordered list
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrPhrasingContent.htmlVar(classes : String? = null, crossinline block : VAR.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    VAR(attributesMapOf("class", classes), consumer).visit(block)
}


/**
 * Self-contained syndicatable or reusable composition
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun SectioningOrFlowContent.article(classes : String? = null, crossinline block : ARTICLE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    ARTICLE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Sidebar for tangentially related content
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun SectioningOrFlowContent.aside(classes : String? = null, crossinline block : ASIDE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    ASIDE(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Container for the dominant contents of another element
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun SectioningOrFlowContent.main(classes : String? = null, crossinline block : MAIN.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    MAIN(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Section with navigational links
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun SectioningOrFlowContent.nav(classes : String? = null, crossinline block : NAV.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    NAV(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Generic document or application section
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun SectioningOrFlowContent.section(classes : String? = null, crossinline block : SECTION.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SECTION(attributesMapOf("class", classes), consumer).visit(block)
}


/**
 * Anchor
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.a(href : String? = null, target : String? = null, referrerPolicy : AReferrerPolicy? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", referrerPolicy?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.noReferrerA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.noReferrer.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.noReferrerWhenDowngradeA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.noReferrerWhenDowngrade.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.originA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.origin.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.originWhenCrossOriginA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.originWhenCrossOrigin.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.sameOriginA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.sameOrigin.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.strictOriginWhenCrossOriginA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.strictOriginWhenCrossOrigin.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.unsafeUrlA(href : String? = null, target : String? = null, classes : String? = null, crossinline block : A.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    A(attributesMapOf("href", href,"target", target,"referrerpolicy", AReferrerPolicy.unsafeUrl.realValue,"class", classes), consumer).visit(block)
}

/**
 * Audio player
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.audio(classes : String? = null, crossinline block : AUDIO.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    AUDIO(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Push button
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.button(formEncType : ButtonFormEncType? = null, formMethod : ButtonFormMethod? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, crossinline block : BUTTON.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"type", type?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.getButton(formEncType : ButtonFormEncType? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, crossinline block : BUTTON.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", ButtonFormMethod.get.realValue,"name", name,"type", type?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.postButton(formEncType : ButtonFormEncType? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, crossinline block : BUTTON.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", ButtonFormMethod.post.realValue,"name", name,"type", type?.enumEncode(),"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.putButton(formEncType : ButtonFormEncType? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, crossinline block : BUTTON.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", ButtonFormMethod.put.realValue,"name", name,"type", type?.enumEncode(),"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.deleteButton(formEncType : ButtonFormEncType? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, crossinline block : BUTTON.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", ButtonFormMethod.delete.realValue,"name", name,"type", type?.enumEncode(),"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.patchButton(formEncType : ButtonFormEncType? = null, name : String? = null, type : ButtonType? = null, classes : String? = null, crossinline block : BUTTON.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    BUTTON(attributesMapOf("formenctype", formEncType?.enumEncode(),"formmethod", ButtonFormMethod.patch.realValue,"name", name,"type", type?.enumEncode(),"class", classes), consumer).visit(block)
}

/**
 * Plugin
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.embed(classes : String? = null, crossinline block : EMBED.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    EMBED(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Inline subwindow
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.iframe(sandbox : IframeSandbox? = null, classes : String? = null, crossinline block : IFRAME.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IFRAME(attributesMapOf("sandbox", sandbox?.enumEncode(),"class", classes), consumer).visit(block)
}
/**
 * Inline subwindow
 */
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.iframe(sandbox : IframeSandbox? = null, classes : String? = null, content : String = "") : Unit = IFRAME(attributesMapOf("sandbox", sandbox?.enumEncode(),"class", classes), consumer).visit({+content})
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.allowSameOriginIframe(classes : String? = null, crossinline block : IFRAME.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IFRAME(attributesMapOf("sandbox", IframeSandbox.allowSameOrigin.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.allowFormSIframe(classes : String? = null, crossinline block : IFRAME.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IFRAME(attributesMapOf("sandbox", IframeSandbox.allowFormS.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.allowScriptsIframe(classes : String? = null, crossinline block : IFRAME.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IFRAME(attributesMapOf("sandbox", IframeSandbox.allowScripts.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.allowSameOriginIframe(classes : String? = null, content : String = "") : Unit = IFRAME(attributesMapOf("sandbox", IframeSandbox.allowSameOrigin.realValue,"class", classes), consumer).visit({+content})
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.allowFormSIframe(classes : String? = null, content : String = "") : Unit = IFRAME(attributesMapOf("sandbox", IframeSandbox.allowFormS.realValue,"class", classes), consumer).visit({+content})
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.allowScriptsIframe(classes : String? = null, content : String = "") : Unit = IFRAME(attributesMapOf("sandbox", IframeSandbox.allowScripts.realValue,"class", classes), consumer).visit({+content})

/**
 * Embedded image
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.img(alt : String? = null, src : String? = null, loading : ImgLoading? = null, classes : String? = null, crossinline block : IMG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IMG(attributesMapOf("alt", alt,"src", src,"loading", loading?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.eagerImg(alt : String? = null, src : String? = null, classes : String? = null, crossinline block : IMG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IMG(attributesMapOf("alt", alt,"src", src,"loading", ImgLoading.eager.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.lazyImg(alt : String? = null, src : String? = null, classes : String? = null, crossinline block : IMG.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    IMG(attributesMapOf("alt", alt,"src", src,"loading", ImgLoading.lazy.realValue,"class", classes), consumer).visit(block)
}

/**
 * Pictures container
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.picture(crossinline block : PICTURE.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    PICTURE(emptyMap, consumer).visit(block)
}

/**
 * Form control
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.input(type : InputType? = null, formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", type?.enumEncode(),"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.buttonInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.button.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.checkBoxInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.checkBox.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.colorInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.color.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.dateInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.date.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.dateTimeInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.dateTime.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.dateTimeLocalInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.dateTimeLocal.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.emailInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.email.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.fileInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.file.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.hiddenInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.hidden.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.imageInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.image.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.monthInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.month.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.numberInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.number.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.passwordInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.password.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.radioInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.radio.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.rangeInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.range.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.resetInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.reset.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.searchInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.search.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.submitInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.submit.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.textInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.text.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.telInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.tel.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.timeInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.time.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.urlInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.url.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.weekInput(formEncType : InputFormEncType? = null, formMethod : InputFormMethod? = null, name : String? = null, classes : String? = null, crossinline block : INPUT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    INPUT(attributesMapOf("type", InputType.week.realValue,"formenctype", formEncType?.enumEncode(),"formmethod", formMethod?.enumEncode(),"name", name,"class", classes), consumer).visit(block)
}

/**
 * Cryptographic key-pair generator form control
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.keyGen(keyType : KeyGenKeyType? = null, classes : String? = null, crossinline block : KEYGEN.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    KEYGEN(attributesMapOf("keytype", keyType?.enumEncode(),"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.rsaKeyGen(classes : String? = null, crossinline block : KEYGEN.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    KEYGEN(attributesMapOf("keytype", KeyGenKeyType.rsa.realValue,"class", classes), consumer).visit(block)
}

/**
 * Form field label text
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.label(classes : String? = null, crossinline block : LABEL.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    LABEL(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Generic embedded object
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.htmlObject(classes : String? = null, crossinline block : OBJECT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    OBJECT(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Option selector
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.select(classes : String? = null, crossinline block : SELECT.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    SELECT(attributesMapOf("class", classes), consumer).visit(block)
}

/**
 * Multi-line text field
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.textArea(rows : String? = null, cols : String? = null, wrap : TextAreaWrap? = null, classes : String? = null, crossinline block : TEXTAREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", wrap?.enumEncode(),"class", classes), consumer).visit(block)
}
/**
 * Multi-line text field
 */
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.textArea(rows : String? = null, cols : String? = null, wrap : TextAreaWrap? = null, classes : String? = null, content : String = "") : Unit = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", wrap?.enumEncode(),"class", classes), consumer).visit({+content})
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.hardTextArea(rows : String? = null, cols : String? = null, classes : String? = null, crossinline block : TEXTAREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.hard.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.softTextArea(rows : String? = null, cols : String? = null, classes : String? = null, crossinline block : TEXTAREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.soft.realValue,"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.virtualTextArea(rows : String? = null, cols : String? = null, classes : String? = null, crossinline block : TEXTAREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.virtual.realValue,"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.physicalTextArea(rows : String? = null, cols : String? = null, classes : String? = null, crossinline block : TEXTAREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.physical.realValue,"class", classes), consumer).visit(block)
}
@Suppress("DEPRECATION")
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.offTextArea(rows : String? = null, cols : String? = null, classes : String? = null, crossinline block : TEXTAREA.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.off.realValue,"class", classes), consumer).visit(block)
}
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.hardTextArea(rows : String? = null, cols : String? = null, classes : String? = null, content : String = "") : Unit = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.hard.realValue,"class", classes), consumer).visit({+content})
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.softTextArea(rows : String? = null, cols : String? = null, classes : String? = null, content : String = "") : Unit = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.soft.realValue,"class", classes), consumer).visit({+content})
@Suppress("DEPRECATION")
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.virtualTextArea(rows : String? = null, cols : String? = null, classes : String? = null, content : String = "") : Unit = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.virtual.realValue,"class", classes), consumer).visit({+content})
@Suppress("DEPRECATION")
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.physicalTextArea(rows : String? = null, cols : String? = null, classes : String? = null, content : String = "") : Unit = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.physical.realValue,"class", classes), consumer).visit({+content})
@Suppress("DEPRECATION")
@HtmlTagMarker
fun FlowOrInteractiveOrPhrasingContent.offTextArea(rows : String? = null, cols : String? = null, classes : String? = null, content : String = "") : Unit = TEXTAREA(attributesMapOf("rows", rows,"cols", cols,"wrap", TextAreaWrap.off.realValue,"class", classes), consumer).visit({+content})

/**
 * Video player
 */
@HtmlTagMarker
@OptIn(ExperimentalContracts::class)
inline fun FlowOrInteractiveOrPhrasingContent.video(classes : String? = null, crossinline block : VIDEO.() -> Unit = {}) : Unit {
    contract { callsInPlace(block, InvocationKind.EXACTLY_ONCE) }
    VIDEO(attributesMapOf("class", classes), consumer).visit(block)
}


