/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.IllegalTimeZoneException;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013J\n\u0010\u0014\u001a\u00020\u0013*\u00020\u0012R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lkotlinx/datetime/TimeZone;", "", "zoneId", "Ljava/time/ZoneId;", "(Ljava/time/ZoneId;)V", "id", "", "getId", "()Ljava/lang/String;", "getZoneId$kotlinx_datetime", "()Ljava/time/ZoneId;", "equals", "", "other", "hashCode", "", "toString", "toInstant", "Lkotlinx/datetime/Instant;", "Lkotlinx/datetime/LocalDateTime;", "toLocalDateTime", "Companion", "kotlinx-datetime"})
public class TimeZone {
    @NotNull
    private final ZoneId zoneId;
    @NotNull
    private static final TimeZone UTC;
    public static final Companion Companion;

    @NotNull
    public final String getId() {
        String string = this.zoneId.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zoneId.id");
        return string;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"$this$toLocalDateTime");
        return TimeZoneKt.toLocalDateTime($this$toLocalDateTime, this);
    }

    @NotNull
    public final Instant toInstant(@NotNull LocalDateTime $this$toInstant) {
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"$this$toInstant");
        return TimeZoneKt.toInstant($this$toInstant, this);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TimeZone && Intrinsics.areEqual((Object)this.zoneId, (Object)((TimeZone)other).zoneId);
    }

    public int hashCode() {
        return this.zoneId.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.zoneId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zoneId.toString()");
        return string;
    }

    @NotNull
    public final ZoneId getZoneId$kotlinx_datetime() {
        return this.zoneId;
    }

    public TimeZone(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = zoneId;
    }

    static {
        Companion = new Companion(null);
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        boolean bl = false;
        boolean bl2 = false;
        ZoneId p1 = zoneOffset;
        boolean bl3 = false;
        UTC = new TimeZone(p1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lkotlinx/datetime/TimeZone$Companion;", "", "()V", "UTC", "Lkotlinx/datetime/TimeZone;", "getUTC", "()Lkotlinx/datetime/TimeZone;", "availableZoneIds", "", "", "getAvailableZoneIds", "()Ljava/util/Set;", "currentSystemDefault", "of", "zoneId", "kotlinx-datetime"})
    public static final class Companion {
        @NotNull
        public final TimeZone currentSystemDefault() {
            ZoneId zoneId = ZoneId.systemDefault();
            boolean bl = false;
            boolean bl2 = false;
            ZoneId p1 = zoneId;
            boolean bl3 = false;
            return new TimeZone(p1);
        }

        @NotNull
        public final TimeZone getUTC() {
            return UTC;
        }

        @NotNull
        public final TimeZone of(@NotNull String zoneId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            try {
                object = ZoneId.of(zoneId);
                boolean bl = false;
                boolean bl2 = false;
                ZoneId p1 = object;
                boolean bl3 = false;
                object = new TimeZone(p1);
            }
            catch (Exception e) {
                if (e instanceof DateTimeException) {
                    throw (Throwable)new IllegalTimeZoneException(e);
                }
                throw (Throwable)e;
            }
            return object;
        }

        @NotNull
        public final Set<String> getAvailableZoneIds() {
            Set<String> set = ZoneId.getAvailableZoneIds();
            Intrinsics.checkNotNullExpressionValue(set, (String)"ZoneId.getAvailableZoneIds()");
            return set;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

