/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.DivRemResult;
import kotlinx.datetime.Instant;
import kotlinx.datetime.MathJvmKt;
import kotlinx.datetime.MathKt;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0004\u001a\"\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0004\u001a\"\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0004\u001a\"\u0010\u0010\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"atZone", "Ljava/time/ZonedDateTime;", "Lkotlinx/datetime/Instant;", "zone", "Lkotlinx/datetime/TimeZone;", "periodUntil", "Lkotlinx/datetime/DateTimePeriod;", "other", "timeZone", "plus", "value", "", "unit", "Lkotlinx/datetime/DateTimeUnit;", "", "period", "until", "kotlinx-datetime"})
@JvmName(name="InstantJvmKt")
public final class InstantJvmKt {
    private static final ZonedDateTime atZone(Instant $this$atZone, TimeZone zone) {
        ZonedDateTime zonedDateTime;
        try {
            ZonedDateTime zonedDateTime2 = $this$atZone.getValue$kotlinx_datetime().atZone(zone.getZoneId$kotlinx_datetime());
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"value.atZone(zone.zoneId)");
            zonedDateTime = zonedDateTime2;
        }
        catch (DateTimeException e) {
            throw (Throwable)new DateTimeArithmeticException(e);
        }
        return zonedDateTime;
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimePeriod period, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            ZonedDateTime thisZdt = InstantJvmKt.atZone($this$plus, timeZone);
            boolean bl = false;
            boolean bl2 = false;
            DateTimePeriod $this$with = period;
            boolean bl3 = false;
            ZonedDateTime zonedDateTime = thisZdt;
            boolean bl4 = false;
            boolean bl5 = false;
            ZonedDateTime $this$run = zonedDateTime;
            boolean bl6 = false;
            zonedDateTime = $this$with.getYears() != 0 && $this$with.getMonths() == 0 ? $this$run.plusYears($this$with.getYears()) : $this$run;
            bl4 = false;
            bl5 = false;
            $this$run = zonedDateTime;
            boolean bl7 = false;
            zonedDateTime = $this$with.getMonths() != 0 ? $this$run.plusMonths((long)$this$with.getYears() * 12L + (long)$this$with.getMonths()) : $this$run;
            bl4 = false;
            bl5 = false;
            $this$run = zonedDateTime;
            boolean bl8 = false;
            zonedDateTime = $this$with.getDays() != 0 ? $this$run.plusDays($this$with.getDays()) : $this$run;
            bl4 = false;
            bl5 = false;
            $this$run = zonedDateTime;
            boolean bl9 = false;
            zonedDateTime = $this$with.getHours() != 0 ? $this$run.plusHours($this$with.getHours()) : $this$run;
            bl4 = false;
            bl5 = false;
            $this$run = zonedDateTime;
            boolean bl10 = false;
            zonedDateTime = $this$with.getMinutes() != 0 ? $this$run.plusMinutes($this$with.getMinutes()) : $this$run;
            bl4 = false;
            bl5 = false;
            $this$run = zonedDateTime;
            boolean bl11 = false;
            zonedDateTime = $this$with.getSeconds() != 0L ? $this$run.plusSeconds($this$with.getSeconds()) : $this$run;
            bl4 = false;
            bl5 = false;
            $this$run = zonedDateTime;
            boolean bl12 = false;
            java.time.Instant instant = ($this$with.getNanoseconds() != 0L ? $this$run.plusNanos($this$with.getNanoseconds()) : $this$run).toInstant();
            bl2 = false;
            boolean bl13 = false;
            java.time.Instant p1 = instant;
            boolean bl14 = false;
            return new Instant(p1);
        }
        catch (DateTimeException e) {
            throw (Throwable)new DateTimeArithmeticException(e);
        }
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.plus($this$plus, 1L, unit, timeZone);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, int value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        return InstantJvmKt.plus($this$plus, (long)value, unit, timeZone);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, long value, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            java.time.Instant instant2;
            boolean bl;
            ZonedDateTime thisZdt = InstantJvmKt.atZone($this$plus, timeZone);
            Object object = unit;
            if (object instanceof DateTimeUnit.TimeBased) {
                void d;
                DivRemResult divRemResult = MathKt.multiplyAndDivide(value, ((DateTimeUnit.TimeBased)unit).getNanoseconds(), 1000000000);
                bl = false;
                boolean bl2 = false;
                DivRemResult $dstr$d$r = divRemResult;
                boolean bl3 = false;
                long l = $dstr$d$r.component1();
                long r = $dstr$d$r.component2();
                java.time.Instant instant3 = $this$plus.getValue$kotlinx_datetime().plusSeconds((long)d).plusNanos(r);
                boolean bl4 = false;
                boolean bl5 = false;
                java.time.Instant it = instant3;
                boolean bl6 = false;
                it.atZone(timeZone.getZoneId$kotlinx_datetime());
                instant2 = instant3;
            } else if (object instanceof DateTimeUnit.DateBased.DayBased) {
                instant2 = thisZdt.plusDays(MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.DateBased.DayBased)unit).getDays())).toInstant();
            } else if (object instanceof DateTimeUnit.DateBased.MonthBased) {
                instant2 = thisZdt.plusMonths(MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.DateBased.MonthBased)unit).getMonths())).toInstant();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = instant2;
            boolean bl7 = false;
            bl = false;
            Object p1 = object;
            boolean bl8 = false;
            instant = new Instant((java.time.Instant)p1);
        }
        catch (Exception e) {
            if (!(e instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw (Throwable)e;
            }
            throw (Throwable)new DateTimeArithmeticException("Instant " + $this$plus + " cannot be represented as local date when adding " + value + ' ' + unit + " to it", e);
        }
        return instant;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DateTimePeriod periodUntil(@NotNull Instant $this$periodUntil, @NotNull Instant other, @NotNull TimeZone timeZone) {
        void nanoseconds;
        void seconds;
        void minutes;
        double time;
        Intrinsics.checkNotNullParameter((Object)$this$periodUntil, (String)"$this$periodUntil");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        ZonedDateTime thisZdt = InstantJvmKt.atZone($this$periodUntil, timeZone);
        ZonedDateTime otherZdt = InstantJvmKt.atZone(other, timeZone);
        long months = thisZdt.until(otherZdt, ChronoUnit.MONTHS);
        ZonedDateTime zonedDateTime = thisZdt.plusMonths(months);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"thisZdt.plusMonths(months)");
        thisZdt = zonedDateTime;
        long days = thisZdt.until(otherZdt, ChronoUnit.DAYS);
        ZonedDateTime zonedDateTime2 = thisZdt.plusDays(days);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"thisZdt.plusDays(days)");
        thisZdt = zonedDateTime2;
        double $this$iv = time = DurationKt.getNanoseconds((long)thisZdt.until(otherZdt, ChronoUnit.NANOS));
        boolean $i$f$toComponents = false;
        boolean bl = false;
        int n = Duration.getNanosecondsComponent-impl((double)$this$iv);
        int n2 = Duration.getSecondsComponent-impl((double)$this$iv);
        int n3 = Duration.getMinutesComponent-impl((double)$this$iv);
        int hours = (int)Duration.getInHours-impl((double)$this$iv);
        boolean bl2 = false;
        return DateTimePeriodKt.DateTimePeriod((int)(months / (long)12), (int)(months % (long)12), (int)days, hours, (int)minutes, (long)seconds, (long)nanoseconds);
    }

    public static final long until(@NotNull Instant $this$until, @NotNull Instant other, @NotNull DateTimeUnit unit, @NotNull TimeZone timeZone) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$until, (String)"$this$until");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        try {
            long l2;
            ZonedDateTime thisZdt = InstantJvmKt.atZone($this$until, timeZone);
            ZonedDateTime otherZdt = InstantJvmKt.atZone(other, timeZone);
            DateTimeUnit dateTimeUnit = unit;
            if (dateTimeUnit instanceof DateTimeUnit.TimeBased) {
                l2 = MathKt.multiplyAddAndDivide(other.getEpochSeconds() - $this$until.getEpochSeconds(), 1000000000, other.getNanosecondsOfSecond() - $this$until.getNanosecondsOfSecond(), ((DateTimeUnit.TimeBased)unit).getNanoseconds());
            } else if (dateTimeUnit instanceof DateTimeUnit.DateBased.DayBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.DAYS) / (long)((DateTimeUnit.DateBased.DayBased)unit).getDays();
            } else if (dateTimeUnit instanceof DateTimeUnit.DateBased.MonthBased) {
                l2 = thisZdt.until(otherZdt, ChronoUnit.MONTHS) / (long)((DateTimeUnit.DateBased.MonthBased)unit).getMonths();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            l = l2;
        }
        catch (DateTimeException e) {
            throw (Throwable)new DateTimeArithmeticException(e);
        }
        catch (ArithmeticException e) {
            l = $this$until.getValue$kotlinx_datetime().compareTo(other.getValue$kotlinx_datetime()) < 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }
}

