/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dataframe.gradle;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dataframe.gradle.CsvOptionsDsl;
import org.jetbrains.dataframe.gradle.DataSchemaVisibility;
import org.jetbrains.dataframe.gradle.GenerateDataSchemaTask;
import org.jetbrains.dataframe.gradle.JdbcOptionsDsl;
import org.jetbrains.dataframe.gradle.JsonOptionsDsl;
import org.jetbrains.dataframe.gradle.NameChecker;
import org.jetbrains.dataframe.impl.codeGen.CodeGenResult;
import org.jetbrains.dataframe.impl.codeGen.CodeGenerator;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.codeGen.DefaultReadDfMethod;
import org.jetbrains.kotlinx.dataframe.codeGen.MarkerVisibility;
import org.jetbrains.kotlinx.dataframe.codeGen.NameNormalizer;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.CodeGenerationReadResult;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.CodeGeneratorImplKt;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.DfReadResult;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.NameNormalizerImplKt;
import org.jetbrains.kotlinx.dataframe.impl.codeGen.SchemaReaderKt;
import org.jetbrains.kotlinx.dataframe.io.ArrowFeather;
import org.jetbrains.kotlinx.dataframe.io.CSV;
import org.jetbrains.kotlinx.dataframe.io.CommonKt;
import org.jetbrains.kotlinx.dataframe.io.Excel;
import org.jetbrains.kotlinx.dataframe.io.JSON;
import org.jetbrains.kotlinx.dataframe.io.OpenApi;
import org.jetbrains.kotlinx.dataframe.io.ReadJdbcKt;
import org.jetbrains.kotlinx.dataframe.io.SupportedFormat;
import org.jetbrains.kotlinx.dataframe.io.TSV;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010-\u001a\u00020.H\u0007J\u0018\u0010/\u001a\u0002002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0018\u00104\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0018\u00105\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0018\u00106\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0010\u00107\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0018\u0010:\u001a\u0002092\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\b\u0010;\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010\b\u001a\u00020\tH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8G\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0007R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0007R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0007R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007\u00a8\u0006>"}, d2={"Lorg/jetbrains/dataframe/gradle/GenerateDataSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "csvOptions", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/dataframe/gradle/CsvOptionsDsl;", "getCsvOptions", "()Lorg/gradle/api/provider/Property;", "data", "", "getData", "dataSchema", "Lorg/gradle/api/provider/Provider;", "Ljava/io/File;", "getDataSchema$annotations", "getDataSchema", "()Lorg/gradle/api/provider/Provider;", "defaultPath", "", "getDefaultPath", "delimiters", "Lorg/gradle/api/provider/SetProperty;", "", "getDelimiters", "()Lorg/gradle/api/provider/SetProperty;", "interfaceName", "", "getInterfaceName", "jdbcOptions", "Lorg/jetbrains/dataframe/gradle/JdbcOptionsDsl;", "getJdbcOptions", "jsonOptions", "Lorg/jetbrains/dataframe/gradle/JsonOptionsDsl;", "getJsonOptions", "packageName", "getPackageName", "schemaVisibility", "Lorg/jetbrains/dataframe/gradle/DataSchemaVisibility;", "getSchemaVisibility", "src", "getSrc", "areBothNotBlank", "tableName", "sqlQuery", "escapePackageName", "generate", "", "generateSchemaByJdbcOptions", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "connection", "Ljava/sql/Connection;", "generateSchemaForQuery", "generateSchemaForTable", "isQueryNotBlankAndTableBlank", "isTableNameNotBlankAndQueryBlank", "stringOf", "throwBothFieldsEmptyException", "", "throwBothFieldsFilledException", "unsupportedType", "urlOf", "Ljava/net/URL;", "dataframe-gradle-plugin"})
public abstract class GenerateDataSchemaTask
extends DefaultTask {
    @NotNull
    private final Provider<File> dataSchema;

    public GenerateDataSchemaTask() {
        Provider provider = this.getPackageName().zip((Provider)this.getInterfaceName(), new BiFunction(this){
            final /* synthetic */ GenerateDataSchemaTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final File apply(String packageName, String interfaceName) {
                Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
                String packagePath = StringsKt.replace$default((String)packageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
                String[] stringArray = new String[]{packagePath, interfaceName + ".Generated.kt"};
                return Paths.get(((File)this.this$0.getSrc().get()).getAbsolutePath(), stringArray).toFile();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"packageName.zip(interfac\u2026rated.kt\").toFile()\n    }");
        this.dataSchema = provider;
    }

    @Input
    @NotNull
    public abstract Property<Object> getData();

    @Input
    @NotNull
    public abstract Property<CsvOptionsDsl> getCsvOptions();

    @Input
    @NotNull
    public abstract Property<JsonOptionsDsl> getJsonOptions();

    @Input
    @NotNull
    public abstract Property<JdbcOptionsDsl> getJdbcOptions();

    @Input
    @NotNull
    public abstract Property<File> getSrc();

    @Input
    @NotNull
    public abstract Property<String> getInterfaceName();

    @Input
    @NotNull
    public abstract Property<String> getPackageName();

    @Input
    @NotNull
    public abstract Property<DataSchemaVisibility> getSchemaVisibility();

    @Input
    @NotNull
    public abstract Property<Boolean> getDefaultPath();

    @Input
    @NotNull
    public abstract SetProperty<Character> getDelimiters();

    @OutputFile
    @NotNull
    public final Provider<File> getDataSchema() {
        return this.dataSchema;
    }

    public static /* synthetic */ void getDataSchema$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void generate() {
        MarkerVisibility markerVisibility;
        DfReadResult readResult;
        Object object = this.getCsvOptions().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"csvOptions.get()");
        CsvOptionsDsl csvOptions = (CsvOptionsDsl)object;
        Object object2 = this.getJsonOptions().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"jsonOptions.get()");
        JsonOptionsDsl jsonOptions = (JsonOptionsDsl)object2;
        Object object3 = this.getJdbcOptions().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"jdbcOptions.get()");
        JdbcOptionsDsl jdbcOptions = (JdbcOptionsDsl)object3;
        Object object4 = this.dataSchema.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"dataSchema.get()");
        File schemaFile = (File)object4;
        Object object5 = this.getPackageName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"packageName.get()");
        String escapedPackageName = this.escapePackageName((String)object5);
        String rawUrl = this.getData().get().toString();
        if (StringsKt.startsWith$default((String)rawUrl, (String)"jdbc", (boolean)false, (int)2, null)) {
            Connection connection = DriverManager.getConnection(rawUrl, jdbcOptions.getUser(), jdbcOptions.getPassword());
            AutoCloseable autoCloseable = connection;
            Throwable throwable = null;
            try {
                MarkerVisibility markerVisibility2;
                Connection it = (Connection)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
                DataFrameSchema schema = this.generateSchemaByJdbcOptions(jdbcOptions, connection);
                CodeGenerator codeGenerator = CodeGenerator.Companion.create(false);
                List additionalImports = CollectionsKt.emptyList();
                Object object6 = this.getDelimiters().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"delimiters.get()");
                Set delimiters = (Set)object6;
                Object object7 = this.getInterfaceName().get();
                Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"interfaceName.get()");
                String string = (String)object7;
                switch (WhenMappings.$EnumSwitchMapping$0[((DataSchemaVisibility)((Object)this.getSchemaVisibility().get())).ordinal()]) {
                    case 1: {
                        markerVisibility2 = MarkerVisibility.INTERNAL;
                        break;
                    }
                    case 2: {
                        markerVisibility2 = MarkerVisibility.IMPLICIT_PUBLIC;
                        break;
                    }
                    case 3: {
                        markerVisibility2 = MarkerVisibility.EXPLICIT_PUBLIC;
                        break;
                    }
                    default: {
                        markerVisibility2 = MarkerVisibility.IMPLICIT_PUBLIC;
                    }
                }
                CodeGenResult codeGenResult = CodeGenerator.DefaultImpls.generate$default((CodeGenerator)codeGenerator, (DataFrameSchema)schema, (String)string, (boolean)true, (boolean)false, (boolean)true, (MarkerVisibility)markerVisibility2, null, null, (NameNormalizer)NameNormalizerImplKt.from((NameNormalizer.Companion)NameNormalizer.Companion, (Set)delimiters), (boolean)false, (int)576, null);
                FilesKt.writeText$default((File)schemaFile, (String)CodeGeneratorImplKt.toStandaloneSnippet((CodeGenResult)codeGenResult, (String)escapedPackageName, (List)additionalImports), null, (int)2, null);
                return;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        Object object8 = this.getData().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"data.get()");
        URL url = this.urlOf(object8);
        Object[] objectArray = new SupportedFormat[]{new CSV(csvOptions.getDelimiter()), new JSON(jsonOptions.getTypeClashTactic(), jsonOptions.getKeyValuePaths()), new Excel(), new TSV(), new ArrowFeather(), new OpenApi()};
        List formats = CollectionsKt.listOf((Object[])objectArray);
        Function4 function4 = SchemaReaderKt.getUrlCodeGenReader((CodeGenerator.Companion)CodeGenerator.Companion);
        Object object9 = this.getInterfaceName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"interfaceName.get()");
        CodeGenerationReadResult codeGenResult = (CodeGenerationReadResult)function4.invoke((Object)url, object9, (Object)formats, (Object)false);
        if (codeGenResult instanceof CodeGenerationReadResult.Success) {
            CodeGenerationReadResult.Success success = (CodeGenerationReadResult.Success)codeGenResult;
            Object object10 = this.getData().get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"data.get()");
            DefaultReadDfMethod readDfMethod = success.getReadDfMethod(this.stringOf(object10));
            String code = CodeGeneratorImplKt.toStandaloneSnippet((String)((CodeGenerationReadResult.Success)codeGenResult).getCode(), (String)escapedPackageName, (List)readDfMethod.getAdditionalImports());
            Object schema = schemaFile;
            Object codeGenerator = Charsets.UTF_8;
            int additionalImports = 8192;
            Object delimiters = schema;
            delimiters = new OutputStreamWriter((OutputStream)new FileOutputStream((File)delimiters), (Charset)codeGenerator);
            schema = delimiters instanceof BufferedWriter ? (BufferedWriter)delimiters : new BufferedWriter((Writer)delimiters, additionalImports);
            codeGenerator = null;
            try {
                BufferedWriter it = (BufferedWriter)schema;
                boolean bl = false;
                it.write(code);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                codeGenerator = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)schema, (Throwable)codeGenerator);
            }
            return;
        }
        if (codeGenResult instanceof CodeGenerationReadResult.Error) {
            this.getLogger().warn("Error while reading types-only from data at " + url + ": " + ((CodeGenerationReadResult.Error)codeGenResult).getReason());
        }
        if ((readResult = (DfReadResult)SchemaReaderKt.getUrlDfReader((CodeGenerator.Companion)CodeGenerator.Companion).invoke((Object)url, (Object)formats)) instanceof DfReadResult.Error) {
            throw new Exception("Error while reading dataframe from data at " + url, ((DfReadResult.Error)readResult).getReason());
        }
        if (!(readResult instanceof DfReadResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        DfReadResult.Success parsedDf = (DfReadResult.Success)readResult;
        CodeGenerator codeGenerator = CodeGenerator.Companion.create(false);
        Object object11 = this.getDelimiters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"delimiters.get()");
        Set delimiters = (Set)object11;
        Object object12 = this.getData().get();
        Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"data.get()");
        DefaultReadDfMethod readDfMethod = parsedDf.getReadDfMethod(this.stringOf(object12));
        DataFrameSchema dataFrameSchema = parsedDf.getSchema();
        Object object13 = this.getInterfaceName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"interfaceName.get()");
        String string = (String)object13;
        switch (WhenMappings.$EnumSwitchMapping$0[((DataSchemaVisibility)((Object)this.getSchemaVisibility().get())).ordinal()]) {
            case 1: {
                markerVisibility = MarkerVisibility.INTERNAL;
                break;
            }
            case 2: {
                markerVisibility = MarkerVisibility.IMPLICIT_PUBLIC;
                break;
            }
            case 3: {
                markerVisibility = MarkerVisibility.EXPLICIT_PUBLIC;
                break;
            }
            default: {
                markerVisibility = MarkerVisibility.IMPLICIT_PUBLIC;
            }
        }
        CodeGenResult codeGenResult2 = CodeGenerator.DefaultImpls.generate$default((CodeGenerator)codeGenerator, (DataFrameSchema)dataFrameSchema, (String)string, (boolean)true, (boolean)false, (boolean)true, (MarkerVisibility)markerVisibility, null, (DefaultReadDfMethod)readDfMethod, (NameNormalizer)NameNormalizerImplKt.from((NameNormalizer.Companion)NameNormalizer.Companion, (Set)delimiters), (boolean)false, (int)576, null);
        FilesKt.writeText$default((File)schemaFile, (String)CodeGeneratorImplKt.toStandaloneSnippet((CodeGenResult)codeGenResult2, (String)escapedPackageName, (List)readDfMethod.getAdditionalImports()), null, (int)2, null);
    }

    private final DataFrameSchema generateSchemaByJdbcOptions(JdbcOptionsDsl jdbcOptions, Connection connection) {
        DataFrameSchema dataFrameSchema;
        this.getLogger().debug("Table name: " + jdbcOptions.getTableName());
        this.getLogger().debug("SQL query: " + jdbcOptions.getSqlQuery());
        String tableName = jdbcOptions.getTableName();
        String sqlQuery = jdbcOptions.getSqlQuery();
        if (this.isTableNameNotBlankAndQueryBlank(tableName, sqlQuery)) {
            dataFrameSchema = this.generateSchemaForTable(connection, tableName);
        } else if (this.isQueryNotBlankAndTableBlank(tableName, sqlQuery)) {
            dataFrameSchema = this.generateSchemaForQuery(connection, sqlQuery);
        } else {
            if (this.areBothNotBlank(tableName, sqlQuery)) {
                this.throwBothFieldsFilledException(tableName, sqlQuery);
                throw new KotlinNothingValueException();
            }
            this.throwBothFieldsEmptyException(tableName, sqlQuery);
            throw new KotlinNothingValueException();
        }
        return dataFrameSchema;
    }

    private final boolean isTableNameNotBlankAndQueryBlank(String tableName, String sqlQuery) {
        return !StringsKt.isBlank((CharSequence)tableName) && StringsKt.isBlank((CharSequence)sqlQuery);
    }

    private final boolean isQueryNotBlankAndTableBlank(String tableName, String sqlQuery) {
        return !StringsKt.isBlank((CharSequence)sqlQuery) && StringsKt.isBlank((CharSequence)tableName);
    }

    private final boolean areBothNotBlank(String tableName, String sqlQuery) {
        return !StringsKt.isBlank((CharSequence)sqlQuery) && !StringsKt.isBlank((CharSequence)tableName);
    }

    private final DataFrameSchema generateSchemaForTable(Connection connection, String tableName) {
        return ReadJdbcKt.getSchemaForSqlTable$default((DataFrame.Companion)DataFrame.Companion, (Connection)connection, (String)tableName, null, (int)4, null);
    }

    private final DataFrameSchema generateSchemaForQuery(Connection connection, String sqlQuery) {
        return ReadJdbcKt.getSchemaForSqlQuery$default((DataFrame.Companion)DataFrame.Companion, (Connection)connection, (String)sqlQuery, null, (int)4, null);
    }

    private final Void throwBothFieldsFilledException(String tableName, String sqlQuery) {
        throw new RuntimeException("Table name '" + tableName + "' and SQL query '" + sqlQuery + "' both are filled! Clear 'tableName' or 'sqlQuery' properties in jdbcOptions with value to generate schema for SQL table or result of SQL query!");
    }

    private final Void throwBothFieldsEmptyException(String tableName, String sqlQuery) {
        throw new RuntimeException("Table name '" + tableName + "' and SQL query '" + sqlQuery + "' both are empty! Populate 'tableName' or 'sqlQuery' properties in jdbcOptions with value to generate schema for SQL table or result of SQL query!");
    }

    private final String stringOf(Object data) {
        String string;
        Object object = data;
        if (object instanceof File) {
            String string2 = ((File)data).getAbsolutePath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data.absolutePath");
        } else if (object instanceof URL) {
            String string3 = ((URL)data).toExternalForm();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"data.toExternalForm()");
        } else if (object instanceof String) {
            if (CommonKt.isUrl((String)((String)data))) {
                string = this.stringOf(new URL((String)data));
            } else {
                File file = this.getProject().file(data);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(data)");
                File relativeFile = file;
                File absoluteFile = new File((String)data);
                string = this.stringOf(relativeFile.exists() ? relativeFile : absoluteFile);
            }
        } else {
            this.unsupportedType();
            throw new KotlinNothingValueException();
        }
        return string;
    }

    private final String escapePackageName(String packageName) {
        String string;
        if (((CharSequence)packageName).length() > 0) {
            CharSequence charSequence = packageName;
            Regex regex = NameChecker.INSTANCE.getPACKAGE_IDENTIFIER_DELIMITER();
            int n = 0;
            string = CollectionsKt.joinToString$default((Iterable)regex.split(charSequence, n), (CharSequence)".", null, null, (int)0, null, (Function1)escapePackageName.1.INSTANCE, (int)30, null);
        } else {
            string = packageName;
        }
        return string;
    }

    private final URL urlOf(Object data) {
        URI uRI;
        Object object = data;
        if (object instanceof File) {
            uRI = ((File)data).toURI();
        } else if (object instanceof URL) {
            uRI = ((URL)data).toURI();
        } else if (object instanceof String) {
            if (CommonKt.isUrl((String)((String)data))) {
                uRI = new URL((String)data).toURI();
            } else {
                File file = this.getProject().file(data);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(data)");
                File relativeFile = file;
                File absoluteFile = new File((String)data);
                uRI = (relativeFile.exists() ? relativeFile : absoluteFile).toURI();
            }
        } else {
            this.unsupportedType();
            throw new KotlinNothingValueException();
        }
        URL uRL = uRI.toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"when (data) {\n          \u2026dType()\n        }.toURL()");
        return uRL;
    }

    private final Void unsupportedType() {
        throw new IllegalArgumentException("data for schema \"" + (String)this.getInterfaceName().get() + "\" must be File, URL or String");
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataSchemaVisibility.values().length];
            try {
                nArray[DataSchemaVisibility.INTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSchemaVisibility.IMPLICIT_PUBLIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSchemaVisibility.EXPLICIT_PUBLIC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

