/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.swiftexport.standalone;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.sir.SirDeclarationContainer;
import org.jetbrains.kotlin.sir.SirImport;
import org.jetbrains.kotlin.sir.SirModule;
import org.jetbrains.kotlin.sir.bridge.BridgeRequest;
import org.jetbrains.kotlin.sir.builder.SirModuleBuilder;
import org.jetbrains.kotlin.sir.providers.SirModuleProvider;
import org.jetbrains.kotlin.sir.providers.impl.SirEnumGeneratorImpl;
import org.jetbrains.kotlin.sir.providers.impl.SirOneToOneModuleProvider;
import org.jetbrains.kotlin.sir.providers.impl.SirSingleModuleProvider;
import org.jetbrains.kotlin.sir.providers.utils.KotlinRuntimeModule;
import org.jetbrains.kotlin.sir.providers.utils.SirModuleExtensionsKt;
import org.jetbrains.kotlin.swiftexport.standalone.InputModule;
import org.jetbrains.kotlin.swiftexport.standalone.MultipleModulesHandlingStrategy;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportConfig;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportFiles;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportLogger;
import org.jetbrains.kotlin.swiftexport.standalone.SwiftExportModule;
import org.jetbrains.kotlin.swiftexport.standalone.TranslationResult;
import org.jetbrains.kotlin.swiftexport.standalone.builders.BuildBridgeRequestsKt;
import org.jetbrains.kotlin.swiftexport.standalone.builders.BuildSwiftModuleKt;
import org.jetbrains.kotlin.swiftexport.standalone.builders.SwiftModuleBuildResults;
import org.jetbrains.kotlin.swiftexport.standalone.writer.BridgeSources;
import org.jetbrains.kotlin.swiftexport.standalone.writer.DumpResultToFilesKt;
import org.jetbrains.sir.printer.SirAsSwiftSourcesPrinter;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a%\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\u0010\b\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0005*\u00020\nH\u0002\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"createDummyLogger", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportLogger;", "runSwiftExport", "Lkotlin/Result;", "", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportModule;", "input", "Lorg/jetbrains/kotlin/swiftexport/standalone/InputModule;", "(Ljava/util/Set;)Ljava/lang/Object;", "translateModule", "Lorg/jetbrains/kotlin/swiftexport/standalone/TranslationResult;", "module", "dependencies", "bridgesModuleName", "", "getBridgesModuleName", "(Lorg/jetbrains/kotlin/swiftexport/standalone/InputModule;)Ljava/lang/String;", "createModuleForPackages", "Lorg/jetbrains/kotlin/sir/SirModule;", "", "writeSwiftModule", "Lorg/jetbrains/kotlin/swiftexport/standalone/SwiftExportModule$SwiftOnly;", "sirModule", "outputPath", "Ljava/nio/file/Path;", "writeModule", "swift-export-standalone"})
@SourceDebugExtension(value={"SMAP\nSwiftExportRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwiftExportRunner.kt\norg/jetbrains/kotlin/swiftexport/standalone/SwiftExportRunnerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SirModuleBuilder.kt\norg/jetbrains/kotlin/sir/builder/SirModuleBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1557#2:352\n1628#2,3:353\n1557#2:356\n1628#2,3:357\n1368#2:361\n1454#2,5:362\n1863#2:367\n1864#2:369\n1557#2:370\n1628#2,3:371\n774#2:374\n865#2,2:375\n1557#2:377\n1628#2,3:378\n40#3:360\n1#4:368\n*S KotlinDebug\n*F\n+ 1 SwiftExportRunner.kt\norg/jetbrains/kotlin/swiftexport/standalone/SwiftExportRunnerKt\n*L\n188#1:352\n188#1:353,3\n206#1:356\n206#1:357,3\n254#1:361\n254#1:362,5\n255#1:367\n255#1:369\n285#1:370\n285#1:371,3\n302#1:374\n302#1:375,2\n303#1:377\n303#1:378,3\n250#1:360\n*E\n"})
public final class SwiftExportRunnerKt {
    @NotNull
    public static final SwiftExportLogger createDummyLogger() {
        return new SwiftExportLogger(){

            public void report(SwiftExportLogger.Severity severity, String message) {
                Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                System.out.println((Object)((Object)((Object)severity) + ": " + message));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Object runSwiftExport(@NotNull Set<InputModule> input) {
        Object object;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void it;
            Collection collection;
            SwiftExportConfig $this$mapTo$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv2 = input;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void rootModule;
                Object item$iv$iv = iterator.next();
                InputModule inputModule = (InputModule)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Set dependencies = SetsKt.minus(input, (Object)rootModule);
                collection.add(SwiftExportRunnerKt.translateModule((InputModule)rootModule, dependencies));
            }
            List translatedModules = (List)destination$iv$iv;
            $this$mapTo$iv$iv2 = ((InputModule)CollectionsKt.first((Iterable)input)).getConfig();
            collection = SwiftExportRunnerKt.createModuleForPackages(translatedModules);
            boolean $i$a$-let-SwiftExportRunnerKt$runSwiftExport$1$packagesModule$22 = false;
            Path path = it.getOutputPath().getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Path $i$f$mapTo22 = path;
            Path path2 = $i$f$mapTo22.resolve(it.getModuleForPackagesName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            $i$f$mapTo22 = path2;
            Path path3 = $i$f$mapTo22.resolve(it.getModuleForPackagesName() + ".swift");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            SwiftExportModule.SwiftOnly packagesModule = SwiftExportRunnerKt.writeSwiftModule((SirModule)collection, path3);
            Iterable $i$f$map22 = translatedModules;
            collection = SetsKt.setOf((Object)packagesModule);
            boolean $i$f$map = false;
            void $i$a$-let-SwiftExportRunnerKt$runSwiftExport$1$packagesModule$22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                TranslationResult bl2 = (TranslationResult)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl3 = false;
                collection2.add(SwiftExportRunnerKt.writeModule((TranslationResult)p0));
            }
            object = Result.constructor-impl((Object)SetsKt.plus((Set)collection, (Iterable)((List)destination$iv$iv2)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private static final TranslationResult translateModule(InputModule module, Set<InputModule> dependencies) {
        SirModuleProvider sirModuleProvider;
        switch (WhenMappings.$EnumSwitchMapping$0[module.getConfig().getMultipleModulesHandlingStrategy().ordinal()]) {
            case 1: {
                sirModuleProvider = (SirModuleProvider)new SirOneToOneModuleProvider();
                break;
            }
            case 2: {
                sirModuleProvider = (SirModuleProvider)new SirSingleModuleProvider(module.getName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        SirModuleProvider moduleProvider = sirModuleProvider;
        SwiftModuleBuildResults buildResult = BuildSwiftModuleKt.initializeSirModule(BuildSwiftModuleKt.createModuleWithScopeProviderFromBinary(module, dependencies), module.getConfig(), moduleProvider);
        List<BridgeRequest> bridgeRequests = BuildBridgeRequestsKt.buildBridgeRequests(module.getConfig().getBridgeGenerator$swift_export_standalone(), (SirDeclarationContainer)buildResult.getModule());
        if (!((Collection)bridgeRequests).isEmpty()) {
            SirModuleExtensionsKt.updateImport((SirModule)buildResult.getModule(), (SirImport)new SirImport(SwiftExportRunnerKt.getBridgesModuleName(module), SirImport.Mode.ImplementationOnly));
        }
        BridgeSources bridges = DumpResultToFilesKt.generateBridgeSources(module.getConfig().getBridgeGenerator$swift_export_standalone(), bridgeRequests, true);
        Set<FqName> set = buildResult.getPackages();
        SirModule sirModule = buildResult.getModule();
        SwiftExportConfig swiftExportConfig = module.getConfig();
        String string = SwiftExportRunnerKt.getBridgesModuleName(module);
        return new TranslationResult(sirModule, set, bridges, swiftExportConfig, string);
    }

    @NotNull
    public static final String getBridgesModuleName(@NotNull InputModule $this$bridgesModuleName) {
        Intrinsics.checkNotNullParameter((Object)$this$bridgesModuleName, (String)"<this>");
        return $this$bridgesModuleName.getConfig().getBridgeModuleNamePrefix$swift_export_standalone() + '_' + $this$bridgesModuleName.getName();
    }

    /*
     * WARNING - void declaration
     */
    private static final SirModule createModuleForPackages(Collection<TranslationResult> $this$createModuleForPackages) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        SirModule sirModule;
        SirModuleBuilder sirModuleBuilder;
        boolean $i$f$buildModule = false;
        SirModuleBuilder $this$createModuleForPackages_u24lambda_u243 = sirModuleBuilder = new SirModuleBuilder();
        boolean bl = false;
        $this$createModuleForPackages_u24lambda_u243.setName(((TranslationResult)CollectionsKt.first((Iterable)$this$createModuleForPackages)).getConfig().getModuleForPackagesName());
        SirModule $this$createModuleForPackages_u24lambda_u247 = sirModule = sirModuleBuilder.build();
        boolean bl2 = false;
        SirEnumGeneratorImpl enumGenerator = new SirEnumGeneratorImpl($this$createModuleForPackages_u24lambda_u247);
        Iterable $this$flatMap$iv = $this$createModuleForPackages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TranslationResult it = (TranslationResult)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getPackages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl4 = false;
            SirEnumGeneratorImpl $this$createModuleForPackages_u24lambda_u247_u24lambda_u246_u24lambda_u245 = enumGenerator;
            boolean bl5 = false;
            $this$createModuleForPackages_u24lambda_u247_u24lambda_u246_u24lambda_u245.sirPackageEnum(it);
        }
        return sirModule;
    }

    private static final SwiftExportModule.SwiftOnly writeSwiftModule(SirModule sirModule, Path outputPath) {
        Object object = new String[]{SirAsSwiftSourcesPrinter.Companion.print$default((SirAsSwiftSourcesPrinter.Companion)SirAsSwiftSourcesPrinter.Companion, (SirModule)sirModule, (boolean)true, (boolean)false, null, (int)8, null)};
        Sequence swiftSources = SequencesKt.sequenceOf((Object[])object);
        File file = outputPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        DumpResultToFilesKt.dumpTextAtFile((Sequence<String>)swiftSources, file);
        object = sirModule.getName();
        return new SwiftExportModule.SwiftOnly(outputPath, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    private static final SwiftExportModule writeModule(TranslationResult $this$writeModule) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SirImport it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Object object = new String[]{SirAsSwiftSourcesPrinter.Companion.print$default((SirAsSwiftSourcesPrinter.Companion)SirAsSwiftSourcesPrinter.Companion, (SirModule)$this$writeModule.getSirModule(), (boolean)$this$writeModule.getConfig().getStableDeclarationsOrder$swift_export_standalone(), (boolean)$this$writeModule.getConfig().getRenderDocComments$swift_export_standalone(), null, (int)8, null)};
        Sequence sequence = SequencesKt.sequenceOf((Object[])object);
        object = $this$writeModule.getConfig().getUnsupportedDeclarationReporter$swift_export_standalone().getMessages();
        Object object2 = sequence;
        boolean $i$f$map = false;
        List list = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("// " + (String)it2);
        }
        Sequence swiftSources = SequencesKt.plus((Sequence)object2, (Iterable)((List)destination$iv$iv));
        Path path = $this$writeModule.getConfig().getOutputPath().resolve($this$writeModule.getSirModule().getName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve($this$writeModule.getSirModule().getName() + ".swift");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = $this$writeModule.getConfig().getOutputPath().resolve($this$writeModule.getSirModule().getName());
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Path path4 = path3.resolve($this$writeModule.getSirModule().getName() + ".kt");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        Path path5 = $this$writeModule.getConfig().getOutputPath().resolve($this$writeModule.getSirModule().getName());
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        Path path6 = path5.resolve($this$writeModule.getSirModule().getName() + ".h");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        SwiftExportFiles outputFiles = new SwiftExportFiles(path2, path4, path6);
        DumpResultToFilesKt.dumpTextAtPath((Sequence<String>)swiftSources, $this$writeModule.getBridgeSources(), outputFiles);
        String string = $this$writeModule.getSirModule().getName();
        destination$iv$iv = $this$writeModule.getSirModule().getImports();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SirImport)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{KotlinRuntimeModule.INSTANCE.getName(), $this$writeModule.getBridgesModuleName()};
            if (!(!SetsKt.setOf((Object[])objectArray).contains(it.getModuleName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SirImport)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(new SwiftExportModule.Reference(it.getModuleName()));
        }
        list = (List)destination$iv$iv2;
        String string2 = $this$writeModule.getBridgesModuleName();
        return new SwiftExportModule.BridgesToKotlin(outputFiles, string2, string, list);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MultipleModulesHandlingStrategy.values().length];
            try {
                nArray[MultipleModulesHandlingStrategy.OneToOneModuleMapping.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MultipleModulesHandlingStrategy.IntoSingleModule.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

