/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeTypePointer;
import org.jetbrains.kotlin.analysis.api.fir.utils.ConeTypePointerWrapper;
import org.jetbrains.kotlin.analysis.api.fir.utils.DelegatingConeTypePointer;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\t\"\b\b\u0000\u0010\f*\u00020\u00062\u0006\u0010\r\u001a\u0002H\f2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u0002H\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\t0\u000f\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\u0004\u0018\u0001H\f\"\b\b\u0000\u0010\f*\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\t2\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard;", "", "<init>", "()V", "creationCache", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointerWrapper;", "restorationCache", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState;", "createPointer", "T", "coneType", "create", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;", "restorePointer", "pointer", "session", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "(Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypePointer;Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "RestorationState", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nConeTypePointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypePointer.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,493:1\n81#2,7:494\n76#2,2:501\n57#2:503\n78#2:504\n*S KotlinDebug\n*F\n+ 1 ConeTypePointer.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard\n*L\n74#1:494,7\n74#1:501,2\n74#1:503\n74#1:504\n*E\n"})
public final class ConeTypeRecursionGuard {
    @NotNull
    private final Map<ConeKotlinType, ConeTypePointerWrapper<?>> creationCache = new LinkedHashMap();
    @NotNull
    private final Map<ConeTypePointer<?>, RestorationState<?>> restorationCache = new LinkedHashMap();

    @NotNull
    public final <T extends ConeKotlinType> ConeTypePointer<T> createPointer(@NotNull T coneType, @NotNull Function1<? super T, ? extends ConeTypePointer<? extends T>> create) {
        Intrinsics.checkNotNullParameter(coneType, (String)"coneType");
        Intrinsics.checkNotNullParameter(create, (String)"create");
        ConeTypePointerWrapper<?> existingWrapper = this.creationCache.get(coneType);
        if (existingWrapper != null) {
            return new DelegatingConeTypePointer(existingWrapper);
        }
        ConeTypePointerWrapper wrapper = new ConeTypePointerWrapper();
        this.creationCache.put(coneType, wrapper);
        ConeTypePointer pointer = (ConeTypePointer)create.invoke(coneType);
        wrapper.initialize(pointer);
        return pointer;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T extends ConeKotlinType> T restorePointer(@NotNull ConeTypePointer<? extends T> pointer, @NotNull KaFirSession session2) {
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        RestorationState<?> state = this.restorationCache.get(pointer);
        if (state instanceof RestorationState.Completed) {
            return ((RestorationState.Completed)state).getType();
        }
        if (state instanceof RestorationState.InProgress) {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            void $this$buildAttachment$iv$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            void cause$iv$iv;
            void message$iv$iv;
            String message$iv = "Unhandled recursive pointer restoration";
            Object cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            String string = message$iv;
            Object var9_9 = cause$iv;
            String attachmentName$iv$iv = attachmentName$iv;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments((String)message$iv$iv, (Throwable)cause$iv$iv);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = (KotlinExceptionWithAttachments)exception$iv$iv;
            String name$iv$iv$iv = attachmentName$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = name$iv$iv$iv;
            void var19_19 = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$restorePointer_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            $this$restorePointer_u24lambda_u240.withEntry("pointer type", Reflection.getOrCreateKotlinClass(pointer.getClass()).getSimpleName());
            var19_19.withAttachment(string2, (Object)exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        if (state != null) {
            throw new NoWhenBranchMatchedException();
        }
        this.restorationCache.put(pointer, new RestorationState.InProgress());
        T restoredType = pointer.restore(session2, this);
        this.restorationCache.put(pointer, new RestorationState.Completed<T>(restoredType));
        return restoredType;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState;", "T", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "", "<init>", "()V", "InProgress", "Completed", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState$Completed;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState$InProgress;", "analysis-api-fir"})
    private static abstract class RestorationState<T extends ConeKotlinType> {
        private RestorationState() {
        }

        public /* synthetic */ RestorationState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState$Completed;", "T", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState;", "type", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "analysis-api-fir"})
        public static final class Completed<T extends ConeKotlinType>
        extends RestorationState<T> {
            @Nullable
            private final T type;

            public Completed(@Nullable T type2) {
                super(null);
                this.type = type2;
            }

            @Nullable
            public final T getType() {
                return this.type;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState$InProgress;", "T", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/ConeTypeRecursionGuard$RestorationState;", "<init>", "()V", "analysis-api-fir"})
        public static final class InProgress<T extends ConeKotlinType>
        extends RestorationState<T> {
            public InProgress() {
                super(null);
            }
        }
    }
}

