/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.sessions;

import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.lifetime.KaBaseLifetimeTracker;
import org.jetbrains.kotlin.analysis.api.impl.base.permissions.KaBaseWriteActionStartedChecker;
import org.jetbrains.kotlin.analysis.api.impl.base.restrictedAnalysis.KaBaseRestrictedAnalysisException;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaBaseUseSiteLibraryModuleAnalysisException;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.ProhibitedAnalysisException;
import org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import org.jetbrains.kotlin.analysis.api.platform.KotlinPlatformSettings;
import org.jetbrains.kotlin.analysis.api.platform.lifetime.KotlinLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.platform.permissions.KaAnalysisPermissionChecker;
import org.jetbrains.kotlin.analysis.api.platform.restrictedAnalysis.KotlinRestrictedAnalysisService;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.utils.errors.ExceptionAttachmentBuilderHelpersKt;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@KaImplementationDetail
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0004J\u0018\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002J \u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J \u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00105\u001a\u00020)2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u00105\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0002R!\u0010\u0006\u001a\u00020\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\u00020\u000f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\r\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012R#\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\r\u0012\u0004\b\u0016\u0010\t\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\u00020\u001b8DX\u0085\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\r\u0012\u0004\b\u001c\u0010\t\u001a\u0004\b\u001d\u0010\u001eR!\u0010 \u001a\u00020!8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\r\u0012\u0004\b\"\u0010\t\u001a\u0004\b#\u0010$R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/session/KaSessionProvider;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "permissionChecker", "Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "getPermissionChecker$annotations", "()V", "getPermissionChecker", "()Lorg/jetbrains/kotlin/analysis/api/platform/permissions/KaAnalysisPermissionChecker;", "permissionChecker$delegate", "Lkotlin/Lazy;", "lifetimeTracker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "getLifetimeTracker$annotations", "getLifetimeTracker", "()Lorg/jetbrains/kotlin/analysis/api/impl/base/lifetime/KaBaseLifetimeTracker;", "lifetimeTracker$delegate", "restrictedAnalysisService", "Lorg/jetbrains/kotlin/analysis/api/platform/restrictedAnalysis/KotlinRestrictedAnalysisService;", "getRestrictedAnalysisService$annotations", "getRestrictedAnalysisService", "()Lorg/jetbrains/kotlin/analysis/api/platform/restrictedAnalysis/KotlinRestrictedAnalysisService;", "restrictedAnalysisService$delegate", "tokenFactory", "Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinLifetimeTokenFactory;", "getTokenFactory$annotations", "getTokenFactory", "()Lorg/jetbrains/kotlin/analysis/api/platform/lifetime/KotlinLifetimeTokenFactory;", "tokenFactory$delegate", "kotlinPlatformSettings", "Lorg/jetbrains/kotlin/analysis/api/platform/KotlinPlatformSettings;", "getKotlinPlatformSettings$annotations", "getKotlinPlatformSettings", "()Lorg/jetbrains/kotlin/analysis/api/platform/KotlinPlatformSettings;", "kotlinPlatformSettings$delegate", "writeActionStartedChecker", "Lorg/jetbrains/kotlin/analysis/api/impl/base/permissions/KaBaseWriteActionStartedChecker;", "checkUseSiteModule", "", "useSiteModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "beforeEnteringAnalysis", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "useSiteElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "handleAnalysisException", "", "throwable", "", "afterLeavingAnalysis", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nKaBaseSessionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaBaseSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,140:1\n118#2,11:141\n57#2:152\n129#2,3:153\n*S KotlinDebug\n*F\n+ 1 KaBaseSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider\n*L\n65#1:141,11\n65#1:152\n65#1:153,3\n*E\n"})
public abstract class KaBaseSessionProvider
extends KaSessionProvider {
    @NotNull
    private final Lazy permissionChecker$delegate;
    @NotNull
    private final Lazy lifetimeTracker$delegate;
    @NotNull
    private final Lazy restrictedAnalysisService$delegate;
    @NotNull
    private final Lazy tokenFactory$delegate;
    @NotNull
    private final Lazy kotlinPlatformSettings$delegate;
    @NotNull
    private final KaBaseWriteActionStartedChecker writeActionStartedChecker;

    public KaBaseSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.permissionChecker$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.permissionChecker_delegate$lambda$0(project));
        this.lifetimeTracker$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.lifetimeTracker_delegate$lambda$0(project));
        this.restrictedAnalysisService$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.restrictedAnalysisService_delegate$lambda$0(project));
        this.tokenFactory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.tokenFactory_delegate$lambda$0(project));
        this.kotlinPlatformSettings$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaBaseSessionProvider.kotlinPlatformSettings_delegate$lambda$0(project));
        this.writeActionStartedChecker = new KaBaseWriteActionStartedChecker(this);
    }

    private final KaAnalysisPermissionChecker getPermissionChecker() {
        Lazy lazy = this.permissionChecker$delegate;
        return (KaAnalysisPermissionChecker)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getPermissionChecker$annotations() {
    }

    private final KaBaseLifetimeTracker getLifetimeTracker() {
        Lazy lazy = this.lifetimeTracker$delegate;
        return (KaBaseLifetimeTracker)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getLifetimeTracker$annotations() {
    }

    private final KotlinRestrictedAnalysisService getRestrictedAnalysisService() {
        Lazy lazy = this.restrictedAnalysisService$delegate;
        return (KotlinRestrictedAnalysisService)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getRestrictedAnalysisService$annotations() {
    }

    @NotNull
    protected final KotlinLifetimeTokenFactory getTokenFactory() {
        Lazy lazy = this.tokenFactory$delegate;
        return (KotlinLifetimeTokenFactory)lazy.getValue();
    }

    @KaCachedService
    protected static /* synthetic */ void getTokenFactory$annotations() {
    }

    private final KotlinPlatformSettings getKotlinPlatformSettings() {
        Lazy lazy = this.kotlinPlatformSettings$delegate;
        return (KotlinPlatformSettings)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getKotlinPlatformSettings$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    protected final void checkUseSiteModule(@NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        if (useSiteModule instanceof KaLibraryModule && !this.getKotlinPlatformSettings().getAllowUseSiteLibraryModuleAnalysis()) {
            throw new KaBaseUseSiteLibraryModuleAnalysisException((KaLibraryModule)useSiteModule);
        }
        boolean condition$iv = KaModuleKt.isResolvable(useSiteModule);
        String attachmentName$iv = "info.txt";
        boolean $i$f$requireWithAttachment = false;
        if (!condition$iv) {
            void $this$requireWithAttachment_u24lambda_u240$iv;
            void $this$buildAttachment$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean bl = false;
            String string = '`' + Reflection.getOrCreateKotlinClass(useSiteModule.getClass()).getSimpleName() + "` is not resolvable and thus cannot be a use-site module.";
            KotlinIllegalArgumentExceptionWithAttachments exception$iv = new KotlinIllegalArgumentExceptionWithAttachments(string);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = (KotlinExceptionWithAttachments)exception$iv;
            String name$iv$iv = attachmentName$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = name$iv$iv;
            void var13_15 = $this$buildAttachment$iv$iv;
            boolean bl2 = false;
            void $this$checkUseSiteModule_u24lambda_u241 = $this$requireWithAttachment_u24lambda_u240$iv;
            boolean bl3 = false;
            ExceptionAttachmentBuilderHelpersKt.withKaModuleEntry((ExceptionAttachmentBuilder)$this$checkUseSiteModule_u24lambda_u241, "useSiteModule", useSiteModule);
            var13_15.withAttachment(string2, (Object)exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        PsiUtilCore.ensureValid((PsiElement)((PsiElement)useSiteElement));
        this.beforeEnteringAnalysis(session);
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.beforeEnteringAnalysis(session);
    }

    private final void beforeEnteringAnalysis(KaSession session) {
        if (!this.getPermissionChecker().isAnalysisAllowed()) {
            throw new ProhibitedAnalysisException("Analysis is not allowed: " + this.getPermissionChecker().getRejectionReason());
        }
        ProgressManager.checkCanceled();
        KotlinRestrictedAnalysisService kotlinRestrictedAnalysisService = this.getRestrictedAnalysisService();
        if (kotlinRestrictedAnalysisService != null) {
            KotlinRestrictedAnalysisService $this$beforeEnteringAnalysis_u24lambda_u240 = kotlinRestrictedAnalysisService;
            boolean bl = false;
            if ($this$beforeEnteringAnalysis_u24lambda_u240.isAnalysisRestricted() && !$this$beforeEnteringAnalysis_u24lambda_u240.isRestrictedAnalysisAllowed()) {
                $this$beforeEnteringAnalysis_u24lambda_u240.rejectRestrictedAnalysis();
                throw new KotlinNothingValueException();
            }
        }
        this.getLifetimeTracker().beforeEnteringAnalysis(session);
        this.writeActionStartedChecker.beforeEnteringAnalysis();
    }

    @Override
    @NotNull
    public Void handleAnalysisException(@NotNull Throwable throwable, @NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        this.handleAnalysisException(throwable);
        throw new KotlinNothingValueException();
    }

    @Override
    @NotNull
    public Void handleAnalysisException(@NotNull Throwable throwable, @NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.handleAnalysisException(throwable);
        throw new KotlinNothingValueException();
    }

    private final Void handleAnalysisException(Throwable throwable) {
        KotlinRestrictedAnalysisService kotlinRestrictedAnalysisService = this.getRestrictedAnalysisService();
        boolean bl = kotlinRestrictedAnalysisService != null ? kotlinRestrictedAnalysisService.isAnalysisRestricted() : false;
        if (bl && !(throwable instanceof Error) && !PlatformExceptionUtilsKt.shouldIjPlatformExceptionBeRethrown((Throwable)throwable)) {
            throw new KaBaseRestrictedAnalysisException(throwable);
        }
        throw throwable;
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        this.afterLeavingAnalysis(session);
    }

    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.afterLeavingAnalysis(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void afterLeavingAnalysis(KaSession session) {
        try {
            this.writeActionStartedChecker.afterLeavingAnalysis();
        }
        finally {
            this.getLifetimeTracker().afterLeavingAnalysis(session);
        }
    }

    private static final KaAnalysisPermissionChecker permissionChecker_delegate$lambda$0(Project $project) {
        return KaAnalysisPermissionChecker.Companion.getInstance($project);
    }

    private static final KaBaseLifetimeTracker lifetimeTracker_delegate$lambda$0(Project $project) {
        return KaBaseLifetimeTracker.Companion.getInstance($project);
    }

    private static final KotlinRestrictedAnalysisService restrictedAnalysisService_delegate$lambda$0(Project $project) {
        return KotlinRestrictedAnalysisService.Companion.getInstance($project);
    }

    private static final KotlinLifetimeTokenFactory tokenFactory_delegate$lambda$0(Project $project) {
        return KotlinLifetimeTokenFactory.Companion.getInstance($project);
    }

    private static final KotlinPlatformSettings kotlinPlatformSettings_delegate$lambda$0(Project $project) {
        return KotlinPlatformSettings.Companion.getInstance($project);
    }
}

