/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.projectStructure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.projectStructure.KaBaseResolutionScope;
import org.jetbrains.kotlin.analysis.api.platform.caches.UtilsKt;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaGlobalSearchScopeMerger;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaResolutionScope;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaResolutionScopeProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseResolutionScopeProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaResolutionScopeProvider;", "<init>", "()V", "getResolutionScope", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KaResolutionScope;", "module", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getAnalyzableModules", "", "buildSearchScope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "analyzableModules", "createBuiltinsScope", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "resolutionScopeCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nKaBaseResolutionScopeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaBaseResolutionScopeProvider.kt\norg/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseResolutionScopeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1660#2,3:64\n2791#2,3:67\n*S KotlinDebug\n*F\n+ 1 KaBaseResolutionScopeProvider.kt\norg/jetbrains/kotlin/analysis/api/impl/base/projectStructure/KaBaseResolutionScopeProvider\n*L\n44#1:64,3\n45#1:67,3\n*E\n"})
public final class KaBaseResolutionScopeProvider
implements KaResolutionScopeProvider {
    @NotNull
    private final Cache<KaModule, KaResolutionScope> resolutionScopeCache;

    public KaBaseResolutionScopeProvider() {
        Cache cache = Caffeine.newBuilder().weakKeys().softValues().expireAfterAccess(Duration.ofSeconds(10L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.resolutionScopeCache = cache;
    }

    @Override
    @NotNull
    public KaResolutionScope getResolutionScope(@NotNull KaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.getOrPut(this.resolutionScopeCache, module, arg_0 -> KaBaseResolutionScopeProvider.getResolutionScope$lambda$0(this, arg_0));
    }

    private final Set<KaModule> getAnalyzableModules(KaModule module) {
        Set set;
        Set $this$getAnalyzableModules_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getAnalyzableModules_u24lambda_u240.add(module);
        $this$getAnalyzableModules_u24lambda_u240.addAll((Collection)module.getDirectRegularDependencies());
        $this$getAnalyzableModules_u24lambda_u240.addAll((Collection)module.getDirectFriendDependencies());
        $this$getAnalyzableModules_u24lambda_u240.addAll((Collection)module.getTransitiveDependsOnDependencies());
        if (module instanceof KaLibrarySourceModule) {
            $this$getAnalyzableModules_u24lambda_u240.add(((KaLibrarySourceModule)module).getBinaryLibrary());
        }
        return SetsKt.build((Set)set);
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope buildSearchScope(KaModule module, Set<? extends KaModule> analyzableModules) {
        boolean bl;
        List $this$buildSearchScope_u24lambda_u240;
        List list;
        block5: {
            void $this$mapTo$iv;
            $this$buildSearchScope_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Iterable iterable = analyzableModules;
            Collection destination$iv = $this$buildSearchScope_u24lambda_u240;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                KaModule kaModule = (KaModule)item$iv;
                Collection collection = destination$iv;
                boolean bl3 = false;
                collection.add(it.getContentScope());
            }
            Iterable $this$none$iv = analyzableModules;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KaModule it = (KaModule)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof KaBuiltinsModule)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            $this$buildSearchScope_u24lambda_u240.add(this.createBuiltinsScope(module.getProject()));
        }
        List scopes = CollectionsKt.build((List)list);
        return KaGlobalSearchScopeMerger.Companion.getInstance(module.getProject()).union(scopes);
    }

    private final GlobalSearchScope createBuiltinsScope(Project project) {
        return BuiltinsVirtualFileProvider.Companion.getInstance().createBuiltinsScope(project);
    }

    private static final KaResolutionScope getResolutionScope$lambda$0(KaBaseResolutionScopeProvider this$0, KaModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set<KaModule> analyzableModules = this$0.getAnalyzableModules(module);
        GlobalSearchScope searchScope = this$0.buildSearchScope(module, analyzableModules);
        return new KaBaseResolutionScope(module, searchScope, analyzableModules);
    }
}

