/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KaImplicitReceiver;
import org.jetbrains.kotlin.analysis.api.components.KaScopeContext;
import org.jetbrains.kotlin.analysis.api.components.KaUseSiteVisibilityChecker;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirFileSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirPsiJavaClassSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KaFirSymbol;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInaccessibleLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaInvalidLifetimeOwnerAccessException;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.types.TypeUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.projectStructure.LLFirModuleDataKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001b\u0010\u001d\u001a\u0004\u0018\u00010\u0016*\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KaFirUseSiteVisibilityChecker;", "Lorg/jetbrains/kotlin/analysis/api/components/KaUseSiteVisibilityChecker;", "position", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "positionModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "useSiteFile", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirFileSymbol;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;Ljava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirFileSymbol;Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "isVisible", "", "candidateSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "getTargetSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "candidateDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isVisibleByPsi", "Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirPsiJavaClassSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirPsiJavaClassSymbol;Lorg/jetbrains/kotlin/analysis/api/fir/symbols/KaFirFileSymbol;)Ljava/lang/Boolean;", "isVisibleFromSuperInterfaceOfImplicitReceiver", "explicitDispatchReceiver", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirVisibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirVisibilityChecker.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirUseSiteVisibilityChecker\n+ 2 KaLifetimeOwner.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeOwnerKt\n+ 3 KaLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeTokenKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/analysis/utils/printer/PsiUtilsKt\n*L\n1#1,217:1\n47#2:218\n36#2:219\n37#2:239\n48#2:240\n47#3,19:220\n1#4:241\n14#5:242\n*S KotlinDebug\n*F\n+ 1 KaFirVisibilityChecker.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KaFirUseSiteVisibilityChecker\n*L\n120#1:218\n120#1:219\n120#1:239\n120#1:240\n120#1:220,19\n204#1:242\n*E\n"})
final class KaFirUseSiteVisibilityChecker
implements KaUseSiteVisibilityChecker {
    @NotNull
    private final PsiElement position;
    @NotNull
    private final KaModule positionModule;
    @NotNull
    private final List<FirDeclaration> containingDeclarations;
    @Nullable
    private final FirExpression dispatchReceiver;
    @NotNull
    private final KaFirFileSymbol useSiteFile;
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;

    public KaFirUseSiteVisibilityChecker(@NotNull PsiElement position, @NotNull KaModule positionModule, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable FirExpression dispatchReceiver, @NotNull KaFirFileSymbol useSiteFile, @NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)positionModule, (String)"positionModule");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        Intrinsics.checkNotNullParameter((Object)useSiteFile, (String)"useSiteFile");
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.position = position;
        this.positionModule = positionModule;
        this.containingDeclarations = containingDeclarations;
        this.dispatchReceiver = dispatchReceiver;
        this.useSiteFile = useSiteFile;
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KaLifetimeToken getToken() {
        return this.token;
    }

    @Override
    public boolean isVisible(@NotNull KaDeclarationSymbol candidateSymbol) {
        FirExpression firExpression2;
        FirDeclaration it2;
        Intrinsics.checkNotNullParameter((Object)candidateSymbol, (String)"candidateSymbol");
        KaLifetimeOwner $this$withValidityAssertion$iv = this;
        boolean $i$f$withValidityAssertion = false;
        KaLifetimeOwner $this$assertIsValidAndAccessible$iv$iv = $this$withValidityAssertion$iv;
        boolean $i$f$assertIsValidAndAccessible = false;
        KaLifetimeToken $this$assertIsValidAndAccessible$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv.getToken();
        boolean $i$f$assertIsValidAndAccessible2 = false;
        KaLifetimeToken $this$assertIsValid$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsValid = false;
        if (!$this$assertIsValid$iv$iv$iv$iv.isValid()) {
            throw new KaInvalidLifetimeOwnerAccessException("Access to invalid " + $this$assertIsValid$iv$iv$iv$iv + ": " + $this$assertIsValid$iv$iv$iv$iv.getInvalidationReason());
        }
        KaLifetimeToken $this$assertIsAccessible$iv$iv$iv$iv = $this$assertIsValidAndAccessible$iv$iv$iv;
        boolean $i$f$assertIsAccessible = false;
        if (!$this$assertIsAccessible$iv$iv$iv$iv.isAccessible()) {
            throw new KaInaccessibleLifetimeOwnerAccessException($this$assertIsAccessible$iv$iv$iv$iv + " is inaccessible: " + $this$assertIsAccessible$iv$iv$iv$iv.getInaccessibilityReason());
        }
        boolean bl = false;
        if (!(candidateSymbol instanceof KaFirSymbol)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (candidateSymbol instanceof KaFirPsiJavaClassSymbol) {
            Boolean bl2 = this.isVisibleByPsi((KaFirPsiJavaClassSymbol)candidateSymbol, this.useSiteFile);
            if (bl2 != null) {
                boolean it2 = bl2;
                boolean firExpression2 = false;
                return it2;
            }
        }
        FirMemberDeclaration firMemberDeclaration = (it2 = ((KaFirSymbol)((Object)candidateSymbol)).getFirSymbol().getFir()) instanceof FirMemberDeclaration ? (FirMemberDeclaration)it2 : null;
        if (firMemberDeclaration == null) {
            return true;
        }
        FirMemberDeclaration candidateDeclaration = firMemberDeclaration;
        boolean dispatchReceiverCanBeExplicit = candidateSymbol instanceof KaCallableSymbol && !((KaCallableSymbol)candidateSymbol).isExtension();
        FirExpression it3 = firExpression2 = this.dispatchReceiver;
        boolean bl3 = false;
        FirExpression explicitDispatchReceiver = dispatchReceiverCanBeExplicit ? firExpression2 : null;
        LLFirSession targetSession = this.getTargetSession(candidateDeclaration);
        if (FirVisibilityChecker.isVisible$default((FirVisibilityChecker)FirVisibilityCheckerKt.getVisibilityChecker((FirSession)targetSession), (FirMemberDeclaration)candidateDeclaration, (FirSession)targetSession, (FirFile)((FirFile)((FirFileSymbol)this.useSiteFile.getFirSymbol()).getFir()), this.containingDeclarations, (FirExpression)explicitDispatchReceiver, (boolean)false, null, (boolean)false, null, (int)480, null)) {
            return true;
        }
        return this.isVisibleFromSuperInterfaceOfImplicitReceiver(candidateSymbol, explicitDispatchReceiver);
    }

    private final LLFirSession getTargetSession(FirMemberDeclaration candidateDeclaration) {
        KaModule candidateModule = LLFirModuleDataKt.getLlFirModuleData((FirElementWithResolveState)candidateDeclaration).getKtModule();
        KaModule targetModule = this.positionModule instanceof KaDanglingFileModule && !Intrinsics.areEqual((Object)candidateModule, (Object)this.positionModule) ? ((KaDanglingFileModule)this.positionModule).getContextModule() : this.positionModule;
        return this.analysisSession.getResolutionFacade().getSessionFor(targetModule);
    }

    private final Boolean isVisibleByPsi(KaFirPsiJavaClassSymbol $this$isVisibleByPsi, KaFirFileSymbol useSiteFile) {
        Boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isVisibleByPsi.getVisibility().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                KaFirPsiJavaClassSymbol outerClass = $this$isVisibleByPsi.getOuterClass();
                if (outerClass == null) {
                    bl = true;
                    break;
                }
                bl = this.isVisibleByPsi(outerClass, useSiteFile);
                break;
            }
            case 3: {
                boolean isSamePackage = Intrinsics.areEqual((Object)$this$isVisibleByPsi.getClassId().getPackageFqName(), (Object)UtilsKt.getPackageFqName((FirFile)((FirFile)((FirFileSymbol)useSiteFile.getFirSymbol()).getFir())));
                if (!isSamePackage) {
                    bl = false;
                    break;
                }
                KaFirPsiJavaClassSymbol outerClass = $this$isVisibleByPsi.getOuterClass();
                if (outerClass == null) {
                    bl = true;
                    break;
                }
                bl = this.isVisibleByPsi(outerClass, useSiteFile);
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isVisibleFromSuperInterfaceOfImplicitReceiver(KaDeclarationSymbol candidateSymbol, FirExpression explicitDispatchReceiver) {
        void $this$parentOfType$iv;
        if (explicitDispatchReceiver != null) {
            return false;
        }
        if (!(candidateSymbol instanceof KaCallableSymbol)) {
            return false;
        }
        if (candidateSymbol.getVisibility() != KaSymbolVisibility.PUBLIC) {
            return false;
        }
        KaFirSession $this$isVisibleFromSuperInterfaceOfImplicitReceiver_u24lambda_u240 = this.analysisSession;
        boolean bl = false;
        KaSymbol kaSymbol = $this$isVisibleFromSuperInterfaceOfImplicitReceiver_u24lambda_u240.getContainingSymbol(candidateSymbol);
        KaClassSymbol kaClassSymbol = kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null;
        if (kaClassSymbol == null) {
            return false;
        }
        KaClassSymbol containingSymbol = kaClassSymbol;
        if (containingSymbol.getClassKind() != KaClassKind.INTERFACE) {
            return false;
        }
        PsiElement psiElement = this.position;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtElement ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtElement.class, (boolean)false);
        if (ktElement == null) {
            return false;
        }
        KtElement ktPosition = ktElement;
        KtFile ktFile = ktPosition.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KaScopeContext scopeContext = $this$isVisibleFromSuperInterfaceOfImplicitReceiver_u24lambda_u240.scopeContext(ktFile, ktPosition);
        for (KaImplicitReceiver implicitReceiver : scopeContext.getImplicitReceivers()) {
            KaClassSymbol classSymbol;
            KaClassLikeSymbol kaClassLikeSymbol = TypeUtilsKt.getSymbol(implicitReceiver.getType());
            KaClassSymbol kaClassSymbol2 = kaClassLikeSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaClassLikeSymbol : null;
            if (kaClassSymbol2 == null || !$this$isVisibleFromSuperInterfaceOfImplicitReceiver_u24lambda_u240.isSubClassOf(classSymbol = kaClassSymbol2, containingSymbol)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KaSymbolVisibility.values().length];
            try {
                nArray[KaSymbolVisibility.PRIVATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.PUBLIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.PACKAGE_PRIVATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

