/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.export.utilities;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"hashCodeCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "isHashCode", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "analysis-api-based-export-common"})
@SourceDebugExtension(value={"SMAP\nisHashCode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 isHashCode.kt\norg/jetbrains/kotlin/analysis/api/export/utilities/IsHashCodeKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,18:1\n1275#2,2:19\n*S KotlinDebug\n*F\n+ 1 isHashCode.kt\norg/jetbrains/kotlin/analysis/api/export/utilities/IsHashCodeKt\n*L\n17#1:19,2\n*E\n"})
public final class IsHashCodeKt {
    @NotNull
    private static final CallableId hashCodeCallableId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHashCode(@NotNull KaSession $this$isHashCode, @NotNull KaCallableSymbol symbol) {
        KaCallableSymbol overriddenSymbol;
        Intrinsics.checkNotNullParameter((Object)$this$isHashCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (Intrinsics.areEqual((Object)symbol.getCallableId(), (Object)hashCodeCallableId)) return true;
        Sequence<KaCallableSymbol> $this$any$iv = $this$isHashCode.getAllOverriddenSymbols(symbol);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            overriddenSymbol = (KaCallableSymbol)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)overriddenSymbol.getCallableId(), (Object)hashCodeCallableId));
        return true;
    }

    static {
        ClassId classId = StandardClassIds.INSTANCE.getAny();
        Name name = Name.identifier((String)"hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        hashCodeCallableId = new CallableId(classId, name);
    }
}

