/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.bridge;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.sir.bridge.BridgeRequest;
import org.jetbrains.kotlin.sir.bridge.FunctionBridgeRequest;
import org.jetbrains.kotlin.sir.bridge.TypeBindingBridgeRequest;
import org.jetbrains.kotlin.sir.util.SirExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/StableBridgeRequestComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/sir/bridge/BridgeRequest;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "lhs", "rhs", "sir-compiler-bridge"})
public final class StableBridgeRequestComparator
implements Comparator<BridgeRequest> {
    @NotNull
    public static final StableBridgeRequestComparator INSTANCE = new StableBridgeRequestComparator();

    private StableBridgeRequestComparator() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compare(@NotNull BridgeRequest lhs, @NotNull BridgeRequest rhs) {
        int n;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        BridgeRequest bridgeRequest = lhs;
        if (bridgeRequest instanceof FunctionBridgeRequest) {
            BridgeRequest bridgeRequest2 = rhs;
            if (bridgeRequest2 instanceof FunctionBridgeRequest) {
                n = ((FunctionBridgeRequest)lhs).getBridgeName().compareTo(((FunctionBridgeRequest)rhs).getBridgeName());
                return n;
            }
            if (!(bridgeRequest2 instanceof TypeBindingBridgeRequest)) throw new NoWhenBranchMatchedException();
            return 1;
        }
        if (!(bridgeRequest instanceof TypeBindingBridgeRequest)) throw new NoWhenBranchMatchedException();
        BridgeRequest bridgeRequest3 = rhs;
        if (bridgeRequest3 instanceof FunctionBridgeRequest) {
            return -1;
        }
        if (!(bridgeRequest3 instanceof TypeBindingBridgeRequest)) throw new NoWhenBranchMatchedException();
        n = SirExtensionsKt.getSwiftFqName(((TypeBindingBridgeRequest)lhs).getSirTypeDeclaration()).compareTo(SirExtensionsKt.getSwiftFqName(((TypeBindingBridgeRequest)rhs).getSirTypeDeclaration()));
        return n;
    }
}

