/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.sir.SirAccessor;
import org.jetbrains.kotlin.sir.SirCallable;
import org.jetbrains.kotlin.sir.SirDeclaration;
import org.jetbrains.kotlin.sir.SirDeclarationParent;
import org.jetbrains.kotlin.sir.SirErrorType;
import org.jetbrains.kotlin.sir.SirExistentialType;
import org.jetbrains.kotlin.sir.SirExtension;
import org.jetbrains.kotlin.sir.SirFunction;
import org.jetbrains.kotlin.sir.SirFunctionalType;
import org.jetbrains.kotlin.sir.SirGetter;
import org.jetbrains.kotlin.sir.SirInit;
import org.jetbrains.kotlin.sir.SirMutableDeclarationContainer;
import org.jetbrains.kotlin.sir.SirNamed;
import org.jetbrains.kotlin.sir.SirNamedDeclaration;
import org.jetbrains.kotlin.sir.SirNominalType;
import org.jetbrains.kotlin.sir.SirParameter;
import org.jetbrains.kotlin.sir.SirSetter;
import org.jetbrains.kotlin.sir.SirType;
import org.jetbrains.kotlin.sir.SirUnsupportedType;
import org.jetbrains.kotlin.sir.SirVariable;
import org.jetbrains.kotlin.sir.util.MiscValidationKt;
import org.jetbrains.kotlin.sir.util.SirSwiftModule;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a'\u0010\u001a\u001a\u0002H\u001b\"\b\b\u0000\u0010\u001b*\u00020\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f\u00a2\u0006\u0002\u0010 \"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0007*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u0017*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\"\u0015\u0010\u0019\u001a\u00020\u0017*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018\"\u0015\u0010!\u001a\u00020\u0013*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u001a\u0010$\u001a\u0004\u0018\u00010\u0013*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0017\u0010'\u001a\u0004\u0018\u00010\u0013*\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\"\u0015\u0010+\u001a\u00020\u0013*\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u0015\u0010+\u001a\u00020\u0013*\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b-\u00100\"\u0015\u0010+\u001a\u00020\u0013*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b-\u00101\u00a8\u00062"}, d2={"allParameters", "", "Lorg/jetbrains/kotlin/sir/SirParameter;", "Lorg/jetbrains/kotlin/sir/SirCallable;", "getAllParameters", "(Lorg/jetbrains/kotlin/sir/SirCallable;)Ljava/util/List;", "returnType", "Lorg/jetbrains/kotlin/sir/SirType;", "getReturnType", "(Lorg/jetbrains/kotlin/sir/SirCallable;)Lorg/jetbrains/kotlin/sir/SirType;", "valueType", "Lorg/jetbrains/kotlin/sir/SirAccessor;", "getValueType", "(Lorg/jetbrains/kotlin/sir/SirAccessor;)Lorg/jetbrains/kotlin/sir/SirType;", "accessors", "Lorg/jetbrains/kotlin/sir/SirVariable;", "getAccessors", "(Lorg/jetbrains/kotlin/sir/SirVariable;)Ljava/util/List;", "name", "", "getName", "(Lorg/jetbrains/kotlin/sir/SirParameter;)Ljava/lang/String;", "isVoid", "", "(Lorg/jetbrains/kotlin/sir/SirType;)Z", "isNever", "addChild", "T", "Lorg/jetbrains/kotlin/sir/SirDeclaration;", "Lorg/jetbrains/kotlin/sir/SirMutableDeclarationContainer;", "producer", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/sir/SirMutableDeclarationContainer;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/sir/SirDeclaration;", "swiftName", "getSwiftName", "(Lorg/jetbrains/kotlin/sir/SirType;)Ljava/lang/String;", "swiftParentNamePrefix", "getSwiftParentNamePrefix", "(Lorg/jetbrains/kotlin/sir/SirDeclaration;)Ljava/lang/String;", "swiftFqNameOrNull", "Lorg/jetbrains/kotlin/sir/SirDeclarationParent;", "getSwiftFqNameOrNull", "(Lorg/jetbrains/kotlin/sir/SirDeclarationParent;)Ljava/lang/String;", "swiftFqName", "Lorg/jetbrains/kotlin/sir/SirNamedDeclaration;", "getSwiftFqName", "(Lorg/jetbrains/kotlin/sir/SirNamedDeclaration;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/sir/SirFunction;", "(Lorg/jetbrains/kotlin/sir/SirFunction;)Ljava/lang/String;", "(Lorg/jetbrains/kotlin/sir/SirVariable;)Ljava/lang/String;", "sir"})
@SourceDebugExtension(value={"SMAP\nSirExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SirExtensions.kt\norg/jetbrains/kotlin/sir/util/SirExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class SirExtensionsKt {
    @NotNull
    public static final List<SirParameter> getAllParameters(@NotNull SirCallable $this$allParameters) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$allParameters, (String)"<this>");
        SirCallable sirCallable = $this$allParameters;
        if (sirCallable instanceof SirFunction) {
            list = ((SirFunction)$this$allParameters).getParameters();
        } else if (sirCallable instanceof SirInit) {
            list = ((SirInit)$this$allParameters).getParameters();
        } else if (sirCallable instanceof SirSetter) {
            list = CollectionsKt.listOf((Object)new SirParameter(null, ((SirSetter)$this$allParameters).getParameterName(), SirExtensionsKt.getValueType((SirAccessor)$this$allParameters), null, 9, null));
        } else if (sirCallable instanceof SirGetter) {
            list = CollectionsKt.emptyList();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public static final SirType getReturnType(@NotNull SirCallable $this$returnType) {
        SirType sirType;
        Intrinsics.checkNotNullParameter((Object)$this$returnType, (String)"<this>");
        SirCallable sirCallable = $this$returnType;
        if (sirCallable instanceof SirFunction) {
            sirType = ((SirFunction)$this$returnType).getReturnType();
        } else if (sirCallable instanceof SirGetter) {
            sirType = SirExtensionsKt.getValueType((SirAccessor)$this$returnType);
        } else if (sirCallable instanceof SirSetter || sirCallable instanceof SirInit) {
            sirType = new SirNominalType(SirSwiftModule.INSTANCE.getVoid(), null, null, null, 14, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sirType;
    }

    @NotNull
    public static final SirType getValueType(@NotNull SirAccessor $this$valueType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueType, (String)"<this>");
        SirDeclarationParent it = $this$valueType.getParent();
        boolean bl = false;
        if (!(it instanceof SirVariable)) {
            throw new IllegalStateException(("Invalid accessor parent " + $this$valueType.getParent()).toString());
        }
        return ((SirVariable)it).getType();
    }

    @NotNull
    public static final List<SirAccessor> getAccessors(@NotNull SirVariable $this$accessors) {
        Intrinsics.checkNotNullParameter((Object)$this$accessors, (String)"<this>");
        Object[] objectArray = new SirAccessor[]{$this$accessors.getGetter(), $this$accessors.getSetter()};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Nullable
    public static final String getName(@NotNull SirParameter $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        String string = $this$name.getParameterName();
        if (string == null) {
            string = $this$name.getArgumentName();
        }
        return string;
    }

    public static final boolean isVoid(@NotNull SirType $this$isVoid) {
        Intrinsics.checkNotNullParameter((Object)$this$isVoid, (String)"<this>");
        return $this$isVoid instanceof SirNominalType && Intrinsics.areEqual((Object)((SirNominalType)$this$isVoid).getTypeDeclaration(), (Object)SirSwiftModule.INSTANCE.getVoid());
    }

    public static final boolean isNever(@NotNull SirType $this$isNever) {
        Intrinsics.checkNotNullParameter((Object)$this$isNever, (String)"<this>");
        return $this$isNever instanceof SirNominalType && Intrinsics.areEqual((Object)((SirNominalType)$this$isNever).getTypeDeclaration(), (Object)SirSwiftModule.INSTANCE.getNever());
    }

    @NotNull
    public static final <T extends SirDeclaration> T addChild(@NotNull SirMutableDeclarationContainer $this$addChild, @NotNull Function0<? extends T> producer) {
        Intrinsics.checkNotNullParameter((Object)$this$addChild, (String)"<this>");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        SirDeclaration child = (SirDeclaration)producer.invoke();
        child.setParent($this$addChild);
        ((Collection)$this$addChild.getDeclarations()).add(child);
        return (T)child;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getSwiftName(@NotNull SirType $this$swiftName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$swiftName, (String)"<this>");
        SirType sirType = $this$swiftName;
        if (sirType instanceof SirExistentialType) {
            string = "Any";
        } else if (sirType instanceof SirNominalType) {
            String string2;
            List<SirType> it;
            List<SirType> list;
            String string3;
            Object[] objectArray;
            int n;
            Object[] objectArray2;
            Object[] objectArray3 = objectArray2 = new String[3];
            int n2 = 0;
            Object object = ((SirNominalType)$this$swiftName).getParent();
            if (object != null && (object = SirExtensionsKt.getSwiftName((SirType)object)) != null) {
                void it2;
                Object object2 = object;
                n = n2;
                objectArray = objectArray3;
                boolean bl = false;
                String string4 = (String)it2 + '.';
                objectArray3 = objectArray;
                n2 = n;
                string3 = string4;
            } else {
                string3 = null;
            }
            objectArray3[n2] = string3;
            objectArray2[1] = SirExtensionsKt.getSwiftFqName(((SirNominalType)$this$swiftName).getTypeDeclaration());
            List<SirType> list2 = list = ((SirNominalType)$this$swiftName).getTypeArguments();
            n = 2;
            objectArray = objectArray2;
            boolean bl = false;
            boolean bl2 = !((Collection)it).isEmpty();
            Object[] objectArray4 = objectArray;
            int n3 = n;
            List<SirType> list3 = bl2 ? list : null;
            if (list3 != null) {
                it = list3;
                n = n3;
                objectArray = objectArray4;
                boolean bl3 = false;
                String string5 = CollectionsKt.joinToString$default((Iterable)it, (CharSequence)",", (CharSequence)"<", (CharSequence)">", (int)0, null, SirExtensionsKt::_get_swiftName_$lambda$4$lambda$3, (int)24, null);
                objectArray4 = objectArray;
                n3 = n;
                string2 = string5;
            } else {
                string2 = null;
            }
            objectArray4[n3] = string2;
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } else if (sirType instanceof SirErrorType) {
            string = "ERROR_TYPE";
        } else if (sirType instanceof SirUnsupportedType) {
            string = "Swift.Never";
        } else if (sirType instanceof SirFunctionalType) {
            string = '(' + CollectionsKt.joinToString$default((Iterable)((SirFunctionalType)$this$swiftName).getParameterTypes(), null, null, null, (int)0, null, SirExtensionsKt::_get_swiftName_$lambda$5, (int)31, null) + ") -> " + SirExtensionsKt.getSwiftName(((SirFunctionalType)$this$swiftName).getReturnType());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String getSwiftParentNamePrefix(SirDeclaration $this$swiftParentNamePrefix) {
        return SirExtensionsKt.getSwiftFqNameOrNull($this$swiftParentNamePrefix.getParent());
    }

    @Nullable
    public static final String getSwiftFqNameOrNull(@NotNull SirDeclarationParent $this$swiftFqNameOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$swiftFqNameOrNull, (String)"<this>");
        Object object = $this$swiftFqNameOrNull instanceof SirNamedDeclaration ? (SirNamedDeclaration)((Object)$this$swiftFqNameOrNull) : null;
        if (object == null || (object = SirExtensionsKt.getSwiftFqName((SirNamedDeclaration)object)) == null) {
            Object object2;
            Object object3 = $this$swiftFqNameOrNull instanceof SirNamed ? (SirNamed)((Object)$this$swiftFqNameOrNull) : null;
            object = object3 != null && (object3 = object3.getName()) != null ? MiscValidationKt.getSwiftSanitizedName((String)object3) : ((object2 = $this$swiftFqNameOrNull instanceof SirExtension ? (SirExtension)$this$swiftFqNameOrNull : null) != null && (object2 = ((SirExtension)object2).getExtendedType()) != null ? SirExtensionsKt.getSwiftName((SirType)object2) : null);
        }
        return object;
    }

    @NotNull
    public static final String getSwiftFqName(@NotNull SirNamedDeclaration $this$swiftFqName) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$swiftFqName, (String)"<this>");
                string = SirExtensionsKt.getSwiftParentNamePrefix($this$swiftFqName);
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = it + '.' + MiscValidationKt.getSwiftSanitizedName($this$swiftFqName.getName());
                string = string2;
                if (string2 != null) break block3;
            }
            string = MiscValidationKt.getSwiftSanitizedName($this$swiftFqName.getName());
        }
        return string;
    }

    @NotNull
    public static final String getSwiftFqName(@NotNull SirFunction $this$swiftFqName) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$swiftFqName, (String)"<this>");
                string = SirExtensionsKt.getSwiftParentNamePrefix($this$swiftFqName);
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = it + '.' + MiscValidationKt.getSwiftSanitizedName($this$swiftFqName.getName());
                string = string2;
                if (string2 != null) break block3;
            }
            string = MiscValidationKt.getSwiftSanitizedName($this$swiftFqName.getName());
        }
        return string;
    }

    @NotNull
    public static final String getSwiftFqName(@NotNull SirVariable $this$swiftFqName) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$swiftFqName, (String)"<this>");
                string = SirExtensionsKt.getSwiftParentNamePrefix($this$swiftFqName);
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = it + '.' + MiscValidationKt.getSwiftSanitizedName($this$swiftFqName.getName());
                string = string2;
                if (string2 != null) break block3;
            }
            string = MiscValidationKt.getSwiftSanitizedName($this$swiftFqName.getName());
        }
        return string;
    }

    private static final CharSequence _get_swiftName_$lambda$4$lambda$3(SirType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SirExtensionsKt.getSwiftName(it);
    }

    private static final CharSequence _get_swiftName_$lambda$5(SirType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SirExtensionsKt.getSwiftName(it);
    }
}

