/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.bridge.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.sir.SirCallable;
import org.jetbrains.kotlin.sir.SirFunction;
import org.jetbrains.kotlin.sir.SirFunctionBody;
import org.jetbrains.kotlin.sir.SirGetter;
import org.jetbrains.kotlin.sir.SirInit;
import org.jetbrains.kotlin.sir.SirNominalType;
import org.jetbrains.kotlin.sir.SirSetter;
import org.jetbrains.kotlin.sir.bridge.BridgeGenerator;
import org.jetbrains.kotlin.sir.bridge.BridgeRequest;
import org.jetbrains.kotlin.sir.bridge.FunctionBridge;
import org.jetbrains.kotlin.sir.bridge.FunctionBridgeRequest;
import org.jetbrains.kotlin.sir.bridge.GeneratedBridge;
import org.jetbrains.kotlin.sir.bridge.SirTypeNamer;
import org.jetbrains.kotlin.sir.bridge.TypeBindingBridge;
import org.jetbrains.kotlin.sir.bridge.TypeBindingBridgeRequest;
import org.jetbrains.kotlin.sir.bridge.impl.BridgeFunctionDescriptor;
import org.jetbrains.kotlin.sir.bridge.impl.BridgeGeneratorImplKt;
import org.jetbrains.kotlin.sir.bridge.impl.BridgeParameter;
import org.jetbrains.kotlin.sir.mangler.ManglerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/sir/bridge/impl/BridgeGeneratorImpl;", "Lorg/jetbrains/kotlin/sir/bridge/BridgeGenerator;", "typeNamer", "Lorg/jetbrains/kotlin/sir/bridge/SirTypeNamer;", "<init>", "(Lorg/jetbrains/kotlin/sir/bridge/SirTypeNamer;)V", "generateBridges", "", "Lorg/jetbrains/kotlin/sir/bridge/GeneratedBridge;", "request", "Lorg/jetbrains/kotlin/sir/bridge/BridgeRequest;", "generateFunctionBridges", "Lorg/jetbrains/kotlin/sir/bridge/FunctionBridge;", "Lorg/jetbrains/kotlin/sir/bridge/FunctionBridgeRequest;", "generateSirFunctionBody", "Lorg/jetbrains/kotlin/sir/SirFunctionBody;", "generateTypeBindingBridge", "Lorg/jetbrains/kotlin/sir/bridge/TypeBindingBridge;", "Lorg/jetbrains/kotlin/sir/bridge/TypeBindingBridgeRequest;", "sir-compiler-bridge"})
@SourceDebugExtension(value={"SMAP\nBridgeGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeGeneratorImpl.kt\norg/jetbrains/kotlin/sir/bridge/impl/BridgeGeneratorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,719:1\n1#2:720\n*E\n"})
public final class BridgeGeneratorImpl
implements BridgeGenerator {
    @NotNull
    private final SirTypeNamer typeNamer;

    public BridgeGeneratorImpl(@NotNull SirTypeNamer typeNamer) {
        Intrinsics.checkNotNullParameter((Object)typeNamer, (String)"typeNamer");
        this.typeNamer = typeNamer;
    }

    @Override
    @NotNull
    public List<GeneratedBridge> generateBridges(@NotNull BridgeRequest request) {
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BridgeRequest bridgeRequest = request;
        if (bridgeRequest instanceof FunctionBridgeRequest) {
            list = this.generateFunctionBridges((FunctionBridgeRequest)request);
        } else if (bridgeRequest instanceof TypeBindingBridgeRequest) {
            list = CollectionsKt.listOf((Object)this.generateTypeBindingBridge((TypeBindingBridgeRequest)request));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<FunctionBridge> generateFunctionBridges(FunctionBridgeRequest request) {
        boolean bl;
        List list;
        List $this$generateFunctionBridges_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        SirCallable sirCallable = request.getCallable();
        if (sirCallable instanceof SirFunction) {
            bl = $this$generateFunctionBridges_u24lambda_u247.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$7$lambda$0));
        } else if (sirCallable instanceof SirGetter) {
            bl = $this$generateFunctionBridges_u24lambda_u247.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$7$lambda$2));
        } else if (sirCallable instanceof SirSetter) {
            bl = $this$generateFunctionBridges_u24lambda_u247.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$7$lambda$4));
        } else if (sirCallable instanceof SirInit) {
            $this$generateFunctionBridges_u24lambda_u247.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$allocationDescriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$7$lambda$5));
            bl = $this$generateFunctionBridges_u24lambda_u247.add(BridgeGeneratorImplKt.access$createFunctionBridge(BridgeGeneratorImplKt.access$initializationDescriptor(request, this.typeNamer), BridgeGeneratorImpl::generateFunctionBridges$lambda$7$lambda$6));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    @NotNull
    public SirFunctionBody generateSirFunctionBody(@NotNull FunctionBridgeRequest request) {
        boolean bl;
        List list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        List $this$generateSirFunctionBody_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        SirCallable sirCallable = request.getCallable();
        if (sirCallable instanceof SirFunction || sirCallable instanceof SirGetter || sirCallable instanceof SirSetter) {
            BridgeFunctionDescriptor descriptor = BridgeGeneratorImplKt.access$descriptor(request, this.typeNamer);
            BridgeParameter errorParameter = descriptor.getErrorParameter();
            if (errorParameter != null) {
                $this$generateSirFunctionBody_u24lambda_u248.add("struct KotlinError: Error { var wrapped: KotlinRuntime.KotlinBase }");
                $this$generateSirFunctionBody_u24lambda_u248.add("var " + errorParameter.getName() + ": UInt = 0");
                $this$generateSirFunctionBody_u24lambda_u248.add("let _result = " + BridgeGeneratorImplKt.access$swiftInvoke(descriptor, this.typeNamer));
                String error = errorParameter.getBridge().getInSwiftSources().kotlinToSwift(this.typeNamer, errorParameter.getName());
                $this$generateSirFunctionBody_u24lambda_u248.add("guard " + errorParameter.getName() + " == 0 else { throw KotlinError(wrapped: " + error + ") }");
                bl = $this$generateSirFunctionBody_u24lambda_u248.add("return " + descriptor.getReturnType().getInSwiftSources().kotlinToSwift(this.typeNamer, "_result"));
            } else {
                bl = $this$generateSirFunctionBody_u24lambda_u248.add("return " + BridgeGeneratorImplKt.access$swiftCall(descriptor, this.typeNamer));
            }
        } else if (sirCallable instanceof SirInit) {
            BridgeFunctionDescriptor initDescriptor = BridgeGeneratorImplKt.access$initializationDescriptor(request, this.typeNamer);
            BridgeParameter errorParameter = initDescriptor.getErrorParameter();
            $this$generateSirFunctionBody_u24lambda_u248.add("let " + BridgeGeneratorImplKt.access$getObj$p().getName() + " = " + BridgeGeneratorImplKt.access$swiftCall(BridgeGeneratorImplKt.access$allocationDescriptor(request, this.typeNamer), this.typeNamer));
            $this$generateSirFunctionBody_u24lambda_u248.add("super.init(__externalRCRef: " + BridgeGeneratorImplKt.access$getObj$p().getName() + ')');
            if (errorParameter != null) {
                $this$generateSirFunctionBody_u24lambda_u248.add("struct KotlinError: Error { var wrapped: KotlinRuntime.KotlinBase }");
                $this$generateSirFunctionBody_u24lambda_u248.add("var " + errorParameter.getName() + ": UInt = 0");
                $this$generateSirFunctionBody_u24lambda_u248.add(BridgeGeneratorImplKt.access$swiftCall(initDescriptor, this.typeNamer));
                String error = errorParameter.getBridge().getInSwiftSources().kotlinToSwift(this.typeNamer, errorParameter.getName());
                bl = $this$generateSirFunctionBody_u24lambda_u248.add("guard " + errorParameter.getName() + " == 0 else { throw KotlinError(wrapped: " + error + ") }");
            } else {
                bl = $this$generateSirFunctionBody_u24lambda_u248.add(BridgeGeneratorImplKt.access$swiftCall(initDescriptor, this.typeNamer));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List list2 = CollectionsKt.build((List)list);
        return new SirFunctionBody(list2);
    }

    private final TypeBindingBridge generateTypeBindingBridge(TypeBindingBridgeRequest request) {
        String annotationName = "kotlin.native.internal.objc.BindClassToObjCName";
        String kotlinType = this.typeNamer.kotlinFqName(new SirNominalType(request.getSirClass(), null, null, 6, null));
        String swiftName = ManglerKt.getMangledNameOrNull(request.getSirClass());
        if (swiftName == null) {
            boolean bl = false;
            String string = "Cannot mangle name for Swift class exported from `" + kotlinType + '`';
            throw new IllegalArgumentException(string.toString());
        }
        return new TypeBindingBridge(annotationName + '(' + kotlinType + "::class, \"" + swiftName + "\")");
    }

    private static final String generateFunctionBridges$lambda$7$lambda$0(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        return $this$createFunctionBridge.getSelfParameter() != null && $this$createFunctionBridge.getExtensionReceiverParameter() != null ? "__" + $this$createFunctionBridge.getSelfParameter().getName() + ".run { __" + $this$createFunctionBridge.getExtensionReceiverParameter().getName() + '.' + (String)CollectionsKt.last($this$createFunctionBridge.getKotlinFqName()) + '(' + CollectionsKt.joinToString$default((Iterable)$this$createFunctionBridge.getArgs(), null, null, null, (int)0, null, null, (int)63, null) + ") }" : $this$createFunctionBridge.getName() + '(' + CollectionsKt.joinToString$default((Iterable)$this$createFunctionBridge.getArgs(), null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    private static final String generateFunctionBridges$lambda$7$lambda$2(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        if (!$this$createFunctionBridge.getArgs().isEmpty()) {
            boolean bl = false;
            String string = "Received a getter " + $this$createFunctionBridge.getName() + " with " + $this$createFunctionBridge.getArgs().size() + " parameters instead of no parameters, aborting";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$createFunctionBridge.getName();
    }

    private static final String generateFunctionBridges$lambda$7$lambda$4(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        if (!($this$createFunctionBridge.getArgs().size() == 1)) {
            boolean bl = false;
            String string = "Received a setter " + $this$createFunctionBridge.getName() + " with " + $this$createFunctionBridge.getArgs().size() + " parameters instead of a single one, aborting";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$createFunctionBridge.getName() + " = " + (String)CollectionsKt.single($this$createFunctionBridge.getArgs());
    }

    private static final String generateFunctionBridges$lambda$7$lambda$5(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        return "kotlin.native.internal.createUninitializedInstance<" + $this$createFunctionBridge.getName() + ">(" + CollectionsKt.joinToString$default((Iterable)$this$createFunctionBridge.getArgs(), null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    private static final String generateFunctionBridges$lambda$7$lambda$6(BridgeFunctionDescriptor $this$createFunctionBridge) {
        Intrinsics.checkNotNullParameter((Object)$this$createFunctionBridge, (String)"$this$createFunctionBridge");
        return "kotlin.native.internal.initInstance(" + (String)CollectionsKt.first($this$createFunctionBridge.getArgs()) + ", " + $this$createFunctionBridge.getName() + '(' + CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)$this$createFunctionBridge.getArgs(), (int)1), null, null, null, (int)0, null, null, (int)63, null) + "))";
    }
}

