/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.sir

class SirImport(
    val moduleName: String,
    val mode: Mode? = null,
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SirImport

        return moduleName == other.moduleName
    }

    override fun hashCode(): Int {
        return moduleName.hashCode()
    }

    enum class Mode {
        ImplementationOnly,
        Exported,
    }
}
