/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010!\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0002J:\u0010%\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J \u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010.\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u0010/\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u0001012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J\u0018\u00102\u001a\u00020\n2\u0006\u0010\u0015\u001a\u0002032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00104\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J6\u00106\u001a\u00020\n*\u0002072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00108\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J6\u0010;\u001a\u00020\n*\u0002072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00108\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u0001012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020$H\u0002J\f\u0010<\u001a\u00020\u0004*\u00020\u0007H\u0002J\f\u0010=\u001a\u00020\u0004*\u00020'H\u0002J!\u0010>\u001a\u00020\n*\u00020\u00072\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\n0@H\u0082\bJ$\u0010B\u001a\u00020\n*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u000e\u0010C\u001a\n\u0012\u0006\b\u0000\u0012\u00020A0DH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0018\u0010\u0006\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "isIde", "", "()Z", "isAnonymousObjectOrContained", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "analyzePropertiesSerializers", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "serializableClass", "props", "", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "descriptor", "canBeSerializedInternally", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canSupportInlineClasses", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "check", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkClassWithCustomSerializer", "checkCorrectTransientAnnotationIsUsed", "properties", "checkCustomSerializerIsNotLocal", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "declarationElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkCustomSerializerMatch", "classType", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "fallbackElement", "checkMinKotlin", "versions", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "checkMinRuntime", "checkSerializerNullability", "serializerType", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "checkTransients", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "declarationHasInitializer", "serializationPluginEnabledOn", "checkType", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "type", "ktType", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkTypeArguments", "isSerializableEnumWithMissingSerializer", "isUnsupportedInlineType", "onSerializableAnnotation", "report", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "reportOnSerializableAnnotation", "error", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "kotlinx-serialization-compiler-plugin"})
public class SerializationPluginDeclarationChecker
implements DeclarationChecker {
    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Object object;
        VersionReader.RuntimeVersions runtimeVersions;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        if (!this.canBeSerializedInternally((ClassDescriptor)descriptor, declaration, context.getTrace())) {
            return;
        }
        if (!(declaration instanceof KtPureClassOrObject)) {
            return;
        }
        if (!this.isIde() && (runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor), context.getTrace())) != null) {
            object = runtimeVersions;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.checkMinKotlin((VersionReader.RuntimeVersions)it, (ClassDescriptor)descriptor, context.getTrace());
            this.checkMinRuntime((VersionReader.RuntimeVersions)it, (ClassDescriptor)descriptor, context.getTrace());
        }
        if ((object = this.buildSerializableProperties((ClassDescriptor)descriptor, context.getTrace())) == null) {
            return;
        }
        SerializableProperties props = object;
        this.checkCorrectTransientAnnotationIsUsed((ClassDescriptor)descriptor, props.getSerializableProperties(), context.getTrace());
        this.checkTransients((KtPureClassOrObject)declaration, context.getTrace());
        this.analyzePropertiesSerializers(context.getTrace(), (ClassDescriptor)descriptor, props.getSerializableProperties());
    }

    private final void checkMinRuntime(VersionReader.RuntimeVersions versions, ClassDescriptor descriptor, BindingTrace trace) {
        if (!versions.implementationVersionMatchSupported()) {
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry != null) {
                String string;
                KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
                boolean bl = false;
                boolean bl2 = false;
                KtAnnotationEntry it = ktAnnotationEntry2;
                boolean bl3 = false;
                Object object = versions.getImplementationVersion();
                String string2 = object == null ? "too low" : ((string = object.toString()) == null ? "too low" : string);
                object = KotlinCompilerVersion.getVersion();
                trace.report((Diagnostic)SerializationErrors.PROVIDED_RUNTIME_TOO_LOW.on((PsiElement)it, (Object)string2, (Object)(object == null ? "unknown" : object), (Object)VersionReader.INSTANCE.getMINIMAL_SUPPORTED_VERSION().toString()));
            }
        }
    }

    private final void checkMinKotlin(VersionReader.RuntimeVersions versions, ClassDescriptor descriptor, BindingTrace trace) {
        if (versions.currentCompilerMatchRequired()) {
            return;
        }
        SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
        ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
        boolean $i$f$onSerializableAnnotation = false;
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
        if (ktAnnotationEntry != null) {
            String string;
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            KtAnnotationEntry it = ktAnnotationEntry2;
            boolean bl3 = false;
            String string2 = KotlinCompilerVersion.getVersion();
            String string3 = string2 == null ? "too low" : string2;
            string2 = versions.getImplementationVersion();
            String string4 = string2 == null ? "unknown" : ((string = string2.toString()) == null ? "unknown" : string);
            string2 = versions.getRequireKotlinVersion();
            trace.report((Diagnostic)SerializationErrors.REQUIRED_KOTLIN_TOO_HIGH.on((PsiElement)it, (Object)string3, (Object)string4, (Object)(string2 == null ? "N/A" : ((string = string2.toString()) == null ? "N/A" : string))));
        }
    }

    protected boolean isIde() {
        return false;
    }

    private final void checkCorrectTransientAnnotationIsUsed(ClassDescriptor descriptor, List<SerializableProperty> properties, BindingTrace trace) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)).asString(), (Object)"java.io.Serializable")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (SerializableProperty prop : properties) {
            Annotations annotations;
            Annotations annotations2;
            AnnotationDescriptor incorrectTransient;
            Object element$iv;
            if (prop.getTransient() || (incorrectTransient = (element$iv = prop.getDescriptor().getBackingField()) == null ? null : ((annotations2 = element$iv.getAnnotations()) == null ? null : annotations2.findAnnotation(JvmAnnotationUtilKt.TRANSIENT_ANNOTATION_FQ_NAME))) == null) continue;
            annotations2 = PsiSourceElementKt.getPsi((SourceElement)incorrectTransient.getSource());
            if (annotations2 == null) {
                PsiElement psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)prop.getDescriptor()));
                if (psiElement == null) continue;
                annotations = psiElement;
            } else {
                annotations = annotations2;
            }
            Annotations elementToReport = annotations;
            trace.report((Diagnostic)SerializationErrors.INCORRECT_TRANSIENT.on((PsiElement)elementToReport));
        }
    }

    private final boolean canBeSerializedInternally(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        ClassDescriptor superClass;
        if (this.isSerializableEnumWithMissingSerializer(descriptor)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            KtElement declarationToReport = ktModifierList == null ? (KtElement)declaration : (KtElement)ktModifierList;
            trace.report((Diagnostic)SerializationErrors.EXPLICIT_SERIALIZABLE_IS_REQUIRED.on((PsiElement)declarationToReport));
            return false;
        }
        if (!descriptor.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return false;
        }
        if (!this.serializationPluginEnabledOn(descriptor)) {
            DiagnosticFactory0<PsiElement> declarationToReport = SerializationErrors.PLUGIN_IS_NOT_ENABLED;
            Intrinsics.checkNotNullExpressionValue(declarationToReport, (String)"PLUGIN_IS_NOT_ENABLED");
            this.reportOnSerializableAnnotation(trace, descriptor, declarationToReport);
            return false;
        }
        if (this.isAnonymousObjectOrContained(descriptor)) {
            DiagnosticFactory0<PsiElement> declarationToReport = SerializationErrors.ANONYMOUS_OBJECTS_NOT_SUPPORTED;
            Intrinsics.checkNotNullExpressionValue(declarationToReport, (String)"ANONYMOUS_OBJECTS_NOT_SUPPORTED");
            this.reportOnSerializableAnnotation(trace, descriptor, declarationToReport);
            return false;
        }
        if (descriptor.isInner()) {
            DiagnosticFactory0<PsiElement> declarationToReport = SerializationErrors.INNER_CLASSES_NOT_SUPPORTED;
            Intrinsics.checkNotNullExpressionValue(declarationToReport, (String)"INNER_CLASSES_NOT_SUPPORTED");
            this.reportOnSerializableAnnotation(trace, descriptor, declarationToReport);
            return false;
        }
        if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)((DeclarationDescriptor)descriptor)) && !this.canSupportInlineClasses(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), trace)) {
            SerializationPluginDeclarationChecker declarationToReport = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry != null) {
                VersionReader.RuntimeVersions runtimeVersions;
                KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
                boolean bl = false;
                boolean bl2 = false;
                KtAnnotationEntry it = ktAnnotationEntry2;
                boolean bl3 = false;
                trace.report((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on((PsiElement)it, (Object)VersionReader.INSTANCE.getMinVersionForInlineClasses$kotlinx_serialization_compiler_plugin().toString(), (Object)String.valueOf((runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), trace)) == null ? null : runtimeVersions.getImplementationVersion())));
            }
            return false;
        }
        if (!KSerializationUtilKt.getHasSerializableAnnotationWithoutArgs(descriptor)) {
            this.checkClassWithCustomSerializer(descriptor, declaration, trace);
            return false;
        }
        if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(descriptor)) {
            DiagnosticFactory0<KtAnnotationEntry> this_$iv = SerializationErrors.SERIALIZABLE_ANNOTATION_IGNORED;
            Intrinsics.checkNotNullExpressionValue(this_$iv, (String)"SERIALIZABLE_ANNOTATION_IGNORED");
            this.reportOnSerializableAnnotation(trace, descriptor, this_$iv);
            return false;
        }
        if (!KSerializationUtilKt.isSerializableEnum(descriptor) && !KSerializationUtilKt.isInternalSerializable(superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)descriptor))) {
            Object v0;
            block13: {
                Collection $this$onSerializableAnnotation$iv = superClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)$this$onSerializableAnnotation$iv, (String)"superClass.constructors");
                Iterable $this$singleOrNull$iv = $this$onSerializableAnnotation$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getValueParameters().size() == 0)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block13;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if (v0 == null) {
                DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR");
                this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
                return false;
            }
        }
        return true;
    }

    private final void checkClassWithCustomSerializer(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        KtAnnotationEntry annotationPsi = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)descriptor);
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor));
        SimpleType simpleType = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"descriptor.defaultType");
        this.checkCustomSerializerMatch(moduleDescriptor, (KotlinType)simpleType, (Annotated)descriptor, (KtElement)annotationPsi, trace, (PsiElement)declaration);
        this.checkCustomSerializerIsNotLocal(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor)), (Annotated)descriptor, trace, (PsiElement)declaration);
    }

    private final boolean isAnonymousObjectOrContained(ClassDescriptor $this$isAnonymousObjectOrContained) {
        for (DeclarationDescriptor current = (DeclarationDescriptor)$this$isAnonymousObjectOrContained; current != null; current = current.getContainingDeclaration()) {
            if (!DescriptorUtils.isAnonymousObject((DeclarationDescriptor)current)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSerializableEnumWithMissingSerializer(ClassDescriptor $this$isSerializableEnumWithMissingSerializer) {
        boolean bl;
        block6: {
            if ($this$isSerializableEnumWithMissingSerializer.getKind() != ClassKind.ENUM_CLASS) {
                return false;
            }
            if ($this$isSerializableEnumWithMissingSerializer.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
                return false;
            }
            if (KSerializationUtilKt.getHasAnySerialAnnotation($this$isSerializableEnumWithMissingSerializer.getAnnotations())) {
                return true;
            }
            Iterable $this$any$iv = KSerializationUtilKt.enumEntries($this$isSerializableEnumWithMissingSerializer);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!KSerializationUtilKt.getHasAnySerialAnnotation(it.getAnnotations())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean serializationPluginEnabledOn(@NotNull ClassDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return true;
    }

    private final SerializableProperties buildSerializableProperties(ClassDescriptor descriptor, BindingTrace trace) {
        if (!descriptor.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return null;
        }
        if (!KSerializationUtilKt.isInternalSerializable(descriptor)) {
            return null;
        }
        if (KSerializationUtilKt.getHasCompanionObjectAsSerializer(descriptor)) {
            return null;
        }
        DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory0, (String)"trace.bindingContext");
        SerializableProperties props = new SerializableProperties(descriptor, (BindingContext)diagnosticFactory0);
        if (!props.isExternallySerializable()) {
            diagnosticFactory0 = SerializationErrors.PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
        }
        boolean bl = false;
        Set namesSet = new LinkedHashSet();
        Iterable $this$forEach$iv = props.getSerializableProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl2 = false;
            if (namesSet.add(it.getName())) continue;
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry == null) continue;
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl3 = false;
            boolean bl4 = false;
            KtAnnotationEntry a = ktAnnotationEntry2;
            boolean bl5 = false;
            trace.report((Diagnostic)SerializationErrors.DUPLICATE_SERIAL_NAME.on((PsiElement)a, (Object)it.getName()));
        }
        trace.record(SerializationPluginDeclarationCheckerKt.getSERIALIZABLE_PROPERTIES(), (Object)descriptor, (Object)props);
        return props;
    }

    private final void checkTransients(KtPureClassOrObject declaration, BindingTrace trace) {
        Map propertiesMap;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        Map<PropertyDescriptor, KtProperty> map = TypeUtilKt.bodyPropertiesDescriptorsMap(declaration, bindingContext, false);
        bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"trace.bindingContext");
        Map $this$forEach$iv = propertiesMap = MapsKt.plus(map, TypeUtilKt.primaryConstructorPropertiesDescriptorsMap(declaration, bindingContext));
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$descriptor$declaration = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$descriptor$declaration;
            boolean bl3 = false;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            Map.Entry entry2 = $dstr$descriptor$declaration;
            boolean bl4 = false;
            KtDeclaration declaration2 = (KtDeclaration)entry2.getValue();
            boolean isInitialized = this.declarationHasInitializer(declaration2) || descriptor.isLateInit();
            boolean isMarkedTransient = KSerializationUtilKt.getSerialTransient(descriptor.getAnnotations());
            boolean hasBackingField = ResolveUtilKt.hasBackingField((PropertyDescriptor)descriptor, (BindingContext)trace.getBindingContext());
            if (!hasBackingField && isMarkedTransient) {
                AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(SerializationAnnotations.INSTANCE.getSerialTransientFqName());
                LazyAnnotationDescriptor lazyAnnotationDescriptor = annotationDescriptor instanceof LazyAnnotationDescriptor ? (LazyAnnotationDescriptor)annotationDescriptor : null;
                KtAnnotationEntry transientPsi = lazyAnnotationDescriptor == null ? null : lazyAnnotationDescriptor.getAnnotationEntry();
                lazyAnnotationDescriptor = transientPsi;
                trace.report((Diagnostic)SerializationErrors.TRANSIENT_IS_REDUNDANT.on((PsiElement)(lazyAnnotationDescriptor == null ? (KtElement)declaration2 : (KtElement)lazyAnnotationDescriptor)));
            }
            if (!isMarkedTransient || isInitialized || !hasBackingField) continue;
            trace.report((Diagnostic)SerializationErrors.TRANSIENT_MISSING_INITIALIZER.on((PsiElement)declaration2));
        }
    }

    private final boolean declarationHasInitializer(KtDeclaration declaration) {
        KtDeclaration ktDeclaration = declaration;
        return ktDeclaration instanceof KtParameter ? ((KtParameter)declaration).hasDefaultValue() : (ktDeclaration instanceof KtProperty ? ((KtProperty)declaration).hasDelegateExpressionOrInitializer() : false);
    }

    private final void analyzePropertiesSerializers(BindingTrace trace, ClassDescriptor serializableClass, List<SerializableProperty> props) {
        BindingContext bindingContext = trace.getBindingContext();
        AbstractSerialGenerator generatorContextForAnalysis2 = new AbstractSerialGenerator(serializableClass, bindingContext){
            final /* synthetic */ ClassDescriptor $serializableClass;
            {
                this.$serializableClass = $serializableClass;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"bindingContext");
                super($super_call_param$1, $serializableClass);
            }
        };
        Iterable $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference ktType;
            ClassDescriptor serializer;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getSerializableWith();
            ClassDescriptor classDescriptor = serializer = kotlinType == null ? null : KSerializationUtilKt.toClassDescriptor(kotlinType);
            PsiElement psiElement = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)it.getDescriptor()));
            if (psiElement == null) continue;
            PsiElement propertyPsi = psiElement;
            KtCallableDeclaration ktCallableDeclaration = propertyPsi instanceof KtCallableDeclaration ? (KtCallableDeclaration)propertyPsi : null;
            KtTypeReference ktTypeReference = ktType = ktCallableDeclaration == null ? null : ktCallableDeclaration.getTypeReference();
            if (serializer != null) {
                KtTypeReference ktTypeReference2 = ktType;
                KtTypeElement element = ktTypeReference2 == null ? null : ktTypeReference2.getTypeElement();
                this.checkCustomSerializerMatch(it.getModule(), it.getType(), (Annotated)it.getDescriptor(), (KtElement)element, trace, propertyPsi);
                this.checkCustomSerializerIsNotLocal(it.getModule(), (Annotated)it.getDescriptor(), trace, propertyPsi);
                KotlinType kotlinType2 = it.getType();
                ktTypeReference2 = serializer.getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference2, (String)"serializer.defaultType");
                this.checkSerializerNullability(kotlinType2, (KotlinType)ktTypeReference2, element, trace, propertyPsi);
                this.checkTypeArguments(generatorContextForAnalysis2, it.getModule(), it.getType(), element, trace, propertyPsi);
                continue;
            }
            this.checkType(generatorContextForAnalysis2, it.getModule(), it.getType(), ktType, trace, propertyPsi);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArguments(AbstractSerialGenerator $this$checkTypeArguments, ModuleDescriptor module, KotlinType type, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Iterable $this$forEachIndexed$iv = type.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            List list;
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n;
            boolean bl2 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
            KotlinType kotlinType2 = kotlinType;
            kotlinType = element;
            this.checkType($this$checkTypeArguments, module, kotlinType2, kotlinType == null ? null : ((list = kotlinType.getTypeArgumentsAsTypes()) == null ? null : (KtTypeReference)CollectionsKt.getOrNull((List)list, (int)i)), trace, fallbackElement);
        }
    }

    private final boolean isUnsupportedInlineType(KotlinType $this$isUnsupportedInlineType) {
        return InlineClassesUtilsKt.isInlineClassType((KotlinType)$this$isUnsupportedInlineType) && !KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType((KotlinType)$this$isUnsupportedInlineType);
    }

    private final boolean canSupportInlineClasses(ModuleDescriptor module, BindingTrace trace) {
        if (this.isIde()) {
            return true;
        }
        return VersionReader.INSTANCE.canSupportInlineClasses(module, trace);
    }

    private final void checkType(AbstractSerialGenerator $this$checkType, ModuleDescriptor module, KotlinType type, KtTypeReference ktType, BindingTrace trace, PsiElement fallbackElement) {
        ClassDescriptor serializer;
        KtTypeElement element;
        if (KSerializationUtilKt.getGenericIndex(type) != null) {
            return;
        }
        Object object = ktType;
        KtTypeElement ktTypeElement = element = object == null ? null : object.getTypeElement();
        if (this.isUnsupportedInlineType(type) && !this.canSupportInlineClasses(module, trace)) {
            object = element;
            PsiElement psiElement = object == null ? fallbackElement : (PsiElement)object;
            object = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(module, trace);
            trace.report((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on(psiElement, (Object)VersionReader.INSTANCE.getMinVersionForInlineClasses$kotlinx_serialization_compiler_plugin().toString(), (Object)String.valueOf(object == null ? null : ((VersionReader.RuntimeVersions)object).getImplementationVersion())));
        }
        if ((serializer = TypeUtilKt.findTypeSerializerOrContextUnchecked($this$checkType, module, type)) != null) {
            this.checkCustomSerializerMatch(module, type, (Annotated)type, (KtElement)element, trace, fallbackElement);
            this.checkCustomSerializerIsNotLocal(module, (Annotated)type, trace, fallbackElement);
            SimpleType simpleType = serializer.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"serializer.defaultType");
            this.checkSerializerNullability(type, (KotlinType)simpleType, element, trace, fallbackElement);
            this.checkTypeArguments($this$checkType, module, type, element, trace, fallbackElement);
        } else {
            KtTypeElement ktTypeElement2 = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NOT_FOUND.on(ktTypeElement2 == null ? fallbackElement : (PsiElement)ktTypeElement2, (Object)type));
        }
    }

    private final void checkCustomSerializerMatch(ModuleDescriptor module, KotlinType classType, Annotated descriptor, KtElement element, BindingTrace trace, PsiElement fallbackElement) {
        KotlinType kotlinType;
        TypeProjection typeProjection;
        KotlinType kotlinType2;
        Object v0;
        Iterable iterable;
        KotlinType serializerType;
        block4: {
            KotlinType kotlinType3 = KSerializationUtilKt.serializableWith(descriptor.getAnnotations(), module);
            if (kotlinType3 == null) {
                return;
            }
            serializerType = kotlinType3;
            iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KotlinType it = (KotlinType)t;
                boolean bl3 = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        KotlinType kotlinType4 = v0;
        KotlinType kotlinType5 = kotlinType4 == null ? null : ((iterable = kotlinType4.getArguments()) == null ? null : (kotlinType2 = (typeProjection = (TypeProjection)CollectionsKt.first((List)iterable)) == null ? null : typeProjection.getType()));
        if (kotlinType2 == null) {
            return;
        }
        KotlinType serializerForType = kotlinType = kotlinType2;
        if (!Intrinsics.areEqual((Object)classType.getConstructor(), (Object)serializerForType.getConstructor())) {
            kotlinType = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_TYPE_INCOMPATIBLE.on(kotlinType == null ? fallbackElement : (PsiElement)kotlinType, (Object)classType, (Object)serializerType, (Object)serializerForType));
        }
    }

    private final void checkCustomSerializerIsNotLocal(ModuleDescriptor module, Annotated declaration, BindingTrace trace, PsiElement declarationElement) {
        KotlinType kotlinType = KSerializationUtilKt.serializableWith(declaration.getAnnotations(), module);
        if (kotlinType == null) {
            return;
        }
        KotlinType serializerType = kotlinType;
        ClassDescriptor classDescriptor = KSerializationUtilKt.toClassDescriptor(serializerType);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor serializerDescriptor = classDescriptor;
        if (DescriptorUtils.isLocal((DeclarationDescriptor)((DeclarationDescriptor)serializerDescriptor))) {
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration(declaration);
            PsiElement element = ktAnnotationEntry == null ? declarationElement : (PsiElement)ktAnnotationEntry;
            trace.report((Diagnostic)SerializationErrors.LOCAL_SERIALIZER_USAGE.on(element, (Object)serializerType));
        }
    }

    private final void checkSerializerNullability(KotlinType classType, KotlinType serializerType, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Object v0;
        Iterable iterable;
        block3: {
            iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KotlinType it = (KotlinType)t;
                boolean bl3 = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        KotlinType kotlinType = v0;
        if (kotlinType == null) {
            return;
        }
        KotlinType castedToKSerial = kotlinType;
        iterable = ((TypeProjection)CollectionsKt.first((List)castedToKSerial.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"castedToKSerial.arguments.first().type");
        Iterable serializerForType = iterable;
        if (!classType.isMarkedNullable() && serializerForType.isMarkedNullable()) {
            iterable = element;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NULLABILITY_INCOMPATIBLE.on(iterable == null ? fallbackElement : (PsiElement)iterable, (Object)serializerType, (Object)classType));
        }
    }

    private final void onSerializableAnnotation(ClassDescriptor $this$onSerializableAnnotation, Function1<? super KtAnnotationEntry, Unit> report) {
        boolean $i$f$onSerializableAnnotation = false;
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation);
        if (ktAnnotationEntry != null) {
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            report.invoke((Object)ktAnnotationEntry2);
        }
    }

    private final void reportOnSerializableAnnotation(BindingTrace $this$reportOnSerializableAnnotation, ClassDescriptor descriptor, DiagnosticFactory0<? super KtAnnotationEntry> error) {
        SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
        ClassDescriptor $this$onSerializableAnnotation$iv = descriptor;
        boolean $i$f$onSerializableAnnotation = false;
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
        if (ktAnnotationEntry != null) {
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            KtAnnotationEntry e = ktAnnotationEntry2;
            boolean bl3 = false;
            $this$reportOnSerializableAnnotation.report((Diagnostic)error.on((PsiElement)e));
        }
    }
}

