/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginErrorsRendering;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bH\u0016J6\u0010#\u001a\u00020\u0004*\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J6\u0010*\u001a\u00020\u0004*\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010+\u001a\u00020\u0010*\u00020\bH\u0002J$\u0010,\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u000e\u0010-\u001a\n\u0012\u0006\b\u0000\u0012\u00020/0.H\u0002J!\u00100\u001a\u00020\u0004*\u00020\b2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u000402H\u0082\b\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "analyzePropertiesSerializers", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "serializableClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "props", "", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "descriptor", "canBeSerializedInternally", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "check", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSerializerNullability", "classType", "Lorg/jetbrains/kotlin/types/KotlinType;", "serializerType", "element", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "fallbackElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkTransients", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "declarationHasInitializer", "serializationPluginEnabledOn", "checkType", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "type", "ktType", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkTypeArguments", "isSerializableEnumWithMissingSerializer", "reportOnSerializableAnnotation", "error", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "safeReport", "report", "Lkotlin/Function1;", "kotlinx-serialization-compiler-plugin"})
public class SerializationPluginDeclarationChecker
implements DeclarationChecker {
    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        if (!this.canBeSerializedInternally((ClassDescriptor)descriptor, declaration, context.getTrace())) {
            return;
        }
        if (!(declaration instanceof KtPureClassOrObject)) {
            return;
        }
        SerializableProperties serializableProperties = this.buildSerializableProperties((ClassDescriptor)descriptor, context.getTrace());
        if (serializableProperties == null) {
            return;
        }
        SerializableProperties props = serializableProperties;
        this.checkTransients((KtPureClassOrObject)declaration, context.getTrace());
        this.analyzePropertiesSerializers(context.getTrace(), (ClassDescriptor)descriptor, props.getSerializableProperties());
    }

    private final boolean canBeSerializedInternally(ClassDescriptor descriptor, KtDeclaration declaration, BindingTrace trace) {
        ClassDescriptor superClass;
        if (this.isSerializableEnumWithMissingSerializer(descriptor)) {
            KtModifierList ktModifierList = declaration.getModifierList();
            KtElement declarationToReport = ktModifierList != null ? (KtElement)ktModifierList : (KtElement)declaration;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.EXPLICIT_SERIALIZABLE_IS_REQUIRED.on((PsiElement)declarationToReport)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
            return false;
        }
        if (!descriptor.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return false;
        }
        if (!this.serializationPluginEnabledOn(descriptor)) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.PLUGIN_IS_NOT_ENABLED;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"SerializationErrors.PLUGIN_IS_NOT_ENABLED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (descriptor.isInline()) {
            DiagnosticFactory0<PsiElement> diagnosticFactory0 = SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (!KSerializationUtilKt.getHasSerializableAnnotationWithoutArgs(descriptor)) {
            return false;
        }
        if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(descriptor)) {
            DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.SERIALIZABLE_ANNOTATION_IGNORED;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"SerializationErrors.SERI\u2026IZABLE_ANNOTATION_IGNORED");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
            return false;
        }
        if (!KSerializationUtilKt.isSerializableEnum(descriptor) && !KSerializationUtilKt.isInternalSerializable(superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)descriptor))) {
            Object v6;
            block10: {
                Collection collection = superClass.getConstructors();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"superClass.constructors");
                Iterable $this$singleOrNull$iv = collection;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl = false;
                    ClassConstructorDescriptor classConstructorDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"it");
                    if (!(classConstructorDescriptor.getValueParameters().size() == 0)) continue;
                    if (found$iv) {
                        v6 = null;
                        break block10;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v6 = !found$iv ? null : single$iv;
            }
            if (v6 == null) {
                DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"SerializationErrors.NON_\u2026RENT_MUST_HAVE_NOARG_CTOR");
                this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
                return false;
            }
        }
        return true;
    }

    private final boolean isSerializableEnumWithMissingSerializer(@NotNull ClassDescriptor $this$isSerializableEnumWithMissingSerializer) {
        boolean bl;
        block6: {
            if ($this$isSerializableEnumWithMissingSerializer.getKind() != ClassKind.ENUM_CLASS) {
                return false;
            }
            if ($this$isSerializableEnumWithMissingSerializer.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
                return false;
            }
            if (KSerializationUtilKt.getHasAnySerialAnnotation($this$isSerializableEnumWithMissingSerializer.getAnnotations())) {
                return true;
            }
            Iterable $this$any$iv = KSerializationUtilKt.enumEntries($this$isSerializableEnumWithMissingSerializer);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!KSerializationUtilKt.getHasAnySerialAnnotation(it.getAnnotations())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean serializationPluginEnabledOn(@NotNull ClassDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final SerializableProperties buildSerializableProperties(ClassDescriptor descriptor, BindingTrace trace) {
        if (!descriptor.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return null;
        }
        if (!KSerializationUtilKt.isInternalSerializable(descriptor)) {
            return null;
        }
        if (KSerializationUtilKt.getHasCompanionObjectAsSerializer(descriptor)) {
            return null;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        SerializableProperties props = new SerializableProperties(descriptor, bindingContext);
        if (!props.isExternallySerializable()) {
            DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"SerializationErrors.PRIM\u2026RAMETER_IS_NOT_A_PROPERTY");
            this.reportOnSerializableAnnotation(trace, descriptor, diagnosticFactory0);
        }
        boolean bl = false;
        Set namesSet = new LinkedHashSet();
        Iterable $this$forEach$iv = props.getSerializableProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry ktAnnotationEntry;
            void $this$safeReport$iv;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl2 = false;
            if (namesSet.add(it.getName())) continue;
            ClassDescriptor classDescriptor = descriptor;
            SerializationPluginDeclarationChecker this_$iv = this;
            boolean $i$f$safeReport = false;
            if (KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$safeReport$iv) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            KtAnnotationEntry a = ktAnnotationEntry;
            boolean bl5 = false;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.DUPLICATE_SERIAL_NAME.on((PsiElement)a, (Object)it.getName())), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
        }
        trace.record(SerializationPluginDeclarationCheckerKt.getSERIALIZABLE_PROPERTIES(), (Object)descriptor, (Object)props);
        return props;
    }

    private final void checkTransients(KtPureClassOrObject declaration, BindingTrace trace) {
        Map propertiesMap;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        Map<PropertyDescriptor, KtProperty> map = TypeUtilKt.bodyPropertiesDescriptorsMap(declaration, bindingContext, false);
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        Map $this$forEach$iv = propertiesMap = MapsKt.plus(map, TypeUtilKt.primaryConstructorPropertiesDescriptorsMap(declaration, bindingContext2));
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$descriptor$declaration = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$descriptor$declaration;
            boolean bl3 = false;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            entry = $dstr$descriptor$declaration;
            bl3 = false;
            KtDeclaration declaration2 = (KtDeclaration)entry.getValue();
            boolean isInitialized = this.declarationHasInitializer(declaration2) || descriptor.isLateInit();
            boolean isMarkedTransient = KSerializationUtilKt.getSerialTransient(descriptor.getAnnotations());
            boolean hasBackingField = ResolveUtilKt.hasBackingField((PropertyDescriptor)descriptor, (BindingContext)trace.getBindingContext());
            if (!hasBackingField && isMarkedTransient) {
                AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(SerializationAnnotations.INSTANCE.getSerialTransientFqName$kotlinx_serialization_compiler_plugin());
                if (!(annotationDescriptor instanceof LazyAnnotationDescriptor)) {
                    annotationDescriptor = null;
                }
                LazyAnnotationDescriptor lazyAnnotationDescriptor = (LazyAnnotationDescriptor)annotationDescriptor;
                KtAnnotationEntry transientPsi = lazyAnnotationDescriptor != null ? lazyAnnotationDescriptor.getAnnotationEntry() : null;
                KtAnnotationEntry ktAnnotationEntry = transientPsi;
                DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.TRANSIENT_IS_REDUNDANT.on(ktAnnotationEntry != null ? (PsiElement)ktAnnotationEntry : (PsiElement)declaration2)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
            }
            if (!isMarkedTransient || isInitialized || !hasBackingField) continue;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.TRANSIENT_MISSING_INITIALIZER.on((PsiElement)declaration2)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
        }
    }

    private final boolean declarationHasInitializer(KtDeclaration declaration) {
        KtDeclaration ktDeclaration = declaration;
        return ktDeclaration instanceof KtParameter ? ((KtParameter)declaration).hasDefaultValue() : (ktDeclaration instanceof KtProperty ? ((KtProperty)declaration).hasDelegateExpressionOrInitializer() : false);
    }

    private final void analyzePropertiesSerializers(BindingTrace trace, ClassDescriptor serializableClass, List<SerializableProperty> props) {
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"trace.bindingContext");
        AbstractSerialGenerator generatorContextForAnalysis2 = new AbstractSerialGenerator(trace, serializableClass, bindingContext, serializableClass){
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ ClassDescriptor $serializableClass;
            {
                this.$trace = $captured_local_variable$0;
                this.$serializableClass = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        Iterable $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference ktType;
            PsiElement propertyPsi;
            ClassDescriptor serializer;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getSerializableWith();
            Object object = serializer = kotlinType != null ? KSerializationUtilKt.toClassDescriptor(kotlinType) : null;
            if (SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)it.getDescriptor())) == null) {
                continue;
            }
            PsiElement psiElement = propertyPsi;
            if (!(psiElement instanceof KtCallableDeclaration)) {
                psiElement = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement;
            Object object2 = ktType = ktCallableDeclaration != null ? ktCallableDeclaration.getTypeReference() : null;
            if (serializer != null) {
                KtTypeReference ktTypeReference = ktType;
                KtTypeElement element = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                KotlinType kotlinType2 = it.getType();
                SimpleType simpleType = serializer.getDefaultType();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"serializer.defaultType");
                this.checkSerializerNullability(kotlinType2, (KotlinType)simpleType, element, trace, propertyPsi);
                this.checkTypeArguments(generatorContextForAnalysis2, it.getModule(), it.getType(), element, trace, propertyPsi);
                continue;
            }
            this.checkType(generatorContextForAnalysis2, it.getModule(), it.getType(), ktType, trace, propertyPsi);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArguments(@NotNull AbstractSerialGenerator $this$checkTypeArguments, ModuleDescriptor module, KotlinType type, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Iterable $this$forEachIndexed$iv = type.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n2;
            boolean bl2 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
            Object object = element;
            this.checkType($this$checkTypeArguments, module, kotlinType, object != null && (object = object.getTypeArgumentsAsTypes()) != null ? (KtTypeReference)CollectionsKt.getOrNull((List)object, (int)i) : null, trace, fallbackElement);
        }
    }

    private final void checkType(@NotNull AbstractSerialGenerator $this$checkType, ModuleDescriptor module, KotlinType type, KtTypeReference ktType, BindingTrace trace, PsiElement fallbackElement) {
        ClassDescriptor serializer;
        KtTypeElement element;
        if (KSerializationUtilKt.getGenericIndex(type) != null) {
            return;
        }
        KtTypeReference ktTypeReference = ktType;
        Object object = element = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (InlineClassesUtilsKt.isInlineClassType((KotlinType)type)) {
            KtTypeElement ktTypeElement = element;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
        }
        if ((serializer = TypeUtilKt.findTypeSerializerOrContextUnchecked($this$checkType, module, type)) != null) {
            SimpleType simpleType = serializer.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"serializer.defaultType");
            this.checkSerializerNullability(type, (KotlinType)simpleType, element, trace, fallbackElement);
            this.checkTypeArguments($this$checkType, module, type, element, trace, fallbackElement);
        } else {
            KtTypeElement ktTypeElement = element;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.SERIALIZER_NOT_FOUND.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)type)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
        }
    }

    private final void checkSerializerNullability(KotlinType classType, KotlinType serializerType, KtTypeElement element, BindingTrace trace, PsiElement fallbackElement) {
        Object v0;
        block3: {
            Iterable iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KotlinType it = (KotlinType)t;
                boolean bl3 = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        KotlinType kotlinType = v0;
        if (kotlinType == null) {
            return;
        }
        KotlinType castedToKSerial = kotlinType;
        if (!classType.isMarkedNullable() && ((TypeProjection)CollectionsKt.first((List)castedToKSerial.getArguments())).getType().isMarkedNullable()) {
            KtTypeElement ktTypeElement = element;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)trace), (Diagnostic)((Diagnostic)SerializationErrors.SERIALIZER_NULLABILITY_INCOMPATIBLE.on(ktTypeElement != null ? (PsiElement)ktTypeElement : fallbackElement, (Object)serializerType, (Object)classType)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
        }
    }

    private final void safeReport(@NotNull ClassDescriptor $this$safeReport, Function1<? super KtAnnotationEntry, Unit> report) {
        block0: {
            int $i$f$safeReport = 0;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$safeReport);
            if (ktAnnotationEntry == null) break block0;
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            Unit cfr_ignored_0 = (Unit)report.invoke((Object)ktAnnotationEntry2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportOnSerializableAnnotation(@NotNull BindingTrace $this$reportOnSerializableAnnotation, ClassDescriptor descriptor, DiagnosticFactory0<? super KtAnnotationEntry> error) {
        block0: {
            void $this$safeReport$iv;
            ClassDescriptor classDescriptor = descriptor;
            SerializationPluginDeclarationChecker this_$iv = this;
            boolean $i$f$safeReport = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$safeReport$iv);
            if (ktAnnotationEntry == null) break block0;
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            KtAnnotationEntry e = ktAnnotationEntry2;
            boolean bl3 = false;
            DiagnosticUtilsKt.reportFromPlugin((DiagnosticSink)((DiagnosticSink)$this$reportOnSerializableAnnotation), (Diagnostic)((Diagnostic)error.on((PsiElement)e)), (DefaultErrorMessages.Extension)SerializationPluginErrorsRendering.INSTANCE);
        }
    }
}

