/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.util.CachedAliasImportData;

@Metadata(mv={1, 5, 0}, k=2, xi=50, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0007\u001a\u0018\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006H\u0002\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n*\u0006\u0012\u0002\b\u00030\u000bH\u0002\u001a\f\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u000e\u001a\f\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ALIAS_IMPORT_DATA_KEY", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/util/CachedAliasImportData;", "aliasImportMap", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "buildAliasImportMap", "getContainingFileStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStub;", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "isProbablyNothing", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "ide-common"})
public final class TypeIndexUtilKt {
    @NotNull
    private static final Key<CachedAliasImportData> ALIAS_IMPORT_DATA_KEY = new Key("ALIAS_IMPORT_MAP_KEY");

    @NotNull
    public static final Multimap<String, String> aliasImportMap(@NotNull KtUserType $this$aliasImportMap) {
        PsiFile psiFile;
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$aliasImportMap, (String)"<this>");
        KotlinUserTypeStub kotlinUserTypeStub = (KotlinUserTypeStub)$this$aliasImportMap.getStub();
        if (kotlinUserTypeStub == null) {
            psiFile2 = null;
        } else {
            PsiFileStub<?> psiFileStub = TypeIndexUtilKt.getContainingFileStub((StubElement)kotlinUserTypeStub);
            psiFile2 = psiFile = (PsiFile)psiFileStub.getPsi();
        }
        if (psiFile == null) {
            kotlinUserTypeStub = HashMultimap.create();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinUserTypeStub, (String)"create()");
            return (Multimap)kotlinUserTypeStub;
        }
        PsiFile file = psiFile;
        return TypeIndexUtilKt.aliasImportMap((KtFile)file);
    }

    @NotNull
    public static final Multimap<String, String> aliasImportMap(@NotNull KtFile $this$aliasImportMap) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasImportMap, (String)"<this>");
        CachedAliasImportData cached = (CachedAliasImportData)$this$aliasImportMap.getUserData(ALIAS_IMPORT_DATA_KEY);
        long modificationStamp = $this$aliasImportMap.getModificationStamp();
        if (cached != null && modificationStamp == cached.getFileModificationStamp()) {
            return cached.getMap();
        }
        CachedAliasImportData data = new CachedAliasImportData(TypeIndexUtilKt.buildAliasImportMap($this$aliasImportMap), modificationStamp);
        $this$aliasImportMap.putUserData(ALIAS_IMPORT_DATA_KEY, (Object)data);
        return data.getMap();
    }

    private static final Multimap<String, String> buildAliasImportMap(KtFile $this$buildAliasImportMap) {
        HashMultimap map = HashMultimap.create();
        KtImportList ktImportList = $this$buildAliasImportMap.getImportList();
        if (ktImportList == null) {
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
            return (Multimap)map;
        }
        KtImportList importList = ktImportList;
        for (KtImportDirective ktImportDirective : importList.getImports()) {
            String string;
            FqName fqName;
            String string2;
            String string3 = ktImportDirective.getAliasName();
            if (string3 == null) continue;
            String aliasName = string2 = string3;
            ImportPath importPath = ktImportDirective.getImportPath();
            FqName fqName2 = fqName = importPath == null ? null : importPath.getFqName();
            String string4 = fqName == null ? null : (string = (importPath = fqName.shortName()) == null ? null : importPath.asString());
            if (string == null) continue;
            String name = string3 = string;
            map.put((Object)aliasName, (Object)name);
        }
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        return (Multimap)map;
    }

    public static final boolean isProbablyNothing(@Nullable KtTypeReference $this$isProbablyNothing) {
        KtUserType ktUserType;
        KtTypeReference ktTypeReference = $this$isProbablyNothing;
        KtTypeElement ktTypeElement = ktTypeReference == null ? null : ktTypeReference.getTypeElement();
        KtUserType ktUserType2 = ktUserType = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
        if (ktUserType == null) {
            return false;
        }
        KtUserType userType = ktUserType;
        return TypeIndexUtilKt.isProbablyNothing(userType);
    }

    public static final boolean isProbablyNothing(@Nullable KtUserType $this$isProbablyNothing) {
        if ($this$isProbablyNothing == null) {
            return false;
        }
        String referencedName = $this$isProbablyNothing.getReferencedName();
        return Intrinsics.areEqual((Object)referencedName, (Object)"Nothing") || TypeIndexUtilKt.aliasImportMap($this$isProbablyNothing).get((Object)referencedName).contains("Nothing");
    }

    private static final PsiFileStub<?> getContainingFileStub(StubElement<?> $this$getContainingFileStub) {
        PsiFileStub<?> psiFileStub;
        if ($this$getContainingFileStub instanceof PsiFileStub) {
            psiFileStub = (PsiFileStub<?>)$this$getContainingFileStub;
        } else {
            StubElement stubElement = $this$getContainingFileStub.getParentStub();
            Intrinsics.checkNotNullExpressionValue((Object)stubElement, (String)"parentStub");
            psiFileStub = TypeIndexUtilKt.getContainingFileStub(stubElement);
        }
        return psiFileStub;
    }
}

